require_relative '../../../globalized'
include Globalized

# ------------------------------------------------------------------------------
describe "[Story #JRNL-2486: Healthcare Contacts - Edit - Provider]", :broken => true, :regression => true do

  before(:all) do
    @PROVIDER_FORM = [
        "* required field",
        "",
        "Type:",
        "Individual Provider",
        "Organization",
        "Prefix:",
        "First Name:",
        "30 character maximum",
        "* Last Name:",
        "40 character maximum",
        "Provider Type:",
        "Specialty:",
        "50 character maximum",
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State:",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Website:",
        "100 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "healthcareContacts")
    initializeAllObjects
    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickContacts
    !45.times{ break if (getSecondaryHeader() == "Contacts"); sleep 1 }

    @contacts.clickHealthCareContacts()
    !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }

    expect(getCount()).to eq(20)
  end

  after(:all) do
    quitDriver()
  end

  context "AC JRNL-2889|TC-1768: 2. When the user selects a Healthcare Contacts entry from the table view" do

    it "System displays the Healthcare Contact record in the Detail screen in Edit mode:" do
        @healthcare_contacts_filter.clickProviderRadioButton()
        @healthcare_contacts_filter.clickFilterButton()
        !10.times{ break if (getFocusedElementText().include?("black")); sleep 1 }

        expect(getCount()).to eq(11)

        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")
        !10.times{ break if (getFocusedElementText().include?("Edit Healthcare Contact")); sleep 1 }
        expect(getFocusedElementText()).to eq("Edit Healthcare Contact")
    end

    it "a) All fields displayed in the Add mode are available in the Edit mode." do
        @providerForm = @providerHealthcareContacts.stripSelectTextFromScreen(
              @providerHealthcareContacts.getScreenContent().split("\n"),
               [
                  'prefix',
                  'providerType',
                  'primaryPhoneType',
                  'otherPhoneType1',
                  'otherPhoneType2',
                  'otherPhoneType3',
                  'otherPhoneType4',
                  'addressCountry',
                  'addressStateAbbreviation'
               ]
        )

        @PROVIDER_FORM.each_with_index do | expectedScreenRow, i |
          expect(@providerForm[i]).to eq(expectedScreenRow)
        end
    end

    it "b) Note: All values previously saved are visible." do
        expect(@providerHealthcareContacts.isOrganizationSelected()).to be false
        expect(@providerHealthcareContacts.isProviderSelected()).to be true
        expect(@providerHealthcareContacts.getLastName()).to eq("black")
        expect(@providerHealthcareContacts.getProviderType()).to eq("Dentist")
        expect(@providerHealthcareContacts.getSpecialty()).to eq("Specialist in Something")
        expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("(111) 000-0002")
        expect(@providerHealthcareContacts.getPrimaryPhoneType()).to eq("Office")
        expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("(222) 000-0002")
        expect(@providerHealthcareContacts.getOtherPhoneType(1)).to eq("Office")
        expect(@providerHealthcareContacts.getOtherPhone(2)).to eq("(333) 000-0002")
        expect(@providerHealthcareContacts.getOtherPhoneType(2)).to eq("Office")
        expect(@providerHealthcareContacts.getOtherPhone(3)).to eq("(444) 000-0002")
        expect(@providerHealthcareContacts.getOtherPhoneType(3)).to eq("Office")
        expect(@providerHealthcareContacts.getOtherPhone(4)).to eq("(555) 000-0002")
        expect(@providerHealthcareContacts.getOtherPhoneType(4)).to eq("Office")
        expect(@providerHealthcareContacts.getCountry()).to eq("United States")
        expect(@providerHealthcareContacts.getCity()).to eq("Boston")
        expect(@providerHealthcareContacts.getState()).to eq("Massachusetts")
    end

    it "If no value was previously saved for a field, the display defaults to null (or select for drop lists);" do
        expect(@providerHealthcareContacts.getPrefix()).to eq("")
        expect(@providerHealthcareContacts.getFirstName()).to eq("")
        expect(@providerHealthcareContacts.getEmail()).to eq("")
        expect(@providerHealthcareContacts.getAddressLineOne()).to eq("")
        expect(@providerHealthcareContacts.getAddressLineTwo()).to eq("")
        expect(@providerHealthcareContacts.getZipPostalCode()).to eq("")
        expect(@providerHealthcareContacts.getWebsite()).to eq("")
        expect(@providerHealthcareContacts.getNote()).to eq("")
        expect(@providerHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")
    end

    it "No guidance text (light gray placeholder text) is shown and all fields are optional unless otherwise indicated." do
        expect(@providerHealthcareContacts.isRequired("select[name='prefix']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='firstName']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='lastName']")).to be true
        expect(@providerHealthcareContacts.isRequired("select[name='providerType']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='specialty']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='primaryPhone']")).to be false
        expect(@providerHealthcareContacts.isRequired("select[name='primaryPhoneType']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='otherPhone1']")).to be false
        expect(@providerHealthcareContacts.isRequired("select[name='otherPhoneType1']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='otherPhone2']")).to be false
        expect(@providerHealthcareContacts.isRequired("select[name='otherPhoneType2']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='otherPhone3']")).to be false
        expect(@providerHealthcareContacts.isRequired("select[name='otherPhoneType3']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='otherPhone4']")).to be false
        expect(@providerHealthcareContacts.isRequired("select[name='otherPhoneType4']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='email']")).to be false
        expect(@providerHealthcareContacts.isRequired("select[name='addressCountry']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='addressLineOne']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='addressLineTwo']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='addressCity']")).to be false
        expect(@providerHealthcareContacts.isRequired("select[name='addressStateAbbreviation']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='addressZipPostalCode']")).to be false
        expect(@providerHealthcareContacts.isRequired("input[name='addressWebsite']")).to be false
        expect(@providerHealthcareContacts.isRequired("textarea[name='note']")).to be false
    end

    it "c) Standard Edit functions are available (Save, Cancel, Delete)" do
        expect(@providerHealthcareContacts.isSaveButtonVisible()).to be true
        expect(@providerHealthcareContacts.isDeleteButtonVisible()).to be true
        expect(@providerHealthcareContacts.isCancelButtonVisible()).to be true
    end

  end

  context "AC #JRNL-2888|TC #JRNL-1966: Save/Cancel" do

      context "1) Save - When a user selects Save " do

        it "System saves the record and the user is returned to the table view, " do
            @providerHealthcareContacts.setLastName("")
            @providerHealthcareContacts.setPrimaryPhone("000")
            @providerHealthcareContacts.setOtherPhone(1, "111")

            @providerHealthcareContacts.clickSave()

            checkingInlineError("Last Name field is required.", 0)
            checkingInlineError("Primary Phone must be formatted (###) ###-####.", 1)
            checkingInlineError("Other Phone must be formatted (###) ###-####.", 2)

            @providerHealthcareContacts.setPrefix("Dr.")
            @providerHealthcareContacts.setFirstName("RobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobinRobin")
            @providerHealthcareContacts.setLastName("AndersonAndersonAndersonAndersonAndersonAndersonAndersonAndersonAndersonAndersonAndersonAndersonAnderson")
            @providerHealthcareContacts.setProviderType("Pharmacist")
            @providerHealthcareContacts.setSpecialty("SuperSpecialSuperSpecialSuperSpecialSuperSpecialSuperSpecialSuperSpecialSuperSpecialSuperSpecialSuperSpecial")
            @providerHealthcareContacts.setPrimaryPhone("0d00000d0000")
            @providerHealthcareContacts.setPrimaryPhoneType("Other")
            @providerHealthcareContacts.setOtherPhone(1, "1s111f11111g1")
            @providerHealthcareContacts.setOtherPhoneType(1, "Mobile")
            @providerHealthcareContacts.setOtherPhone(2, "222d2222s222f")
            @providerHealthcareContacts.setOtherPhoneType(2, "Fax")
            @providerHealthcareContacts.setOtherPhone(3, "33d333g3333b3")
            @providerHealthcareContacts.setOtherPhoneType(3, "Office")
            @providerHealthcareContacts.setOtherPhone(4, "44io4444o44l44")
            @providerHealthcareContacts.setOtherPhoneType(4, "Other")
            @providerHealthcareContacts.setEmail("doctor@email.comdoctor@email.comdoctor@email.comdoctor@email.comdoctor@email.comdoctor@email.comdoctor@email.com")
            @providerHealthcareContacts.setCountry("Togo")
            @providerHealthcareContacts.setAddressLineOne("1 First St1 First St1 First St1 First St1 First St1 First St1 First St1 First St1 First St1 First St1 First St")
            @providerHealthcareContacts.setAddressLineTwo("Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1")
            @providerHealthcareContacts.setCity("ArlingtonArlingtonArlingtonArlingtonArlingtonArlingtonArlingtonArlingtonArlingtonArlingtonArlingtonArlington")
            @providerHealthcareContacts.setStateProvince("VirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVirginia")
            @providerHealthcareContacts.setZipPostalCode("000000000000000000000000000000000000000000")
            @providerHealthcareContacts.setWebsite("qa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.com")
            @providerHealthcareContacts.setNote("NotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotes")

            @providerHealthcareContacts.clickSave()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

        it "Focus is on the header. " do
            !10.times{ break if (getFocusedElementText().include?("Healthcare Contacts")); sleep 1 }
            expect(getFocusedElementText()).to eq("Healthcare Contacts")
        end

        it "Updates made to the record are visible in the table, if included in that view." do
            expect(getTextForRow(1).include?("AndersonAndersonAndersonAndersonAnderson, RobinRobinRobinRobinRobinRobin")).to be true

            expect(getCount()).to eq(11)

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")
        end

        it "System saves the record and the user is returned to the table view, " do
            expect(@providerHealthcareContacts.isOrganizationSelected()).to be false
            expect(@providerHealthcareContacts.isProviderSelected()).to be true
            expect(@providerHealthcareContacts.getPrefix()).to eq("Dr.")
            expect(@providerHealthcareContacts.getFirstName()).to eq("RobinRobinRobinRobinRobinRobin")
            expect(@providerHealthcareContacts.getFirstName().length()).to eq(30)
            expect(@providerHealthcareContacts.getLastName()).to eq("AndersonAndersonAndersonAndersonAnderson")
            expect(@providerHealthcareContacts.getLastName().length()).to eq(40)
            expect(@providerHealthcareContacts.getProviderType()).to eq("Pharmacist")
            expect(@providerHealthcareContacts.getSpecialty()).to eq("SuperSpecialSuperSpecialSuperSpecialSuperSpecialSu")
            expect(@providerHealthcareContacts.getSpecialty().length()).to eq(50)
            expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("(000) 000-0000")
            expect(@providerHealthcareContacts.getPrimaryPhoneType()).to eq("Other")
            expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("(111) 111-1111")
            expect(@providerHealthcareContacts.getOtherPhoneType(1)).to eq("Mobile")
            expect(@providerHealthcareContacts.getOtherPhone(2)).to eq("(222) 222-2222")
            expect(@providerHealthcareContacts.getOtherPhoneType(2)).to eq("Fax")
            expect(@providerHealthcareContacts.getOtherPhone(3)).to eq("(333) 333-3333")
            expect(@providerHealthcareContacts.getOtherPhoneType(3)).to eq("Office")
            expect(@providerHealthcareContacts.getOtherPhone(4)).to eq("(444) 444-4444")
            expect(@providerHealthcareContacts.getOtherPhoneType(4)).to eq("Other")
            expect(@providerHealthcareContacts.getEmail()).to eq("doctor@email.comdoctor@email.comdoctor@email.comdoctor@email.comdoctor@email.comdoctor@email.comdoct")
            expect(@providerHealthcareContacts.getEmail().length()).to eq(100)
            expect(@providerHealthcareContacts.getCountry()).to eq("Togo")
            expect(@providerHealthcareContacts.getAddressLineOne()).to eq("1 First St1 First St1 First St1 First St1 First St1 First St1 First St1 First St1 First St1 First St")
            expect(@providerHealthcareContacts.getAddressLineOne().length()).to eq(100)
            expect(@providerHealthcareContacts.getAddressLineTwo()).to eq("Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1Apt1")
            expect(@providerHealthcareContacts.getAddressLineTwo().length()).to eq(100)
            expect(@providerHealthcareContacts.getCity()).to eq("ArlingtonArlingtonArlingtonArlingtonArlingtonArlin")
            expect(@providerHealthcareContacts.getCity().length()).to eq(50)
            expect(@providerHealthcareContacts.getStateProvince()).to eq("VirginiaVirginiaVirginiaVirginiaVirginiaVirginiaVi")
            expect(@providerHealthcareContacts.getStateProvince().length()).to eq(50)
            expect(@providerHealthcareContacts.getZipPostalCode()).to eq("0000000000")
            expect(@providerHealthcareContacts.getZipPostalCode().length()).to eq(10)
            expect(@providerHealthcareContacts.getWebsite()).to eq("qa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex.comqa.agilex")
            expect(@providerHealthcareContacts.getWebsite().length()).to eq(100)
            expect(@providerHealthcareContacts.getNote()).to eq("NotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotes")
            expect(@providerHealthcareContacts.getNote().length()).to eq(250)
            expect(@providerHealthcareContacts.getCountDownDisplayForNote()).to eq("0 characters left")

            @providerHealthcareContacts.setPrefix("")
            @providerHealthcareContacts.setFirstName("")
            @providerHealthcareContacts.setLastName("Akin")
            @providerHealthcareContacts.setProviderType("")
            @providerHealthcareContacts.setSpecialty("")
            @providerHealthcareContacts.setPrimaryPhone("")
            @providerHealthcareContacts.setPrimaryPhoneType("")
            @providerHealthcareContacts.setOtherPhone(1, "")
            @providerHealthcareContacts.setOtherPhoneType(1, "")
            @providerHealthcareContacts.clickDeleteOtherPhoneButton(4)
            @providerHealthcareContacts.clickDeleteOtherPhoneButton(3)
            @providerHealthcareContacts.clickDeleteOtherPhoneButton(2)
            @providerHealthcareContacts.setEmail("")
            @providerHealthcareContacts.setCountry("Select")
            @providerHealthcareContacts.setAddressLineOne("")
            @providerHealthcareContacts.setAddressLineTwo("")
            @providerHealthcareContacts.setCity("")
            @providerHealthcareContacts.setStateProvince("")
            @providerHealthcareContacts.setZipPostalCode("")
            @providerHealthcareContacts.setWebsite("")
            @providerHealthcareContacts.setNote("")

            @providerHealthcareContacts.clickSave()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

        it "Focus is on the header. " do
            !10.times{ break if (getFocusedElementText().include?("Healthcare Contacts")); sleep 1 }
            expect(getFocusedElementText()).to eq("Healthcare Contacts")
        end

        it "Updates made to the record are visible in the table, if included in that view." do
            expect(getTextForRow(1).include?("Akin")).to be true
            expect(getCount()).to eq(11)

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")

            expect(@providerHealthcareContacts.isOrganizationSelected()).to be false
            expect(@providerHealthcareContacts.isProviderSelected()).to be true
            expect(@providerHealthcareContacts.getPrefix()).to eq("")
            expect(@providerHealthcareContacts.getFirstName()).to eq("")
            expect(@providerHealthcareContacts.getLastName()).to eq("Akin")
            expect(@providerHealthcareContacts.getProviderType()).to eq("")
            expect(@providerHealthcareContacts.getSpecialty()).to eq("")
            expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("")
            expect(@providerHealthcareContacts.getPrimaryPhoneType()).to eq("")
            expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("")
            expect(@providerHealthcareContacts.getOtherPhoneType(1)).to eq("")
            expect(@providerHealthcareContacts.getEmail()).to eq("")
            expect(@providerHealthcareContacts.getCountry()).to eq("Select")
            expect(@providerHealthcareContacts.getAddressLineOne()).to eq("")
            expect(@providerHealthcareContacts.getAddressLineTwo()).to eq("")
            expect(@providerHealthcareContacts.getCity()).to eq("")
            expect(@providerHealthcareContacts.getState()).to eq("")
            expect(@providerHealthcareContacts.getZipPostalCode()).to eq("")
            expect(@providerHealthcareContacts.getWebsite()).to eq("")
            expect(@providerHealthcareContacts.getNote()).to eq("")
            expect(@providerHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")
        end

      end

      context "2) Cancel - When a user selects Cancel, " do

        it "No updates are made to the record and the user is shown the table view with the focus placed on the header" do
            @providerHealthcareContacts.setPrefix("Mr.")
            @providerHealthcareContacts.setFirstName("asdadf")
            @providerHealthcareContacts.setLastName("gsdfgsdfg")
            @providerHealthcareContacts.setProviderType("Other")
            @providerHealthcareContacts.setSpecialty("dfgsdfg")
            @providerHealthcareContacts.setPrimaryPhone("6666666666")
            @providerHealthcareContacts.setPrimaryPhoneType("Fax")
            @providerHealthcareContacts.setOtherPhone(1, "7777777777")
            @providerHealthcareContacts.setOtherPhoneType(1, "Fax")
            @providerHealthcareContacts.setEmail("sergserg")
            @providerHealthcareContacts.setCountry("Turkey")
            @providerHealthcareContacts.setAddressLineOne("retyhtdnb")
            @providerHealthcareContacts.setAddressLineTwo("bsadfv")
            @providerHealthcareContacts.setCity("aergvevba")
            @providerHealthcareContacts.setStateProvince("bndtyhxrth")
            @providerHealthcareContacts.setZipPostalCode("aWERGFERG")
            @providerHealthcareContacts.setWebsite("bxrtnhsxrg")
            @providerHealthcareContacts.setNote("srthbszrth")

            @providerHealthcareContacts.clickCancel()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")

            expect(getTextForRow(1).include?("Akin")).to be true
            expect(getCount()).to eq(11)

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")

            expect(@providerHealthcareContacts.isOrganizationSelected()).to be false
            expect(@providerHealthcareContacts.isProviderSelected()).to be true
            expect(@providerHealthcareContacts.getPrefix()).to eq("")
            expect(@providerHealthcareContacts.getFirstName()).to eq("")
            expect(@providerHealthcareContacts.getLastName()).to eq("Akin")
            expect(@providerHealthcareContacts.getProviderType()).to eq("")
            expect(@providerHealthcareContacts.getSpecialty()).to eq("")
            expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("")
            expect(@providerHealthcareContacts.getPrimaryPhoneType()).to eq("")
            expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("")
            expect(@providerHealthcareContacts.getOtherPhoneType(1)).to eq("")
            expect(@providerHealthcareContacts.getEmail()).to eq("")
            expect(@providerHealthcareContacts.getCountry()).to eq("Select")
            expect(@providerHealthcareContacts.getAddressLineOne()).to eq("")
            expect(@providerHealthcareContacts.getAddressLineTwo()).to eq("")
            expect(@providerHealthcareContacts.getCity()).to eq("")
            expect(@providerHealthcareContacts.getState()).to eq("")
            expect(@providerHealthcareContacts.getZipPostalCode()).to eq("")
            expect(@providerHealthcareContacts.getWebsite()).to eq("")
            expect(@providerHealthcareContacts.getNote()).to eq("")
            expect(@providerHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")

            @providerHealthcareContacts.clickCancel()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")

            expect(getCount()).to eq(11)
        end

      end

  end

  ############################
  ### SWITCH BETWEEN TYPES ###
  ############################

  context "AC JRNL-2889|TC-1768: 2. When the user selects a Healthcare Contacts entry from the table view" do

    it "System displays the Healthcare Contact record in the Detail screen in Edit mode:" do
        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")
        !10.times{ break if (getFocusedElementText().include?("Edit Healthcare Contact")); sleep 1 }
        expect(getFocusedElementText()).to eq("Edit Healthcare Contact")
    end

  end

  context "AC #JRNL-2888|TC #JRNL-1966: Save" do

      context "1) Save - When a user selects Save " do

        it "System saves the record and the user is returned to the table view, " do
            @organizationHealthcareContacts.selectOrganization()
            @organizationHealthcareContacts.setOrganizationName("Zeus Test Facility")
            @organizationHealthcareContacts.setOrganizationType("Lab")
            @organizationHealthcareContacts.setPrimaryPhone("6106839991")
            @organizationHealthcareContacts.setPrimaryPhoneType("Office")
            @organizationHealthcareContacts.setOtherPhone(1, "7179516174")
            @organizationHealthcareContacts.setOtherPhoneType(1, "Mobile")
            @organizationHealthcareContacts.setEmail("zeus@yahoo.com")
            @organizationHealthcareContacts.setCountry("United States")
            @organizationHealthcareContacts.setAddressLineOne("1000 Mount Olympus Dr")
            @organizationHealthcareContacts.setAddressLineTwo("")
            @organizationHealthcareContacts.setCity("Athens")
            @organizationHealthcareContacts.setState("Georgia")
            @organizationHealthcareContacts.setZipPostalCode("12345")
            @organizationHealthcareContacts.setWebsite("zeus.com")
            @organizationHealthcareContacts.setNote("")

            @organizationHealthcareContacts.clickSave()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

        it "Updates made to the record are visible in the table, if included in that view." do
            expect(getCount()).to eq(10)

            @healthcare_contacts_filter.clickOrganizationRadioButton()
            @healthcare_contacts_filter.clickFilterButton()
            !10.times{ break if (getFocusedElementText().include?("Alexandria Hospital")); sleep 1 }

            expect(getCount()).to eq(10)

            clickNthRow(10)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")
            !10.times{ break if (getFocusedElementText().include?("Edit Healthcare Contact")); sleep 1 }
            expect(getFocusedElementText()).to eq("Edit Healthcare Contact")
        end

        it "System saves the record and the user is returned to the table view, " do
            expect(@organizationHealthcareContacts.isOrganizationSelected()).to be true
            expect(@organizationHealthcareContacts.isProviderSelected()).to be false
            expect(@organizationHealthcareContacts.getOrganizationName()).to eq("Zeus Test Facility")
            expect(@organizationHealthcareContacts.getOrganizationType()).to eq("Lab")
            expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("(610) 683-9991")
            expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to eq("Office")
            expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("(717) 951-6174")
            expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to eq("Mobile")
            expect(@organizationHealthcareContacts.getEmail()).to eq("zeus@yahoo.com")
            expect(@organizationHealthcareContacts.getCountry()).to eq("United States")
            expect(@organizationHealthcareContacts.getAddressLineOne()).to eq("1000 Mount Olympus Dr")
            expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq("")
            expect(@organizationHealthcareContacts.getCity()).to eq("Athens")
            expect(@organizationHealthcareContacts.getState()).to eq("Georgia")
            expect(@organizationHealthcareContacts.getZipPostalCode()).to eq("12345")
            expect(@organizationHealthcareContacts.getWebsite()).to eq("zeus.com")
            expect(@organizationHealthcareContacts.getNote()).to eq("")
            expect(@organizationHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")

            @providerHealthcareContacts.selectProvider()
            @providerHealthcareContacts.setPrefix("Ms.")
            @providerHealthcareContacts.setFirstName("Rose")
            @providerHealthcareContacts.setLastName("Zee")
            @providerHealthcareContacts.setProviderType("Other")
            @providerHealthcareContacts.setSpecialty("Dancing")
            @providerHealthcareContacts.setPrimaryPhone("")
            @providerHealthcareContacts.setPrimaryPhoneType("")
            @providerHealthcareContacts.setOtherPhone(1, "")
            @providerHealthcareContacts.setOtherPhoneType(1, "")
            @providerHealthcareContacts.setEmail("rose-dancer@something.com")
            @providerHealthcareContacts.setCountry("Ukraine")
            @providerHealthcareContacts.setAddressLineOne("")
            @providerHealthcareContacts.setAddressLineTwo("")
            @providerHealthcareContacts.setCity("")
            @providerHealthcareContacts.setStateProvince("")
            @providerHealthcareContacts.setZipPostalCode("")
            @providerHealthcareContacts.setWebsite("")
            @providerHealthcareContacts.setNote("")

            @providerHealthcareContacts.clickSave()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

        it "Updates made to the record are visible in the table, if included in that view." do
            expect(getCount()).to eq(9)

            @healthcare_contacts_filter.clickProviderRadioButton()
            @healthcare_contacts_filter.clickFilterButton()
            !10.times{ break if (getFocusedElementText().include?("Arlington Hospital")); sleep 1 }

            expect(getCount()).to eq(11)

            clickNthRow(11)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")
            !10.times{ break if (getFocusedElementText().include?("Edit Healthcare Contact")); sleep 1 }
            expect(getFocusedElementText()).to eq("Edit Healthcare Contact")

            expect(@providerHealthcareContacts.isOrganizationSelected()).to be false
            expect(@providerHealthcareContacts.isProviderSelected()).to be true
            expect(@providerHealthcareContacts.getPrefix()).to eq("Ms.")
            expect(@providerHealthcareContacts.getFirstName()).to eq("Rose")
            expect(@providerHealthcareContacts.getLastName()).to eq("Zee")
            expect(@providerHealthcareContacts.getProviderType()).to eq("Other")
            expect(@providerHealthcareContacts.getSpecialty()).to eq("Dancing")
            expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("")
            expect(@providerHealthcareContacts.getPrimaryPhoneType()).to eq("")
            expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("")
            expect(@providerHealthcareContacts.getOtherPhoneType(1)).to eq("")
            expect(@providerHealthcareContacts.getEmail()).to eq("rose-dancer@something.com")
            expect(@providerHealthcareContacts.getCountry()).to eq("Ukraine")
            expect(@providerHealthcareContacts.getAddressLineOne()).to eq("")
            expect(@providerHealthcareContacts.getAddressLineTwo()).to eq("")
            expect(@providerHealthcareContacts.getCity()).to eq("")
            expect(@providerHealthcareContacts.getState()).to eq("")
            expect(@providerHealthcareContacts.getZipPostalCode()).to eq("")
            expect(@providerHealthcareContacts.getWebsite()).to eq("")
            expect(@providerHealthcareContacts.getNote()).to eq("")
            expect(@providerHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")

            @providerHealthcareContacts.clickCancel()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

      end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)

    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to be true

  end

end

