require_relative '../../../globalized'
include Globalized

# ------------------------------------------------------------------------------
describe "[Story #JRNL-2486: Healthcare Contacts - Edit - Organization]", :broken => true, :regression => true do

  before(:all) do
    @ORGANIZATION_FORM = [
        "* required field",
        "",
        "Type:",
        "Individual Provider",
        "Organization",
        "Type:",
        "* Name:",
        "100 character maximum",
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State:",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Website:",
        "100 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "healthcareContacts")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickContacts
    !45.times{ break if (getSecondaryHeader() == "Contacts"); sleep 1 }

    @contacts.clickHealthCareContacts()
    !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }

    expect(getCount()).to eq(20)
  end

  after(:all) do
    quitDriver()
  end

  ####################
  ### ORGANIZATION ###
  ####################

  context "AC JRNL-2888|TC-1768: 2. When the user selects a Healthcare Contacts entry from the table view" do

    it "System displays the Healthcare Contact record in the Detail screen in Edit mode:" do
        @healthcare_contacts_filter.clickOrganizationRadioButton()
        @healthcare_contacts_filter.clickFilterButton()
        !10.times{ break if (getFocusedElementText().include?("Alexandria Hospital")); sleep 1 }

        expect(getCount()).to eq(9)

        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")
        !10.times{ break if (getFocusedElementText().include?("Edit Healthcare Contact")); sleep 1 }
        expect(getFocusedElementText()).to eq("Edit Healthcare Contact")
    end

    it "a) All fields displayed in the Add mode are available in the Edit mode." do
        @form = @organizationHealthcareContacts.stripSelectTextFromScreen(
              @organizationHealthcareContacts.getScreenContent().split("\n"),
               [
                  'prefix',
                  'association',
                  'primaryPhoneType',
                  'otherPhoneType1',
                  'otherPhoneType2',
                  'otherPhoneType3',
                  'otherPhoneType4',
                  'addressCountry',
                  'addressStateAbbreviation'
               ]
        )

        @ORGANIZATION_FORM.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end
    end

    it "b) Note: All values previously saved are visible." do
        expect(@organizationHealthcareContacts.isOrganizationSelected()).to be true
        expect(@organizationHealthcareContacts.isProviderSelected()).to be false
        expect(@organizationHealthcareContacts.getOrganizationName()).to eq("Alexandria Hospital")
        expect(@organizationHealthcareContacts.getOrganizationType()).to eq("Lab")
        expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("(111) 000-0003")
        expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to eq("Fax")
        expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("(222) 000-0003")
        expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to eq("Fax")
        expect(@organizationHealthcareContacts.getOtherPhone(2)).to eq("(333) 000-0003")
        expect(@organizationHealthcareContacts.getOtherPhoneType(2)).to eq("Fax")
        expect(@organizationHealthcareContacts.getOtherPhone(3)).to eq("(444) 000-0003")
        expect(@organizationHealthcareContacts.getOtherPhoneType(3)).to eq("Fax")
        expect(@organizationHealthcareContacts.getOtherPhone(4)).to eq("(555) 000-0003")
        expect(@organizationHealthcareContacts.getOtherPhoneType(4)).to eq("Fax")
        expect(@organizationHealthcareContacts.getEmail()).to eq("test@agilex.com")
        expect(@organizationHealthcareContacts.getCountry()).to eq("United States")
        expect(@organizationHealthcareContacts.getCity()).to eq("Boston")
        expect(@organizationHealthcareContacts.getState()).to eq("Massachusetts")
    end

    it "If no value was previously saved for a field, the display defaults to null (or select for drop lists);" do
        expect(@organizationHealthcareContacts.getAddressLineOne()).to eq("")
        expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq("")
        expect(@organizationHealthcareContacts.getZipPostalCode()).to eq("")
        expect(@organizationHealthcareContacts.getWebsite()).to eq("")
        expect(@organizationHealthcareContacts.getNote()).to eq("")
        expect(@organizationHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")
    end

    it "No guidance text (light gray placeholder text) is shown and all fields are optional unless otherwise indicated." do
        expect(@organizationHealthcareContacts.isRequired("input[name='addressName']")).to be true
        expect(@organizationHealthcareContacts.isRequired("select[name='association']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='primaryPhone']")).to be false
        expect(@organizationHealthcareContacts.isRequired("select[name='primaryPhoneType']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='otherPhone1']")).to be false
        expect(@organizationHealthcareContacts.isRequired("select[name='otherPhoneType1']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='otherPhone2']")).to be false
        expect(@organizationHealthcareContacts.isRequired("select[name='otherPhoneType2']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='otherPhone3']")).to be false
        expect(@organizationHealthcareContacts.isRequired("select[name='otherPhoneType3']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='otherPhone4']")).to be false
        expect(@organizationHealthcareContacts.isRequired("select[name='otherPhoneType4']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='email']")).to be false
        expect(@organizationHealthcareContacts.isRequired("select[name='addressCountry']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='addressLineOne']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='addressLineTwo']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='addressCity']")).to be false
        expect(@organizationHealthcareContacts.isRequired("select[name='addressStateAbbreviation']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='addressZipPostalCode']")).to be false
        expect(@organizationHealthcareContacts.isRequired("input[name='addressWebsite']")).to be false
        expect(@organizationHealthcareContacts.isRequired("textarea[name='note']")).to be false
    end

    it "c) Standard Edit functions are available (Save, Cancel, Delete)" do
        expect(@organizationHealthcareContacts.isSaveButtonVisible()).to be true
        expect(@organizationHealthcareContacts.isDeleteButtonVisible()).to be true
        expect(@organizationHealthcareContacts.isCancelButtonVisible()).to be true
    end

  end

  context "AC #JRNL-2888|TC #JRNL-1966: Save/Cancel" do

    context "1) Save - When a user selects Save " do

        it "System saves the record and the user is returned to the table view, " do
            @organizationHealthcareContacts.setOrganizationName("")
            @organizationHealthcareContacts.setPrimaryPhone("000")
            @organizationHealthcareContacts.setOtherPhone(1, "111")

            @organizationHealthcareContacts.clickSave()

            checkingInlineError("Name field is required.", 0)
            checkingInlineError("Primary Phone must be formatted (###) ###-####.", 1)
            checkingInlineError("Other Phone must be formatted (###) ###-####.", 2)

            @organizationHealthcareContacts.setOrganizationName("ABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYYY")
            @organizationHealthcareContacts.setOrganizationType("Clinic")
            @organizationHealthcareContacts.setPrimaryPhone("000abc00000def00")
            @organizationHealthcareContacts.setPrimaryPhoneType("Mobile")
            @organizationHealthcareContacts.setOtherPhone(1, "11abc111111def11")
            @organizationHealthcareContacts.setOtherPhoneType(1, "Mobile")
            @organizationHealthcareContacts.setOtherPhone(2, "2abc222222222def")
            @organizationHealthcareContacts.setOtherPhoneType(2, "Mobile")
            @organizationHealthcareContacts.setOtherPhone(3, "abc33333def33333")
            @organizationHealthcareContacts.setOtherPhoneType(3, "Mobile")
            @organizationHealthcareContacts.setOtherPhone(4, "4a4s4d4f4v4b4n4@4g4")
            @organizationHealthcareContacts.setOtherPhoneType(4, "Mobile")
            @organizationHealthcareContacts.setEmail("new_email@email.comnew_email@email.comnew_email@email.comnew_email@email.comnew_email@email.comnew_email@email.com")
            @organizationHealthcareContacts.setCountry("United Kingdom")
            @organizationHealthcareContacts.setAddressLineOne("100 Address Lane100 Address Lane100 Address Lane100 Address Lane100 Address Lane100 Address Lane100 Address Lane")
            @organizationHealthcareContacts.setAddressLineTwo("AptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptC")
            @organizationHealthcareContacts.setCity("BoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoise")
            @organizationHealthcareContacts.setStateProvince("IdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdaho")
            @organizationHealthcareContacts.setZipPostalCode("77777777777777777777777777777777777777777777777777")
            @organizationHealthcareContacts.setWebsite("agilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.com")
            @organizationHealthcareContacts.setNote("NotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenote")

            @organizationHealthcareContacts.clickSave()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

        it "Focus is on the header. " do
            !10.times{ break if (getFocusedElementText().include?("Healthcare Contacts")); sleep 1 }
            expect(getFocusedElementText()).to eq("Healthcare Contacts")
        end

        it "Updates made to the record are visible in the table, if included in that view." do
            expect(getTextForRow(1).include?("ABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILI")).to be true

            expect(getCount()).to eq(9)

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")
        end

        it "System saves the record and the user is returned to the table view, " do
            expect(@organizationHealthcareContacts.isOrganizationSelected()).to be true
            expect(@organizationHealthcareContacts.isProviderSelected()).to be false
            expect(@organizationHealthcareContacts.getOrganizationName()).to eq("ABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILITYABRANDNEWFACILI")
            expect(@organizationHealthcareContacts.getOrganizationName().length()).to eq(100)
            expect(@organizationHealthcareContacts.getOrganizationType()).to eq("Clinic")
            expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("(000) 000-0000")
            expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to eq("Mobile")
            expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("(111) 111-1111")
            expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to eq("Mobile")
            expect(@organizationHealthcareContacts.getOtherPhone(2)).to eq("(222) 222-2222")
            expect(@organizationHealthcareContacts.getOtherPhoneType(2)).to eq("Mobile")
            expect(@organizationHealthcareContacts.getOtherPhone(3)).to eq("(333) 333-3333")
            expect(@organizationHealthcareContacts.getOtherPhoneType(3)).to eq("Mobile")
            expect(@organizationHealthcareContacts.getOtherPhone(4)).to eq("(444) 444-4444")
            expect(@organizationHealthcareContacts.getOtherPhoneType(4)).to eq("Mobile")
            expect(@organizationHealthcareContacts.getEmail()).to eq("new_email@email.comnew_email@email.comnew_email@email.comnew_email@email.comnew_email@email.comnew_e")
            expect(@organizationHealthcareContacts.getEmail().length()).to eq(100)
            expect(@organizationHealthcareContacts.getCountry()).to eq("United Kingdom")
            expect(@organizationHealthcareContacts.getAddressLineOne()).to eq("100 Address Lane100 Address Lane100 Address Lane100 Address Lane100 Address Lane100 Address Lane100 ")
            expect(@organizationHealthcareContacts.getAddressLineOne().length()).to eq(100)
            expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq("AptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptCAptC")
            expect(@organizationHealthcareContacts.getAddressLineTwo().length()).to eq(100)
            expect(@organizationHealthcareContacts.getCity()).to eq("BoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoiseBoise")
            expect(@organizationHealthcareContacts.getCity().length()).to eq(50)
            expect(@organizationHealthcareContacts.getStateProvince()).to eq("IdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdahoIdaho")
            expect(@organizationHealthcareContacts.getStateProvince().length()).to eq(50)
            expect(@organizationHealthcareContacts.getZipPostalCode()).to eq("7777777777")
            expect(@organizationHealthcareContacts.getZipPostalCode().length()).to eq(10)
            expect(@organizationHealthcareContacts.getWebsite()).to eq("agilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.comagilex.com")
            expect(@organizationHealthcareContacts.getWebsite().length()).to eq(100)
            expect(@organizationHealthcareContacts.getNote()).to eq("NotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenotenoteNotenoteno")
            expect(@organizationHealthcareContacts.getNote().length()).to eq(250)
            expect(@organizationHealthcareContacts.getCountDownDisplayForNote()).to eq("0 characters left")

            @organizationHealthcareContacts.setOrganizationName("A NEWER FACILITY")
            @organizationHealthcareContacts.setOrganizationType("")
            @organizationHealthcareContacts.setPrimaryPhone("")
            @organizationHealthcareContacts.setPrimaryPhoneType("")
            @organizationHealthcareContacts.setOtherPhone(1, "")
            @organizationHealthcareContacts.setOtherPhoneType(1, "")
            @organizationHealthcareContacts.clickDeleteOtherPhoneButton(4)
            @organizationHealthcareContacts.clickDeleteOtherPhoneButton(3)
            @organizationHealthcareContacts.clickDeleteOtherPhoneButton(2)
            @organizationHealthcareContacts.setEmail("")
            @organizationHealthcareContacts.setCountry("Select")
            @organizationHealthcareContacts.setAddressLineOne("")
            @organizationHealthcareContacts.setAddressLineTwo("")
            @organizationHealthcareContacts.setCity("")
            @organizationHealthcareContacts.setStateProvince("")
            @organizationHealthcareContacts.setZipPostalCode("")
            @organizationHealthcareContacts.setWebsite("")
            @organizationHealthcareContacts.setNote("")

            @organizationHealthcareContacts.clickSave()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

        it "Focus is on the header. " do
            !10.times{ break if (getFocusedElementText().include?("Healthcare Contacts")); sleep 1 }
            expect(getFocusedElementText()).to eq("Healthcare Contacts")
        end

        it "Updates made to the record are visible in the table, if included in that view." do
            expect(getTextForRow(1).include?("A NEWER FACILITY")).to be true
            expect(getCount()).to eq(9)

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")

            expect(@organizationHealthcareContacts.isOrganizationSelected()).to be true
            expect(@organizationHealthcareContacts.isProviderSelected()).to be false
            expect(@organizationHealthcareContacts.getOrganizationName()).to eq("A NEWER FACILITY")
            expect(@organizationHealthcareContacts.getOrganizationType()).to eq("")
            expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("")
            expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to eq("")
            expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("")
            expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to eq("")
            expect(@organizationHealthcareContacts.getEmail()).to eq("")
            expect(@organizationHealthcareContacts.getCountry()).to eq("Select")
            expect(@organizationHealthcareContacts.getAddressLineOne()).to eq("")
            expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq("")
            expect(@organizationHealthcareContacts.getCity()).to eq("")
            expect(@organizationHealthcareContacts.getState()).to eq("")
            expect(@organizationHealthcareContacts.getZipPostalCode()).to eq("")
            expect(@organizationHealthcareContacts.getWebsite()).to eq("")
            expect(@organizationHealthcareContacts.getNote()).to eq("")
            expect(@organizationHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")
        end

    end

    context "2) Cancel - When a user selects Cancel, " do

        it "No updates are made to the record and the user is shown the table view with the focus placed on the header" do
            @organizationHealthcareContacts.setOrganizationName("ssdfsdfsdf")
            @organizationHealthcareContacts.setOrganizationType("Other")
            @organizationHealthcareContacts.setPrimaryPhone("0000000000")
            @organizationHealthcareContacts.setPrimaryPhoneType("Other")
            @organizationHealthcareContacts.setOtherPhone(1, "1111111111")
            @organizationHealthcareContacts.setOtherPhoneType(1, "Other")
            @organizationHealthcareContacts.setEmail("email@email.com")
            @organizationHealthcareContacts.setCountry("Uzbekistan")
            @organizationHealthcareContacts.setAddressLineOne("500 Address Lane")
            @organizationHealthcareContacts.setAddressLineTwo("Apt D")
            @organizationHealthcareContacts.setCity("Meunster")
            @organizationHealthcareContacts.setStateProvince("Indiana")
            @organizationHealthcareContacts.setZipPostalCode("66666")
            @organizationHealthcareContacts.setWebsite("agilex.dev.com")
            @organizationHealthcareContacts.setNote("Note note note note")

            @organizationHealthcareContacts.clickCancel()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")

            expect(getTextForRow(1).include?("A NEWER FACILITY")).to be true
            expect(getCount()).to eq(9)

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")

            expect(@organizationHealthcareContacts.isOrganizationSelected()).to be true
            expect(@organizationHealthcareContacts.isProviderSelected()).to be false
            expect(@organizationHealthcareContacts.getOrganizationName()).to eq("A NEWER FACILITY")
            expect(@organizationHealthcareContacts.getOrganizationType()).to eq("")
            expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("")
            expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to eq("")
            expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("")
            expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to eq("")
            expect(@organizationHealthcareContacts.getEmail()).to eq("")
            expect(@organizationHealthcareContacts.getCountry()).to eq("Select")
            expect(@organizationHealthcareContacts.getAddressLineOne()).to eq("")
            expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq("")
            expect(@organizationHealthcareContacts.getCity()).to eq("")
            expect(@organizationHealthcareContacts.getState()).to eq("")
            expect(@organizationHealthcareContacts.getZipPostalCode()).to eq("")
            expect(@organizationHealthcareContacts.getWebsite()).to eq("")
            expect(@organizationHealthcareContacts.getNote()).to eq("")
            expect(@organizationHealthcareContacts.getCountDownDisplayForNote()).to eq("250 characters left")

            @organizationHealthcareContacts.clickCancel()
            !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Healthcare Contacts")
        end

    end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)

    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to be true

  end

end

