require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2486: Healthcare Contacts Delete]", :broken => true, :regression => true  do

  before(:all) do

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "healthcareContacts")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickContacts()

    !45.times{ break if (getSecondaryHeader == "Contacts"); sleep 1 }
  expect(getSecondaryHeader).to eq("Contacts")

  @contacts.clickHealthCareContacts
  !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
  expect(getPrimaryHeader).to eq("Healthcare Contacts")

  expect(getCount()).to eq(20)

  @contactCountBeforeDelete = retreiveAllDocumentsInCollection("contacts", "personalprofiledb").length

end

after(:all) do
  quitDriver()
end

context "AC #JRNL-2888|TC #JRNL-1965: (1) When the user selects a Healthcare Contact entry from the table view, the system displays the Healthcare Contact record in the Detail screen in Edit mode." do

  it "(a) Check number of contacts and select first contact in list" do
    expect(@healthcare_contacts_filter.isAllSelected()).to be true

    !10.times{ break if (getFocusedElementText().include?("Name \nAlexandria Hospital \nType \nOrganization\nPrimary Phone \n(111) 000-0003 ")); sleep 1 }

    clickNthRow(8)
    !45.times{ break if (getPrimaryHeader == "Edit Healthcare Contact"); sleep 1 }
    expect(getPrimaryHeader).to eq("Edit Healthcare Contact")
    !10.times{ break if (getFocusedElementText().include?("Edit Healthcare Contact")); sleep 1 }
    expect(getFocusedElementText()).to eq("Edit Healthcare Contact")

    #expect(@healthcare_contacts.isOrganizationSelected()). to be true

  end

  it "(b) Standard Edit functions are available (Save, Cancel, Delete)" do
    expect(@healthcare_contacts.isDeleteButtonVisible()).to be true
    expect(@healthcare_contacts.isCancelButtonVisible()).to be true
    expect(@healthcare_contacts.isSaveButtonVisible()).to be true
  end

end

context " AC #JRNL-2888|TC #JRNL-1965: Delete" do

  it "When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal" do

    @healthcare_contacts.clickDelete()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    expect(@modal.getConfirmButtonText()).to eq("Yes")
    expect(@modal.getCancelButtonText()).to eq("No")
  end

  it "Clicking No closes the modal and returns the user to the Detail entry, edit mode, with focus on the delete button." do
    @modal.clickNoButton()
    !45.times{ break if (getPrimaryHeader == "Edit Healthcare Contact"); sleep 1 }
    expect(getPrimaryHeader).to eq("Edit Healthcare Contact")
    !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
    expect(getFocusedElementText()).to eq("Delete")

    @healthcare_contacts.clickCancel()
    !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
    expect(getPrimaryHeader).to eq("Healthcare Contacts")

    expect(getCount()).to eq(20)
  end

  it "Clicking Yes, closes the modal, and moves the user to the Detail view with the table shown and the deleted item is removed from the table list." do
    clickNthRow(8)
    !45.times{ break if (getPrimaryHeader == "Edit Healthcare Contact"); sleep 1 }
    expect(getPrimaryHeader).to eq("Edit Healthcare Contact")



    @healthcare_contacts.clickDelete()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    expect(@modal.getConfirmButtonText()).to eq("Yes")
    expect(@modal.getCancelButtonText()).to eq("No")

    @modal.clickYesButton()
    !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
    expect(getPrimaryHeader).to eq("Healthcare Contacts")
    !10.times{ break if (getFocusedElementText().include?("Name \nAlexandria Hospital \nType \nOrganization \nPrimary Phone \n(111) 000-0003 ")); sleep 1 }
    expect(getCount()).to eq(19)


  end

  it "All deletes are soft deletes, meaning they are removed from the user's screen but remain in the database for audit purposes. " do
    expect(retreiveAllDocumentsInCollection("contacts", "personalprofiledb").length).to eq(@contactCountBeforeDelete)
  end

end

it "AC #JRNL-2888|TC #JRNL-1965: If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal." do
  clickNthRow(1)
  !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
  expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")

  @healthcare_contacts.setCity("ASDFGHJKL")
  @contacts.clickHealthCareContacts()

  puts "Confirm modal content"
  !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
  expect(@modal.getConfirmationHeading()).to eq("Confirmation")
  expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
  @modal.clickReturnButton()
  !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
  expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")

  @contacts.clickHealthCareContacts()
  !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
  expect(@modal.getConfirmationHeading()).to eq("Confirmation")
  expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
  @modal.clickContinueButton()
  !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
  expect(getPrimaryHeader()).to eq("Healthcare Contacts")

  clickNthRow(1)
  !45.times{ break if (getPrimaryHeader() == "Edit Healthcare Contact"); sleep 1 }
  expect(getPrimaryHeader()).to eq("Edit Healthcare Contact")

  expect(@healthcare_contacts.getCity()).not_to eq("ASDFGHJKL")
  @healthcare_contacts.clickCancel()
  !45.times{ break if (getPrimaryHeader() == "Healthcare Contacts"); sleep 1 }
  expect(getPrimaryHeader()).to eq("Healthcare Contacts")
end
end

