#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2486:  Healthcare Contacts - Add Provider (MaxMin)]", :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("contacts", "personalprofiledb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    contactPosition = 6

    @navMenu.clickContacts
    !45.times{ break if (@contacts.getSecondaryHeader == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader).to eq("Contacts")

    @contacts.clickHealthCareContacts
    !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
    expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-2887|TC-1768: *Add max/min data content" do

    before(:all) do

        @text_10  = "AB0-E.G'IJ"
        @text_30  = @text_10 + @text_10 + @text_10
        @text_50  = @text_10 + @text_10 + @text_10 + @text_10 + @text_10
        @text_40a = "ZB0-E.G'IJ" + @text_10 + @text_10 + @text_10
        @text_50a = "ZB0-E.G'IJ" + @text_10 + @text_10 + @text_10 + @text_10
        @text_100 = @text_50 + @text_50
        @text_250 = @text_100 + @text_100 + @text_50

    end

    context "*Add maximum data content" do

      it ".Enter data" do

        #Click the Add Healthcare Contact button
        @contacts.clickAddButton
        !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
        expect(@providerHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")

        @providerHealthcareContacts.selectProvider()
        @providerHealthcareContacts.setPrefix("Mrs.")
        @providerHealthcareContacts.setFirstName(@text_30)
        @providerHealthcareContacts.setLastName(@text_40a)
        @providerHealthcareContacts.setProviderType("Physician Assistant")
        @providerHealthcareContacts.setSpecialty(@text_50)

        @providerHealthcareContacts.setPrimaryPhone("1112223333")
        #use default phone type

        @providerHealthcareContacts.setOtherPhone(1,"2221113333")
        @providerHealthcareContacts.setOtherPhoneType(1,"Fax")

        @providerHealthcareContacts.clickAddPhoneButton()
        @providerHealthcareContacts.setOtherPhone(2,"2223334444")
        @providerHealthcareContacts.setOtherPhoneType(2,"Mobile")

        @providerHealthcareContacts.clickAddPhoneButton()
        @providerHealthcareContacts.setOtherPhone(3,"4445556666")
        @providerHealthcareContacts.setOtherPhoneType(3,"Other")


        @providerHealthcareContacts.clickAddPhoneButton()
        @providerHealthcareContacts.setOtherPhone(4,"6667778888")
        #OtherPhoneType for #4 left null

        @providerHealthcareContacts.setEmail(@text_100)
        # Use default country of United Stastes  @providerHealthcareContacts.setCountry(...)
        @providerHealthcareContacts.setAddressLineOne(@text_100)
        @providerHealthcareContacts.setAddressLineTwo(@text_100)
        @providerHealthcareContacts.setCity(@text_50)
        @providerHealthcareContacts.setState("District of Columbia")
        @providerHealthcareContacts.setZipPostalCode(@text_10)
        @providerHealthcareContacts.setWebsite(@text_100)
        @providerHealthcareContacts.setNote(@text_250)

        #Save
        @providerHealthcareContacts.clickSave

        #Verify added contact is listed
        !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
        expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

        contactAdded =  "Name \n" +
                          @text_40a + ", " + @text_30 + " \n" +
                        "Type \n" +
                          "Individual Provider \n" +
                        "Primary Phone \n" +
                          "(111) 222-3333 "

        !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }
        expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq(contactAdded)

      end

      it ".Verify entered data" do

        @healthcare_contacts_list.clickOnContactByRow(0)

       !45.times{ break if (getPrimaryHeader == "Edit Healthcare Contact"); sleep 1 }
        expect(@providerHealthcareContacts.getPrimaryHeader).to eq("Edit Healthcare Contact")


        expect(@providerHealthcareContacts.isProviderSelected()).to   eq(true)
        expect(@providerHealthcareContacts.getPrefix()).to eq("Mrs.")
        expect(@providerHealthcareContacts.getFirstName()).to   eq(@text_30)
        expect(@providerHealthcareContacts.getLastName()).to   eq(@text_40a)
        expect(@providerHealthcareContacts.getProviderType()).to   eq("Physician Assistant")
        expect(@providerHealthcareContacts.getSpecialty()).to   eq(@text_50)

        expect(@providerHealthcareContacts.getPrimaryPhone()).to   eq("(111) 222-3333")
        expect(@providerHealthcareContacts.getPrimaryPhoneType()).to   eq("Office")

        expect(@providerHealthcareContacts.getOtherPhone(1)).to   eq("(222) 111-3333")
        expect(@providerHealthcareContacts.getOtherPhoneType(1)).to   eq("Fax")

        expect(@providerHealthcareContacts.getOtherPhone(2)).to   eq("(222) 333-4444")
        expect(@providerHealthcareContacts.getOtherPhoneType(2)).to   eq("Mobile")

        expect(@providerHealthcareContacts.getOtherPhone(3)).to   eq("(444) 555-6666")
        expect(@providerHealthcareContacts.getOtherPhoneType(3)).to   eq("Other")

        expect(@providerHealthcareContacts.getOtherPhone(4)).to   eq("(666) 777-8888")
        expect(@providerHealthcareContacts.getOtherPhoneType(4)).to   eq("")

        expect(@providerHealthcareContacts.getEmail()).to   eq(@text_100)
        expect(@providerHealthcareContacts.getCountry()).to   eq("United States")
        expect(@providerHealthcareContacts.getAddressLineOne()).to   eq(@text_100)
        expect(@providerHealthcareContacts.getAddressLineTwo()).to   eq(@text_100)
        expect(@providerHealthcareContacts.getCity()).to   eq(@text_50)
        expect(@providerHealthcareContacts.getState()).to   eq("District of Columbia")
        expect(@providerHealthcareContacts.getZipPostalCode()).to   eq(@text_10)
        expect(@providerHealthcareContacts.getWebsite()).to   eq(@text_100)
        expect(@providerHealthcareContacts.getNote()).to   eq(@text_250)

        @providerHealthcareContacts.clickSave

      end

    end

    context "*Add minimum data content" do

      it ".Enter data" do

        !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
        expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

        #Click the Add Healthcare Contact button
        @contacts.clickAddButton
        !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
        expect(@providerHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")


        @providerHealthcareContacts.setLastName("a")

        #Save
        @providerHealthcareContacts.clickSave

        #Verify added contact is listed
        !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
        expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

        contactAdded =  "Name \n" +
                          "a \n" +
                        "Type \n" +
                          "Individual Provider \n" +
                        "Primary Phone \n" +
                          " "

        !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }
        expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq(contactAdded)

      end

      it ".Verify entered data" do

        @healthcare_contacts_list.clickOnContactByRow(0)

       !45.times{ break if (getPrimaryHeader == "Edit Healthcare Contact"); sleep 1 }
        expect(@providerHealthcareContacts.getPrimaryHeader).to eq("Edit Healthcare Contact")

        expect(@providerHealthcareContacts.isProviderSelected()).to   eq(true)
        expect(@providerHealthcareContacts.getPrefix()).to eq("")
        expect(@providerHealthcareContacts.getFirstName()).to   eq("")
        expect(@providerHealthcareContacts.getLastName()).to   eq("a")
        expect(@providerHealthcareContacts.getProviderType()).to   eq("")
        expect(@providerHealthcareContacts.getSpecialty()).to   eq("")

        expect(@providerHealthcareContacts.getPrimaryPhone()).to   eq("")
        expect(@providerHealthcareContacts.getPrimaryPhoneType()).to   eq("Office")

        expect(@providerHealthcareContacts.getOtherPhone(1)).to   eq("")
        expect(@providerHealthcareContacts.getOtherPhoneType(1)).to   eq("")

        expect(@providerHealthcareContacts.getEmail()).to   eq("")
        expect(@providerHealthcareContacts.getCountry()).to   eq("United States")
        expect(@providerHealthcareContacts.getAddressLineOne()).to   eq("")
        expect(@providerHealthcareContacts.getAddressLineTwo()).to   eq("")
        expect(@providerHealthcareContacts.getCity()).to   eq("")
        expect(@providerHealthcareContacts.getState()).to   eq("Select")
        expect(@providerHealthcareContacts.getZipPostalCode()).to   eq("")
        expect(@providerHealthcareContacts.getWebsite()).to   eq("")
        expect(@providerHealthcareContacts.getNote()).to   eq("")

        @providerHealthcareContacts.clickSave

      end

    end

  end

end
