#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized


describe "[Story #JRNL-2486:  Healthcare Contacts - Add Provider]", :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("contacts", "personalprofiledb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickContacts
    !45.times{ break if (@contacts.getSecondaryHeader == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader).to eq("Contacts")

  end

  after(:all) do
    quitDriver()
  end

  context "AC JRNL-2886|TC-1781: 1. When the user views the Healthcare Contacts Table list, " do

    it "An Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
      @contacts.clickHealthCareContacts
      !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
      expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")
      expect(@contacts.isAddVisible).to eq(true)
      waitForPageToFinishLoading
      @healthcare_contacts_filter.clickProviderRadioButton()
      @healthcare_contacts_filter.clickFilterButton()

    end

  end

  context "AC JRNL-2886|TC-1781: 1.a. When a user selects Add, " do

    it "The Add Healthcare Contacts screen is shown, header: Add Healthcare Contact" do
      @contacts.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
      expect(@providerHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")
    end

    describe "AC JRNL-2887|TC-1768: 1.b. Detailed Healthcare Contact fields include the following:" do

      before(:all) do
        @contactAddForm = @providerHealthcareContacts.stripSelectTextFromScreen(
              @providerHealthcareContacts.getScreenContent().split("\n"),
               [  'addressCountry',
                  'addressStateAbbreviation',
                  'primaryPhoneType',
                  'otherPhoneType1',
                  'providerType',
                  'prefix'
               ]
        )
        #DEBUG @contactAddForm.each_with_index do | row, i |
        #DEBUG   puts "dump screen content[#{i}] --> [#{row}]"
        #DEBUG end

      end

      it "(Check all visible labels and screen reader alt text on screen)" do

        textOnScreen = [
                "* required field",
                "",
                "Type:",
                "Individual Provider",
                "Organization",
                "Prefix:",
                "First Name:",
                "30 character maximum",
                "* Last Name:",
                "40 character maximum",
                "Provider Type:",
                "Specialty:",
                "50 character maximum",
                "Primary Phone:",
                "Enter 10 digits",
                "Primary Phone Type:",
                "Other Phone:",
                "Enter 10 digits",
                "Other Phone Type:",
                " Add Phone",
                "Email:",
                "100 character maximum",
                "Address",
                "Country:",
                "Address Line 1:",
                "100 character maximum",
                "Address Line 2:",
                "100 character maximum",
                "City:",
                "50 character maximum",
                "State:",
                "ZIP/Postal Code:",
                "10 character maximum",
                "Website:",
                "100 character maximum",
                "Note:",
                "250 character maximum",
                "250 characters left",
                "Save Cancel"
          ]

        textOnScreen.each_with_index do | expectedScreenRow, i |
          #DEBUG puts "comparing [#{i}] expected=[#{expectedScreenRow}]  actual=[#{@contactAddForm[i]}]"
          expect(@contactAddForm[i]).to eq(expectedScreenRow)
        end
        expect(@contactAddForm.length).to eq(textOnScreen.length)

      end


      #it "Note: Unless otherwise indicated, all values default to null (or select for drop lists),
      #no guidance text (light gray placeholder text) is shown, and all fields are optional."

      it "Contact Type (single select, radio buttons, values: Individual Provider (default), Organization)" do

        expect(@providerHealthcareContacts.isProviderSelected).to eq(true)
        expect(@providerHealthcareContacts.isOrganizationSelected).to eq(false)

      end

      context "If the Type = Provider, then display the following fields immediately below type and above the Phone fields:" do

        it "Prefix (single select, drop list, values: Select, Dr. Ms. Mrs. Mr.)" do

          prefix_list = [ "Dr.", "Ms.", "Mrs.", "Mr." ]
          prefix_list.each_with_index do | prefix, i |
            @providerHealthcareContacts.setPrefix(prefix)
            expect(@providerHealthcareContacts.getPrefix()).to eq(prefix)
          end

        end

        it "Provider Type (Select, Physician, Nurse Practitioner, Physician Assistant, Dentist, Pharmacist, Chiropractor, Nurse, Other)" do

          providerTypes = [ "Physician",
                            "Nurse Practitioner",
                            "Physician Assistant",
                            "Dentist",
                            "Pharmacist",
                            "Chiropractor",
                            "Nurse",
                            "Other"
                          ]

          providerTypes.each_with_index do | providerValue, i |
            @providerHealthcareContacts.setProviderType(providerValue)
            expect(@providerHealthcareContacts.getProviderType()).to eq(providerValue)
          end

        end



        it "First Name (alphanumeric characters, textbox, 30 characters)" do

          #default to null
          expect(@providerHealthcareContacts.getFirstName()).to eq("")

          firstName = "abcdefghij"
          @providerHealthcareContacts.setFirstName(firstName)
          expect(@providerHealthcareContacts.getFirstName().length).to eq(10)
          expect(@providerHealthcareContacts.getFirstName()).to eq(firstName)

          firstName = "abcdefghij" + "abcdefghij" + "abcdefghij"
          @providerHealthcareContacts.setFirstName(firstName)
          expect(@providerHealthcareContacts.getFirstName().length).to eq(30)
          expect(@providerHealthcareContacts.getFirstName()).to eq(firstName)

          firstName_1 = firstName  + "x"
          @providerHealthcareContacts.setFirstName(firstName_1)
          expect(@providerHealthcareContacts.getFirstName().length).to eq(30)
          expect(@providerHealthcareContacts.getFirstName()).to eq(firstName)

        end


        it "Last Name (required, alphanumeric characters, textbox, 40 characters)" do
          #default to null
          expect(@providerHealthcareContacts.getLastName()).to eq("")

          lastName = "abcdefghij"
          @providerHealthcareContacts.setLastName(lastName)
          expect(@providerHealthcareContacts.getLastName().length).to eq(10)
          expect(@providerHealthcareContacts.getLastName()).to eq(lastName)

          lastName = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          @providerHealthcareContacts.setLastName(lastName)
          expect(@providerHealthcareContacts.getLastName().length).to eq(40)
          expect(@providerHealthcareContacts.getLastName()).to eq(lastName)

          lastName_1 = lastName + "x"
          @providerHealthcareContacts.setLastName(lastName_1)
          expect(@providerHealthcareContacts.getLastName().length).to eq(40)
          expect(@providerHealthcareContacts.getLastName()).to eq(lastName)

          lastName = "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x"
          @providerHealthcareContacts.setLastName(lastName)
          expect(@providerHealthcareContacts.getLastName().length).to eq(40)
          expect(@providerHealthcareContacts.getLastName()).to eq(lastName)

        end




        it "Specialty (text, 50 characters)" do
          #default to null
          expect(@providerHealthcareContacts.getSpecialty()).to eq("")

          specialty = "abcdefghij"
          @providerHealthcareContacts.setSpecialty(specialty)
          expect(@providerHealthcareContacts.getSpecialty().length).to eq(10)
          expect(@providerHealthcareContacts.getSpecialty()).to eq(specialty)

          specialty = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          @providerHealthcareContacts.setSpecialty(specialty)
          expect(@providerHealthcareContacts.getSpecialty().length).to eq(50)
          expect(@providerHealthcareContacts.getSpecialty()).to eq(specialty)

          specialty_1 = specialty  + "x"
          @providerHealthcareContacts.setSpecialty(specialty_1)
          expect(@providerHealthcareContacts.getSpecialty().length).to eq(50)
          expect(@providerHealthcareContacts.getSpecialty()).to eq(specialty)

        end

      end

      context "For both contact types, the following are always shown:" do

        it "v. Primary Phone (format is constrained to (###) ###-####; guidance text (light gray) is shown to convey format. " do
          #default to null
          expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("")

          @providerHealthcareContacts.setPrimaryPhone("1112223333")
          expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("(111) 222-3333")

        end


        it "v. Entry is constrained to numeric. Format is maintained in the field as the user adds the phone number. ", :broken => true do

          @providerHealthcareContacts.setPrimaryPhone("AAA123cccc")
          expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("(123) ###-####")

          @providerHealthcareContacts.setPrimaryPhone("7038893800")
          expect(@providerHealthcareContacts.getPrimaryPhone()).to eq("(703) 889-3800")

        end

        it "v. Voice over users will hear guidance indicating the field accepts 10 digit phone numbers using numeric entry only." do
          #Look in screen contents.  Find "Primary Phone" entry and then check content of next line
          expect(@contactAddForm[@contactAddForm.index('Primary Phone:')+1]).to eq("Enter 10 digits")
        end

        it "vi. Primary Phone Type: select, Office (default), Fax, mobile, other" do

          expect(@providerHealthcareContacts.getPrimaryPhoneType()).to eq("Office")

          phoneTypes = [ "Office", "Fax",  "Mobile",  "Other"  ]
          phoneTypes.each_with_index do | value, i |
            @providerHealthcareContacts.setPrimaryPhoneType(value)
            expect(@providerHealthcareContacts.getPrimaryPhoneType()).to eq(value)
          end
          @providerHealthcareContacts.setPrimaryPhoneType("Mobile")

        end

        it "vii. Other Phone (one to four additional other phone numbers and other phone types can be added; formatting matches Primary Phone )", :broken => true do

          expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("")

          @providerHealthcareContacts.setOtherPhone(1,"1112223333")
          expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("(111) 222-3333")

          @providerHealthcareContacts.setOtherPhone(1,"AAA123cccc")
          expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("(123) ###-####")

          @providerHealthcareContacts.setOtherPhone(1,"7038895000")
          expect(@providerHealthcareContacts.getOtherPhone(1)).to eq("(703) 889-5000")

        end

        it "ix. Other Phone Type: select (default), Office, Fax, mobile, other" do

          phoneTypes = [ "Office", "Fax",  "Mobile",  "Other"  ]
          for i in 1..1 do
            expect(@providerHealthcareContacts.getOtherPhoneType(i)).to eq("")
            phoneTypes.each_with_index do | value, j |
              @providerHealthcareContacts.setOtherPhoneType(i,value)
              expect(@providerHealthcareContacts.getOtherPhoneType(i)).to eq(value)
            end
          end

        end

        it "1. Add Phone (button, alt text same as label, selecting adds another Other Phone number field and another Other Phone Type field; " do
          #Look in screen contents.  Find "Other Phone" entry and then check content of next two lines
          expect(@contactAddForm[@contactAddForm.index('Other Phone:')+1]).to eq("Enter 10 digits")
          expect(@contactAddForm[@contactAddForm.index('Other Phone:')+2]).to eq("Other Phone Type:")
        end

        it "when added focus is placed on newly added Other Phone Number field);" do
            @providerHealthcareContacts.clickAddPhoneButton()
            expect(getActiveElement().attribute('name')).to eq("otherPhone2")
        end

      end

      context "2. If more than one 'Other Phone' field is added a delete option is added next to the Other Phone fields " do

        xit "('x Delete' button, alt text reads: Delete <data for phone number of field to be deleted and phone type selected for that phone number>);", :broken => true do

          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(1)).to eq(true)
          expect(@providerHealthcareContacts.getDeleteOtherPhoneButtonAltText(1)).to eq("Delete Other Phone Number (703) 889-5000 with type Other")

          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(2)).to eq(true)
          expect(@providerHealthcareContacts.getDeleteOtherPhoneButtonAltText(2)).to eq("Delete Other Phone Number Empty with type none")

          @providerHealthcareContacts.clickAddPhoneButton()
          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(3)).to eq(true)
          @providerHealthcareContacts.setOtherPhone(3,"7038896666")
          @providerHealthcareContacts.setOtherPhoneType(3,"Mobile")

          @providerHealthcareContacts.clickAddPhoneButton()
          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(4)).to eq(true)
          @providerHealthcareContacts.setOtherPhone(4,"7038897777")
          @providerHealthcareContacts.setOtherPhoneType(4,"Fax")

        end

        xit " Deletes may occur in any order and are not confirmed (no modal is shown);", :broken => true do
          waitForPageToFinishLoading
          waitForPageToFinishLoading
          @providerHealthcareContacts.clickDeleteOtherPhoneButton(3)

          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(4)).to eq(false)
          expect(@providerHealthcareContacts.getOtherPhone(3)).to eq("(703) 889-7777")
          expect(@providerHealthcareContacts.getOtherPhoneType(3)).to eq("Fax")

          @providerHealthcareContacts.clickDeleteOtherPhoneButton(2)
          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(3)).to eq(false)
          expect(@providerHealthcareContacts.getOtherPhone(2)).to eq("(703) 889-7777")
          expect(@providerHealthcareContacts.getOtherPhoneType(2)).to eq("Fax")

        end

        it "When only one 'Other phone number' field set is shown the delete option is removed.)" do
          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(1)).to eq(true)
          @providerHealthcareContacts.clickDeleteOtherPhoneButton(2)
          expect(@providerHealthcareContacts.isDeleteOtherPhoneButtonVisible(1)).to eq(false)
        end

        it "(null other phone or other phone type records are permitting)" do
            @providerHealthcareContacts.clickAddPhoneButton()
        end

        it "x. Email (100 characters, text, validation to be added later)" do
          expect(@providerHealthcareContacts.getEmail()).to eq("")

          email_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          email_100 = email_50 + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdef.com"
          @providerHealthcareContacts.setEmail(email_100)
          expect(@providerHealthcareContacts.getEmail().length).to eq(100)
          expect(@providerHealthcareContacts.getEmail()).to eq(email_100)

          email_101 =  email_100 + "x"
          @providerHealthcareContacts.setEmail(email_101)
          expect(@providerHealthcareContacts.getEmail().length).to eq(100)
          expect(@providerHealthcareContacts.getEmail()).to eq(email_100)

        end

      end


      describe "xi. Address (section label for fields below)" do

        it "1. Country, select list, default to US" do
          expect(@providerHealthcareContacts.getCountry()).to eq("United States")
        end

        it "If country = US show State (US) drop down select" do
          # verify state label
          expect(@providerHealthcareContacts.getStateLabel()).to eq("State:")

        end

        it "2. Address Line 1 (alphanumeric, text box, 100 characters)" do
          expect(@providerHealthcareContacts.getAddressLineOne()).to eq("")

          text_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          text_100 = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @providerHealthcareContacts.setAddressLineOne(text_100)
          expect(@providerHealthcareContacts.getAddressLineOne().length).to eq(100)
          expect(@providerHealthcareContacts.getAddressLineOne()).to eq(text_100)

          text_101 =  text_100 + "x"
          @providerHealthcareContacts.setAddressLineOne(text_101)
          expect(@providerHealthcareContacts.getAddressLineOne().length).to eq(100)
          expect(@providerHealthcareContacts.getAddressLineOne()).to eq(text_100)

        end

        it "3. Address line 2 (alphanumeric, text box, 100 characters)" do
          expect(@providerHealthcareContacts.getAddressLineTwo()).to eq("")

          text_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          text_100 = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @providerHealthcareContacts.setAddressLineTwo(text_100)
          expect(@providerHealthcareContacts.getAddressLineTwo().length).to eq(100)
          expect(@providerHealthcareContacts.getAddressLineTwo()).to eq(text_100)

          text_101 =  text_100 + "x"
          @providerHealthcareContacts.setAddressLineTwo(text_101)
          expect(@providerHealthcareContacts.getAddressLineTwo().length).to eq(100)
          expect(@providerHealthcareContacts.getAddressLineTwo()).to eq(text_100)

        end

        it "4. City (alphanumeric, text box, 50 characters)" do

          text_50 = "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ"
          @providerHealthcareContacts.setCity(text_50)
          expect(@providerHealthcareContacts.getCity().length).to eq(50)
          expect(@providerHealthcareContacts.getCity()).to eq(text_50)

          text_51 =  text_50 + "x"
          @providerHealthcareContacts.setCity(text_51)
          expect(@providerHealthcareContacts.getCity().length).to eq(50)
          expect(@providerHealthcareContacts.getCity()).to eq(text_50)

        end

        it "5. State (select list, select option shown as default and is equivalent to null; " do
          expect(@providerHealthcareContacts.getState()).to eq("Select")
          expect(@providerHealthcareContacts.getStateByValue()).to eq("")
        end

        xit "standard list to be used that includes DC and Puerto Rico)", :broken => true do
          @providerHealthcareContacts.setState("District of Columbia")
          expect(@providerHealthcareContacts.getState()).to eq("District of Columbia")
          @providerHealthcareContacts.setState("Puerto Rico")
          expect(@providerHealthcareContacts.getState()).to eq("Puerto Rico")
          expect(@providerHealthcareContacts.getStateByValue()).to eq("42")
        end

        it "If country is not US then show free text: State/Province" do
          @providerHealthcareContacts.setCountry("United Kingdom")
          expect(@providerHealthcareContacts.getCountry()).to eq("United Kingdom")

          expect(@providerHealthcareContacts.getStateLabel()).to eq("State/Province:")
        end

        it "6. State/Province (text, 50 characters)" do

          text_50 = "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @providerHealthcareContacts.setStateProvince(text_50)
          expect(@providerHealthcareContacts.getStateProvince().length).to eq(50)
          expect(@providerHealthcareContacts.getStateProvince()).to eq(text_50)

          text_51 =  text_50 + "x"
          @providerHealthcareContacts.setStateProvince(text_51)
          expect(@providerHealthcareContacts.getStateProvince().length).to eq(50)
          expect(@providerHealthcareContacts.getStateProvince()).to eq(text_50)

        end

        it "7. ZIP/Postal Code (alphanumeric, text box, 10 characters)" do

          expect(@providerHealthcareContacts.getZipPostalCode()).to eq("")

          text_10 = "123defGHIJ"
          @providerHealthcareContacts.setZipPostalCode(text_10)
          expect(@providerHealthcareContacts.getZipPostalCode().length).to eq(10)
          expect(@providerHealthcareContacts.getZipPostalCode()).to eq(text_10)

          text_11 =  text_10 + "x"
          @providerHealthcareContacts.setZipPostalCode(text_11)
          expect(@providerHealthcareContacts.getZipPostalCode().length).to eq(10)
          expect(@providerHealthcareContacts.getZipPostalCode()).to eq(text_10)

        end


        it "8. Website (alphanumeric, textbox, 100 characters)" do

          expect(@providerHealthcareContacts.getWebsite()).to eq("")

          text_50 = "http://www" + ".bcdefghij" + ".bcdefghij" + "abcdefghij" + "abcdefghij"
          text_100 = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @providerHealthcareContacts.setWebsite(text_100)
          expect(@providerHealthcareContacts.getWebsite().length).to eq(100)
          expect(@providerHealthcareContacts.getWebsite()).to eq(text_100)

          text_101 =  text_100 + "x"
          @providerHealthcareContacts.setWebsite(text_101)
          expect(@providerHealthcareContacts.getWebsite().length).to eq(100)
          expect(@providerHealthcareContacts.getWebsite()).to eq(text_100)

        end


        it "9. Note (alphanumeric, textbox, 250 character, character countdown)" do

          text99 = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"
          @providerHealthcareContacts.setNote(text99)
          expect(@providerHealthcareContacts.getNote.length).to eq(99)
          expect(@providerHealthcareContacts.getNote).to eq(text99)
          expect(@providerHealthcareContacts.getCountDownDisplayForNote).to eq("151 characters left")

          text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
          @providerHealthcareContacts.setNote(text200)
          expect(@providerHealthcareContacts.getNote.length).to eq(200)
          expect(@providerHealthcareContacts.getNote).to eq(text200)
          expect(@providerHealthcareContacts.getCountDownDisplayForNote).to eq("50 characters left")

          text250 = text200 + "12345678901234567890123456789012345678901234567890"
          @providerHealthcareContacts.setNote(text250)
          expect(@providerHealthcareContacts.getNote.length).to eq(250)
          expect(@providerHealthcareContacts.getNote).to eq(text250)
          expect(@providerHealthcareContacts.getCountDownDisplayForNote).to eq("0 characters left")

          text251 = text250 + "x"
          @providerHealthcareContacts.setNote(text250)
          expect(@providerHealthcareContacts.getNote.length).to eq(250)
          expect(@providerHealthcareContacts.getNote).to eq(text250)
          expect(@providerHealthcareContacts.getCountDownDisplayForNote).to eq("0 characters left")

        end

      end

      context "Required fields" do
        it "Last Name required" do
          @providerHealthcareContacts.setLastName("")
          @providerHealthcareContacts.clickSave()

          expectedValidationSummaryHeader = "The following errors were found:"
          !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("entryForm")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("entryForm", "Last Name field is required.")).to eq(true)

          lastName = "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x"
          @providerHealthcareContacts.setLastName(lastName)
          expect(@providerHealthcareContacts.getLastName().length).to eq(40)

        end
      end

    end


    describe "AC JRNL-2888|TC-1767: c. Standard Save and Cancel options are available:" do

      context "1) Save - When a user selects Save" do

        it "The system saves the record and the user is returned to the table view, " do
          @providerHealthcareContacts.clickSave
          !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")
        end

        it "Focus is on the header. " do
          expect(getFocusedElementText()).to eq(@contacts.getPrimaryHeader)
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

        end

        xit "Updates made to the record are visible in the table, if included in that view.", :broken => true do

          contactAdded =  "Name \n" +
                            "abcdefghij1234567890ABCDEFGHIJ --'-----x, abcdefghijabcdefghijabcdefghij \n"+
                          "Type \n" +
                            "Individual Provider \n" +
                          "Primary Phone \n" +
                            "(703) 889-3800 "

          !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }
          expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq(contactAdded)
          expect(@healthcare_contacts_list.getContactsCount()).to eq(1)

        end


        xit "(Verify data)", :broken => true do

          @healthcare_contacts_list.clickOnContactByRow(0)

          firstName = "abcdefghij" + "abcdefghij" + "abcdefghij"
          lastName = "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x"
          specialty = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          email_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          email_100 = email_50 + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdef.com"
          text_50_city = "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ"
          text_50_prov = "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          text_10_zip = "123defGHIJ"
          text_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          text_100_addr = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          text_50 = "http://www" + ".bcdefghij" + ".bcdefghij" + "abcdefghij" + "abcdefghij"
          text_100_web = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
          text_250_note = text200 + "12345678901234567890123456789012345678901234567890"

          expect(@providerHealthcareContacts.isProviderSelected()).to   eq(true)
          expect(@providerHealthcareContacts.getPrefix()).to eq("Mr.")
          expect(@providerHealthcareContacts.getFirstName()).to   eq(firstName)
          expect(@providerHealthcareContacts.getLastName()).to   eq(lastName)
          expect(@providerHealthcareContacts.getProviderType()).to   eq("Other")
          expect(@providerHealthcareContacts.getSpecialty()).to   eq(specialty)

          expect(@providerHealthcareContacts.getPrimaryPhone()).to   eq("(703) 889-3800")
          expect(@providerHealthcareContacts.getPrimaryPhoneType()).to   eq("Mobile")

          expect(@providerHealthcareContacts.getOtherPhone(1)).to   eq("(703) 889-5000")
          expect(@providerHealthcareContacts.getOtherPhoneType(1)).to   eq("Other")

          expect(@providerHealthcareContacts.getOtherPhone(2)).to   eq("")
          expect(@providerHealthcareContacts.getOtherPhoneType(2)).to   eq("")

          expect(@providerHealthcareContacts.getEmail()).to   eq(email_100)
          expect(@providerHealthcareContacts.getCountry()).to   eq("United Kingdom")
          expect(@providerHealthcareContacts.getAddressLineOne()).to   eq(text_100_addr)
          expect(@providerHealthcareContacts.getAddressLineTwo()).to   eq(text_100_addr)
          expect(@providerHealthcareContacts.getCity()).to   eq(text_50_city)
          expect(@providerHealthcareContacts.getStateProvince()).to   eq(text_50_prov)
          expect(@providerHealthcareContacts.getZipPostalCode()).to   eq(text_10_zip)
          expect(@providerHealthcareContacts.getWebsite()).to   eq(text_100_web)
          expect(@providerHealthcareContacts.getNote()).to   eq(text_250_note)
        end

      end


      context "2) Cancel - When a user selects Cancel, ", :broken => true do

        before(:all) do
          waitForPageToFinishLoading
          @providerHealthcareContacts.clickCancel

          !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

          @contacts.clickAddButton
          !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
          expect(@providerHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")

          @providerHealthcareContacts.setLastName("a")
          @providerHealthcareContacts.clickCancel
          !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }

        end

        it "No updates are made to the record " do
          expect(@healthcare_contacts_list.getContactsCount()).to eq(1)
        end

        it "User is shown the table view with the focus placed on the header" do
          expect(getFocusedElementText()).to eq(@contacts.getPrimaryHeader)
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")
        end

      end

    end

  end

end