#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized



describe "[Story #JRNL-2486:  Healthcare Contacts - Add Organization (MaxMin)]", :regression => true do

    before(:all) do
        initializeConfigurations(BASE_URL)
        removeCollection("contacts", "personalprofiledb")

        initializeAllObjects

        @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

        expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

        @main.clickNavMenu()
        !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
        contactPosition = 6

        @navMenu.clickContacts
        !45.times{ break if (@contacts.getSecondaryHeader == "Contacts"); sleep 1 }
        expect(@contacts.getSecondaryHeader).to eq("Contacts")

        @contacts.clickHealthCareContacts
        !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
        expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

    end

    after(:all) do
        quitDriver()
    end


    describe "AC JRNL-2887|TC-1768: *Add max/min data content" do

        before(:all) do

            @text_10  = "AB0-E.G'IJ"
            @text_50  = @text_10 + @text_10 + @text_10 + @text_10 + @text_10
            @text_100a = "ZB0-E.G'IJ" + @text_10 + @text_10 + @text_10 + @text_10 + @text_50
            @text_100 = @text_50 + @text_50
            @text_250 = @text_100 + @text_100 + @text_50

        end

        context "*Add maximum data content" do

            it ".Enter data" do

                #Click the Add Healthcare Contact button
                @contacts.clickAddButton
                !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
                expect(@organizationHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")

                @organizationHealthcareContacts.selectOrganization()

                @organizationHealthcareContacts.setOrganizationName(@text_100a)
                @organizationHealthcareContacts.setOrganizationType("Hospital")

                @organizationHealthcareContacts.setPrimaryPhone("1112223333")
                #use default phone type

                @organizationHealthcareContacts.setOtherPhone(1,"2221113333")
                @organizationHealthcareContacts.setOtherPhoneType(1,"Fax")

                @organizationHealthcareContacts.clickAddPhoneButton()
                @organizationHealthcareContacts.setOtherPhone(2,"2223334444")
                @organizationHealthcareContacts.setOtherPhoneType(2,"Mobile")

                @organizationHealthcareContacts.clickAddPhoneButton()
                @organizationHealthcareContacts.setOtherPhone(3,"4445556666")
                @organizationHealthcareContacts.setOtherPhoneType(3,"Other")


                @organizationHealthcareContacts.clickAddPhoneButton()
                @organizationHealthcareContacts.setOtherPhone(4,"6667778888")
                #OtherPhoneType for #4 left null

                @organizationHealthcareContacts.setEmail(@text_100)
                # Use default country of United Stastes
                @organizationHealthcareContacts.setAddressLineOne(@text_100)
                @organizationHealthcareContacts.setAddressLineTwo(@text_100)
                @organizationHealthcareContacts.setCity(@text_50)
                @organizationHealthcareContacts.setState("District of Columbia")
                @organizationHealthcareContacts.setZipPostalCode(@text_10)
                @organizationHealthcareContacts.setWebsite(@text_100)
                @organizationHealthcareContacts.setNote(@text_250)

                #Save
                @organizationHealthcareContacts.clickSave

                #Verify added contact is listed
                !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
                expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

                contactAdded =  "Name \n" +
                    @text_100a + " \n" +
                    "Type \n" +
                    "Organization \n" +
                    "Primary Phone \n" +
                    "(111) 222-3333 "

                !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }
                expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq(contactAdded)

            end

            it ".Verify entered data" do

                @healthcare_contacts_list.clickOnContactByRow(0)

                !45.times{ break if (getPrimaryHeader == "Edit Healthcare Contact"); sleep 1 }
                expect(@organizationHealthcareContacts.getPrimaryHeader).to eq("Edit Healthcare Contact")

                expect(@organizationHealthcareContacts.isOrganizationSelected()).to   eq(true)
                expect(@organizationHealthcareContacts.getOrganizationName()).to   eq(@text_100a)

                expect(@organizationHealthcareContacts.getOrganizationType()).to   eq("Hospital")

                expect(@organizationHealthcareContacts.getPrimaryPhone()).to   eq("(111) 222-3333")
                expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to   eq("Office")

                expect(@organizationHealthcareContacts.getOtherPhone(1)).to   eq("(222) 111-3333")
                expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to   eq("Fax")

                expect(@organizationHealthcareContacts.getOtherPhone(2)).to   eq("(222) 333-4444")
                expect(@organizationHealthcareContacts.getOtherPhoneType(2)).to   eq("Mobile")

                expect(@organizationHealthcareContacts.getOtherPhone(3)).to   eq("(444) 555-6666")
                expect(@organizationHealthcareContacts.getOtherPhoneType(3)).to   eq("Other")

                expect(@organizationHealthcareContacts.getOtherPhone(4)).to   eq("(666) 777-8888")
                expect(@organizationHealthcareContacts.getOtherPhoneType(4)).to   eq("")

                expect(@organizationHealthcareContacts.getEmail()).to   eq(@text_100)
                expect(@organizationHealthcareContacts.getCountry()).to   eq("United States")
                expect(@organizationHealthcareContacts.getAddressLineOne()).to   eq(@text_100)
                expect(@organizationHealthcareContacts.getAddressLineTwo()).to   eq(@text_100)
                expect(@organizationHealthcareContacts.getCity()).to   eq(@text_50)
                expect(@organizationHealthcareContacts.getState()).to   eq("District of Columbia")
                expect(@organizationHealthcareContacts.getZipPostalCode()).to   eq(@text_10)
                expect(@organizationHealthcareContacts.getWebsite()).to   eq(@text_100)
                expect(@organizationHealthcareContacts.getNote()).to   eq(@text_250)

                @organizationHealthcareContacts.clickSave

            end

        end

        context "*Add minimum data content" do

            it ".Enter data" do

                !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
                expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

                #Click the Add Healthcare Contact button
                @contacts.clickAddButton
                !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
                expect(@organizationHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")

                @organizationHealthcareContacts.selectOrganization()

                @organizationHealthcareContacts.setOrganizationName("a")

                #Save
                @organizationHealthcareContacts.clickSave

                #Verify added contact is listed
                !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
                expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

                contactAdded =  "Name \n" +
                    "a \n" +
                    "Type \n" +
                    "Organization \n" +
                    "Primary Phone \n" +
                    " "

                !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }
                expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq(contactAdded)

            end

            it ".Verify entered data" do

                @healthcare_contacts_list.clickOnContactByRow(0)

                !45.times{ break if (getPrimaryHeader == "Edit Healthcare Contact"); sleep 1 }
                expect(@organizationHealthcareContacts.getPrimaryHeader).to eq("Edit Healthcare Contact")

                expect(@organizationHealthcareContacts.isOrganizationSelected()).to   eq(true)

                expect(@organizationHealthcareContacts.getOrganizationName()).to   eq("a")
                expect(@organizationHealthcareContacts.getOrganizationType()).to   eq("")

                expect(@organizationHealthcareContacts.getPrimaryPhone()).to   eq("")
                expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to   eq("Office")

                expect(@organizationHealthcareContacts.getOtherPhone(1)).to   eq("")
                expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to   eq("")

                expect(@organizationHealthcareContacts.getEmail()).to   eq("")
                expect(@organizationHealthcareContacts.getCountry()).to   eq("United States")
                expect(@organizationHealthcareContacts.getAddressLineOne()).to   eq("")
                expect(@organizationHealthcareContacts.getAddressLineTwo()).to   eq("")
                expect(@organizationHealthcareContacts.getCity()).to   eq("")
                expect(@organizationHealthcareContacts.getState()).to   eq("Select")
                expect(@organizationHealthcareContacts.getZipPostalCode()).to   eq("")
                expect(@organizationHealthcareContacts.getWebsite()).to   eq("")
                expect(@organizationHealthcareContacts.getNote()).to   eq("")

                @organizationHealthcareContacts.clickSave

            end

        end

    end


end