#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2486:  Healthcare Contacts - Add Organization]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("contacts", "personalprofiledb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    #contactPosition = 6

    @navMenu.clickContacts
    !45.times{ break if (@contacts.getSecondaryHeader == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader).to eq("Contacts")

  end

  after(:all) do
    quitDriver()
  end

  context "AC JRNL-2886|TC-1781: 1. When the user views the Healthcare Contacts Table list, " do

    it "An Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
      @contacts.clickHealthCareContacts
      !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
      expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")
      expect(@contacts.isAddVisible).to eq(true)

      @healthcare_contacts_filter.clickOrganizationRadioButton()
      @healthcare_contacts_filter.clickFilterButton()

    end

  end

  context "AC JRNL-2886|TC-1781: 1.a. When a user selects Add, " do

    it "The Add Healthcare Contacts screen is shown, header: Add Healthcare Contact" do
      @contacts.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
      expect(@organizationHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")
    end

    describe "AC JRNL-2887|TC-1786: 1.b. Detailed Healthcare Contact fields include the following:" do

      before(:all) do

        @organizationHealthcareContacts.selectOrganization

        @contactAddForm = @organizationHealthcareContacts.stripSelectTextFromScreen(
              @organizationHealthcareContacts.getScreenContent().split("\n"),
               [  'addressCountry',
                  'addressStateAbbreviation',
                  'primaryPhoneType',
                  'otherPhoneType1',
                  'association'
               ]
        )
        #DEBUG @contactAddForm.each_with_index do | row, i |
        #DEBUG   puts "dump screen content[#{i}] --> [#{row}]"
        #DEBUG end

      end

      it "(Check all visible labels and screen reader alt text on screen)" do

        textOnScreen = [
                "* required field",
                "",
                "Type:",
                "Individual Provider",
                "Organization",
                "Type:",
                "* Name:",
                "100 character maximum",
                "Primary Phone:",
                "Enter 10 digits",
                "Primary Phone Type:",
                "Other Phone:",
                "Enter 10 digits",
                "Other Phone Type:",
                " Add Phone",
                "Email:",
                "100 character maximum",
                "Address",
                "Country:",
                "Address Line 1:",
                "100 character maximum",
                "Address Line 2:",
                "100 character maximum",
                "City:",
                "50 character maximum",
                "State:",
                "ZIP/Postal Code:",
                "10 character maximum",
                "Website:",
                "100 character maximum",
                "Note:",
                "250 character maximum",
                "250 characters left",
                "Save Cancel"
          ]

        textOnScreen.each_with_index do | expectedScreenRow, i |
          #DEBUG puts "comparing [#{i}] expected=[#{expectedScreenRow}]  actual=[#{@contactAddForm[i]}]"
          expect(@contactAddForm[i]).to eq(expectedScreenRow)
        end

      end


      #it "Note: Unless otherwise indicated, all values default to null (or select for drop lists),
      #no guidance text (light gray placeholder text) is shown, and all fields are optional."

      it "Contact Type (single select, radio buttons, values: Individual Provider (default), Organization)" do

        expect(@organizationHealthcareContacts.isOrganizationSelected).to eq(true)
        expect(@organizationHealthcareContacts.isProviderSelected).to eq(false)

      end

      context "If the Type = Organization, then display" do

        it "Type (single select, select list, Values: Select, Clinic, Hospital, Lab, Pharmacy, Nursing Home, Other)" do

          expect(@organizationHealthcareContacts.getOrganizationType()).to eq("")

          organizationTypes = [
            "Clinic",
            "Hospital",
            "Lab",
            "Pharmacy",
            "Nursing Home",
            "Other"
          ]

          organizationTypes.each_with_index do | organizationValue, i |
            @organizationHealthcareContacts.setOrganizationType(organizationValue)
            expect(@organizationHealthcareContacts.getOrganizationType()).to eq(organizationValue)
          end

        end


        it "Name (required, 100 characters, text)" do
          #default to null
          expect(@organizationHealthcareContacts.getOrganizationName()).to eq("")

          fName = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          organizationName = fName + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"

          @organizationHealthcareContacts.setOrganizationName(fName)
          expect(@organizationHealthcareContacts.getOrganizationName().length).to eq(50)
          expect(@organizationHealthcareContacts.getOrganizationName()).to eq(fName)

          @organizationHealthcareContacts.setOrganizationName(organizationName)
          expect(@organizationHealthcareContacts.getOrganizationName().length).to eq(100)
          expect(@organizationHealthcareContacts.getOrganizationName()).to eq(organizationName)

          organizationName_1 = organizationName + "x"
          @organizationHealthcareContacts.setOrganizationName(organizationName_1)
          expect(@organizationHealthcareContacts.getOrganizationName().length).to eq(100)
          expect(@organizationHealthcareContacts.getOrganizationName()).to eq(organizationName)

          @organizationHealthcareContacts.setOrganizationName(organizationName)
          expect(@organizationHealthcareContacts.getOrganizationName().length).to eq(100)
          expect(@organizationHealthcareContacts.getOrganizationName()).to eq(organizationName)

        end

      end



      context "For both contact types, the following are always shown:" do

        it "v. Primary Phone (format is constrained to (###) ###-####; guidance text (light gray) is shown to convey format. " do
          #default to null
          expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("")

          @organizationHealthcareContacts.setPrimaryPhone("1112223333")
          expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("(111) 222-3333")

        end


        it "v. Entry is constrained to numeric. Format is maintained in the field as the user adds the phone number. ", :broken => true do

          @organizationHealthcareContacts.setPrimaryPhone("AAA123cccc")
          expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("(123) ###-####")

          @organizationHealthcareContacts.setPrimaryPhone("7038893800")
          expect(@organizationHealthcareContacts.getPrimaryPhone()).to eq("(703) 889-3800")

        end

        it "v. Voice over users will hear guidance indicating the field accepts 10 digit phone numbers using numeric entry only." do
          #Look in screen contents.  Find "Primary Phone" entry and then check content of next line
          expect(@contactAddForm[@contactAddForm.index('Primary Phone:')+1]).to eq("Enter 10 digits")
        end

        it "vi. Primary Phone Type: select, Office (default), Fax, mobile, other" do

          expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to eq("Office")

          phoneTypes = [ "Office", "Fax",  "Mobile",  "Other"  ]
          phoneTypes.each_with_index do | value, i |
            @organizationHealthcareContacts.setPrimaryPhoneType(value)
            expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to eq(value)
          end

        end

        it "vii. Other Phone (one to four additional other phone numbers and other phone types can be added; formatting matches Primary Phone )", :broken => true do

          expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("")
          waitForPageToFinishLoading

          @organizationHealthcareContacts.setOtherPhone(1,"1112223333")
          expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("(111) 222-3333")
          waitForPageToFinishLoading

          @organizationHealthcareContacts.setOtherPhone(1,"AAA123cccc")
          expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("(123) ###-####")
          waitForPageToFinishLoading

          @organizationHealthcareContacts.setOtherPhone(1,"7038895000")
          expect(@organizationHealthcareContacts.getOtherPhone(1)).to eq("(703) 889-5000")

        end

        it "ix. Other Phone Type: select (default), Office, Fax, mobile, other" do

          phoneTypes = [ "Office", "Fax",  "Mobile",  "Other"  ]
          for i in 1..1 do
            expect(@organizationHealthcareContacts.getOtherPhoneType(i)).to eq("")
            phoneTypes.each_with_index do | value, j |
              @organizationHealthcareContacts.setOtherPhoneType(i,value)
              expect(@organizationHealthcareContacts.getOtherPhoneType(i)).to eq(value)
            end
          end
          @organizationHealthcareContacts.setOtherPhoneType(1,"Fax")
        end

        it "1. Add Phone (button, alt text same as label, selecting adds another Other Phone number field and another Other Phone Type field; " do
          #Look in screen contents.  Find "Other Phone" entry and then check content of next two lines
          expect(@contactAddForm[@contactAddForm.index('Other Phone:')+1]).to eq("Enter 10 digits")
          expect(@contactAddForm[@contactAddForm.index('Other Phone:')+2]).to eq("Other Phone Type:")
        end

        it "when added focus is placed on newly added Other Phone Number field);" do
            @organizationHealthcareContacts.clickAddPhoneButton()
            expect(getActiveElement().attribute('name')).to eq("otherPhone2")
        end

      end

      context "2. If more than one 'Other Phone' field is added a delete option is added next to the Other Phone fields " do

        xit "('x Delete' button, alt text reads: Delete <data for phone number of field to be deleted and phone type selected for that phone number>);", :broken => true do

          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(1)).to eq(true)
          expect(@organizationHealthcareContacts.getDeleteOtherPhoneButtonAltText(1)).to eq("Delete Other Phone Number (703) 889-5000 with type Fax")

          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(2)).to eq(true)
          expect(@organizationHealthcareContacts.getDeleteOtherPhoneButtonAltText(2)).to eq("Delete Other Phone Number Empty with type none")

          @organizationHealthcareContacts.clickAddPhoneButton()
          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(3)).to eq(true)
          @organizationHealthcareContacts.setOtherPhone(3,"7038896666")
          @organizationHealthcareContacts.setOtherPhoneType(3,"Mobile")

          @organizationHealthcareContacts.clickAddPhoneButton()
          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(4)).to eq(true)
          @organizationHealthcareContacts.setOtherPhone(4,"7038897777")
          @organizationHealthcareContacts.setOtherPhoneType(4,"Fax")

        end

        xit " Deletes may occur in any order and are not confirmed (no modal is shown);", :broken => true do

          @organizationHealthcareContacts.clickDeleteOtherPhoneButton(3)

          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(4)).to eq(false)
          expect(@organizationHealthcareContacts.getOtherPhone(3)).to eq("(703) 889-7777")
          expect(@organizationHealthcareContacts.getOtherPhoneType(3)).to eq("Fax")

          @organizationHealthcareContacts.clickDeleteOtherPhoneButton(2)
          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(3)).to eq(false)
          expect(@organizationHealthcareContacts.getOtherPhone(2)).to eq("(703) 889-7777")
          expect(@organizationHealthcareContacts.getOtherPhoneType(2)).to eq("Fax")

        end

        it "When only one 'Other phone number' field set is shown the delete option is removed.)", :broken => true do
          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(1)).to eq(true)
          @organizationHealthcareContacts.clickDeleteOtherPhoneButton(2)
          expect(@organizationHealthcareContacts.isDeleteOtherPhoneButtonVisible(1)).to eq(false)
        end

        it "(null other phone or other phone type records are permitting)" do
            @organizationHealthcareContacts.clickAddPhoneButton()
        end

        it "x. Email (100 characters, text, validation to be added later)" do
          expect(@organizationHealthcareContacts.getEmail()).to eq("")

          email_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          email_100 = email_50 + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdef.com"
          @organizationHealthcareContacts.setEmail(email_100)
          expect(@organizationHealthcareContacts.getEmail().length).to eq(100)
          expect(@organizationHealthcareContacts.getEmail()).to eq(email_100)

          email_101 =  email_100 + "x"
          @organizationHealthcareContacts.setEmail(email_101)
          expect(@organizationHealthcareContacts.getEmail().length).to eq(100)
          expect(@organizationHealthcareContacts.getEmail()).to eq(email_100)

        end

      end


      describe "xi. Address (section label for fields below)" do

        it "1. Country, select list, default to US" do
          expect(@organizationHealthcareContacts.getCountry()).to eq("United States")
        end

        it "If country = US show State (US) drop down select" do
          # verify state label
          expect(@organizationHealthcareContacts.getStateLabel()).to eq("State:")

        end

        it "2. Address Line 1 (alphanumeric, text box, 100 characters)" do
          expect(@organizationHealthcareContacts.getAddressLineOne()).to eq("")

          text_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          text_100 = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @organizationHealthcareContacts.setAddressLineOne(text_100)
          expect(@organizationHealthcareContacts.getAddressLineOne().length).to eq(100)
          expect(@organizationHealthcareContacts.getAddressLineOne()).to eq(text_100)

          text_101 =  text_100 + "x"
          @organizationHealthcareContacts.setAddressLineOne(text_101)
          expect(@organizationHealthcareContacts.getAddressLineOne().length).to eq(100)
          expect(@organizationHealthcareContacts.getAddressLineOne()).to eq(text_100)

        end

        it "3. Address line 2 (alphanumeric, text box, 100 characters)" do
          expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq("")

          text_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          text_100 = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @organizationHealthcareContacts.setAddressLineTwo(text_100)
          expect(@organizationHealthcareContacts.getAddressLineTwo().length).to eq(100)
          expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq(text_100)

          text_101 =  text_100 + "x"
          @organizationHealthcareContacts.setAddressLineTwo(text_101)
          expect(@organizationHealthcareContacts.getAddressLineTwo().length).to eq(100)
          expect(@organizationHealthcareContacts.getAddressLineTwo()).to eq(text_100)

        end

        it "4. City (alphanumeric, text box, 50 characters)" do

          text_50 = "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ"
          @organizationHealthcareContacts.setCity(text_50)
          expect(@organizationHealthcareContacts.getCity().length).to eq(50)
          expect(@organizationHealthcareContacts.getCity()).to eq(text_50)

          text_51 =  text_50 + "x"
          @organizationHealthcareContacts.setCity(text_51)
          expect(@organizationHealthcareContacts.getCity().length).to eq(50)
          expect(@organizationHealthcareContacts.getCity()).to eq(text_50)

        end

        it "5. State (select list, select option shown as default and is equivalent to null; " do
          expect(@organizationHealthcareContacts.getState()).to eq("Select")
          expect(@organizationHealthcareContacts.getStateByValue()).to eq("")
        end

        xit "standard list to be used that includes DC and Puerto Rico)", :broken => true do
          @organizationHealthcareContacts.setState("District of Columbia")
          expect(@organizationHealthcareContacts.getState()).to eq("District of Columbia")
          @organizationHealthcareContacts.setState("Puerto Rico")
          expect(@organizationHealthcareContacts.getState()).to eq("Puerto Rico")
          expect(@organizationHealthcareContacts.getStateByValue()).to eq("42")
        end

        it "If country is not US then show free text: State/Province" do
          @organizationHealthcareContacts.setCountry("United Kingdom")
          expect(@organizationHealthcareContacts.getCountry()).to eq("United Kingdom")

          expect(@organizationHealthcareContacts.getStateLabel()).to eq("State/Province:")
        end

        it "6. State/Province (text, 50 characters)" do

          text_50 = "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @organizationHealthcareContacts.setStateProvince(text_50)
          expect(@organizationHealthcareContacts.getStateProvince().length).to eq(50)
          expect(@organizationHealthcareContacts.getStateProvince()).to eq(text_50)

          text_51 =  text_50 + "x"
          @organizationHealthcareContacts.setStateProvince(text_51)
          expect(@organizationHealthcareContacts.getStateProvince().length).to eq(50)
          expect(@organizationHealthcareContacts.getStateProvince()).to eq(text_50)

        end

        it "7. ZIP/Postal Code (alphanumeric, text box, 10 characters)" do

          expect(@organizationHealthcareContacts.getZipPostalCode()).to eq("")

          text_10 = "123defGHIJ"
          @organizationHealthcareContacts.setZipPostalCode(text_10)
          expect(@organizationHealthcareContacts.getZipPostalCode().length).to eq(10)
          expect(@organizationHealthcareContacts.getZipPostalCode()).to eq(text_10)

          text_11 =  text_10 + "x"
          @organizationHealthcareContacts.setZipPostalCode(text_11)
          expect(@organizationHealthcareContacts.getZipPostalCode().length).to eq(10)
          expect(@organizationHealthcareContacts.getZipPostalCode()).to eq(text_10)

        end


        it "8. Website (alphanumeric, textbox, 100 characters)" do

          expect(@organizationHealthcareContacts.getWebsite()).to eq("")

          text_50 = "http://www" + ".bcdefghij" + ".bcdefghij" + "abcdefghij" + "abcdefghij"
          text_100 = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          @organizationHealthcareContacts.setWebsite(text_100)
          expect(@organizationHealthcareContacts.getWebsite().length).to eq(100)
          expect(@organizationHealthcareContacts.getWebsite()).to eq(text_100)

          text_101 =  text_100 + "x"
          @organizationHealthcareContacts.setWebsite(text_101)
          expect(@organizationHealthcareContacts.getWebsite().length).to eq(100)
          expect(@organizationHealthcareContacts.getWebsite()).to eq(text_100)

        end


        it "9. Note (alphanumeric, textbox, 250 character, character countdown)" do

          text99 = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"
          @organizationHealthcareContacts.setNote(text99)
          expect(@organizationHealthcareContacts.getNote.length).to eq(99)
          expect(@organizationHealthcareContacts.getNote).to eq(text99)
          expect(@organizationHealthcareContacts.getCountDownDisplayForNote).to eq("151 characters left")

          text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
          @organizationHealthcareContacts.setNote(text200)
          expect(@organizationHealthcareContacts.getNote.length).to eq(200)
          expect(@organizationHealthcareContacts.getNote).to eq(text200)
          expect(@organizationHealthcareContacts.getCountDownDisplayForNote).to eq("50 characters left")

          text250 = text200 + "12345678901234567890123456789012345678901234567890"
          @organizationHealthcareContacts.setNote(text250)
          expect(@organizationHealthcareContacts.getNote.length).to eq(250)
          expect(@organizationHealthcareContacts.getNote).to eq(text250)
          expect(@organizationHealthcareContacts.getCountDownDisplayForNote).to eq("0 characters left")

          text251 = text250 + "x"
          @organizationHealthcareContacts.setNote(text250)
          expect(@organizationHealthcareContacts.getNote.length).to eq(250)
          expect(@organizationHealthcareContacts.getNote).to eq(text250)
          expect(@organizationHealthcareContacts.getCountDownDisplayForNote).to eq("0 characters left")

        end

      end

      context "Required fields" do
        it "Facility Name required" do

          fName = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          organizationName = fName + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"

          @organizationHealthcareContacts.setOrganizationName("")
          @organizationHealthcareContacts.clickSave()

          expectedValidationSummaryHeader = "The following errors were found:"
          !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("entryForm")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("entryForm", "Name field is required.")).to eq(true)

          @organizationHealthcareContacts.setOrganizationName(organizationName)
          expect(@organizationHealthcareContacts.getOrganizationName().length).to eq(100)
        end
      end




    end

    describe "AC JRNL-2888|TC-1767: c. Standard Save and Cancel options are available:" do

      context "1) Save - When a user selects Save" do

        it "The system saves the record and the user is returned to the table view, " do
          @organizationHealthcareContacts.clickSave
          !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")
        end

        it "Focus is on the header. " do
          expect(getFocusedElementText()).to eq(@contacts.getPrimaryHeader)
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

        end

        it "Updates made to the record are visible in the table, if included in that view." do

          fName = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          organizationName = fName + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"

          contactAdded =  "Name \n" +
                            organizationName + " \n"+
                          "Type \n" +
                            "Organization \n" +
                          "Primary Phone \n" +
                            "(703) 889-3800 "

          !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }
          expect(@healthcare_contacts_list.getContentByRowNumber(0).include?(organizationName)).to be true
          expect(@healthcare_contacts_list.getContactsCount()).to eq(1)

        end



        it "(Verify data)", :broken => true do

          @healthcare_contacts_list.clickOnContactByRow(0)

          fName = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          organizationName = fName + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          #specialty = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          email_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          email_100 = email_50 + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdef.com"
          text_50_city = "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ" + "123defGHIJ"
          text_50_prov = "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          text_10_zip = "123defGHIJ"
          text_50 = "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij" + "abcdefghij"
          text_100_addr = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          text_50 = "http://www" + ".bcdefghij" + ".bcdefghij" + "abcdefghij" + "abcdefghij"
          text_100_web = text_50 + "abcdefghij" + "1234567890" + "ABCDEFGHIJ" + " --'-----x" + "abcdefghij"
          text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
          text_250_note = text200 + "12345678901234567890123456789012345678901234567890"

          expect(@organizationHealthcareContacts.isOrganizationSelected()).to   eq(true)

          expect(@organizationHealthcareContacts.getOrganizationName()).to   eq(organizationName)
          expect(@organizationHealthcareContacts.getOrganizationType()).to   eq("Other")

          expect(@organizationHealthcareContacts.getPrimaryPhone()).to   eq("(703) 889-3800")
          expect(@organizationHealthcareContacts.getPrimaryPhoneType()).to   eq("Other")

          expect(@organizationHealthcareContacts.getOtherPhone(1)).to   eq("(703) 889-5000")
          expect(@organizationHealthcareContacts.getOtherPhoneType(1)).to   eq("Fax")

          expect(@organizationHealthcareContacts.getOtherPhone(2)).to   eq("")
          expect(@organizationHealthcareContacts.getOtherPhoneType(2)).to   eq("")

          expect(@organizationHealthcareContacts.getEmail()).to   eq(email_100)
          expect(@organizationHealthcareContacts.getCountry()).to   eq("United Kingdom")
          expect(@organizationHealthcareContacts.getAddressLineOne()).to   eq(text_100_addr)
          expect(@organizationHealthcareContacts.getAddressLineTwo()).to   eq(text_100_addr)
          expect(@organizationHealthcareContacts.getCity()).to   eq(text_50_city)
          expect(@organizationHealthcareContacts.getStateProvince()).to   eq(text_50_prov)
          expect(@organizationHealthcareContacts.getZipPostalCode()).to   eq(text_10_zip)
          expect(@organizationHealthcareContacts.getWebsite()).to   eq(text_100_web)
          expect(@organizationHealthcareContacts.getNote()).to   eq(text_250_note)
        end

      end


      context "2) Cancel - When a user selects Cancel, ", :broken => true do

        before(:all) do

          @organizationHealthcareContacts.clickCancel

          !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")

          @contacts.clickAddButton
          !45.times{ break if (getPrimaryHeader == "Add Healthcare Contact"); sleep 1 }
          expect(@organizationHealthcareContacts.getPrimaryHeader).to eq("Add Healthcare Contact")

          @organizationHealthcareContacts.selectOrganization
          @organizationHealthcareContacts.setOrganizationName("a")
          @organizationHealthcareContacts.clickCancel
          !10.times{ break if (@healthcare_contacts_list.getContentByRowNumber(0) != ""); sleep 1 }

        end

        it "No updates are made to the record " do
          expect(@healthcare_contacts_list.getContactsCount()).to eq(1)
        end

        it "User is shown the table view with the focus placed on the header" do
          expect(getFocusedElementText()).to eq(@contacts.getPrimaryHeader)
          expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")
        end
      end
    end
  end
end
