require_relative '../../../globalized'
include Globalized
today = Date.today.strftime('%A')
oneMonthEarlier= (Date.today - 30.days).strftime('%A')

describe "Story#JRNL-2491: [Communications_Log_JRNL_2491_List_Filter_spec.rb]
Story#JRNL-1333 [Transition the Communication log to the new Mongo HTS]", :regression => true do

  before(:all) do
    @COMMUNICATIONS_LOG_SCREEN_TITLE = "Communications Log"
    @ADD_LOG_ENTRY_TITLE  = "Add "  + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @EDIT_LOG_ENTRY_TITLE = "Edit " + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @LIST_HEADER = [ "Subject", "Who", "Type", "Date"]
    @EXPECTED_FILTER_SCREEN_INFO_CONTENT = [ \
      '* required field',
      'Date Range:',
      '*',
      'Required: Start Date: M M / D D / Y Y Y Y:',
      'Start Date:',
      'This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.',
      "Day selected is "+oneMonthEarlier,
      oneMonthEarlier,
      '*',
      'Required: End Date: M M / D D / Y Y Y Y:',
      'End Date:',
      'This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.',
      "Day selected is "+today,
      today,
      'Apply Reset',
    ]

    initializeConfigurations(BASE_URL)

    helper_setTestDates

    #Backend Database Setup
    @patientID = helper_get_TestPatientID

    resetCollection("communicationlogs", "personalprofiledb", "communicationLogs")

    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111111", "recorded", (Time.now - 1.days))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111112", "recorded", (Time.now - 2.days))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111113", "recorded", (Time.now - 15.days))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111114", "recorded", (Time.now - 20.days))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111115", "recorded", (Time.now - 25.days))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111116", "recorded", (Time.now - 27.days))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111117", "recorded", (Time.now - 29.days))

    initializeAllObjects

    #Login to Landing page
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Navigate to Communications Log page
    helper_navigateToCommunicationsLog()
    !45.times{ break if (getPrimaryHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)
  end

  after(:all) do
    quitDriver()
  end

  it "AC# JRNL-2735|TC# JRNL-2765: (b.i & b.ii) Start Date & End dates as required fields & in format mm/dd/yyyy;'* required field' at the top of the screen.", :broken => true do
    helper_verify_list(@communications.getListHeader.split("\n"), @LIST_HEADER)
    helper_verify_list(@communications_log_filter.getScreenContent.split("\n"), @EXPECTED_FILTER_SCREEN_INFO_CONTENT)
  end

  it "AC# JRNL-2735|TC# JRNL-2765: (a) Filter Feature (i) Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter' when expanded." do
    expect(@communications_log_filter.isFilterExpanded()).to be true
    expect(isElementVisible(:id,'startDate')).to be true
    expect(isElementVisible(:id,'endDate')).to be true

    expect(@communications_log_filter.isStartDateVisible()).to be true
    expect(@communications_log_filter.isEndDateVisible()).to be true
    expect(@communications_log_filter.getFilterIconLabel()).to eq("Filter\nCollapse filter options")
  end

  it "AC# JRNL-2734|TC# JRNL-2765: (a) Filter Feature (ii) Users can collapse the filter list by clicking on the Collapse filter icon.  When collapsed, the filter icon alt text reads Expand Filter.", :broken => true do
    waitForPageToFinishLoading
    @communications_log_filter.clickOnFilterIcon
    expect(@communications_log_filter.isFilterCollapsed()).to be true
    expect(@communications_log_filter.getFilterIconLabel()).to eq("Filter\nExpand filter options")

    expect(isElementVisible(:id,'startDate')).to be false
    expect(isElementVisible(:id,'endDate')).to be false

    expect(@communications_log_filter.isStartDateVisible()).to be false
    expect(@communications_log_filter.isEndDateVisible()).to be false

    @communications_log_filter.clickOnFilterIcon
    expect(@communications_log_filter.isFilterExpanded()).to be true

    expect(isElementVisible(:id,'startDate')).to be true
    expect(isElementVisible(:id,'endDate')).to be true

    expect(@communications_log_filter.isStartDateVisible()).to be true
    expect(@communications_log_filter.isEndDateVisible()).to be true
  end

  it "AC# JRNL-2734|TC# JRNL-2765: (b.iv) The default date range filter is set to show a range equivalent to the last 30 days. ", :broken => true do
    expect(@communications.getFilterStartDate()).to eq(@thirtyDaysAgo)
    expect(@communications.getFilterEndDate()).to eq(@today)
    #Wait until the grid's count is 7
    !45.times{ break if (@communications.getCommunicationsLogCount() == ( 7) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(7)
  end

  it "AC# JRNL-2735|TC# JRNL-2765: Communications Log entries displayed in a table format, sorted in reverse chronological order by Date ", :broken => true do
    #Start verifying the list sorted in reverse chronological order by Date
    expect(@communications.getNthSubjectInCommList(1)).to eq("Mail XRay films -1d")
    expect(@communications.getNthSubjectInCommList(2)).to eq("InPerson to Dr Sharon -2d")
    expect(@communications.getNthSubjectInCommList(3)).to eq("Fax Paper To Dept -15d")
    expect(@communications.getNthSubjectInCommList(4)).to eq("MaxSubjectIs 50Chars 234567890123456789012345 -20d")
    expect(@communications.getNthSubjectInCommList(5)).to eq("Phone Dr. Kim -25d")
    expect(@communications.getNthSubjectInCommList(6)).to eq("Email Dr. Sue -27d")
    expect(@communications.getNthSubjectInCommList(7)).to eq("Texted Dr Sharon -29d")
  end

  it "AC# JRNL-2734|TC# JRNL-2765: (c.i, ciii) Adding a value to any of the filter fields and selecting Filter button updates the table view to show records that match the filter parameters and the focus is at the first row", :broken => true do
    waitForPageToFinishLoading
    numOfDaysAgo = 25
    helper_setDateRangeThenClickFilter(@communications, numOfDaysAgo)

    #Wait until the grid's count changed to  5
    !45.times{ break if (@communications.getCommunicationsLogCount() == 5 ); sleep 1 }
    expectedFocus = "Subject \nMail XRay films -1d \nWho \nDr. Smith \nType \nPostal \nDate \n#{@oneDayAgo}"

    expect(getFocusedElementText()).to include(expectedFocus)
    expect(@communications.getCommunicationsLogCount()).to eq(5)

    helper_validatAllEntriesWithinRange(@communications)

    helper_validateEntryShouldBeInRange(@communications, "Mail XRay films -1d")
    helper_validateEntryShouldBeInRange(@communications, "InPerson to Dr Sharon -2d")
    helper_validateEntryShouldBeInRange(@communications, "Fax Paper To Dept -15d")
    helper_validateEntryShouldBeInRange(@communications, "MaxSubjectIs 50Chars 234567890123456789012345 -20d")
    helper_validateEntryShouldBeInRange(@communications, "Phone Dr. Kim -25d")

    #Start verifying the list
    expect(@communications.getNthSubjectInCommList(1)).to eq("Mail XRay films -1d")
    expect(@communications.getNthSubjectInCommList(2)).to eq("InPerson to Dr Sharon -2d")
    expect(@communications.getNthSubjectInCommList(3)).to eq("Fax Paper To Dept -15d")
    expect(@communications.getNthSubjectInCommList(4)).to eq("MaxSubjectIs 50Chars 234567890123456789012345 -20d")
    expect(@communications.getNthSubjectInCommList(5)).to eq("Phone Dr. Kim -25d")

    helper_validateEntryShouldNotBeInRange(@communications, "Email Dr. Sue -27d")
    helper_validateEntryShouldNotBeInRange(@communications, "Texted Dr Sharon -29d")

    numOfDaysAgo = 19
    helper_setDateRangeThenClickFilter(@communications, numOfDaysAgo)

    helper_validatAllEntriesWithinRange(@communications)
    helper_validateEntryShouldBeInRange(@communications, "Mail XRay films -1d")
    helper_validateEntryShouldBeInRange(@communications, "InPerson to Dr Sharon -2d")
    helper_validateEntryShouldBeInRange(@communications, "Fax Paper To Dept -15d")

    expect(@communications.getNthSubjectInCommList(1)).to eq("Mail XRay films -1d")
    expect(@communications.getNthSubjectInCommList(2)).to eq("InPerson to Dr Sharon -2d")
    expect(@communications.getNthSubjectInCommList(3)).to eq("Fax Paper To Dept -15d")

    helper_validateEntryShouldNotBeInRange(@communications, "MaxSubjectIs 50Chars 234567890123456789012345 -20d")
    helper_validateEntryShouldNotBeInRange(@communications, "Phone Dr. Kim -25d")
    helper_validateEntryShouldNotBeInRange(@communications, "Email Dr. Sue -27d")
    helper_validateEntryShouldNotBeInRange(@communications, "Texted Dr Sharon -29d")
  end

  it "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
    expect(@date_filter.isResetButtonPresent()).to eq(true)
    expect(@date_filter.getResetButtonLabel()).to eq("Reset")

    @date_filter.clickResetBtn()
    !10.times{ break if (getFocusedElementText().include?("Subject")); sleep 1 }
    expect(getCount()).to eq(7)
    expect(@communications.getNthSubjectInCommList(1)).to eq("Mail XRay films -1d")
    expect(@communications.getNthSubjectInCommList(2)).to eq("InPerson to Dr Sharon -2d")
    expect(@communications.getNthSubjectInCommList(3)).to eq("Fax Paper To Dept -15d")
    expect(@communications.getNthSubjectInCommList(4)).to eq("MaxSubjectIs 50Chars 234567890123456789012345 -20d")
    expect(@communications.getNthSubjectInCommList(5)).to eq("Phone Dr. Kim -25d")
    expect(@communications.getNthSubjectInCommList(6)).to eq("Email Dr. Sue -27d")
    expect(@communications.getNthSubjectInCommList(7)).to eq("Texted Dr Sharon -29d")
    expect(@communications.getFocusedElementText()).to eq(getTextForRow(1) + " ")

    # DEFAULTS
    expect(@communications.getFilterStartDate()).to eq(@thirtyDaysAgo)
    expect(@communications.getFilterEndDate()).to eq(@today)
  end

  ##########################################################
  # Story#JRNL-2460 supersedes story#JRNL-3278|AC# JRNL-2734 below
  ##########################################################
  #it 'AC# JRNL-2734|TC# JRNL-2765: (c.ii & c.iii) If no records are found when a filter is applied, focus is at message "No results found." ' do
  #  numOfDaysAgo = 0
  #  puts("Setting filter range within to #{numOfDaysAgo} days")
  #  helper_setDateRangeThenClickFilter(@communications, numOfDaysAgo)
  #  helper_verify_Empty_List(@communications, "No results found.")
  #  expect(getFocusedElementText()).to eq("No results found.")
  #end
  ##########################################################

  it 'Story# MVAH-1580 supersedes story# MVAH-820|AC# JRNL-2734 (AC# JRNL-2734|TC# JRNL-2765: (c.ii & c.iii) If no records are found when a filter is applied, focus is at message "No results found.") ' do
    numOfDaysAgo = 0
    puts("Setting filter range within to #{numOfDaysAgo} days")
    helper_setDateRangeThenClickFilter(@communications, numOfDaysAgo)
    helper_verify_Empty_List(@communications, "No results were found with the current filters. Use the Add button above to create a new record.")
    expect(getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
  end

  it "AC# JRNL-2735|TC# JRNL-2765: (b.iii) Start date must be before or equal to end date, (.v) dates can't be future date, (.vi), dates cannot be before 01/01/1900" do
    @communications.setDateRangeAndFilter(@tomorrow, @today)
    if Time.new.year.to_s != @tomorrow[-4..-1]
      helper_checkingInlineError("Start Date must be formatted MM/DD/YYYY.", "filterForm")
    else
      helper_checkingInlineError("Start Date must occur before End Date.", "filterForm")
      helper_checkingInlineError("Start Date must be between 01/01/1900 and #{@today}.", "filterForm")
    end

    @communications.setDateRangeAndFilter("12/31/1899", @today)  #Front end takes "1899" as "199"
    helper_checkingInlineError("Start Date must be formatted MM/DD/YYYY.", "filterForm")

    @communications.setDateRangeAndFilter(@fifteenDaysAgo, "12/31/200")  #Front end takes "1899" as "199"
    helper_checkingInlineError("End Date must be formatted MM/DD/YYYY.", "filterForm")
  end

end
