require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2491;JRNL-2490: [Communications_Log_JRNL_2490_Add_Postal_InPerson_Fax_Other_spec.rb]
Story#JRNL-1333 [Transition the Communication log to the new Mongo HTS]", :regression => true do

  before(:all) do
    @COMMUNICATIONS_LOG_SCREEN_TITLE = "Communications Log"
    @ADD_LOG_ENTRY_TITLE  = "Add "  + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @EDIT_LOG_ENTRY_TITLE = "Edit " + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @LONG_NOTES   = "Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789"
    @LONG_CONTACT = "MaxContactIs 50Chars 23456789012345678901234567890AAAAAAAAAA"
    @LONG_SUBJECT = "MaxSubjectIs 50Chars 23456789012345678901234567890xxxxxx"

    initializeConfigurations(BASE_URL)
    removeCollection("communicationlogs", "personalprofiledb")

    initializeAllObjects

    @subject_InPerson_LogEntry = "Talked to Dr Sharon"

    @twentyfiveDaysAgo = getDateNthDaysAgo(25, "%m/%d/%Y")
    @twentyDaysAgo = getDateNthDaysAgo(20, "%m/%d/%Y")

    @fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")

    @nineteenDaysAgo = getDateNthDaysAgo(19, "%m/%d/%Y")

    @twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    @oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")


    #Login to Landing page
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Navigate to Communications Log page
    helper_navigateToCommunicationsLog()
    !45.times{ break if (getPrimaryHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)

  end

  after(:all) do
    quitDriver()
  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: Add Communications Log Entry - Postal Type - more than 250 characters entered to Notes " do

    #type Postal
    #puts("Postal- added @oneDayAgo is [#{@oneDayAgo}]")
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @oneDayAgo, "Postal", "Mail XRay films -1d", "", @LONG_NOTES, 1)

    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Verifying Adding Log Entry - Postal Type -  more than 250 characters entered to Notes")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: Click on specific subject to open - Postal Type - only 250 characters saved for Notes" do

    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @oneDayAgo, "Postal", "Mail XRay films -1d", "", @LONG_NOTES)
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - 1d: Click on specific subject to open - Postal Type - only 250 characters saved for Notes")

  end



  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: Add Communications Log Entry - In person Type - empty notes" do

    #type In person
    #puts("In person- added @twoDaysAgo is [#{@twoDaysAgo}]")
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twoDaysAgo, "In Person", "InPerson to Dr Sharon -2d", "Dr. Sharon","", 2)
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Verifying Adding Log Entry - In person Type - empty notes")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: CLick on specific subject to open - In person Type - added entry on screen 'Edit Communications Log Entry'" do

    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twoDaysAgo, "In Person", "InPerson to Dr Sharon -2d", "Dr. Sharon","")
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 -2d: CLick on specific subject to open - In person Type - added entry on screen 'In Person Communications Log Entry'")

  end



  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: Add Communications Log Entry - Fax Type - " do

    #type Fax
    faxEntry = "Fax Paper To Dept -15d"
    #puts("Fax- added @fifteenDaysAgo is [#{@fifteenDaysAgo}]")
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @fifteenDaysAgo, "Fax", faxEntry, @LONG_CONTACT,"Fax entry: Writing a note is optional", 3)
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Verifying Adding Fax Log Entry on screen 'Add Communications Log Entry'")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: CLick on specific subject to open 6th added entry on screen 'Edit Communications Log Entry'" do

    faxEntry = "Fax Paper To Dept -15d"
    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @fifteenDaysAgo, "Fax", faxEntry, @LONG_CONTACT,"Fax entry: Writing a note is optional")
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - 15d: CLick on specific subject to open Fax added entry on screen 'Edit Communications Log Entry'")

  end



  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: Add Communications Log Entry - Other Type -  more than 250 characters entered to Subject and Contact" do

    #type Other

    #puts("Other- added @twentyDaysAgo is [#{@twentyDaysAgo}]")
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twentyDaysAgo, "Other", @LONG_SUBJECT, @LONG_CONTACT, "Other entry: Writing a note is optional", 4)
    #puts("PASSED: AC# JRNL-2735;JRNL-2728, AC#1162 - Add Communications Log Entry - Other Type - more than 250 characters entered to Subject and Contact ")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2791: CLick on specific subject to open - Other Type - only 50 characters saved for Subject and Contact" do

    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twentyDaysAgo, "Other", @LONG_SUBJECT, @LONG_CONTACT, "Other entry: Writing a note is optional")
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - CLick on specific subject to open - Other Type - only 50 characters saved for Subject and Contact")
    #puts("++++++ PASSED: Communications_Log_MVAH_820_Add_Postal_InPerson_Fax_Other_spec.rb")

  end
end