require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2491: [Communications_Log_JRNL_2490_Add_Phone_Email_Text_spec.rb]
Story#JRNL-1333 [Transition the Communication log to the new Mongo HTS]", :regression => true do


  before(:all) do
    @COMMUNICATIONS_LOG_SCREEN_TITLE = "Communications Log"
    @ADD_LOG_ENTRY_TITLE  = "Add "  + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @EDIT_LOG_ENTRY_TITLE = "Edit " + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"

    initializeConfigurations(BASE_URL)
    removeCollection("communicationlogs", "personalprofiledb")
    initializeAllObjects

    @subjectOf4thLogEntry = "Talked to Dr Sharon"

    @twentynineDaysAgo = getDateNthDaysAgo(29, "%m/%d/%Y")
    @twentysevenDaysAgo = getDateNthDaysAgo(27, "%m/%d/%Y")

    @twentyfiveDaysAgo = getDateNthDaysAgo(25, "%m/%d/%Y")
    @twentyDaysAgo = getDateNthDaysAgo(20, "%m/%d/%Y")

    @fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")

    @twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    @oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")


    #Login to Landing page
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Navigate to Communications Log page
    helper_navigateToCommunicationsLog()
    !45.times{ break if (getPrimaryHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)

  end

  after(:all) do
    quitDriver()
  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2792: Verifying Adding Log Entry - Phone Type - on screen 'Add Communications Log Entry'" do

    #type: phone
    #puts("1st record -type Phone- added @twentyfiveDaysAgo is [#{@twentyfiveDaysAgo}]")  -
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twentyfiveDaysAgo, "Phone", "Phone Dr. Kim -25d", "Dr.Kim", "Phone Contact: Writing a note is optional", 1)
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Verifying Adding Log Entry - Phone Type - on screen 'Add Communications Log Entry'")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2792: Click on specific subject to open - Phone Type -  added entry on screen 'Edit Communications Log Entry'" do
    #@EDIT_LOG_ENTRY_TITLE
    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twentyfiveDaysAgo, "Phone", "Phone Dr. Kim -25d", "Dr.Kim", "Phone Contact: Writing a note is optional")
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Click on specific subject to open - Phone Type -  added entry on screen 'Edit Communications Log Entry'")

  end

  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2792: Verifying Adding Log Entry - Email Type - on screen 'Add Communications Log Entry'" do

    #type Email
    #puts("2nd record -type Email- added @twentyDaysAgo is [#{@twentyDaysAgo}]")
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twentyDaysAgo, "Email", "Email Dr. Sue -20d", "Dr.Sue", "", 1)

    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Verifying Adding Log Entry - Email Type - on screen 'Add Communications Log Entry'")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2792: Click on specific subject to open - Email Type - added entry on screen 'Edit Communications Log Entry'" do

    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twentyDaysAgo, "Email", "Email Dr. Sue -20d", "Dr.Sue", "")
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Click on specific subject to open - Email Type - added entry on screen 'Edit Communications Log Entry'")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2792: Verifying Adding Log Entry - Text Type - on screen 'Add Communications Log Entry'" do

    #type Text
    #puts("-type Phone- added @oneDayAgo is [#{@oneDayAgo}]")
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @oneDayAgo, "Text", "Texted Dr Sharon -1d", "Dr. Sharon", "Text entry: Writing a note is optional", 1)
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Verifying Adding Log Entry - Text Type - on screen 'Add Communications Log Entry'")

  end


  it "AC# JRNL-2735;JRNL-2728|TC# JRNL-2792: Click on specific subject to open - Text Type - added entry on screen 'Edit Communications Log Entry'" do

    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @oneDayAgo, "Text", "Texted Dr Sharon -1d", "Dr. Sharon", "Text entry: Writing a note is optional")
    #puts("PASSED: AC# JRNL-2735;JRNL-2728 - Click on specific subject to open - Text Type - added entry on screen 'Edit Communications Log Entry'")
    #puts("++++++ PASSED: Communications_Log_MVAH_822_Add_Phone_Email_Text_spec.rb")
  end
end