require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2490: [Communications_Log_JRNL_2490_Nav_Edit_spec.rb]
Story#JRNL-1333 [Transition the Communication log to the new Mongo HTS]", :regression => true do


  before(:all) do
    @COMMUNICATIONS_LOG_SCREEN_TITLE = "Communications Log"
    @ADD_LOG_ENTRY_TITLE  = "Add "  + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @EDIT_LOG_ENTRY_TITLE = "Edit " + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"

    @LONG_NOTES   = "Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789"
    @LONG_CONTACT = "MaxContactIs 50Chars 23456789012345678901234567890AAAAAAAAAA"
    @LONG_SUBJECT = "MaxSubjectIs 50Chars 23456789012345678901234567890xxxxxx"

    initializeConfigurations(BASE_URL)
    @patientID = helper_get_TestPatientID
    removeCollection("communicationlogs", "personalprofiledb")

    initializeAllObjects

    @subjectOf4thLogEntry = "Talked to Dr Sharon"

    helper_setTestDates

    #Login to Landing page
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Navigate to Communications Log page
    helper_navigateToCommunicationsLog()
    !45.times{ break if (getPrimaryHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)
  end

  after(:all) do
    quitDriver()
  end

  it "AC# JRNL-2728|TC# JRNL-2834: (3a, 3b) ADD-NAV: Navigating away while trying to adding entry with max characters for subject, contact and notes" do
    helper_add_nav_this_log_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @ADD_LOG_ENTRY_TITLE, @twentyDaysAgo, "Text", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES, 1)
  end

  it "AC# JRNL-2730|TC# JRNL-2834: (3a, 3b) EDIT-NAV: Navigating away while trying to editing existing entry" do
    helper_edit_nav_this_log_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @today, "Text", "@LONG_SUBJECT", "@LONG_CONTACT", "@LONG_NOTES", 1)
  end

  it "AC# JRNL-2730|TC# JRNL-2834: (3a, 3b) EDIT-CANCEL-REQUIRED FIELDS: Verify required fields and Cancel button functionality" do
    #Verify required fields then modify data but click Cancel to cancel the editing process
    helper_edit_required_fields_and_cancel_button(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twentyDaysAgo, "xxxText", "xxxx@LONG_SUBJECT", "xxxx@LONG_CONTACT", "xxxx@LONG_NOTES", 1)
    #Verify existing data not changed
    helper_verify_row_data(@communications, @today, "Text", "@LONG_SUBJECT", "@LONG_CONTACT", "@LONG_NOTES", 1)
  end

end