require_relative '../../../globalized'
include Globalized


describe "Story#JRNL-2490: [Communications_Log_JRNL_2490_Misc_spec.rb]
Story#JRNL-1333 [Transition the Communication log to the new Mongo HTS]", :regression => true do

  before(:all) do
    today = Date.today.strftime('%A')
    @COMMUNICATIONS_LOG_SCREEN_TITLE = "Communications Log"
    @ADD_LOG_ENTRY_TITLE  = "Add "  + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @EDIT_LOG_ENTRY_TITLE = "Edit " + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"

    @LONG_NOTES   = "Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789"
    @LONG_CONTACT = "MaxContactIs 50Chars 23456789012345678901234567890AAAAAAAAAA"
    @LONG_SUBJECT = "MaxSubjectIs 50Chars 23456789012345678901234567890xxxxxx"

    @INITIAL_ENTRY_FORM = [ \
      '* required field',
      '',
      '*',
      'Required: Date: M M / D D / Y Y Y Y:',
      'Date:',
      'This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.',
       "Day selected is "+today,
       today,
      '* Type:',
      'Select',
      'Phone',
      'Fax',
      'In Person',
      'Email',
      'Text',
      'Postal',
      'Other',
      '* Subject:',
      '50 character maximum',
      'Who:',
      '50 character maximum',
      'Note:',
      '250 character maximum',
      '250 characters left',
      'Save Cancel'
       ]

    initializeConfigurations(BASE_URL)
    removeCollection("communicationlogs", "personalprofiledb")
    initializeAllObjects

    @subjectOf4thLogEntry = "Talked to Dr Sharon"

    helper_setTestDates

    #Login to Landing page
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Navigate to Communications Log page
    helper_navigateToCommunicationsLog()
    !45.times{ break if (getPrimaryHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)
  end

  after(:all) do
    quitDriver()
  end


  it "AC# JRNL-2728|TC# JRNL-2834: Screen with title 'Communications Log' contains Add Log Entry button" do
    expect(@communications.getSecondaryHeader()).to eq("Contacts")  #JRNL-2490
    expect(@communications.getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE) #JRNL-2490
    expect(@communications.isAddCommunicationBtnVisible()).to eq(true)
  end

  it "AC# JRNL-2728|TC# JRNL-2834: (1a; 1b; 1c) Clicking Add button displays screen 'Add Communications Log Entry', Date, Type defaults to today and 'Select' respectively" do
    @communications.clickAddCommunicationBtn()
    helper_verifyEntryDetailScreenTitle(@ADD_LOG_ENTRY_TITLE)
    dateInForm = @communications.getDateInForm()
    expect(dateInForm).to eq(@today)
    expect(@communications.getContactTypeDefaultText).to eq("Select")
    expect(@communications.isDeleteButtonVisible()).to be false
    expect(@communications.isCancelButtonVisible()).to be true
    expect(@communications.isSaveButtonVisible()).to be true

    communicationEntryForm = @communications.getScreenContent().split("\n")
    helper_verify_list(communicationEntryForm, @INITIAL_ENTRY_FORM)
  end

  it "AC# JRNL-2728|TC# JRNL-2834: (1b) Verifying TotalCharacterInNarrative on screen 'Add Communications Log Entry'" do
    # verify that Note will be 250 characters with character countdown.
    expect(@communications.verifyTotalCharacterInNarrative()).to be true
    @communications.clickCancelButton()
  end

  it "AC# JRNL-2728|TC# JRNL-2834: (1b) Verifying Errors for required fields Subject, Type, Date " do
    #"Type field is required." and "Subject field is required."
    @communications.addCommunicationLog(@oneDayAgo, "", "", "", "")
    helper_verifyEntryDetailScreenTitle(@ADD_LOG_ENTRY_TITLE)
    helper_checkingInlineError("Type field is required.", "entryForm")
    helper_checkingInlineError("Subject field is required.", "entryForm")
    @communications.clickCancelButton()

    #"Subject field is required."
    @communications.addCommunicationLog(@oneDayAgo, "Other", "", "", "")
    helper_verifyEntryDetailScreenTitle(@ADD_LOG_ENTRY_TITLE)
    helper_checkingInlineError("Subject field is required.", "entryForm")
    @communications.clickCancelButton()

    #"Date field is required."
    @communications.addCommunicationLog("", "Other", "Subject", "", "")
    helper_verifyEntryDetailScreenTitle(@ADD_LOG_ENTRY_TITLE)
    helper_requiredDateTimeFieldTest(@communications, "Date", "Date field is required.")
    @communications.clickCancelButton()

    #"Date field is required."
    @communications.addCommunicationLog(@tomorrow, "Other", "Subject", "", "")
    if Time.new.year.to_s != @tomorrow[-4..-1]
      helper_checkingInlineError("Date must be formatted MM/DD/YYYY.", "entryForm")
    else
      helper_checkingInlineError("Date must be between 01/01/1900 and #{@today}.", "entryForm")
    end

    @communications.clickCancelButton()
  end

end
