require_relative '../../../globalized'
include Globalized


describe "Story#JRNL-2490: [Communications_Log_JRNL_2490_Delete_spec.rb]
Story#JRNL-1333 [Transition the Communication log to the new Mongo HTS]", :regression => true do

  before(:all) do
    @COMMUNICATIONS_LOG_SCREEN_TITLE = "Communications Log"
    @ADD_LOG_ENTRY_TITLE  = "Add "  + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @EDIT_LOG_ENTRY_TITLE = "Edit " + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"

    @LONG_NOTES   = "Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789"
    @LONG_CONTACT = "MaxContactIs 50Chars 23456789012345678901234567890AAAAAAAAAA"
    @LONG_SUBJECT = "MaxSubjectIs 50Chars 23456789012345678901234567890xxxxxx"


    initializeConfigurations(BASE_URL)
    @patientID = helper_get_TestPatientID
    removeCollection("communicationlogs", "personalprofiledb")

    initializeAllObjects

    @subjectOf4thLogEntry = "Talked to Dr Sharon"

    helper_setTestDates

    #Login to Landing page
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Navigate to Communications Log page
    helper_navigateToCommunicationsLog()
    !45.times{ break if (getPrimaryHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)
  end

  after(:all) do
    quitDriver()
  end


  it "AC# JRNL-2728|TC# JRNL-2834: (1) SAVE: Adding entry with max characters for subject, contact and notes" do

    #type Other
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twentyDaysAgo, "Phone", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES, 1)
    ##puts("PASSED: AC#1162 - (1) SAVE: Adding entry with max characters for subject, contact and notes")

  end


  it "AC# JRNL-2730|TC# JRNL-2834: (1) SAVE: Verify entry with max characters for subject, contact and notes added" do

    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twentyDaysAgo, "Phone", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES)
    ##puts("PASSED: AC# JRNL-2730: (1) SAVE: Verify entry with max characters for subject, contact and notes added")

  end


  it "AC# JRNL-2731|TC# JRNL-2834: (3) DELETE: Verify entry with max characters for subject, contact and notes deleted" do
    helper_NO_deleteNthCommLog(@communications, 1, @EDIT_LOG_ENTRY_TITLE, @COMMUNICATIONS_LOG_SCREEN_TITLE)

    ##puts("PASSED: AC# JRNL-2731: (3) DELETE: Verify with 'NO' response, entry with max characters for subject, contact and notes deleted")
    helper_YES_deleteNthCommLog(@communications, 1, @EDIT_LOG_ENTRY_TITLE, @COMMUNICATIONS_LOG_SCREEN_TITLE)

    ##puts("PASSED: AC# JRNL-2731: (3) DELETE: Verify with 'YES' response, entry with max characters for subject, contact and notes deleted")
  end


  it "AC# JRNL-2731|TC# JRNL-2834: (3) DELETE: Verify all entries added in the back end are deleted" do

    #Load in the data, update the first 3 documents and delete the remaining
    insertCollection("communicationlogs", "personalprofiledb", "communicationLogs_set1")

    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111111", "recorded", addDays(getTodayInZeroTime,-1))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111112", "recorded", addDays(getTodayInZeroTime,-2))
    updateDocument("communicationlogs", "personalprofiledb", "541111111111111111111113", "recorded", addDays(getTodayInZeroTime,-15))

    refreshBrowser

    helper_verifyListScreenTitle(@COMMUNICATIONS_LOG_SCREEN_TITLE)
    commLogCountBeforeDelete = @communications.getCommunicationsLogCount()

    !commLogCountBeforeDelete.times{
      helper_YES_deleteNthCommLog(@communications, 1, @EDIT_LOG_ENTRY_TITLE, @COMMUNICATIONS_LOG_SCREEN_TITLE)
    }
    #helper_verify_Empty_List(@communications, "No results found.")
    helper_verify_Empty_List(@communications, "No results were found with the current filters. Use the Add button above to create a new record.")
    ##puts("AC# JRNL-2731|TC# JRNL-2834: (3) DELETE: Verify all entries added in the back end are deleted")
  end


  it "Re-add communcation log entry that was deleted" do

    #Verify able to re-add the Communcation Log entry that was deleted

    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twentyDaysAgo, "Phone", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES, 1)
    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twentyDaysAgo, "Phone", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES)

  end

end