require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2490: [Communications_Log_JRNL_2490_Add_spec.rb] Story#JRNL-1333
[Transition the Communication log to the new Mongo HTS]", :regression => true do

  before(:all) do
    @COMMUNICATIONS_LOG_SCREEN_TITLE = "Communications Log"
    @ADD_LOG_ENTRY_TITLE  = "Add "  + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"
    @EDIT_LOG_ENTRY_TITLE = "Edit " + @COMMUNICATIONS_LOG_SCREEN_TITLE + " Entry"

    @LONG_NOTES   = "Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789Postal entry - 123450123456789"
    @LONG_CONTACT = "MaxContactIs 50Chars 23456789012345678901234567890AAAAAAAAAA"
    @LONG_SUBJECT = "MaxSubjectIs 50Chars 23456789012345678901234567890xxxxxx"

    @INITIAL_ENTRY_FORM = [ \
      '* required field',
      '* Date:',
      'MM/DD/YYYY',
      'This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker',
      '* Type:',
      'Select',
      'Phone',
      'Fax',
      'In Person',
      'Email',
      'Text',
      'Postal',
      'Other',
      '* Subject:',
      '50 character maximum',
      'Who:',
      '50 character maximum',
      'Note:',
      '250 character maximum',
      '250 characters left',
      'Save Cancel'
       ]

    initializeConfigurations(BASE_URL)
    removeCollection("communicationlogs", "personalprofiledb")

    initializeAllObjects

    @subjectOf4thLogEntry = "Talked to Dr Sharon"

    helper_setTestDates

    #Login to Landing page
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Navigate to Communications Log page
    helper_navigateToCommunicationsLog()
    !45.times{ break if (getPrimaryHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)

  end

  after(:all) do
    quitDriver()
  end

  it "AC# JRNL-2728|TC# JRNL-2834: Screen with title 'Communications Log' contains Add Log Entry button" do
    expect(@communications.getSecondaryHeader()).to eq("Contacts")  #JRNL-2490
    expect(@communications.getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE) #JRNL-2490
    expect(@communications.isAddCommunicationBtnVisible()).to eq(true)
    ##puts("PASSED: AC# JRNL-2728 - Screen with title 'Communications Log' contains Add Log Entry button ")
  end


  it "AC# JRNL-2730|TC# JRNL-2834: (1c) Cancel button: enabled- Save, Delete buttons: disabled and Clicking Cancel button: no record added" do

    @communications.clickAddCommunicationBtn()
    helper_verifyEntryDetailScreenTitle(@ADD_LOG_ENTRY_TITLE)

    expect(@communications.isDeleteButtonVisible()).to be false
    expect(@communications.isCancelButtonVisible()).to be true
    expect(@communications.isSaveButtonVisible()).to be true
    ##puts("PASSED: AC# JRNL-2730 - (1c) Cancel button: enabled- Save, Delete buttons: disabled")

    @communications.fillDataInCommunicationLogForm(@oneDayAgo, "Other", "xxx", "yyy", "zzz")
    @communications.clickCancelButton()
    !45.times{ break if (getMainHeader() == @COMMUNICATIONS_LOG_SCREEN_TITLE); sleep 1 }
    expect(getPrimaryHeader()).to eq(@COMMUNICATIONS_LOG_SCREEN_TITLE)

    #helper_verify_Empty_List(@communications, "No results found.")
    helper_verify_Empty_List(@communications, "No results were found with the current filters. Use the Add button above to create a new record.")

    ##puts("PASSED: AC# JRNL-2730 -  (1c) Cancel button: enabled- Save, Delete buttons: disabled and Clicking Cancel button: no record added")
  end



  it "AC# JRNL-2730|TC# JRNL-2834: (1) SAVE: Adding entry with max characters for subject, contact and notes" do

    #type Other
    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twentyDaysAgo, "Email", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES, 1)
    ##puts("PASSED: AC#1168 - (1) SAVE: Adding entry with max characters for subject, contact and notes")

  end


  it "AC# JRNL-2730|TC# JRNL-2834: (1) SAVE: Verify entry with max characters for subject, contact and notes added" do

    helper_verify_this_entry_added(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @EDIT_LOG_ENTRY_TITLE, @twentyDaysAgo, "Email", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES)
    ##puts("PASSED: AC# JRNL-2730: (1) SAVE: Verify entry with max characters for subject, contact and notes added")

  end


  it "AC# JRNL-2730|TC# JRNL-2834: (1) Verify adding duplicate entry" do

    helper_add_this_entry(@communications, @COMMUNICATIONS_LOG_SCREEN_TITLE, @twentyDaysAgo, "Email", @LONG_SUBJECT, @LONG_CONTACT, @LONG_NOTES, 1)
    expect(@communications.getCommunicationsLogCount()).to eq(2)
    ##puts("PASSED: AC# JRNL-2730: (1) Verify adding duplicate entry")

  end
end
