#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "Story #JRNL-2492 #MVAH-1229 [Contact_Create_Contacts_Feature_JRNL_2492_spec.rb]", :regression => true do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "AC# JRNL-2717|TC# JRNL-2758: The 'Contacts' feature will be accessible via the Contacts button in the left-hand menu; it's below Notifications button and above Assessments button" do
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    expect(@nav_menu.isContactsButtonVisible()).to eq(true)
    contactPosition = 8
    expect(@nav_menu.getNthOptionName(contactPosition-1)).to eq("Notifications")
    expect(@nav_menu.getNthOptionName(contactPosition)).to eq("Contacts")
    expect(@nav_menu.getNthOptionName(contactPosition+1)).to eq("Assessments")

    @nav_menu.clickContacts

    !45.times{ break if (@contacts.getSecondaryHeader == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader).to eq("Contacts")
    expect(@contacts.getPrimaryHeader).to eq("Contacts")
    ##puts"PASSED: STORY# MVHA819 ==> AC# JRNL-2717"

  end



  it "AC# JRNL-2856|TC# JRNL-2758: Verify the feature groups of 'Contacts' are 'Healthcare Contacts, Insurance Contacts, Personal Contacts,  and Communications Log'" do

    expect(@contacts.getNthContactsFeatureName(1)).to eq("Healthcare Contacts")
    expect(@contacts.getNthContactsFeatureName(2)).to eq("Insurance Contacts")
    expect(@contacts.getNthContactsFeatureName(3)).to eq("Personal Contacts")
    expect(@contacts.getNthContactsFeatureName(4)).to eq("Communications Log")

    expect(@common.getDefaultMsg).to eq("Select an item from the Contacts list to view details or add a new Contact entry.")

    @contacts.clickPersonalContacts
    !45.times{ break if (@contacts.getPrimaryHeader == "Personal Contacts"); sleep 1 }
    expect(@contacts.getPrimaryHeader).to eq("Personal Contacts")
  end


  # ----------------------------------------------------------------------------------
  #  10/06/2014 - UPDATE
  #  AC# MVAH-1067|TC# JRNL-2758 (below) has been superceded by  Story MVAH-1229 | AC JRNL-2856 (above)
  # ----------------------------------------------------------------------------------

  #it "AC# MVAH-1067|TC# JRNL-2758: Verify the feature groups of 'Contacts' are 'Provider Contacts, Facility Contacts, Insurance Contacts, Personal Contacts,  and Communications Log'" do
  #
  #  expect(@contacts.getNthContactsFeatureName(1)).to eq("Provider Contacts")
  #  expect(@contacts.getNthContactsFeatureName(2)).to eq("Facility Contacts")
  #  expect(@contacts.getNthContactsFeatureName(3)).to eq("Insurance Contacts")
  #  expect(@contacts.getNthContactsFeatureName(4)).to eq("Personal Contacts")
  #  expect(@contacts.getNthContactsFeatureName(5)).to eq("Communications Log")
  #
  #  expect(@common.getDefaultMsg).to eq("Select an item from the Contacts list to view details or add a new Contact entry.")
  #
  #  @contacts.clickPersonalContacts
  #  !45.times{ break if (@contacts.getPrimaryHeader == "Personal Contacts"); sleep 1 }
  #  expect(@contacts.getPrimaryHeader).to eq("Personal Contacts")
  #  puts"PASSED ALL: STORY# JRNL-2492 ==> AC# MVAH-1067"
  #  puts("++++++ PASSED: Contact_Create_Contacts_Feature_JRNL_2492_spec.rb")
  #end
  # ----------------------------------------------------------------------------------


end
