require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-65: Upate to use Final ROA From ]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteROAFromTable("D123401") #delete ROA for zztest.patient01
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-156 | TC # JRNL-183: User cannot log into the application if they do not have a Right of Access form on record" do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()
    
    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.justLogin("zztest.patient01")

    !45.times{ break if (getPageTitle() ==  "Right Of Access"); sleep 1 }
    expect(getPageTitle()).to eq("Right Of Access")
    @roa.clickNext()
    
    !45.times{ break if (getPageTitle() == "Review"); sleep 1 }
    expect(getPageTitle()).to eq("Review")

    waitForPageToFinishLoading
    @roa.clickCancelInReview()
    waitForPageToFinishLoading

    !45.times{ break if (getPageTitle() ==  "Right Of Access"); sleep 1 }

    expect(getPageTitle()).to eq("Right Of Access")

  end

  it "AC #JRNL-158 | TC # JRNL-183: User declines ROA" do
    waitForPageToFinishLoading
    @roa.clickCancelEndOnLaunchpad()
    expect(getPageTitle()).to eq("Launchpad")

  end

  it "AC #JRNL-157 | TC # JRNL-183:  User must sign ROA to use application" do
    gotoHome(BASE_URL)
    !45.times{ break if (getPageTitle() ==  "Right Of Access"); sleep 1 }
    expect(getPageTitle()).to eq("Right Of Access")

    @roa.clickNext()
    !45.times{ break if (getPageTitle() == "Review"); sleep 1 }
    expect(getPageTitle()).to eq("Review")

    @roa.clickVerify()

    #To check if the Time Zone selection screen is present
    if is_element_present(:css, "button[ng-click='save()']") then
      puts "Initializing user Notification Setting and the Time Zone selection."
      byPassTheNotificationSettingsScreen()
    end

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  BELOW CODE ###################################
########################################################################################################################
########################################################################################################################

    waitForPageToFinishLoading
    !15.times{ break if (@main.pleaseNoteHeader() == "Please Note"); sleep 2 }
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  ABOVE CODE ###################################
########################################################################################################################
########################################################################################################################

    waitForPageToFinishLoading
    @app_tour.clickAppTourCloseButton

    !45.times{ break if (@main.isNavMenuVisible() == true); sleep 1 }
      #DS Logon is not displayed if the user is already logged in
     expect(@main.isNavMenuVisible()).to be true
     expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

end
