require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-32: User should be prsented with a EULA]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-77 | TC #JRNL-227: EULA (Upon using the app for the first time, the user will need to accept a EULA)" do
    !45.times{ break if (@eula.getEulaHeading() == "End User License Agreement"); sleep 1 }
    expect(@eula.getEulaHeading()).to eq("End User License Agreement")

    !45.times{ break if (@eula.declineEulaVisible?() == true); sleep 1 }
    expect(@eula.declineEulaVisible?()).to be true
    expect(@eula.acceptEulaVisible?()).to be true

  end

  it "AC #JRNL-87 | TC #JRNL-227: For web based applications, when the user declines the EULA, they will returned to Launchpad. " do
    @eula.clickDeclineEulaButton()
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")
  end

  it "AC #JRNL-86 | TC #JRNL-227:  -When the user accepts the EULA, they will be taken to the app landing page as a non logged in user if they have not already Logged in, or the landing page of the app as a logged in user if they have already logged in (Single Signon)" do
    gotoHome(BASE_URL)

    !45.times{ break if (@eula.getEulaHeading() == "End User License Agreement"); sleep 1 }
    expect(@eula.getEulaHeading()).to eq("End User License Agreement")

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    
    expect(@landing.getFooterText).to eq("Not logged in")

    @common.clearLocalStorage

    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen when user is not logged in
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    gotoHome(BASE_URL)

    waitForPageToFinishLoading
    !45.times{ break if (@eula.getEulaHeading() == "End User License Agreement"); sleep 1 }
    expect(@eula.getEulaHeading()).to eq("End User License Agreement")
    @eula.clickDeclineEulaButton()

    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")
    waitForPageToFinishLoading
    @launchpad.clickLogIn()
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")
    sleep 2
    @eula.clickAcceptLaunchpadEula()
    waitForPageToFinishLoading
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")

    expect(@launchpad.getFooterUserName()).to eq("Logged in as patient01, zztest")

    gotoHome(BASE_URL)

    !45.times{ break if (@eula.getEulaHeading() == "End User License Agreement"); sleep 1 }
    expect(@eula.getEulaHeading()).to eq("End User License Agreement")

    @eula.clickAccept()

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  BELOW CODE ###################################
########################################################################################################################
########################################################################################################################

    waitForPageToFinishLoading
    !15.times{ break if (@main.pleaseNoteHeader() == "Please Note"); sleep 2 }
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  ABOVE CODE ###################################
########################################################################################################################
########################################################################################################################

    !45.times{ break if (@main.isNavMenuVisible() == true); sleep 1 }
    #DS Logon is not displayed if the user is already logged in
    expect(@main.isNavMenuVisible()).to be true
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  it "AC #JRNL-78 | TC #JRNL-227: User will not have to reaccept the EULA for a web app unless the current EULA is newer than the date signed", :broken => true do
    @main.clickUserMenu()
    @menu.clickLogoutBtn()

    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")

    #the current EULA is not newer than the date signed
    gotoHome(BASE_URL)
    #Lands on the Splash landing page
    !45.times{ break if (getPageTitle() == "My VA Health"); sleep 1 }

    expect(getPageTitle()).to eq("My VA Health")

    #Need to add scenario that the current EULA is newer than the date signed

  end

end
