require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-76: Authenticate through DSLogon]", :regression => true do
      
  before(:all) do  
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end  
    
  after(:all) do
    quitDriver()
  end 

  it "AC #JRNL-89 | TC #JRNL-215: User has accepted the EULA" do
    !45.times{ break if (@eula.getEulaHeading() == "End User License Agreement"); sleep 1 }
    expect(@eula.getEulaHeading()).to eq("End User License Agreement")
   
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()
    
    #Checking the DS Logon screen
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
  end
   
  it "AC #JRNL-90 | TC #JRNL-215:  User is directed to an external login page(via IAM services)" do
    expect(getPageTitle()).to eq("Department of Veterans Affairs - Veteran Login Page")
    expect(@loginpage.isUserNameFieldVisible?()).to be true
    expect(@loginpage.isPasswordFieldVisible?()).to be true
  end
  
  it "AC #JRNL-91| TC #JRNL-215: After user authenticates with their DSLogon UN/PW, user will return to app", :broken => true do
    @loginpage.loginAsVeteran01AndAcceptROA()

    !45.times{ break if (@main.isNavMenuVisible() == true); sleep 1 }
     #DS Logon is not displayed if the user is already logged in
    expect(@main.isNavMenuVisible()).to be true
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  it "AC #JRNL-92| TC #JRNL-215: After loggin in, user will see 'Log Off' button as part of navigation menu", :broken => true do

    @main.clickUserMenu
    !45.times{ break if (@menu.getMenuHeading == "User Menu"); sleep 1 }
    expect(@menu.getMenuHeading).to eq("User Menu")

    @menu.clickLogoutBtn()
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")
    waitForPageToFinishLoading
    expect(@launchpad.getFooterUserName()).to eq("Not logged in")
  end
  
end
 