require_relative '../../globalized'
include Globalized

describe "Story #JRNL-108 Single Sign On", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    addJournalLaunchpadItemToDatabase();
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-109| TC #JRNL-224: SSO Open second app without-reauthenticating" do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()  
   
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    gotoLaunchpad()

    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    waitForPageToFinishLoading
    @eula.clickAcceptLaunchpadEula()

    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")
    waitForPageToFinishLoading
    expect(@launchpad.getFooterUserName()).to eq("Logged in as patient01, zztest")
    @launchpad.clickLogOut()
    expect(@launchpad.getFooterUserName()).to eq("Not logged in")
  end

  it "AC #JRNL-110 | TC #JRNL-224:  Login not required if authenticated" do
    @launchpad.clickLogIn()
    @loginpage.loginAsVeteran("zztest.patient01")
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")

    expect(@launchpad.getFooterUserName()).to eq("Logged in as patient01, zztest")
    @launchpad.clickJournal()

    !45.times{ break if (@main.getTitle() == "Home"); sleep 1 }
    expect(@main.getTitle()).to eq("Home")
    waitForPageToFinishLoading
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  it "AC #JRNL-111 | TC #JRNL-224:  Log off option" do
    @main.clickUserMenu()
    !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
    @menu.isLogOutVisible()
    @menu.clickLogoutBtn()

    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")
    waitForPageToFinishLoading
    expect(@launchpad.getFooterUserName()).to eq("Not logged in")
    @launchpad.clickJournal()
    !45.times{ break if (@main.getTitle() == "My VA Health"); sleep 1 }
    expect(@main.getTitle()).to eq("My VA Health")

    @main.clickUserMenu()
    !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
    expect(@menu.isLogOutVisible()).to be false
    expect(@menu.isLogInVisible()).to be true
  end
end

