require_relative '../../globalized'
include Globalized
require 'rspec'
require 'date'
require 'time'

todayMonthDayYear= Date.today.strftime('%m/%d/%Y')
todayMonthYear= Date.today.strftime('%m/%Y')
yesterdayMonthDayYear = (Date.today - 1).strftime('%m/%d/%Y')
tomorrowMonthDayYear = (Date.today + 1).strftime('%m/%d/%Y')
fiveYearsAgoMonthDayYear = (Date.today - 5.years).strftime('%m/%d/%Y')
sixYearAgoMonthDayYear = (Date.today - 6.years).strftime('%m/%d/%Y')
oneYearAgoMonthDayYear = (Date.today - 1.years).strftime('%m/%d/%Y')
oneYearAgoMonthYear = (Date.today - 1.years).strftime('%m/%Y')
oneYearForwardMonthDayYear = (Date.today + 1.years).strftime('%m/%d/%Y')
oneYearForwardMonthYear = (Date.today + 1.years).strftime('%m/%Y')
oneYearBackMonthYear = (Date.today - 1.years).strftime('%m/%Y')
todayYear = Date.today.strftime('%Y')
oneYearAgoYear = (Date.today - 1.years).strftime('%Y')
tooEarlyDateMonthDayYear = '01/01/1900'
tooLateDateMonthDayYear = '12/31/2099'
invalidDateFormat = '1'
time = Time.new
currentTimeHourMinuteMeridian = time.strftime('%H:%M'' %p')

describe "[Story #JRNL_2426: Calendar Widget Warning Message]" do

before(:all) do

  initializeConfigurations(BASE_URL)
  initializeAllObjects

  ########################
  ### CLEAR MONGO DATA ###
  ########################
  removeCollection("occupationhistory", "personalhistorydb")
  removeCollection("assessments", "healthinventorydb")
  removeCollection("goals", "healthinventorydb")
  removeCollection("plan", "previsitagendadb")
  #My Medical
  removeCollection("symptoms", "medicalhistorydb")
  removeCollection('medications', 'medicalhistorydb')
  removeCollection('allergies', 'medicalhistorydb')
  removeCollection("diagnosis", "medicalhistorydb")
  removeCollection("surgeries", "medicalhistorydb")
  removeCollection("hospitalization", "medicalhistorydb")
  removeCollection("familyhistory", "medicalhistorydb")
  resetCollection("preventiveservices", "healthtrackerdb", "PSlistForTableView")
  #Personal Trackers
  # Glucose
  removeCollection("chemlabs", "medicalhistorydb")
  # Cholesterol/Lipid
  removeCollection("chemlabsbundles", "medicalhistorydb")
  # Stress
  removeCollection("stress", "medicalhistorydb")
  # Sleep
  removeCollection("sleep", "medicalhistorydb")
  # Mood
  removeCollection("mood", "medicalhistorydb")
  # Height, Weight, Pain, Respiration, Temperature
  removeCollection("vitalsigns", "medicalhistorydb")
  # Blood Pressure and Pulse
  removeCollection("vitalsignsbundles", "medicalhistorydb")
  # Diet
  removeCollection("diet", "healthfactordb")
  # Exercise
  removeCollection("fitness", "healthfactordb")
  # Notification
  removeCollection("reminders", "remindersdb")
  # Preferences
  removeCollection("preferences", "healthtrackerdb")
  # Daily Events
  removeCollection("notes", "medicalhistorydb")
  #Contacts
  removeCollection("contacts", "personalprofiledb")
  removeCollection("communicationlogs", "personalprofiledb")
  #Images and Documents
  removeCollection("attachments.chunks", "attachmentsdb")
  removeCollection("attachments.files", "attachmentsdb")

  @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
end

after(:all) do
  quitDriver
end

context "'JRNL 466 Calendar Widget'"

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Profile/Occupational History and verify Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickMyProfile
  @navMenu.clickMilitaryOccupationalHistory
  @occupationalHistory.clickAddEntryButton
  @occupationalHistory.setEventTitle('Add Event Date')

  @occupationalHistory.setExposureRadioButton('yes')
  @occupationalHistory.setRecordDetailsAboutYourExposure('Add Record Details About Your Exposure')
  @occupationalHistory.enterDate('')
  @occupationalHistory.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Event Date field is required.')

  @occupationalHistory.enterDate(invalidDateFormat)
  @occupationalHistory.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Event Date must be formatted MM/DD/YYYY.')

  @occupationalHistory.enterDate(tomorrowMonthDayYear)
  @occupationalHistory.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Event Date must be between 01/01/1900 and ' + todayMonthDayYear + '.')

  @occupationalHistory.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Profile/Occupational History and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyProfile
    @navMenu.clickMilitaryOccupationalHistory
    @occupationalHistory.clickAddEntryButton
    @occupationalHistory.setEventTitle('Add Event Date')

    @occupationalHistory.enterDate(todayMonthDayYear)
    @occupationalHistory.setExposureRadioButton('yes')
    @occupationalHistory.setRecordDetailsAboutYourExposure('Add Record Details About Your Exposure')
    @occupationalHistory.clickSaveButtonJump
    @occupationalHistory.clickNthRow(1)

    expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_DATE)).to eq(todayMonthDayYear)

    @occupationalHistory.enterDate(yesterdayMonthDayYear)
    @occupationalHistory.clickSaveButtonJump
    @occupationalHistory.clickNthRow(1)

    expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_DATE)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Event date to validate Add and Edit Entry from My Profile/Occupational History is visible in the table Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickMyProfile
  @navMenu.clickMilitaryOccupationalHistory
  @driver.execute_script("$('form.filter-form').css('overflow', 'visible');")
  @occupationalHistory.setStartDate('')
  @occupationalHistory.setEndDate(todayMonthDayYear)
  @occupationalHistory.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @occupationalHistory.setStartDate(todayMonthDayYear)
  @occupationalHistory.setEndDate('')
  @occupationalHistory.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @occupationalHistory.setStartDate(tomorrowMonthDayYear)
  @occupationalHistory.setEndDate(tomorrowMonthDayYear)
  @occupationalHistory.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @occupationalHistory.setStartDate(todayMonthDayYear)
  @occupationalHistory.setEndDate(yesterdayMonthDayYear)
  @occupationalHistory.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @occupationalHistory.setStartDate(invalidDateFormat)
  @occupationalHistory.setEndDate(todayMonthDayYear)
  @occupationalHistory.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @occupationalHistory.setStartDate(todayMonthDayYear)
  @occupationalHistory.setEndDate(invalidDateFormat)
  @occupationalHistory.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Event date to validate Add and Edit Entry from My Profile/Occupational History is visible in the table', :broken => true do
    @main.clickNavMenu
    @navMenu.clickMyProfile
    @navMenu.clickMilitaryOccupationalHistory

    @occupationalHistory.setStartDate(yesterdayMonthDayYear)
    @occupationalHistory.setEndDate(todayMonthDayYear)
    @occupationalHistory.clickApplyButton
    @occupationalHistory.clickNthRow(1)

    expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::START_DATE)).to eq(yesterdayMonthDayYear)
    @occupationalHistory.clickSaveButtonJump
end

it 'JRNL 466 Calendar Widget - Filter Date date My Story/Assessment/History Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyStory
    @my_story.clickAssessment
    @assessment.clickHistoryButton

    @assessment.setStartDate('')
    @assessment.setEndDate(todayMonthDayYear)
    @assessment.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

    @assessment.setStartDate(todayMonthDayYear)
    @assessment.setEndDate('')
    @assessment.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

    @assessment.setStartDate(tomorrowMonthDayYear)
    @assessment.setEndDate(tomorrowMonthDayYear)
    @assessment.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

    @assessment.setStartDate(todayMonthDayYear)
    @assessment.setEndDate(yesterdayMonthDayYear)
    @assessment.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

    @assessment.setStartDate(invalidDateFormat)
    @assessment.setEndDate(todayMonthDayYear)
    @assessment.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

    @assessment.setStartDate(todayMonthDayYear)
    @assessment.setEndDate(invalidDateFormat)
    @assessment.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date date My Story/Assessment/History' do
     @main.clickNavMenu
     @navMenu.clickMyStory
     @my_story.clickAssessment
     @assessment.clickHistoryButton
     expect(@assessment.getTextFromInput(:css, Assessment::START_DATE)).to eq(oneYearAgoMonthDayYear)
     expect(@assessment.getTextFromInput(:css, Assessment::END_DATE)).to eq(todayMonthDayYear)
     @assessment.setStartDate(todayMonthDayYear)
     @assessment.setEndDate(todayMonthDayYear)
     @assessment.clickApplyButton
     expect(@assessment.getTextFromInput(:css, Assessment::START_DATE)).to eq(todayMonthDayYear)
     expect(@assessment.getTextFromInput(:css, Assessment::END_DATE)).to eq(todayMonthDayYear)
     @assessment.clickResetButton
     expect(@assessment.getTextFromInput(:css, Assessment::START_DATE)).to eq(oneYearAgoMonthDayYear)
     expect(@assessment.getTextFromInput(:css, Assessment::END_DATE)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Story/Goals and verify Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickMyStory
  @my_story.clickGoals
  @common.clickAddButton
  @goal.setGoalName('Add Name Of Goal')

  @goal.setGoalStartDate('')
  @goal.setGoalEndDate(todayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Goal Start Date field is required.')

  @goal.setGoalStartDate(todayMonthDayYear)
  @goal.setGoalEndDate('')
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Goal End Date field is required.')

  @goal.setGoalStartDate(tooEarlyDateMonthDayYear)
  @goal.setGoalEndDate(todayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Step Due Dates must fall within or on the Goal’s Start Date and End Date range.\nGoal Start Date must be between 12/12/1900 and 12/12/2099.")

  @goal.setGoalStartDate(todayMonthDayYear)
  @goal.setGoalEndDate(tooLateDateMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Step Due Dates must fall within or on the Goal’s Start Date and End Date range.\nGoal End Date must be between 12/12/1900 and 12/12/2099.")

  @goal.setGoalStartDate(todayMonthDayYear)
  @goal.setGoalEndDate(yesterdayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Goal Start Date must occur before Goal End Date.')

  @goal.setGoalStartDate(invalidDateFormat)
  @goal.setGoalEndDate(todayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Goal Start Date must be formatted MM/DD/YYYY.')

  @goal.setGoalStartDate(todayMonthDayYear)
  @goal.setGoalEndDate(invalidDateFormat)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Goal End Date must be formatted MM/DD/YYYY.')

  @goal.setGoalStartDate(todayMonthDayYear)
  @goal.setGoalEndDate(tomorrowMonthDayYear)
  @goal.setNthStep(1, 'Step 1')

  @goal.setNthStepDueDate(1, '')
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Due Date #1 field is required.')

  @goal.setNthStepDueDate(1, invalidDateFormat)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Due Date #1 must be formatted MM/DD/YYYY.')

  @goal.setNthStepDueDate(1, yesterdayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Step Due Dates must fall within or on the Goal’s Start Date and End Date range.')

  @goal.setNthStepDueDate(1, tomorrowMonthDayYear)
  @goal.clickAddStepButton
  @goal.setNthStep(2, 'Step 2')

  @goal.setNthStepDueDate(2, '')
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Due Date #2 field is required.')

  @goal.setNthStepDueDate(2, invalidDateFormat)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Due Date #2 must be formatted MM/DD/YYYY.')

  @goal.setNthStepDueDate(2, todayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Steps must be entered in sequential order based on the Step Due Date.')

  @goal.setNthStepDueDate(2, yesterdayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Steps must be entered in sequential order based on the Step Due Date.\nStep Due Dates must fall within or on the Goal’s Start Date and End Date range.")

  @goal.setNthStepDueDate(2, tomorrowMonthDayYear)
  @goal_notification.selectNotificationStatus('On')
  @goal_notification.selectNotifyMe('Daily')

  @goal_notification.setNotificationStartDate('')
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @goal_notification.setNotificationStartDate(invalidDateFormat)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @goal_notification.setNotificationStartDate(yesterdayMonthDayYear)
  @goal.clickSaveButtonJump
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Step Due Dates must fall within or on the Goal’s Start Date and End Date range.\nStart Date must be between " + todayMonthDayYear + " and 12/31/2099.")

  @goal.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Story/Goals and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyStory
    @my_story.clickGoals
    @common.clickAddButton
    @goal.setGoalName('Add Name Of Goal')

    @goal.setGoalStartDate(todayMonthDayYear)
    @goal.setGoalEndDate(todayMonthDayYear)
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.clickAddStepButton
    @goal.setNthStep(1,'Step 1')
    @goal.setNthStepDueDate(1, todayMonthDayYear)

    @goal.setNthStep(2,'Step 2')
    @goal.setNthStepDueDate(2, todayMonthDayYear)

    @goal.setNthStep(3,'Step 3')
    @goal.setNthStepDueDate(3, todayMonthDayYear)

    @goal.setNthStep(4,'Step 4')
    @goal.setNthStepDueDate(4, todayMonthDayYear)

    @goal.setNthStep(5,'Step 5')
    @goal.setNthStepDueDate(5, todayMonthDayYear)

    @goal.setNthStep(6,'Step 6')
    @goal.setNthStepDueDate(6, todayMonthDayYear)

    @goal.setNthStep(7,'Step 7')
    @goal.setNthStepDueDate(7, todayMonthDayYear)

    @goal.setNthStep(8,'Step 8')
    @goal.setNthStepDueDate(8, todayMonthDayYear)

    @goal.setNthStep(9,'Step 9')
    @goal.setNthStepDueDate(9, todayMonthDayYear)

    @goal.setNthStep(10,'Step 10')
    @goal.setNthStepDueDate(10, todayMonthDayYear)

    @goal_notification.selectNotificationStatus('On')
    @goal_notification.setNotificationStartDate(todayMonthDayYear)
    @goal_notification.selectNotifyMe('Daily')

    @goal.clickSaveButtonJump

    @goal.clickNthRow(1)
end

it 'JRNL 466 Calendar Widget - Filter Date My Story/Goals Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickMyStory
  @my_story.clickGoals

  @my_story.setFromDate('')
  @my_story.setToDate(todayMonthDayYear)
  @my_story.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From Date field is required.')

  @my_story.setFromDate(todayMonthDayYear)
  @my_story.setToDate('')
  @my_story.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('To Date field is required.')

  @my_story.setFromDate(todayMonthDayYear)
  @my_story.setToDate(yesterdayMonthDayYear)
  @my_story.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From Date must occur before To Date.')

  @my_story.setFromDate(invalidDateFormat)
  @my_story.setToDate(todayMonthDayYear)
  @my_story.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From Date must be formatted MM/DD/YYYY.')

  @my_story.setFromDate(todayMonthDayYear)
  @my_story.setToDate(invalidDateFormat)
  @my_story.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('To Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date My Story/Goals' do
    @main.clickNavMenu
    @navMenu.clickMyStory
    @my_story.clickGoals
    expect(@assessment.getTextFromInput(:css, MyStory::FROM_DATE)).to eq(oneYearAgoMonthDayYear)
    expect(@assessment.getTextFromInput(:css, MyStory::TO_DATE)).to eq(oneYearForwardMonthDayYear)
    @my_story.setFromDate(todayMonthDayYear)
    @my_story.setToDate(todayMonthDayYear)
    @my_story.clickApplyButton
    expect(@assessment.getTextFromInput(:css, MyStory::FROM_DATE)).to eq(todayMonthDayYear)
    expect(@assessment.getTextFromInput(:css, MyStory::TO_DATE)).to eq(todayMonthDayYear)
    @my_story.clickResetButton
    expect(@assessment.getTextFromInput(:css, MyStory::FROM_DATE)).to eq(oneYearAgoMonthDayYear)
    expect(@assessment.getTextFromInput(:css, MyStory::TO_DATE)).to eq(oneYearForwardMonthDayYear)
    #Update this to add verifying table data from entries added and edited
end

##################################### MY MEDICAL STARTS HERE ##########################################################

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Plan Your Appointment and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickPlanYourAppointment
    @common.clickAddButton
    @appmt.selectAppointmentStatus('Desired')
    @appmt.setClinic('VAMC')

    @appmt.setAppointmentDate(invalidDateFormat)
    @appmt.clickSaveBtnJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @appmt.setAppointmentDate(todayMonthDayYear)
    @appmt.clickSaveBtnJump
end

xit 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Plan Your Appointment and verify Calendar widget Positive Scenarios', :broken => true do
      @main.clickNavMenu
      @navMenu.clickMyMedical
      @myMedical.clickPlanYourAppointment
      @common.clickAddButton
      @appmt.setAppointmentDate(todayMonthDayYear)
      @appmt.selectAppointmentStatus('Desired')
      @appmt.setClinic('VAMC')
      @appmt.clickSaveBtn
      #There is a bug 'save becomes disabled and page stays on same page. Once bug is fixed add code for edit goal and verification for required fields
      @appmt.clickNthRow(1)
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Plan Your Appointment Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickPlanYourAppointment

    @myMedical.setStartDate('')
    @myMedical.setEndDate(todayMonthDayYear)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

    @myMedical.setStartDate(todayMonthDayYear)
    @myMedical.setEndDate('')
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

    @myMedical.setStartDate(todayMonthDayYear)
    @myMedical.setEndDate(yesterdayMonthDayYear)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

    @myMedical.setStartDate(invalidDateFormat)
    @myMedical.setEndDate(todayMonthDayYear)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

    @myMedical.setStartDate(todayMonthDayYear)
    @myMedical.setEndDate(invalidDateFormat)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

xit 'JRNL 466 Calendar Widget - Filter Date My Medical/Plan Your Appointment', :broken => true do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickPlanYourAppointment
    expect(@assessment.getTextFromInput(:css, MyMedical::START_DATE)).to eq(oneYearAgoMonthDayYear)
    expect(@assessment.getTextFromInput(:css, MyMedical::END_DATE)).to eq(oneYearForwardMonthDayYear)
    ###There is a bug the default start date is showing 04/14/2016 and default end date is showing 04/14/2016
    @myMedical.setFromDate(todayMonthDayYear)
    @myMedical.setToDate(todayMonthDayYear)
    @myMedical.clickApplyButton
    expect(@assessment.getTextFromInput(:css, MyMedical::START_DATE)).to eq(todayMonthDayYear)
    expect(@assessment.getTextFromInput(:css, MyMedical::END_DATE)).to eq(todayMonthDayYear)
    @myMedical.clickResetButton
    expect(@assessment.getTextFromInput(:css, MyMedical::START_DATE)).to eq(oneYearAgoMonthDayYear)
    expect(@assessment.getTextFromInput(:css, MyMedical::END_DATE)).to eq(oneYearForwardMonthDayYear)
    #Update this to add verifying table data from entries added and edited
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Symptom Diary and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickSymptom
    @myMedical.clickAddEntryButton
    @symptom.enterSymptomName('Add Symptom Name')

    @symptom.enterDate('')
    @symptom.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @symptom.enterDate(invalidDateFormat)
    @symptom.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @symptom.enterDate(tomorrowMonthDayYear)
    @symptom.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @symptom.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Symptom Diary and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickSymptom
    @myMedical.clickAddEntryButton
    ###The date field is defaulted to today is this how it should behave ? and symptom name becomes read only after saving
    @symptom.enterDate(todayMonthDayYear)
    @symptom.enterSymptomName('Add Symptom Name')

    @symptom.clickSaveButtonJump
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Symptom Diary Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickSymptom

    @myMedical.setStartDate('')
    @myMedical.setEndDate(todayMonthDayYear)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From Date field is required.')

    @myMedical.setStartDate(todayMonthDayYear)
    @myMedical.setEndDate('')
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('To Date field is required.')

    @myMedical.setStartDate(tomorrowMonthDayYear)
    @myMedical.setEndDate(tomorrowMonthDayYear)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("From Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTo Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

    @myMedical.setStartDate(todayMonthDayYear)
    @myMedical.setEndDate(yesterdayMonthDayYear)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From Date must occur before To Date.')

    @myMedical.setStartDate(invalidDateFormat)
    @myMedical.setEndDate(todayMonthDayYear)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From Date must be formatted MM/DD/YYYY.')

    @myMedical.setStartDate(todayMonthDayYear)
    @myMedical.setEndDate(invalidDateFormat)
    @myMedical.clickApplyButton
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('To Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Symptom Diary' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickSymptom
    expect(@symptom.getTextFromInput(:css, Symptom::FROM_DATE)).to eq(oneYearAgoMonthDayYear)
    expect(@symptom.getTextFromInput(:css, Symptom::TO_DATE)).to eq(todayMonthDayYear)
    @symptom.setFromDate(todayMonthDayYear)
    @symptom.setToDate(todayMonthDayYear)
    @symptom.clickApplyButton
    expect(@symptom.getTextFromInput(:css, Symptom::FROM_DATE)).to eq(todayMonthDayYear)
    expect(@symptom.getTextFromInput(:css, Symptom::TO_DATE)).to eq(todayMonthDayYear)
    @symptom.clickResetButton
    expect(@symptom.getTextFromInput(:css, Symptom::FROM_DATE)).to eq(oneYearAgoMonthDayYear)
    expect(@symptom.getTextFromInput(:css, Symptom::TO_DATE)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Medications and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickMedications
    @common.clickAddButton
    @medications.enterMedicationName('Tylenol')
    @medications.setSelectBoxFrequency('Once a Day')
    @medications.setStartDate(todayMonthDayYear)
    @medications.setEndDate(yesterdayMonthDayYear)
    @medications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Medication Started must occur before Medication Ended.')

    @medications.setStartDate(invalidDateFormat)
    @medications.setEndDate(todayMonthDayYear)
    @medications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Medication Started must be formatted MM/DD/YYYY.')

    @medications.setStartDate(todayMonthDayYear)
    @medications.setEndDate(invalidDateFormat)
    @medications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Medication Ended must be formatted MM/DD/YYYY.')

    @medications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Medications and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickMedications
    @common.clickAddButton
    @medications.enterMedicationName('Tylenol')
    @medications.setSelectBoxFrequency('Once a Day')
    @medications.setStartDate(todayMonthDayYear)
    @medications.setEndDate(todayMonthDayYear)
    @medications.clickSaveButtonJump
    clickReviewYourInfoSaveButton
    clickNthRow(1)

    expect(@medications.getTextFromInput(:css, Medications::START_DATE)).to eq(todayMonthDayYear)
    expect(@medications.getTextFromInput(:css, Medications::END_DATE)).to eq(todayMonthDayYear)

    @medications.setStartDate(todayMonthDayYear)
    @medications.setEndDate(tomorrowMonthDayYear)
    @medications.clickSaveButtonJump
    clickReviewYourInfoSaveButton
    clickNthRow(1)

    expect(@medications.getTextFromInput(:css, Medications::START_DATE)).to eq(todayMonthDayYear)
    expect(@medications.getTextFromInput(:css, Medications::END_DATE)).to eq(tomorrowMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Medications' do
##NO DATE FILTER ON THIS Medical/Medications
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Allergies and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickAllergies
    @common.clickAddButton
    @allergies.enterAllergy('Pollen')
    @allergies.clickSaveButton

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date first occurred field is required.')

    @allergies.enterDate(tomorrowMonthDayYear)
    @allergies.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date first occurred must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @allergies.enterDate(invalidDateFormat)
    @allergies.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date first occurred must be formatted MM/DD/YYYY.')

    @allergies.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Allergies and verify Calendar widget Positive Scenarios' do
     @main.clickNavMenu
     @navMenu.clickMyMedical
     @myMedical.clickAllergies
     @common.clickAddButton
     @allergies.enterAllergy('Pollen')
     @allergies.enterDate(todayMonthDayYear)
     @allergies.clickSaveButton
     clickReviewYourInfoSaveButton
     clickNthRow(1)

     expect(@allergies.getTextFromInput(:css, Allergies::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

     @allergies.enterDate(yesterdayMonthDayYear)
     @allergies.clickSaveButton
     clickReviewYourInfoSaveButton
     clickNthRow(1)

     expect(@allergies.getTextFromInput(:css, Allergies::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Allergies' do
##NO DATE FILTER ON THIS Medical/Allergies
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Diagnosis and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickAddDiagnosis
    @common.clickAddButton
    @diagnoses.enterDate(tomorrowMonthDayYear)
    @diagnoses.setDiagnosis('Cancer')
    @diagnoses.setCurrentChecked
    @diagnoses.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Onset must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @diagnoses.enterDate(invalidDateFormat)
    @diagnoses.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Onset must be formatted MM/DD/YYYY.')

    @diagnoses.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Diagnosis and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickAddDiagnosis
    @common.clickAddButton
    @diagnoses.enterDate(todayMonthDayYear)
    @diagnoses.setDiagnosis('Cancer')
    @diagnoses.setCurrentChecked
    @diagnoses.clickSaveButtonJump
    clickNthRow(1)

    expect(@diagnoses.getTextFromInput(:css, Diagnoses::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @diagnoses.enterDate(yesterdayMonthDayYear)
    @diagnoses.clickSaveButtonJump
    clickNthRow(1)

    expect(@diagnoses.getTextFromInput(:css, Diagnoses::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Diagnosis' do
##NO DATE FILTER My Medical/Diagnosis
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Surgeries and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickSurgeries
    @surgeries.clickAddEntryButton
    @surgeries.setNameOfSurgery('Biopsy')
    @surgeries.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Surgery/Procedure field is required.')

    @surgeries.enterDate(tomorrowMonthDayYear)
    @surgeries.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Surgery/Procedure must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @surgeries.enterDate(invalidDateFormat)
    @surgeries.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Surgery/Procedure must be formatted MM/DD/YYYY.')

    @surgeries.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Surgeries and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickSurgeries
    @surgeries.clickAddEntryButton
    @surgeries.setNameOfSurgery('Biopsy')
    @surgeries.setDateOfSurgeryProcedure(todayMonthDayYear)
    @surgeries.clickSaveButtonJump
    clickNthRow(1)

    expect(@surgeries.getTextFromInput(:css, Surgeries::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @surgeries.setDateOfSurgeryProcedure(yesterdayMonthDayYear)
    @surgeries.clickSaveButtonJump
    clickNthRow(1)

    expect(@surgeries.getTextFromInput(:css, Surgeries::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Allergies' do
##NO DATE FILTER ON THIS Medical/Surgeries
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Hospitalizations and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickHospitalizations
    @hospitalizations.clickAddEntryButton
    @hospitalizations.setEndDate(todayMonthDayYear)
    @hospitalizations.setFacilityHospital('Veteran Affairs Medical Center')
    @hospitalizations.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

    @hospitalizations.setStartDate(todayMonthDayYear)
    @hospitalizations.setEndDate('')
    @hospitalizations.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

    @hospitalizations.setStartDate(tomorrowMonthDayYear)
    @hospitalizations.setEndDate(tomorrowMonthDayYear)
    @hospitalizations.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

    @hospitalizations.setStartDate(todayMonthDayYear)
    @hospitalizations.setEndDate(yesterdayMonthDayYear)
    @hospitalizations.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

    @hospitalizations.setStartDate(invalidDateFormat)
    @hospitalizations.setEndDate(todayMonthDayYear)
    @hospitalizations.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

    @hospitalizations.setStartDate(todayMonthDayYear)
    @hospitalizations.setEndDate(invalidDateFormat)
    @hospitalizations.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')

    @hospitalizations.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/Hospitalizations and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickHospitalizations
    @hospitalizations.clickAddEntryButton
    @hospitalizations.setStartDate(todayMonthDayYear)
    @hospitalizations.setEndDate(todayMonthDayYear)
    @hospitalizations.setFacilityHospital('Veteran Affairs Medical Center')
    @hospitalizations.clickSaveButtonJump
    @hospitalizations.clickNthRow(1)

    expect(@hospitalizations.getTextFromInput(:css, Hospitalizations::START_DATE)).to eq(todayMonthDayYear)
    expect(@hospitalizations.getTextFromInput(:css, Hospitalizations::END_DATE)).to eq(todayMonthDayYear)

    @hospitalizations.setStartDate(yesterdayMonthDayYear)
    @hospitalizations.setEndDate(yesterdayMonthDayYear)
    @hospitalizations.clickSaveButtonJump
    @hospitalizations.clickNthRow(1)

    expect(@hospitalizations.getTextFromInput(:css, Hospitalizations::START_DATE)).to eq(yesterdayMonthDayYear)
    expect(@hospitalizations.getTextFromInput(:css, Hospitalizations::END_DATE)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/Hospitalizations' do
  @main.clickNavMenu
  @navMenu.clickMyMedical
  @myMedical.clickHospitalizations
  @myMedical.setStartDate(yesterdayMonthDayYear)
  @myMedical.setEndDate(yesterdayMonthDayYear)
  @myMedical.clickApplyButton
  @images_docs.clickNthRow(1)

  expect(@hospitalizations.getTextFromInput(:css, Hospitalizations::START_DATE)).to eq(yesterdayMonthDayYear)
  expect(@hospitalizations.getTextFromInput(:css, Hospitalizations::END_DATE)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/FamilyHistory and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickFamilyHistory
    @familyHistory.clickAddEntryButton
    @familyHistory.setFirstName('fname')
    @familyHistory.setLastName('lname')
    @familyHistory.setSelectBoxRelative('Mother')
    @familyHistory.setSelectBoxRelationshipType('Paternal')
    @familyHistory.setDOB(todayMonthDayYear)
    @familyHistory.setYear(invalidDateFormat)
    @familyHistory.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Year must be formatted YYYY.')

    @familyHistory.setDOB(invalidDateFormat)
    @familyHistory.setYear(todayYear)
    @familyHistory.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Birth must be formatted MM/DD/YYYY.')

    @familyHistory.setDOB(tomorrowMonthDayYear)
    @familyHistory.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Birth must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @familyHistory.clickCancelButtonJump
end


it 'JRNL 466 Calendar Widget - Add and Edit Entry to My Medical/FamilyHistory and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickMyMedical
    @myMedical.clickFamilyHistory
    @familyHistory.clickAddEntryButton
    @familyHistory.setFirstName('fname')
    @familyHistory.setLastName('lname')
    @familyHistory.setSelectBoxRelative('Mother')
    @familyHistory.setSelectBoxRelationshipType('Paternal')
    @familyHistory.setDOB(todayMonthDayYear)
    @familyHistory.setYear(todayYear)
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.clickAddDiagnosisButton
    @familyHistory.setNthStep(1,'Step 1')
    @familyHistory.setNthStepDate(0, todayYear)

    @familyHistory.setNthStep(2,'Step 2')
    @familyHistory.setNthStepDate(1, todayYear)

    @familyHistory.setNthStep(3,'Step 3')
    @familyHistory.setNthStepDate(2, todayYear)

    @familyHistory.setNthStep(4,'Step 4')
    @familyHistory.setNthStepDate(3, todayYear)

    @familyHistory.setNthStep(5,'Step 5')
    @familyHistory.setNthStepDate(4, todayYear)

    @familyHistory.setNthStep(6,'Step 6')
    @familyHistory.setNthStepDate(5, todayYear)

    @familyHistory.setNthStep(7,'Step 7')
    @familyHistory.setNthStepDate(6, todayYear)

    @familyHistory.setNthStep(8,'Step 8')
    @familyHistory.setNthStepDate(7, todayYear)

    @familyHistory.setNthStep(9,'Step 9')
    @familyHistory.setNthStepDate(8, todayYear)

    @familyHistory.setNthStep(10,'Step 10')
    @familyHistory.setNthStepDate(9, todayYear)


    @familyHistory.clickSaveButtonJump
    @familyHistory.clickNthRow(1)

    expect(@familyHistory.getTextFromInput(:css, FamilyHistory::DOB_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@familyHistory.getTextFromInput(:css, FamilyHistory::YEAR_TEXTFIELD)).to eq(todayYear)

    @familyHistory.setDOB(yesterdayMonthDayYear)
    @familyHistory.setYear(oneYearAgoYear)
    @familyHistory.clickSaveButtonJump
    @familyHistory.clickNthRow(1)

    expect(@familyHistory.getTextFromInput(:css, FamilyHistory::DOB_TEXTFIELD)).to eq(yesterdayMonthDayYear)
    expect(@familyHistory.getTextFromInput(:css, FamilyHistory::YEAR_TEXTFIELD)).to eq(oneYearAgoYear)
end

it 'JRNL 466 Calendar Widget - Filter Date My Medical/FamilyHistory' do
##NO DATE FILTER HERE
end

##################################### MY MEDICAL ENDS HERE ############################################################

#################################### Personal Trackers Start HERE ####################################################
it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/BloodPressureAndPulse and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickBloodPressureAndPulse
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickInAppCheckbox

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/BloodPressureAndPulse and verify Calendar widget Positive Scenarios' do
     @main.clickNavMenu
     @navMenu.clickPersonalTrackers
     @personalTrackers.clickBloodPressureAndPulse
     @personaltracker_notification.clickNotificationButton
     @notifications.clickOffRadioButton
     @notifications.clickOnRadioButton
     @notifications.setNotificationStartDate(todayMonthDayYear)
     @notifications.selectNotifyMe('Daily')
     @notifications.setNotificationTime('09:15 AM')
     @notifications.clickNotificationSaveButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/BloodPressureAndPulse and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickBloodPressureAndPulse
    @bloodPressureAndPulse.clickAddEntryButton
    @bloodPressureAndPulse.setSystolic('190')
    @bloodPressureAndPulse.setDiastolic('80')
    @bloodPressureAndPulse.setPulse('100')

    @bloodPressureAndPulse.enterDate('')
    @bloodPressureAndPulse.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @bloodPressureAndPulse.enterDate(invalidDateFormat)
    @bloodPressureAndPulse.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @bloodPressureAndPulse.enterDate(tomorrowMonthDayYear)
    @bloodPressureAndPulse.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @bloodPressureAndPulse.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/BloodPressureAndPulse and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickBloodPressureAndPulse
    @bloodPressureAndPulse.clickAddEntryButton
    @bloodPressureAndPulse.enterDate(todayMonthDayYear)
    @bloodPressureAndPulse.setSystolic('190')
    @bloodPressureAndPulse.setDiastolic('80')
    @bloodPressureAndPulse.setPulse('100')
    @bloodPressureAndPulse.clickSaveButtonBloodPressureAndPulse
    @bloodPressureAndPulse.clickNthRow(1)

    expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @bloodPressureAndPulse.enterDate(yesterdayMonthDayYear)
    @bloodPressureAndPulse.clickSaveButtonBloodPressureAndPulse
    @bloodPressureAndPulse.clickNthRow(1)

    expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/BloodPressureAndPulse Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickBloodPressureAndPulse

  @bloodPressureAndPulse.setStartDate('')
  @bloodPressureAndPulse.setEndDate(todayMonthDayYear)
  @bloodPressureAndPulse.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @bloodPressureAndPulse.setStartDate(todayMonthDayYear)
  @bloodPressureAndPulse.setEndDate('')
  @bloodPressureAndPulse.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @bloodPressureAndPulse.setStartDate(tomorrowMonthDayYear)
  @bloodPressureAndPulse.setEndDate(tomorrowMonthDayYear)
  @bloodPressureAndPulse.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @bloodPressureAndPulse.setStartDate(todayMonthDayYear)
  @bloodPressureAndPulse.setEndDate(yesterdayMonthDayYear)
  @bloodPressureAndPulse.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @bloodPressureAndPulse.setStartDate(invalidDateFormat)
  @bloodPressureAndPulse.setEndDate(todayMonthDayYear)
  @bloodPressureAndPulse.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @bloodPressureAndPulse.setStartDate(todayMonthDayYear)
  @bloodPressureAndPulse.setEndDate(invalidDateFormat)
  @bloodPressureAndPulse.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/BloodPressureAndPulse' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickBloodPressureAndPulse
  @bloodPressureAndPulse.setStartDate(yesterdayMonthDayYear)
  @bloodPressureAndPulse.setEndDate(yesterdayMonthDayYear)
  @bloodPressureAndPulse.clickApplyButton
  @bloodPressureAndPulse.clickNthRow(1)

  expect(@bloodPressureAndPulse.getTextFromInput(:css, BloodPressureAndPulse::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/CholesterolLipid and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickCholesterolLipid
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickInAppCheckbox

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/CholesterolLipid and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickCholesterolLipid
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification save button is disabled
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/CholesterolLipid and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickCholesterolLipid
    @personalTrackers.clickAddEntryButton
    @cholesterolLipid.setTotalSerumCholesterol('100')

    @cholesterolLipid.enterDate('')
    @cholesterolLipid.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @cholesterolLipid.enterDate(invalidDateFormat)
    @cholesterolLipid.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @cholesterolLipid.enterDate(tomorrowMonthDayYear)
    @cholesterolLipid.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @cholesterolLipid.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/CholesterolLipid and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickCholesterolLipid
    @personalTrackers.clickAddEntryButton
    @cholesterolLipid.enterDate(todayMonthDayYear)
    @cholesterolLipid.setTotalSerumCholesterol('100')
    @cholesterolLipid.clickSaveButtonJump
    @cholesterolLipid.clickNthRow(1)

    expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @cholesterolLipid.enterDate(yesterdayMonthDayYear)
    @cholesterolLipid.clickSaveButtonJump
    @cholesterolLipid.clickNthRow(1)

    expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/CholesterolLipid Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickCholesterolLipid

  @cholesterolLipid.setStartDate('')
  @cholesterolLipid.setEndDate(todayMonthDayYear)
  @cholesterolLipid.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @cholesterolLipid.setStartDate(todayMonthDayYear)
  @cholesterolLipid.setEndDate('')
  @cholesterolLipid.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @cholesterolLipid.setStartDate(tomorrowMonthDayYear)
  @cholesterolLipid.setEndDate(tomorrowMonthDayYear)
  @cholesterolLipid.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @cholesterolLipid.setStartDate(todayMonthDayYear)
  @cholesterolLipid.setEndDate(yesterdayMonthDayYear)
  @cholesterolLipid.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @cholesterolLipid.setStartDate(invalidDateFormat)
  @cholesterolLipid.setEndDate(todayMonthDayYear)
  @cholesterolLipid.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @cholesterolLipid.setStartDate(todayMonthDayYear)
  @cholesterolLipid.setEndDate(invalidDateFormat)
  @cholesterolLipid.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/CholesterolLipid' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickCholesterolLipid
  @cholesterolLipid.setStartDate(yesterdayMonthDayYear)
  @cholesterolLipid.setEndDate(yesterdayMonthDayYear)
  @cholesterolLipid.clickApplyButton
  @cholesterolLipid.clickNthRow(1)

  expect(@cholesterolLipid.getTextFromInput(:css, CholesterolLipid::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/DailyEvents and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDailyEvents
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickInAppCheckbox

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/DailyEvents and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDailyEvents
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/DailyEvents and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDailyEvents
    @personalTrackers.clickAddEntryButton
    @dailyEvents.setEventText('Daily Events')

    @dailyEvents.enterDate('')
    @dailyEvents.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @dailyEvents.enterDate(invalidDateFormat)
    @dailyEvents.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @dailyEvents.enterDate(tomorrowMonthDayYear)
    @dailyEvents.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @dailyEvents.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/DailyEvents and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDailyEvents
    @personalTrackers.clickAddEntryButton
    @dailyEvents.enterDate(todayMonthDayYear)
    @dailyEvents.setEventText('Daily Events')
    @dailyEvents.clickSaveButtonJump
    @dailyEvents.clickNthRow(1)

    expect(@dailyEvents.getTextFromInput(:css, Daily_events::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @dailyEvents.enterDate(yesterdayMonthDayYear)
    @dailyEvents.clickSaveButtonJump
    @dailyEvents.clickNthRow(1)

    expect(@dailyEvents.getTextFromInput(:css, Daily_events::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/DailyEvents Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickDailyEvents

  @dailyEvents.setStartDate('')
  @dailyEvents.setEndDate(todayMonthDayYear)
  @dailyEvents.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @dailyEvents.setStartDate(todayMonthDayYear)
  @dailyEvents.setEndDate('')
  @dailyEvents.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @dailyEvents.setStartDate(tomorrowMonthDayYear)
  @dailyEvents.setEndDate(tomorrowMonthDayYear)
  @dailyEvents.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @dailyEvents.setStartDate(todayMonthDayYear)
  @dailyEvents.setEndDate(yesterdayMonthDayYear)
  @dailyEvents.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @dailyEvents.setStartDate(invalidDateFormat)
  @dailyEvents.setEndDate(todayMonthDayYear)
  @dailyEvents.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @dailyEvents.setStartDate(todayMonthDayYear)
  @dailyEvents.setEndDate(invalidDateFormat)
  @dailyEvents.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/DailyEvents' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickDailyEvents
  @dailyEvents.setStartDate(yesterdayMonthDayYear)
  @dailyEvents.setEndDate(yesterdayMonthDayYear)
  @dailyEvents.clickApplyButton
  @dailyEvents.clickNthRow(1)

  expect(@dailyEvents.getTextFromInput(:css, Daily_events::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Diet and verify Calendar widget Positive Scenarios' do
    #Should there be a notification button for diet?
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Diet and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDiet
    @personalTrackers.clickAddEntryButton
    @diet.selectBoxMeallType('Lunch')
    @diet.setCalories(100)

    @diet.enterDate('')
    @diet.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @diet.enterDate(invalidDateFormat)
    @diet.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @diet.enterDate(tomorrowMonthDayYear)
    @diet.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @diet.clickCancelButtonJump
    #THERE IS A BUG SECTION TITLE SHOWS IN THE HEADER AND NO DATA SHOWS UP
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Diet and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDiet
    @personalTrackers.clickAddEntryButton
    @diet.enterDate(todayMonthDayYear)
    @diet.selectBoxMeallType('Lunch')
    @diet.setCalories(100)
    @diet.clickSaveButtonJump
    @diet.clickNthRow(1)

    expect(@diet.getTextFromInput(:css, Diet::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @diet.enterDate(yesterdayMonthDayYear)
    @diet.clickSaveButtonJump
    @diet.clickNthRow(1)

    expect(@diet.getTextFromInput(:css, Diet::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
    #THERE IS A BUG SECTION TITLE SHOWS IN THE HEADER AND NO DATA SHOWS UP
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Diet Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickDiet

  @diet.setStartDate('')
  @diet.setEndDate(todayMonthDayYear)
  @diet.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @diet.setStartDate(todayMonthDayYear)
  @diet.setEndDate('')
  @diet.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @diet.setStartDate(tomorrowMonthDayYear)
  @diet.setEndDate(tomorrowMonthDayYear)
  @diet.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @diet.setStartDate(todayMonthDayYear)
  @diet.setEndDate(yesterdayMonthDayYear)
  @diet.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @diet.setStartDate(invalidDateFormat)
  @diet.setEndDate(todayMonthDayYear)
  @diet.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @diet.setStartDate(todayMonthDayYear)
  @diet.setEndDate(invalidDateFormat)
  @diet.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Diet' do
  #THERE IS A BUG SECTION TITLE SHOWS IN THE HEADER AND NO DATA SHOWS UP
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickDiet
  @diet.setStartDate(yesterdayMonthDayYear)
  @diet.setEndDate(yesterdayMonthDayYear)
  @diet.clickApplyButton
  @diet.clickNthRow(1)

  expect(@diet.getTextFromInput(:css, Diet::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Exercise and verify Calendar widget Positive Scenarios' do
    #Should there be a notification button for exercise?
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Exercise and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickExercise
    @personalTrackers.clickAddEntryButton
    @exercise.selectActivity('Cycling')
    @exercise.setDuration("5 days")

    @exercise.enterDate('')
    @exercise.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @exercise.enterDate(invalidDateFormat)
    @exercise.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @exercise.enterDate(tomorrowMonthDayYear)
    @exercise.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @exercise.clickCancelButtonJump
    #THERE IS A BUG SECTION TITLE SHOWS IN THE HEADER AND NO DATA SHOWS UP
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Exercise and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickExercise
    @personalTrackers.clickAddEntryButton
    @exercise.enterDate(todayMonthDayYear)
    @exercise.selectActivity('Cycling')
    @exercise.setDuration("5 days")
    @exercise.clickSaveButtonJump
    @exercise.clickNthRow(1)

    expect(@exercise.getTextFromInput(:css, Exercise::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @exercise.enterDate(yesterdayMonthDayYear)
    @exercise.clickSaveButtonJump
    @exercise.clickNthRow(1)

    expect(@exercise.getTextFromInput(:css, Exercise::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
    #THERE IS A BUG SECTION TITLE SHOWS IN THE HEADER AND NO DATA SHOWS UP
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Exercise Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickExercise

  @exercise.setStartDate('')
  @exercise.setEndDate(todayMonthDayYear)
  @exercise.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @exercise.setStartDate(todayMonthDayYear)
  @exercise.setEndDate('')
  @exercise.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @exercise.setStartDate(tomorrowMonthDayYear)
  @exercise.setEndDate(tomorrowMonthDayYear)
  @exercise.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @exercise.setStartDate(todayMonthDayYear)
  @exercise.setEndDate(yesterdayMonthDayYear)
  @exercise.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @exercise.setStartDate(invalidDateFormat)
  @exercise.setEndDate(todayMonthDayYear)
  @exercise.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @exercise.setStartDate(todayMonthDayYear)
  @exercise.setEndDate(invalidDateFormat)
  @exercise.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Exercise' do
  #THERE IS A BUG SECTION TITLE SHOWS IN THE HEADER AND NO DATA SHOWS UP
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickExercise
    @exercise.setStartDate(yesterdayMonthDayYear)
    @exercise.setEndDate(yesterdayMonthDayYear)
    @exercise.clickApplyButton
    @exercise.clickNthRow(1)

    expect(@exercise.getTextFromInput(:css, Exercise::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Glucose and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickGlucose
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickInAppCheckbox

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Glucose and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickGlucose
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Glucose and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickGlucose
    @personalTrackers.clickAddEntryButton
    @glucose.setGlucoseLevel('400')
    @glucose.setSelectBoxTested('Fasting (8 hours)')

    @glucose.enterDate('')
    @glucose.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @glucose.enterDate(invalidDateFormat)
    @glucose.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @glucose.enterDate(tomorrowMonthDayYear)
    @glucose.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @glucose.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Glucose and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickGlucose
    @personalTrackers.clickAddEntryButton
    @glucose.enterDate(todayMonthDayYear)
    @glucose.setGlucoseLevel('400')
    @glucose.setSelectBoxTested('Fasting (8 hours)')
    @glucose.clickSaveButtonJump
    @glucose.clickNthRow(1)

    expect(@glucose.getTextFromInput(:css, Glucose::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @glucose.enterDate(yesterdayMonthDayYear)
    @glucose.clickSaveButtonJump
    @glucose.clickNthRow(1)

    expect(@glucose.getTextFromInput(:css, Glucose::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Glucose Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickGlucose

  @glucose.setStartDate('')
  @glucose.setEndDate(todayMonthDayYear)
  @glucose.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @glucose.setStartDate(todayMonthDayYear)
  @glucose.setEndDate('')
  @glucose.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @glucose.setStartDate(tomorrowMonthDayYear)
  @glucose.setEndDate(tomorrowMonthDayYear)
  @glucose.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @glucose.setStartDate(todayMonthDayYear)
  @glucose.setEndDate(yesterdayMonthDayYear)
  @glucose.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @glucose.setStartDate(invalidDateFormat)
  @glucose.setEndDate(todayMonthDayYear)
  @glucose.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @glucose.setStartDate(todayMonthDayYear)
  @glucose.setEndDate(invalidDateFormat)
  @glucose.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Glucose' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickGlucose
    @glucose.setStartDate(yesterdayMonthDayYear)
    @glucose.setEndDate(yesterdayMonthDayYear)
    @glucose.clickApplyButton
    @glucose.clickNthRow(1)

    expect(@glucose.getTextFromInput(:css, Glucose::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Height and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickHeight
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickInAppCheckbox

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Height and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickHeight
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Height and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickHeight
    @personalTrackers.clickAddEntryButton
    @height.setHeight('6')

    @height.enterDate('')
    @height.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @height.enterDate(invalidDateFormat)
    @height.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @height.enterDate(tomorrowMonthDayYear)
    @height.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @height.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Height and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickHeight
    @personalTrackers.clickAddEntryButton
    @height.enterDate(todayMonthDayYear)
    @height.setHeight('6')
    @height.clickSaveButton
    @height.clickNthRow(1)

    expect(@height.getTextFromInput(:css, Height::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @height.enterDate(yesterdayMonthDayYear)
    @height.clickSaveButton
    @height.clickNthRow(1)

    expect(@height.getTextFromInput(:css, Height::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Height Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickHeight

  @height.setStartDate('')
  @height.setEndDate(todayMonthDayYear)
  @height.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @height.setStartDate(todayMonthDayYear)
  @height.setEndDate('')
  @height.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @height.setStartDate(tomorrowMonthDayYear)
  @height.setEndDate(tomorrowMonthDayYear)
  @height.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @height.setStartDate(todayMonthDayYear)
  @height.setEndDate(yesterdayMonthDayYear)
  @height.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @height.setStartDate(invalidDateFormat)
  @height.setEndDate(todayMonthDayYear)
  @height.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @height.setStartDate(todayMonthDayYear)
  @height.setEndDate(invalidDateFormat)
  @height.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Height' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickHeight
    @height.setStartDate(yesterdayMonthDayYear)
    @height.setEndDate(yesterdayMonthDayYear)
    @height.clickApplyButton
    @height.clickNthRow(1)
    expect(@height.getTextFromInput(:css, Height::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Mood and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickMood
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Mood and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickMood
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Mood and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickMood
    @personalTrackers.clickAddEntryButton

    @mood.enterDate('')
    @mood.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @mood.enterDate(invalidDateFormat)
    @mood.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @mood.enterDate(tomorrowMonthDayYear)
    @mood.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @mood.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Mood and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickMood
    @personalTrackers.clickAddEntryButton
    @mood.enterDate(todayMonthDayYear)
    @mood.clickSaveButtonJump
    @mood.clickNthRow(1)

    expect(@mood.getTextFromInput(:css, Mood::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @mood.enterDate(yesterdayMonthDayYear)
    @mood.clickSaveButtonJump
    @mood.clickNthRow(1)

    expect(@mood.getTextFromInput(:css, Mood::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Mood Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickMood

  @mood.setStartDate('')
  @mood.setEndDate(todayMonthDayYear)
  @mood.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @mood.setStartDate(todayMonthDayYear)
  @mood.setEndDate('')
  @mood.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @mood.setStartDate(tomorrowMonthDayYear)
  @mood.setEndDate(tomorrowMonthDayYear)
  @mood.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @mood.setStartDate(todayMonthDayYear)
  @mood.setEndDate(yesterdayMonthDayYear)
  @mood.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @mood.setStartDate(invalidDateFormat)
  @mood.setEndDate(todayMonthDayYear)
  @mood.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @mood.setStartDate(todayMonthDayYear)
  @mood.setEndDate(invalidDateFormat)
  @mood.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Mood' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickMood
    @mood.setStartDate(yesterdayMonthDayYear)
    @mood.setEndDate(yesterdayMonthDayYear)
    @mood.clickApplyButton
    @mood.clickNthRow(1)

    expect(@mood.getTextFromInput(:css, Mood::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Pain and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickPain
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Pain and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickPain
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Pain and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickPain
    @personalTrackers.clickAddEntryButton

    @pain.enterDate('')
    @pain.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @pain.enterDate(invalidDateFormat)
    @pain.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @pain.enterDate(tomorrowMonthDayYear)
    @pain.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @pain.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Pain and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickPain
    @personalTrackers.clickAddEntryButton
    @pain.enterDate(todayMonthDayYear)
    @pain.clickSaveButtonJump
    @pain.clickNthRow(1)

    expect(@pain.getTextFromInput(:css, Pain::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @pain.enterDate(yesterdayMonthDayYear)
    @pain.clickSaveButtonJump
    @pain.clickNthRow(1)

    expect(@pain.getTextFromInput(:css, Pain::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Pain Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickPain

  @pain.setStartDate('')
  @pain.setEndDate(todayMonthDayYear)
  @pain.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @pain.setStartDate(todayMonthDayYear)
  @pain.setEndDate('')
  @pain.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @pain.setStartDate(tomorrowMonthDayYear)
  @pain.setEndDate(tomorrowMonthDayYear)
  @pain.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @pain.setStartDate(todayMonthDayYear)
  @pain.setEndDate(yesterdayMonthDayYear)
  @pain.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @pain.setStartDate(invalidDateFormat)
  @pain.setEndDate(todayMonthDayYear)
  @pain.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @pain.setStartDate(todayMonthDayYear)
  @pain.setEndDate(invalidDateFormat)
  @pain.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Pain' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickPain
    @pain.setStartDate(yesterdayMonthDayYear)
    @pain.setEndDate(yesterdayMonthDayYear)
    @pain.clickApplyButton
    @pain.clickNthRow(1)

#     expect(@pain.getTextFromInput(:css, Pain::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Respiration and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickRespiration
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Respiration and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickRespiration
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Respiration and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickRespiration
    @personalTrackers.clickAddEntryButton
    @respiration.setRespiration('50')

    @respiration.enterDate('')
    @respiration.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @respiration.enterDate(invalidDateFormat)
    @respiration.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @respiration.enterDate(tomorrowMonthDayYear)
    @respiration.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @respiration.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Respiration and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickRespiration
    @personalTrackers.clickAddEntryButton
    @respiration.enterDate(todayMonthDayYear)
    @respiration.setRespiration('50')
    @respiration.clickSaveButtonJump
    @respiration.clickNthRow(1)

    expect(@respiration.getTextFromInput(:css, Respiration::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @respiration.enterDate(yesterdayMonthDayYear)
    @respiration.setRespiration('50')
    @respiration.clickSaveButtonJump
    @respiration.clickNthRow(1)

    expect(@respiration.getTextFromInput(:css, Respiration::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Respiration Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickRespiration

  @respiration.setStartDate('')
  @respiration.setEndDate(todayMonthDayYear)
  @respiration.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @respiration.setStartDate(todayMonthDayYear)
  @respiration.setEndDate('')
  @respiration.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @respiration.setStartDate(tomorrowMonthDayYear)
  @respiration.setEndDate(tomorrowMonthDayYear)
  @respiration.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @respiration.setStartDate(todayMonthDayYear)
  @respiration.setEndDate(yesterdayMonthDayYear)
  @respiration.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @respiration.setStartDate(invalidDateFormat)
  @respiration.setEndDate(todayMonthDayYear)
  @respiration.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @respiration.setStartDate(todayMonthDayYear)
  @respiration.setEndDate(invalidDateFormat)
  @respiration.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Respiration' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickRespiration
    @respiration.setStartDate(yesterdayMonthDayYear)
    @respiration.setEndDate(yesterdayMonthDayYear)
    @respiration.clickApplyButton
    @respiration.clickNthRow(1)

    expect(@respiration.getTextFromInput(:css, Respiration::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Sleep and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickSleep
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Sleep and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickSleep
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Sleep and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickSleep
    @personalTrackers.clickAddEntryButton
    @sleep.setStartTime(currentTimeHourMinuteMeridian)
    @sleep.setEndTime(currentTimeHourMinuteMeridian)

    @sleep.setStartDate('')
    @sleep.setEndDate(todayMonthDayYear)
    @sleep.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @sleep.setStartDate(todayMonthDayYear)
    @sleep.setEndDate('')
    @sleep.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("End Date field is required.")

    @sleep.setStartDate(tomorrowMonthDayYear)
    @sleep.setEndDate(tomorrowMonthDayYear)
    @sleep.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Time cannot be a future time.")

    @sleep.setStartDate(todayMonthDayYear)
    @sleep.setEndDate(yesterdayMonthDayYear)
    @sleep.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date/Time must occur before End Date/Time.")

    @sleep.setStartDate(invalidDateFormat)
    @sleep.setEndDate(todayMonthDayYear)
    @sleep.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @sleep.setStartDate(todayMonthDayYear)
    @sleep.setEndDate(invalidDateFormat)
    @sleep.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("End Date must be formatted MM/DD/YYYY.")

    @sleep.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Sleep and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickSleep
    @personalTrackers.clickAddEntryButton
    @sleep.setStartDate(todayMonthDayYear)
    @sleep.setEndDate(todayMonthDayYear)
    @sleep.setStartTime(currentTimeHourMinuteMeridian)
    @sleep.setEndTime(currentTimeHourMinuteMeridian)
    @sleep.clickSaveButtonJump
    @sleep.clickNthRow(1)

    expect(@sleep.getTextFromInput(:css, Sleep::START_DATE)).to eq(todayMonthDayYear)
    expect(@sleep.getTextFromInput(:css, Sleep::END_DATE)).to eq(todayMonthDayYear)

    @sleep.setStartDate(yesterdayMonthDayYear)
    @sleep.setEndDate(yesterdayMonthDayYear)
    @sleep.clickSaveButtonJump
    @sleep.clickNthRow(1)

    expect(@sleep.getTextFromInput(:css, Sleep::START_DATE)).to eq(yesterdayMonthDayYear)
    expect(@sleep.getTextFromInput(:css, Sleep::END_DATE)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Sleep Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickSleep

  @sleep.setStartDate('')
  @sleep.setEndDate(todayMonthDayYear)
  @sleep.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From field is required.')

  @sleep.setStartDate(todayMonthDayYear)
  @sleep.setEndDate('')
  @sleep.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('To field is required.')

  @sleep.setStartDate(tomorrowMonthDayYear)
  @sleep.setEndDate(tomorrowMonthDayYear)
  @sleep.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("From must be between 01/01/1900 and " + todayMonthDayYear + ".\nTo must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @sleep.setStartDate(todayMonthDayYear)
  @sleep.setEndDate(yesterdayMonthDayYear)
  @sleep.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From must occur before To.')

  @sleep.setStartDate(invalidDateFormat)
  @sleep.setEndDate(todayMonthDayYear)
  @sleep.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('From must be formatted MM/DD/YYYY.')

  @sleep.setStartDate(todayMonthDayYear)
  @sleep.setEndDate(invalidDateFormat)
  @sleep.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('To must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Sleep' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickSleep
    @sleep.setStartDate(yesterdayMonthDayYear)
    @sleep.setEndDate(yesterdayMonthDayYear)
    @sleep.clickApplyButton
    @sleep.clickNthRow(1)

    expect(@sleep.getTextFromInput(:css, Sleep::START_DATE)).to eq(yesterdayMonthDayYear)
    expect(@sleep.getTextFromInput(:css, Sleep::END_DATE)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Stress and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickStress
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Stress and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickStress
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Stress and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickStress
    @personalTrackers.clickAddEntryButton

    @stress.enterDate('')
    @stress.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @stress.enterDate(invalidDateFormat)
    @stress.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @stress.enterDate(tomorrowMonthDayYear)
    @stress.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @stress.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Stress and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickStress
    @personalTrackers.clickAddEntryButton
    @stress.enterDate(todayMonthDayYear)
    @stress.clickSaveButtonJump
    @stress.clickNthRow(1)

    expect(@stress.getTextFromInput(:css, Stress::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @stress.enterDate(yesterdayMonthDayYear)
    @stress.clickSaveButtonJump
    @stress.clickNthRow(1)

    expect(@stress.getTextFromInput(:css, Stress::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Stress Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickStress

  @stress.setStartDate('')
  @stress.setEndDate(todayMonthDayYear)
  @stress.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @stress.setStartDate(todayMonthDayYear)
  @stress.setEndDate('')
  @stress.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @stress.setStartDate(tomorrowMonthDayYear)
  @stress.setEndDate(tomorrowMonthDayYear)
  @stress.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @stress.setStartDate(todayMonthDayYear)
  @stress.setEndDate(yesterdayMonthDayYear)
  @stress.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @stress.setStartDate(invalidDateFormat)
  @stress.setEndDate(todayMonthDayYear)
  @stress.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @stress.setStartDate(todayMonthDayYear)
  @stress.setEndDate(invalidDateFormat)
  @stress.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Stress' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickStress
    @stress.setStartDate(yesterdayMonthDayYear)
    @stress.setEndDate(yesterdayMonthDayYear)
    @stress.clickApplyButton
    @stress.clickNthRow(1)

    expect(@stress.getTextFromInput(:css, Stress::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Temperature and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickTemperature
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Temperature and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickTemperature
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Temperature and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickTemperature
    @personalTrackers.clickAddEntryButton
    @temperature.setTemperature('100.0')

    @temperature.enterDate('')
    @temperature.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @temperature.enterDate(invalidDateFormat)
    @temperature.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @temperature.enterDate(tomorrowMonthDayYear)
    @temperature.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @temperature.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Temperature and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickTemperature
    @personalTrackers.clickAddEntryButton
    @temperature.enterDate(todayMonthDayYear)
    @temperature.setTemperature('100.0')
    @temperature.clickSaveButtonJump
    @temperature.clickNthRow(1)

    expect(@temperature.getTextFromInput(:css, Temperature::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @temperature.enterDate(yesterdayMonthDayYear)
    @temperature.clickSaveButtonJump
    @temperature.clickNthRow(1)

    expect(@temperature.getTextFromInput(:css, Temperature::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Temperature Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickTemperature

  @temperature.setStartDate('')
  @temperature.setEndDate(todayMonthDayYear)
  @temperature.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @temperature.setStartDate(todayMonthDayYear)
  @temperature.setEndDate('')
  @temperature.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @temperature.setStartDate(tomorrowMonthDayYear)
  @temperature.setEndDate(tomorrowMonthDayYear)
  @temperature.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @temperature.setStartDate(todayMonthDayYear)
  @temperature.setEndDate(yesterdayMonthDayYear)
  @temperature.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @temperature.setStartDate(invalidDateFormat)
  @temperature.setEndDate(todayMonthDayYear)
  @temperature.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @temperature.setStartDate(todayMonthDayYear)
  @temperature.setEndDate(invalidDateFormat)
  @temperature.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Temperature' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickTemperature
    @temperature.setStartDate(yesterdayMonthDayYear)
    @temperature.setEndDate(yesterdayMonthDayYear)
    @temperature.clickApplyButton
    @temperature.clickNthRow(1)

    expect(@temperature.getTextFromInput(:css, Temperature::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Weight and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickWeight
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')

    @notifications.setNotificationStartDate('')
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date field is required.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.")

    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.clickNotificationSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.")

    @notifications.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add Notification to Personal Trackers/Weight and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickWeight
    @personaltracker_notification.clickNotificationButton
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickNotificationSaveButton
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Weight and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickWeight
    @personalTrackers.clickAddEntryButton
    @weight.setWeight('999')

    @weight.enterDate('')
    @weight.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date field is required.')

    @weight.enterDate(invalidDateFormat)
    @weight.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @weight.enterDate(tomorrowMonthDayYear)
    @weight.clickSaveButtonJump
    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nTime cannot be a future time.")

    @weight.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Personal Trackers/Weight and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickWeight
    @personalTrackers.clickAddEntryButton
    @weight.enterDate(todayMonthDayYear)
    @weight.setWeight('999')
    @weight.clickSaveButtonJump
    @weight.clickNthRow(1)

    expect(@weight.getTextFromInput(:css, Weight::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @weight.enterDate(yesterdayMonthDayYear)
    @weight.clickSaveButtonJump
    @weight.clickNthRow(1)

    expect(@weight.getTextFromInput(:css, Weight::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Weight Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickPersonalTrackers
  @personalTrackers.clickWeight

  @weight.setStartDate('')
  @weight.setEndDate(todayMonthDayYear)
  @weight.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date field is required.')

  @weight.setStartDate(todayMonthDayYear)
  @weight.setEndDate('')
  @weight.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date field is required.')

  @weight.setStartDate(tomorrowMonthDayYear)
  @weight.setEndDate(tomorrowMonthDayYear)
  @weight.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between 01/01/1900 and " + todayMonthDayYear + ".\nEnd Date must be between 01/01/1900 and " + todayMonthDayYear + ".")

  @weight.setStartDate(todayMonthDayYear)
  @weight.setEndDate(yesterdayMonthDayYear)
  @weight.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must occur before End Date.')

  @weight.setStartDate(invalidDateFormat)
  @weight.setEndDate(todayMonthDayYear)
  @weight.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

  @weight.setStartDate(todayMonthDayYear)
  @weight.setEndDate(invalidDateFormat)
  @weight.clickApplyButton
  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Filter Date Personal Trackers/Weight' do
    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickWeight
    @weight.setStartDate(yesterdayMonthDayYear)
    @weight.setEndDate(yesterdayMonthDayYear)
    @weight.clickApplyButton
    @weight.clickNthRow(1)

    expect(@weight.getTextFromInput(:css, Weight::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

################################### Personal Trackers Ends HERE ######################################################

################################### My Reminders Starts HERE #########################################################

xit 'JRNL 466 Calendar Widget - Add Entry to My Reminders/Appointments  Calendar widget Negative Scenarios', :broken => true do
    #BUG 'APPOINTMENT ACCEPTS DATES IN THE PAST'
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickAppointments
    @appointments.clickAddEntryButton
    @appointments.setAppointmentDate(yesterdayMonthDayYear)
    @appointments.setAppointmentTime('09:15 AM')
    @appointments.setClinicOrOrganizationName('VAMC')
    @appointments.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @appointments.setAppointmentDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit My Reminders/Appointments and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickAppointments
    @appointments.clickAddEntryButton
    @appointments.setAppointmentDate(todayMonthDayYear)
    @appointments.setAppointmentTime('09:15 AM')
    @appointments.setClinicOrOrganizationName('VAMC')
    @appointments.clickSaveButtonJump
    @appointments.clickNthRow(1)

    expect(@appointments.getTextFromInput(:css, Appointments::APPOINTMENT_DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @appointments.setAppointmentDate(yesterdayMonthDayYear)
    @appointments.clickSaveButtonJump
    @appointments.clickNthRow(1)
    expect(@appointments.getTextFromInput(:css, Appointments::APPOINTMENT_DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

   it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/Medications  Calendar widget Negative Scenarios' do

    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickMedications
    @medications.clickAddEntryButton
    @medications.enterMedicationName('Dalodid')
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be between ' + todayMonthDayYear + ' and 12/31/2099.')

    @notifications.setNotificationStartDate(invalidDateFormat)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit My Reminders/Medications and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickMedications
    @medications.clickAddEntryButton
    @medications.enterMedicationName('Dalodid')
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickSaveButtonJump
    ###Notification does not save
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices Calendar widget Negative Scenarios' do
  @main.clickNavMenu
  @navMenu.clickReminders
  @screening.clickPreventiveServices
  @preventative_services.clickAddEntryButton
  @screening.setServiceName('Custom Created Service')
  @preventative_services.setLastCompletedDate(tomorrowMonthDayYear)
  @preventative_services.setNextDueDate(tomorrowMonthDayYear)
  @screening.clickNotifyMeAboutThisDueDateCheckbox('On the date')
  @preventative_services.clickSaveButtonJump

  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Completed must be between 01/01/1900 and ' + todayMonthDayYear + '.')

  @preventative_services.setLastCompletedDate(invalidDateFormat)
  @preventative_services.setNextDueDate(yesterdayMonthDayYear)
  @preventative_services.clickSaveButtonJump

  expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Completed must be formatted MM/DD/YYYY.')

  @notifications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit My Reminders/PreventiveServices and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickAddEntryButton
    @screening.setServiceName('Custom Created Service')
    @preventative_services.setLastCompletedDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump
    @preventative_services.clickCustomCreatedService

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_COMPLETED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @preventative_services.setLastCompletedDate(yesterdayMonthDayYear)
    @preventative_services.setNextDueDate(tomorrowMonthDayYear)
    @screening.clickNotifyMeAboutThisDueDateCheckbox('On the date')

    @preventative_services.clickSaveButtonJump
    @preventative_services.clickCustomCreatedService
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/TetanusVaccination  Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickTetanusVaccination
    @preventative_services.setLastAdministeredDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(tomorrowMonthDayYear)
    @screening.clickNotifyMeAboutThisDueDateCheckbox('On the date')
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @preventative_services.setLastAdministeredDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/TetanusVaccination and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickTetanusVaccination
    @preventative_services.setLastAdministeredDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump
    @preventative_services.clickTetanusVaccination

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_ADMINISTERED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

  it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/BloodPressureScreening  Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickBloodPressureScreening
    @preventative_services.setLastTakenDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(tomorrowMonthDayYear)
    @bloodPressureAndPulse.setSystolic('90')
    @bloodPressureAndPulse.setDiastolic('60')
    @notifications.clickOneDayBeforeCheckbox
    @notifications.clickInAppCheckbox
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Last Taken must be between 01/01/1900 and " + todayMonthDayYear + ".\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @preventative_services.setLastTakenDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @bloodPressureAndPulse.setSystolic('90')
    @bloodPressureAndPulse.setDiastolic('60')
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Last Taken must be formatted MM/DD/YYYY.")

    @notifications.clickCancelButton
end

xit 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/BloodPressureScreening and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickBloodPressureScreening
    @preventative_services.setLastTakenDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @bloodPressureAndPulse.setSystolic('90')
    @bloodPressureAndPulse.setDiastolic('60')
    @notifications.clickOneDayBeforeCheckbox

    @preventative_services.clickSaveButtonJump
    @preventative_services.clickBloodPressureScreening

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_TAKEN_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    ###BUG Below date field defaults to today/month/day/adds 2 years from today in the year field
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/CholesterolScreening  Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickCholesterolScreening
    @preventative_services.setLastTestedDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.selectResults('Normal')
    @notifications.clickOneDayBeforeCheckbox
    @notifications.clickInAppCheckbox
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Last Tested must be between 01/01/1900 and " + todayMonthDayYear + ".\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @preventative_services.setLastTestedDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.selectResults('Normal')
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Tested must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

xit 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/CholesterolScreening and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickCholesterolScreening
    @preventative_services.setLastTestedDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.selectResults('Normal')
    @notifications.clickOneDayBeforeCheckbox

    @preventative_services.clickSaveButtonJump
    @preventative_services.clickCholesterolScreening

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_TESTED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    ###BUG Below date field defaults to today/month/day/adds 5 years from today in the year field
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

xit 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/ShinglesVaccination Calendar widget Negative Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickShinglesVaccination
    ###Bug Below next due date field is DISABLED
    @preventative_services.setLastAdministeredDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @preventative_services.setLastAdministeredDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

xit 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/ShinglesVaccination and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickShinglesVaccination
    @preventative_services.setLastAdministeredDate(todayMonthDayYear)
    ###Bug Below next due date field is DISABLED
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump
    @preventative_services.clickShinglesVaccination

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_ADMINISTERED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/PCV13PneumococcalVaccinationand   Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickPCV13PneumococcalVaccination
    @preventative_services.setLastAdministeredDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @preventative_services.setLastAdministeredDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/PCV13PneumococcalVaccinationand verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickPCV13PneumococcalVaccination
    @preventative_services.setLastAdministeredDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump
    @preventative_services.clickPCV13PneumococcalVaccination

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_ADMINISTERED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/PPSV23PneumococcalVaccination  Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickPPSV23PneumococcalVaccination
    @preventative_services.setLastAdministeredDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @preventative_services.setLastAdministeredDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/PPSV23PneumococcalVaccination and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickPPSV23PneumococcalVaccination
    @preventative_services.setLastAdministeredDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump
    @preventative_services.clickPPSV23PneumococcalVaccination

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_ADMINISTERED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/FluVaccination  Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickFluVaccination
    @preventative_services.setLastAdministeredDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @preventative_services.setLastAdministeredDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/FluVaccination and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickFluVaccination
    @preventative_services.setLastAdministeredDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump
    @preventative_services.clickFluVaccination

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_ADMINISTERED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/ColorectalCancerScreening  Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickFluVaccination
    @preventative_services.setLastAdministeredDate(tomorrowMonthDayYear)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @preventative_services.setLastAdministeredDate(invalidDateFormat)
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

xit 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/ColorectalCancerScreening and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickColorectalCancerScreening
    @preventative_services.setLastCompletedDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    @preventative_services.clickColorectalCancerScreening

    ###Bug below Last Completed Date is displaying no data
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_COMPLETED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/HIVVaccination  Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickHIVVaccination
    @preventative_services.setLastTestedDate(tomorrowMonthDayYear)
    @preventative_services.selectResults('Abnormal')
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Tested must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @preventative_services.setLastTestedDate(invalidDateFormat)
    @preventative_services.selectResults('Abnormal')
    @preventative_services.setNextDueDate(yesterdayMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Last Tested must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

xit 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/HIVVaccination and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickHIVVaccination
    @preventative_services.setLastTestedDate(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.selectResults('Abnormal')
    @preventative_services.clickSaveButtonJump
    @preventative_services.clickHIVVaccination

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::LAST_TESTED_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
    ###Bug below Next Due Date Date is displaying no data
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/PreventiveServices/HPVVaccination and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickHPVVaccination
    @preventative_services.setVaccination1Administered(tomorrowMonthDayYear)
    @preventative_services.setVaccination2Administered(tomorrowMonthDayYear)
    @preventative_services.setVaccination3Administered(tomorrowMonthDayYear)
    @preventative_services.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Vaccination 1 Administered must be between 01/01/1900 and " + todayMonthDayYear + ".\nVaccination 2 Administered must be between 01/01/1900 and " + todayMonthDayYear + ".\nVaccination 3 Administered must be between 01/01/1900 and " + todayMonthDayYear + ".")

    @preventative_services.setVaccination1Administered(invalidDateFormat)
    @notifications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Vaccination 1 Administered must be formatted MM/DD/YYYY.\nVaccination 2 Administered must be between 01/01/1900 and " + todayMonthDayYear + ".\nVaccination 3 Administered must be between 01/01/1900 and " + todayMonthDayYear + ".")

    @preventative_services.setVaccination1Administered(todayMonthDayYear)
    @preventative_services.setVaccination2Administered(invalidDateFormat)
    @notifications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Vaccination 2 Administered must be formatted MM/DD/YYYY.\nVaccination 3 Administered must be between 01/01/1900 and " + todayMonthDayYear + ".")

    @preventative_services.setVaccination1Administered(todayMonthDayYear)
    @preventative_services.setVaccination2Administered(todayMonthDayYear)
    @preventative_services.setVaccination3Administered(invalidDateFormat)
    @notifications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Vaccination 3 Administered must be formatted MM/DD/YYYY.')

    @notifications.clickCancelButton
end

xit 'JRNL 466 Calendar Widget - Edit My Reminders/PreventiveServices/HPVVaccination and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickPreventiveServices
    @preventative_services.clickHPVVaccination
    @preventative_services.setVaccination1Administered(todayMonthDayYear)
    @preventative_services.setVaccination2Administered(todayMonthDayYear)
    @preventative_services.setVaccination3Administered(todayMonthDayYear)
    @preventative_services.setNextDueDate(todayMonthDayYear)
    @preventative_services.clickSaveButtonJump
    #ADD VERIFY DATE CODE ONCE FIXED
    ###BUG NEXT DUE DATE IS DISABLED this is not a bug this is a male patient and field will default to null
    @preventative_services.clickHPVVaccination

    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::VACCINATION_1_ADMINISTERED_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::VACCINATION_2_ADMINISTERED_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::VACCINATION_3_ADMINISTERED_TEXTFIELD)).to eq(todayMonthDayYear)
    expect(@preventative_services.getTextFromInput(:css, PreventiveServices::NEXT_DUE_DATE_TEXTFIELD)).to eq(todayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to My Reminders/Other and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickOther
    @screening.clickAddEntry
    @screening.setReminderTitle('Remind Me Test')
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(yesterdayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickInAppCheckbox
    @notifications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be between " + todayMonthDayYear + " and 12/31/2099.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.setNotificationStartDate(invalidDateFormat)
    @notifications.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq("Start Date must be formatted MM/DD/YYYY.\nA Notification Delivery method is needed to save this record. Please select a method and save again.")

    @notifications.clickCancelButton
end

xit 'JRNL 466 Calendar Widget - Edit My Reminders/Other and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickOther
    @screening.clickAddEntry
    @screening.setReminderTitle('Remind Me Test')
    @notifications.clickOffRadioButton
    @notifications.clickOnRadioButton
    @notifications.setNotificationStartDate(todayMonthDayYear)
    @notifications.selectNotifyMe('Daily')
    @notifications.setNotificationTime('09:15 AM')
    @notifications.clickInAppCheckbox
    @notifications.clickSaveButtonJump
    ###BUG SAVE BUTTON IS DISABLED
end

################################### My Reminders Ends HERE ###########################################################

################################### Notifications Starts HERE ########################################################

it 'JRNL 466 Calendar Widget - Filter Notifications/All Notifications and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickNotifications
    @notifications.clickAllNotifications
    @notifications.setStartDate(todayMonthDayYear)
    @notifications.setEndDate(todayMonthDayYear)
    @notifications.selectSourceByName('All Notifications')
    @notifications.clickApplyButton
    ##VERIFY ALL NOTIFICATIONS ARE SHOWING
    @notifications.selectSourceByName('My VA Health App Notices')
    @notifications.setStartDate(todayMonthDayYear)
    @notifications.setEndDate(todayMonthDayYear)
    @notifications.clickApplyButton
    ###VERIFY MY VA HEALTH NOTIFICATIONS ARE SHOWING
    @notifications.selectSourceByName('VA Health Messages')
    @notifications.setStartDate(todayMonthDayYear)
    @notifications.setEndDate(todayMonthDayYear)
    @notifications.clickApplyButton
    ###VERIFY VA HEALTH MESSAGES ARE SHOWING
end

it 'JRNL 466 Calendar Widget - Filter Notifications/My VA Health App Notices and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickNotifications
    @notifications.clickMyVaHealthAppNotices
    @notifications.setStartDate(todayMonthDayYear)
    @notifications.setEndDate(todayMonthDayYear)
    @notifications.clickApplyButton
    ###VERIFY MY VA HEALTH NOTIFICATIONS ARE SHOWING
end

it 'JRNL 466 Calendar Widget - Filter Notifications/Va Health Messages and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickNotifications
    @notifications.clickVaHealthMessages
    @notifications.setStartDate(todayMonthDayYear)
    @notifications.setEndDate(todayMonthDayYear)
    @notifications.clickApplyButton
    ###VERIFY VA HEALTH MESSAGES ARE SHOWING
end

#################################### Notifications Ends HERE ##########################################################

#################################### Contacts Starts HERE #############################################################

it 'JRNL 466 Calendar Widget - Add Entry to Contacts/Insurance Contacts and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickContacts
    @contacts.clickInsuranceContacts
    @contacts.clickAddButton
    @contacts.setCompany('Company Name')
    @contacts.setEffectiveDate(todayMonthYear)
    @contacts.setEndDate(oneYearBackMonthYear)
    @contacts.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Effective Date must occur before End Date.')

    @contacts.setEffectiveDate(invalidDateFormat)
    @contacts.setEndDate(todayMonthYear)
    @contacts.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Effective Date must be formatted MM/YYYY.')

    @contacts.setEffectiveDate(todayMonthYear)
    @contacts.setEndDate(invalidDateFormat)
    @contacts.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/YYYY.')

    @contacts.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit Contacts/Insurance Contacts and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickContacts
    @contacts.clickInsuranceContacts
    @contacts.clickAddButton
    @contacts.setCompany('Company Name')
    @contacts.setEffectiveDate(todayMonthYear)
    @contacts.setEndDate(todayMonthYear)
    @contacts.clickSaveButtonJump
    @contacts.clickNthRow(1)

    expect(@contacts.getTextFromInput(:css, Contacts::EFFECTIVE_DATE_TEXTFIELD)).to eq(todayMonthYear)
    expect(@contacts.getTextFromInput(:css, Contacts::END_DATE_TEXTFIELD)).to eq(todayMonthYear)

    @contacts.setEffectiveDate(oneYearAgoMonthYear)
    @contacts.setEndDate(oneYearAgoMonthYear)
    @contacts.clickSaveButtonJump
    @contacts.clickNthRow(1)

    expect(@contacts.getTextFromInput(:css, Contacts::EFFECTIVE_DATE_TEXTFIELD)).to eq(oneYearAgoMonthYear)
    expect(@contacts.getTextFromInput(:css, Contacts::END_DATE_TEXTFIELD)).to eq(oneYearAgoMonthYear)
end

it 'JRNL 466 Calendar Widget - Add Entry to Contacts/Communications Log and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickContacts
    @contacts.clickCommunicationsLog
    @contacts.clickAddButton
    @contacts.setDate(tomorrowMonthDayYear)
    @contacts.selectType('In Person')
    @contacts.setSubject('Subject')
    @contacts.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @contacts.setDate(invalidDateFormat)
    @contacts.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date must be formatted MM/DD/YYYY.')

    @contacts.clickCancelButtonJump
end

it 'JRNL 466 Calendar Widget - Add and Edit Contacts/Communications Log and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickContacts
    @contacts.clickCommunicationsLog
    @contacts.clickAddButton
    @contacts.setDate(todayMonthDayYear)
    @contacts.selectType('In Person')
    @contacts.setSubject('Subject')
    @contacts.clickSaveButtonJump
    @contacts.clickNthRow(1)

    expect(@contacts.getTextFromInput(:css, Contacts::DATE_TEXTFIELD)).to eq(todayMonthDayYear)

    @contacts.setDate(yesterdayMonthDayYear)
    @contacts.clickSaveButtonJump
    @contacts.clickNthRow(1)

    expect(@contacts.getTextFromInput(:css, Contacts::DATE_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

#################################### Contacts Ends HERE ###############################################################

#################################### Images and Documents Start HERE ##################################################

it 'JRNL 466 Calendar Widget - Add and Edit Entry to ImagesDocuments/All/Military and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickAll
    @images_docs.clickAddEntryButton
    @images_docs.selectCategory('Medical')
    @images_docs.selectType('EKG')
    @images_docs.setDateOfDocument(tomorrowMonthDayYear)
    @images_docs.addAttachment("addFile", "spidey.jpg")
    @images_docs.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Document must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @images_docs.setDateOfDocument(invalidDateFormat)
    @images_docs.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Document must be formatted MM/DD/YYYY.')

    @images_docs.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit ImagesDocuments/All Log and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickAll
    @images_docs.clickAddEntryButton
    @images_docs.selectCategory('Medical')
    @images_docs.selectType('EKG')
    @images_docs.setDateOfDocument(todayMonthDayYear)
    @images_docs.addAttachment("addFile", "spidey.jpg")
    @images_docs.clickSaveButtonJump
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(todayMonthDayYear)

    @images_docs.setDateOfDocument(yesterdayMonthDayYear)
    @images_docs.clickSaveButtonJump
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to ImagesDocuments/All/Military and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickAll
    @images_docs.clickAddEntryButton
    @images_docs.selectCategory('Military')
    @images_docs.selectType('EKG')
    @images_docs.setDateOfDocument(tomorrowMonthDayYear)
    @images_docs.addAttachment("addFile", "spidey.jpg")
    @images_docs.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Document must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @images_docs.setDateOfDocument(invalidDateFormat)
    @images_docs.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Document must be formatted MM/DD/YYYY.')

    @images_docs.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit ImagesDocuments/All Log and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickAll
    @images_docs.clickAddEntryButton
    @images_docs.selectCategory('Military')
    @images_docs.selectType('EKG')
    @images_docs.setDateOfDocument(todayMonthDayYear)
    @images_docs.addAttachment("addFile", "spidey.jpg")
    @images_docs.clickSaveButtonJump
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(todayMonthDayYear)

    @images_docs.setDateOfDocument(yesterdayMonthDayYear)
    @images_docs.clickSaveButtonJump
    @images_docs.clickNthRow(2)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Add and Edit Entry to ImagesDocuments/All and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickAll
    @images_docs.clickAddEntryButton
    @images_docs.selectCategory('Other')
    @images_docs.selectType('EKG')
    @images_docs.setDateOfDocument(tomorrowMonthDayYear)
    @images_docs.addAttachment("addFile", "spidey.jpg")
    @images_docs.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Document must be between 01/01/1900 and ' + todayMonthDayYear + '.')

    @images_docs.setDateOfDocument(invalidDateFormat)
    @images_docs.clickSaveButtonJump

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Date of Document must be formatted MM/DD/YYYY.')

    @images_docs.clickCancelButton
end

it 'JRNL 466 Calendar Widget - Add and Edit ImagesDocuments/All/Other and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickAll
    @images_docs.clickAddEntryButton
    @images_docs.selectCategory('Other')
    @images_docs.selectType('EKG')
    @images_docs.setDateOfDocument(todayMonthDayYear)
    @images_docs.addAttachment("addFile", "spidey.jpg")
    @images_docs.clickSaveButtonJump
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(todayMonthDayYear)

    @images_docs.setDateOfDocument(yesterdayMonthDayYear)
    @images_docs.clickSaveButtonJump
    @images_docs.clickNthRow(3)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter ImagesDocuments/All Log and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickAll
    @images_docs.setStartDate(yesterdayMonthDayYear)
    @images_docs.setEndDate(yesterdayMonthDayYear)
    @images_docs.clickApplyButton
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
    @images_docs.clickSaveButtonJump

    @images_docs.clickNthRow(2)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
    @images_docs.clickSaveButtonJump

    @images_docs.clickNthRow(3)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
    @images_docs.clickSaveButtonJump
end

it 'JRNL 466 Calendar Widget - Filter ImagesDocuments/Medical Log and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickMedical
    @images_docs.setStartDate(yesterdayMonthDayYear)
    @images_docs.setEndDate(yesterdayMonthDayYear)
    @images_docs.clickApplyButton
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter ImagesDocuments/Military Log and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickMilitary
    @images_docs.setStartDate(yesterdayMonthDayYear)
    @images_docs.setEndDate(yesterdayMonthDayYear)
    @images_docs.clickApplyButton
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

it 'JRNL 466 Calendar Widget - Filter ImagesDocuments/Other Log and verify Calendar widget Positive Scenarios' do
    @main.clickNavMenu
    @navMenu.clickImagesDocuments
    @navMenu.clickOther
    @images_docs.setStartDate(yesterdayMonthDayYear)
    @images_docs.setEndDate(yesterdayMonthDayYear)
    @images_docs.clickApplyButton
    @images_docs.clickNthRow(1)

    expect(@images_docs.getTextFromInput(:css, Images_Documents::DATE_OF_DOCUMENT_TEXTFIELD)).to eq(yesterdayMonthDayYear)
end

################################## Images and Documents Ends HERE ###################################################

###################################### Health Report Starts HERE ####################################################

it 'JRNL 466 Calendar Widget - Add Entry to Health Report and verify Calendar widget Negative Scenarios' do
    @main.clickNavMenu
    @navMenu.clickHealthReport
    @health_report.clickIncludePersonalTrackerCheckBox
    @health_report.setStartDate(todayMonthDayYear)
    @health_report.setEndDate(tomorrowMonthDayYear)
    @health_report.clickBloodPressureAndPulseCheckBox
    @health_report.clickGenerateReportButton

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be between ' + sixYearAgoMonthDayYear + ' and ' + todayMonthDayYear + '.')

    @health_report.setStartDate(invalidDateFormat)
    @health_report.setEndDate(todayMonthDayYear)
    @health_report.clickGenerateReportButton

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('Start Date must be formatted MM/DD/YYYY.')

    @health_report.setStartDate(todayMonthDayYear)
    @health_report.setEndDate(invalidDateFormat)
    @health_report.clickGenerateReportButton

    expect(getTextForElement(:css, Error_Validation::ERROR_MESSAGE_BOX)).to eq('End Date must be formatted MM/DD/YYYY.')
end

it 'JRNL 466 Calendar Widget - Health Report and verify Calendar widget Positive Scenarios', :broken => true do
    @main.clickNavMenu
    @navMenu.clickHealthReport
    @health_report.clickIncludePersonalTrackerCheckBox
    @health_report.clickIncludePersonalTrackerCheckBox
    @health_report.setStartDate(todayMonthDayYear)
    @health_report.setEndDate(todayMonthDayYear)
    @health_report.clickBloodPressureAndPulseCheckBox
    @health_report.clickGenerateReportButton

  ####################################### Health Report Ends HERE ######################################################

end
end
