require_relative '../../globalized'
include Globalized

def verifyAppTourCarousel
  waitForPageToFinishLoading
  expect(@app_tour.isAppTourModalVisible).to eq(true)
  expect(@app_tour.isAppTourModalHeaderTextCorrect).to eq(true)

  expect(@app_tour.isAppTourNthSlideImageVisible(1)).to eq(true)
  expect(@app_tour.isAppTourLeftButtonVisible).to eq(false)
  expect(@app_tour.isAppTourRightButtonVisible).to eq(true)
  @app_tour.clickAppTourRightButton

  expect(@app_tour.isAppTourNthSlideImageVisible(2)).to eq(true)
  expect(@app_tour.isAppTourLeftButtonVisible).to eq(true)
  expect(@app_tour.isAppTourRightButtonVisible).to eq(true)
  @app_tour.clickAppTourRightButton

  expect(@app_tour.isAppTourNthSlideImageVisible(3)).to eq(true)
  expect(@app_tour.isAppTourLeftButtonVisible).to eq(true)
  expect(@app_tour.isAppTourRightButtonVisible).to eq(true)
  @app_tour.clickAppTourLeftButton

  expect(@app_tour.isAppTourNthSlideImageVisible(2)).to eq(true)
  expect(@app_tour.isAppTourLeftButtonVisible).to eq(true)
  expect(@app_tour.isAppTourRightButtonVisible).to eq(true)
  @app_tour.clickAppTourRightButton

  expect(@app_tour.isAppTourNthSlideImageVisible(3)).to eq(true)
  expect(@app_tour.isAppTourLeftButtonVisible).to eq(true)
  expect(@app_tour.isAppTourRightButtonVisible).to eq(true)
  @app_tour.clickAppTourRightButton

  expect(@app_tour.isAppTourNthSlideImageVisible(4)).to eq(true)
  expect(@app_tour.isAppTourLeftButtonVisible).to eq(true)
  expect(@app_tour.isAppTourRightButtonVisible).to eq(true)
  @app_tour.clickAppTourRightButton

  expect(@app_tour.isAppTourNthSlideImageVisible(5)).to eq(true)
  expect(@app_tour.isAppTourLeftButtonVisible).to eq(true)
  expect(@app_tour.isAppTourRightButtonVisible).to eq(false)
end

describe "[ Story# JRNL-468: AppTour_JRNL_468_spec ]" do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage('zztest.patient01', 'patient01, zztest')
  end

  after(:all) do
    quitDriver
  end

  context "AC JRNL-468|TC JRNL-3687: App Navigation" do
    it 'JRNL-468 App Tour - Verify App Tour Appears after Logging in and Accepting PGD Notice - Home Page' do
      @common.clearLocalStorage
      @app_tour.loginForAppTour('zztest.patient01', 'patient01, zztest')
      verifyAppTourCarousel
      @app_tour.clickAppTourCloseButton
    end

    it "JRNL-468 App Tour - Verify App Tour Appears after Clicking on App Tour Option in User Menu - User Menu" do
      @main.clickUserMenu
      @userGuide.clickAppTourButton
      verifyAppTourCarousel
      @app_tour.clickAppTourCloseButton
      @main.clickUserMenu
    end

    xit "JRNL-468 App Tour - Verify App Tour Appears after Logging in without PGD Notice - Home Page", :broken => true do
      # PGD message does not appear, App tour carousel pops up on login page
      # BUG? Does not appear in this scenario only on firefox, works on chrome/safari
      @app_tour.loginForAppTour('zztest.patient01', 'patient01, zztest')
      verifyAppTourCarousel
      @app_tour.clickAppTourCloseButton
      @main.clickUserMenu
    end

    it "JRNL-468 App Tour - Verify App Tour Does not Appear after"\
       'clicking "Do Not Show Again", Logging in and Accepting PGD Notice - Home Page' do
      @common.clearLocalStorage
      @main.clickUserMenu
      @userGuide.clickAppTourButton
      @app_tour.clickAppTourDoNotShowAgainButton
      @app_tour.loginForAppTour('zztest.patient01', 'patient01, zztest')
      expect(@app_tour.isAppTourModalVisible).to eq(false)
    end

    it "JRNL-468 App Tour - Verify App Tour Does not Appear after"\
       'clicking "Do Not Show Again" and Logging in without PGD Notice - Home Page' do
      @app_tour.loginForAppTour('zztest.patient01', 'patient01, zztest')
      expect(@app_tour.isAppTourModalVisible).to eq(false)
    end
  end
end