require_relative '../../globalized'
include Globalized
 
describe "[Angular-BolierPlate:  Application Foundation ]" do

  before(:all) do  
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end  
    
  after(:all) do
    quitDriver()
  end 
  
  it "Verify authentication, EULA and ROA" do
    !45.times{ break if (@eula.declineEulaVisible?() == true); sleep 1 }
    @eula.clickDeclineEulaButton()
    
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    expect(getPageTitle()).to eq("Launchpad")  
      
    #current Launchpad does not have angular-boilerplate app
    gotoHome(BASE_URL)
    
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 } 
    @eula.clickAccept()  
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()
        
    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    waitForPageToFinishLoading
    @loginpage.loginAsVeteran01AndDeclineRoaEndsOnLaunchpad()
    
    #accept Launchpad EULA
    waitForPageToFinishLoading
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    @eula.clickAcceptLaunchpadEula()
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }   
       
    #current Launchpad does not have angular-boilerplate app
    gotoHome(BASE_URL)
    waitForPageToFinishLoading
    !45.times{ break if (getPageTitle() ==  "Right Of Access"); sleep 1 } 
    @roa.clickNext()
    waitForPageToFinishLoading
    !45.times{ break if (getPageTitle() == "Review"); sleep 1 } 
    @roa.clickVerify()

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  BELOW CODE ###################################
########################################################################################################################
########################################################################################################################

    waitForPageToFinishLoading
    !15.times{ break if (@main.pleaseNoteHeader() == "Please Note"); sleep 2 }
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  ABOVE CODE ###################################
########################################################################################################################
########################################################################################################################

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to  eq("Logged in as patient01, zztest")

    #To check if the Time Zone selection screen is present
    if is_element_present(:css, "button[ng-click='save()']") then
      puts "Initializing user Notification Setting and the Time Zone selection."
      byPassTheNotificationSettingsScreen()
    end
  end  
end
 