RSpec.shared_examples "Verify Assessment functionalities" do
  it "When a user opens the assessment feature, the assessment name (Hospital Admission Care Assessment) is shown in the assessment list in alphabetical order.", :broken => true do
    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='Assessments']").click
    waitForPageToFinishLoading
    !45.times{ break if (getSecondaryHeader() == "Assessment List"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Assessment List")
    !45.times{ break if (getPrimaryHeader == "Assessment"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Assessment")
    !45.times{ break if (@hassList.getNthAssessmentFeatureName(@ASSESSMENT_POSITION) == @ASSESSMENT_TITLE); sleep 1 }
    expect(@hassList.getNthAssessmentFeatureName(@ASSESSMENT_POSITION)).to eq(@ASSESSMENT_TITLE)
  end

  it "AC HASS-264|TC HASS-265: Assessment detail page default display", :broken => true do
    expect(@hassList.getDetailDefaultText()).to eq("Select an item from the list to start an assessment.")
  end

  it "When a user opens the assessment, the assessment content is shown in the detail view", :broken => true do
    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName(@ASSESSMENT_TITLE)
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == @ASSESSMENT_TITLE); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq(@ASSESSMENT_TITLE)
    expect(@hassInfo.getInstructionalText()).to eq(@INSTRUCTIONAL_TEXT)

  end

  it "Button: Start Assessment ", :broken => true do
    expect(getTextForElement(:css, Assessment_Information::START_ASSESSMENT_BTN)).to eq("Start Assessment")
  end

  it "Question Format/Save Draft/Submit/Next/Back button", :broken => true do
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of " + @NUM_QUESTIONS.to_s)); sleep 1 }

    for i in 1..@NUM_QUESTIONS
      question = @QUESTIONS["Question " + i.to_s + " of " + @NUM_QUESTIONS.to_s ]

      puts "Assessment title (Hospital Admission Care Assessment)"
      expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq(@ASSESSMENT_TITLE)
      puts "Required field key - right justified: * required field"
      expect(getRequiredFieldInfoText()).to eq(@REQUIRED_FIELD_INFO_TEXT)
      puts "Question " + i.to_s + " of <total number of questions>"
      expect(@hassQuest.getQuestionNumText).to eq("Question " + i.to_s + " of " + @NUM_QUESTIONS.to_s)

      puts "Question and Answer choice text (described in subsequent criteria)"
      if question['questionType'] == 'radio'
        !45.times{ break if (@hassQuest.getQuestionLabel('radio', i) == question['question']); sleep 1 }
        expect(@hassQuest.getQuestionLabel('radio', i)).to eq(question['question'])
        options = question['options'].split('|')

        actualOptions = getElements(:css,  "input[name='Q" + i.to_s + "-option']")
        for j in 0..(options.length - 1)
          expect(actualOptions[j].attribute('value').strip).to eq(options[j].strip)
        end

        if (question['defaultOption'] == "")
          expect(@hassQuest.isAnyRadioButtonChecked(i)).to eq(false)
        end

        @hassQuest.selectOneRadioButton("Q" + i.to_s + "-option", question['answer'])

      elsif question['questionType'] == 'text'
        !45.times{ break if (@hassQuest.getQuestionLabel('text', i) == question['question']); sleep 1 }
        expect(@hassQuest.getQuestionLabel('text', i)).to eq(question['question'])

        text_50 = "0123456789001234567890012345678900123456789001234567890"
        setInput("input[name='Q" + i.to_s + "']", text_50)
        expect(getTextFromInput(:css, "input[name='Q" + i.to_s + "']").length).to eq(50)

        setInput("input[name='Q" + i.to_s + "']", question['answer'])
      end

      puts "Save Draft Button"
      !45.times{ break if (@hassQuest.isTheSaveDraftButtonDisabled == false); sleep 1 }
      @hassQuest.clickTheSaveButton()
      puts "Click OK button from Save Draft pop up"
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      @modal.clickOKFromSaveDraftConfirmation()

      expect(isThisElementDisabled(:css, Assessment_Questionnaire::SAVE_DRAFT_BUTTON )).to eq(true)

      puts "inProgress field in db set to true"
      isInProgress = retrieveLatestRecordFieldInDocument("assessmentResults", "assessmentsdb", "EDIPI", "D123401", "inProgress")
      expect(isInProgress).to eq(true)
      hassID = @hassList.findIndexWithGivenName(@ASSESSMENT_TITLE)

      if (i + 1 > @NUM_QUESTIONS)  #submit
        !45.times{ break if (getFocusedElementText() == "Submit"); sleep 1 }
        expect(getFocusedElementText()).to eq("Submit")
      elsif
      !45.times{ break if (getFocusedElementText() == "Next"); sleep 1 }
        expect(getFocusedElementText()).to eq("Next")
      end

      clickAssessmentByNameAndClickStartAssessment(hassID, i)

      puts "Upon re-opening the assessment, the user is brought to the screen in the assessment where they last saved the assessment; Users can navigate to see all previously entered data"
      puts "Back button"

      if question['questionType'] == 'radio'
        expect(isThisRadioButtonOrCheckBoxSelected('radio', question['answer'], "Q" + i.to_s + "-option")).to eq(true)
      elsif question['questionType'] == 'text'
        expect(getTextFromInput(:css,  "input[name='Q" + i.to_s + "']")).to eq(question['answer'])
      end

      for k in (1..i).to_a.reverse
        @hassQuest.clickBackButton

        if (k == 1)
          !45.times{ break if (isElementPresentAndVisible(:css,  Assessment_Information::START_ASSESSMENT_BTN)); sleep 1 }
          expect(isElementPresentAndVisible(:css,  Assessment_Information::START_ASSESSMENT_BTN)).to eq(true)

        else
          !45.times{ break if (@hassQuest.getQuestionNumText()== "Question " +  (k - 1) .to_s + " of " + @NUM_QUESTIONS.to_s); sleep 1 }
          expect(@hassQuest.getQuestionNumText()).to eq("Question " +  (k - 1).to_s + " of " + @NUM_QUESTIONS.to_s)
          curQuestion = @QUESTIONS["Question " + (k - 1).to_s + " of " + @NUM_QUESTIONS.to_s ]

          if curQuestion['questionType'] == 'radio'
            expect(isThisRadioButtonOrCheckBoxSelected('radio', curQuestion['answer'], "Q" + (k - 1).to_s + "-option")).to eq(true)
          elsif curQuestion['questionType'] == 'text'
            expect(getTextFromInput(:css,  "input[name='Q" + (k - 1).to_s + "']")).to eq(curQuestion['answer'])
          end

        end

      end

      clickAssessmentByNameAndClickStartAssessment(hassID, i)

      puts "< button for phone user"

      resizeWindowToPhone()
      expect(isElementPresentAndVisible(:css,  Assessment_Questionnaire::EXIT_BUTTON_FOR_PHONE)).to eq(true)
      expect(getElement(:css,  Assessment_Questionnaire::EXIT_BUTTON_FOR_PHONE).attribute("title")).to eq("Return to Assessment List options")

      puts "If the user has no unsaved data, a user may navigate away from the assessment and no confirmation message is shown."
      click(:css,  Assessment_Questionnaire::EXIT_BUTTON_FOR_PHONE)

      !45.times{ break if (getSecondaryHeader() == "Assessment List"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Assessment List")

      resizeWindowToDefault()
      expect(getTextForElement(:css,  "span.placeholder-message")).to eq("Select an item from the list to start an assessment.")

      clickAssessmentByNameAndClickStartAssessment(hassID, i)

      puts "next button"
      @hassQuest.clickTheNextButton()

      nextQuestionNum = i + 1

      if (i + 1 > @NUM_QUESTIONS)  #submit
        #Verify that the Modal Dialog box is popped up
        !45.times{ break if (@modal.getConfirmationHeading() == "Submission Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Submission Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You are submitting the " + @ASSESSMENT_TITLE + " for zztest patient01.\nOnce you submit an assessment you will no longer be able to edit your answers.\nSelect CONTINUE to proceed with the submission, or RETURN to return to the assessment in progress.")
        @modal.clickReturnButton
        expect(@modal.isConfirmationPopUpNotPresent)

        expect(@hassQuest.getQuestionNumText()).to eq("Question " +   @NUM_QUESTIONS.to_s + " of " + @NUM_QUESTIONS.to_s)

        puts "Submission"
        @hassQuest.clickTheNextButton()

        !45.times{ break if (@modal.getConfirmationHeading() == "Submission Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Submission Confirmation")
        @modal.clickContinueButton
        !45.times{ break if (@print.isSetUpNotificationButtonVisible() == true); sleep 1 }

#        expect(@print.isSetUpNotificationButtonVisible()).to eq(true)

        isInProgress = retrieveLatestRecordFieldInDocument("assessmentResults", "assessmentsdb", "EDIPI", "D123401", "inProgress")
        expect(isInProgress).to eq(false)

      elsif
      !45.times{ break if (@hassQuest.getQuestionNumText()== "Question " +  nextQuestionNum.to_s + " of " + @NUM_QUESTIONS.to_s); sleep 1 }
        expect(@hassQuest.getQuestionNumText()).to eq("Question " +  nextQuestionNum.to_s + " of " + @NUM_QUESTIONS.to_s)

        puts "Unsaved data warning message"

        nextQuestion = @QUESTIONS["Question " + nextQuestionNum.to_s + " of " + @NUM_QUESTIONS.to_s ]

        if nextQuestion['questionType'] == 'radio'
          @hassQuest.selectOneRadioButton("Q" + nextQuestionNum.to_s + "-option", nextQuestion['answer'])
        elsif nextQuestion['questionType'] == 'text'
          setInput("input[name='Q" + nextQuestionNum.to_s + "']", nextQuestion['answer'])
        end

        @main.clickNavMenu()
        #Click Assessment button
        @navMenu.clickContacts

        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

        @modal.clickReturnButton()
        !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }

        nextHassID = @hassList.findIndexWithGivenName(@NEXT_ASSESSMENT_TITLE)
        @hassList.clickThisAssessment(nextHassID)

        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

        @modal.clickContinueButton
        !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == @NEXT_ASSESSMENT_TITLE); sleep 1 }
        expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq(@NEXT_ASSESSMENT_TITLE)


        clickAssessmentByNameAndClickStartAssessment(hassID, i)

        @hassQuest.clickTheNextButton()
        !45.times{ break if (@hassQuest.getQuestionNumText()== "Question " +  nextQuestionNum.to_s + " of " + @NUM_QUESTIONS.to_s); sleep 1 }
        expect(@hassQuest.getQuestionNumText()).to eq("Question " +  nextQuestionNum.to_s + " of " + @NUM_QUESTIONS.to_s)

      end

    end
  end
end

RSpec.shared_examples "Assessment - Successful Subimt View & Print Options" do
  it "When the user Submits an assessment, the system displays a summary view of the assessment in the Detail view.", :broken => true do
    !45.times{ break if (getPrimaryHeader() == "Assessment Details"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Assessment Details")
  end

  it "Instructional Text", :broken => true do
    expect(@print.getAssessmentSubmitConfirmationMessage()).to include('You have successfully submitted the ' + @ASSESSMENT_TITLE + ' for '+ @USER_NAME + '.')
    expect(@print.getAssessmentSubmitConfirmationMessage()).to include('A copy of the questions and your responses is provided below. This page may be printed using your browser print function.')
#    expect(@print.getSetUpNotificationInstructionMsg()).to eq("Click the \"Set Up Notification\" button below if you would like to be notified to retake the assessment at a future date.")
  end

  it "Assessment Name, Version, Patient Name, Date and time submitted ", :broken => true do
    expect(@print.getPrintAssessmentTitle).to eq(@ASSESSMENT_TITLE + ", Version 1.0")
    expect(@print.getSubmitterName(@ASSESSMENT_TITLE )).to eq(@USER_NAME_2)

    dateTaken = retrieveLatestRecordFieldInDocument("assessmentResults", "assessmentsdb", "EDIPI", "D123401", "dateTaken")
    time = Time.parse(dateTaken.to_s)
    expect(@print.getSubmittedDateTimeFromGUI(@ASSESSMENT_TITLE)).to eq((time.in_time_zone("Eastern Time (US & Canada)")).strftime("%m/%d/%Y %H:%M:%S").to_s)
  end

  it "Each question and answer provided by the user during assessment completion", :broken => true do
    for i in 1..@NUM_QUESTIONS
      question = @QUESTIONS["Question " + i.to_s + " of " + @NUM_QUESTIONS.to_s ]
      questionText = question['question'].split('*')
      expect(questionText[1].strip).to eq(@print.getDisplayedQuestion(i).strip)
      expect(question['answer'].strip).to eq(@print.getDisplayedAnswer(i).strip)
    end
  end
end

RSpec.shared_examples "Hide Notification for Out/In patient" do
  it "Hide the Nofication text and fields" do
    expect(@print.isSetUpNotificationButtonVisible()).to eq(false)
    expect(@print.getSetUpNotificationInstructionMsg()).to eq("")
  end
end

RSpec.shared_examples "Notification" do
  it "When the user Submits an assessment, the system displays a summary view of the assessment in the Detail view." do
    #covered in Assessment - Successful Submit View & Print Options
  end

  it "When the user selects the Set up in-app notification button, the system displays assessment notification setup modal.", :broken => true do
    expect(@print.getSetUpNotificationInstructionMsg()).to eq("Click the \"Set Up Notification\" button below if you would like to be notified to retake the assessment at a future date.")
    expect(@print.isSetUpNotificationButtonVisible()).to eq(true)

    @print.clickSetUpNotificationButton

    !45.times{ break if (@modal.getConfirmationHeading() == "Set Up Notification"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set Up Notification")
    expect(@modal.getConfirmationMessage()).to include("You may elect to receive a notification to retake this assessment at a future date. To receive this notification, select an option below.")
    expect(getTextForElement(:css, Print_Assessment::RETAKE_ASSESSMENT_IN_LABEL)).to eq("Retake assessment in:")

    expect(getPulldownValues('notificationFrequency')).to eq(["Select","One Week", "Two Weeks", "One Month", "Three Months"])
    expect(getElement(:css, Print_Assessment::RETAKE_ASSESSMENT_IN_SELECT).attribute("required")).to eq("true")

    @modal.clickCancelButton

    #no setup information is changed/saved
    remindersDocuments =  retreiveAllDocumentsInCollection("reminders", "remindersdb")
    expect(remindersDocuments.count).to eq(0)

    @print.clickSetUpNotificationButton
    !45.times{ break if (@modal.getConfirmationHeading() == "Set Up Notification"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set Up Notification")
    setSelectBoxValue(Print_Assessment::RETAKE_ASSESSMENT_IN_SELECT, @NOTIFICATION_FREQUENCY)

    @modal.clickSaveButton

    !45.times{ break if (getPrimaryHeader() == "Assessment Details"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Assessment Details")

    !45.times{ break if (getFocusedElementText() == "Set Up Notification"); sleep 1 }
    expect(getFocusedElementText()).to eq("Set Up Notification")

  end

  it "When the user saves the record the notification information is saved as: ", :broken => true do
    remindersDocuments =  retreiveAllDocumentsInCollection("reminders", "remindersdb")
    expect(remindersDocuments.count).to eq(1)

    #create date = today
    #today = getDateNthDaysAgo(0, "%Y-%m-%d")
    today  =((Time.now).utc).strftime("%Y-%m-%d")

    date  = remindersDocuments[0]['createDate'].to_s.split(' ')
    expect(date[0]).to eq(today)

    #Effective Display date = <create date> + retake notification time frame (1 week = 7 days, 2 weeks = 14 days, 1 month = 30 days, 3 months = 90 days)
    eventDate = remindersDocuments[0]['eventDate'].to_s.split(' ')

    today = getDateNthDaysAgo(0, "%m/%d/%Y")
    expectedEventDate = getDateNthDaysFromGivenDate(today, getNumberOfDays(@NOTIFICATION_FREQUENCY))

    convertedDate = convertDateByFormatStr(expectedEventDate, "%Y-%m-%d")

    expect(eventDate[0]).to eq(convertedDate)

    #Display time = 9:00 AM (preference time zone)
    expect(remindersDocuments[0]['times'].to_s).to eq("[\"09:00 AM\"]")

    #Notification source = My VA Health - Assessments
    expect(remindersDocuments[0]['source']).to eq("My VA Health - Assessments")

    #Notification text (body): <assessment name> is due now.
    auxData = remindersDocuments[0]['auxData']
    notificationBody = auxData[4]

    expect(notificationBody['value']).to eq(@ASSESSMENT_TITLE + " is due now.")

  end
end

def clickAssessmentByNameAndClickStartAssessment(hassID, i)
  @hassList.clickThisAssessment(hassID)
  !45.times { break if (@hassInfo.getAssessmentNameFromInfoPageHeader == @ASSESSMENT_TITLE); sleep 1 }
  expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq(@ASSESSMENT_TITLE)

  @hassInfo.clickStartAssessmentButton()

  !45.times { break if (expect(@hassQuest.getQuestionNumText()).to eq("Question " + i.to_s + " of " + @NUM_QUESTIONS.to_s)); sleep 1 }
  !45.times { break if (@hassQuest.isTheNextButtonDisabled == false); sleep 1 }
end

def getNumberOfDays(frequency)
  case frequency
    when 'One Week'
      return 7
    when 'Two Weeks'
      return 14
    when 'One Month'
      return 30
    when 'Three Months'
      return 90
  end
end