#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized



describe "[Story #JRNL-1200: Outpatient Care Assessment]
          [Story #JRNL-1078: Successful Submit View & Print Options]
          [Story #JRNL-1081: Notification]
          [Story #JRNL-1039: Hide Notification for Outpatient and Inpatient Assessments]", :acceptance => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("assessmentResults", "assessmentsdb")
    removeCollection("reminders", "remindersdb")
    removeCollection("notifications", "notificationsdb")
    resetQuartzNotificationDb()

    initializeAllObjects

    @ASSESSMENT_TITLE = "Outpatient Care Assessment"
    @INSTRUCTIONAL_TEXT = "• This assessment captures your comments about care you received during a recent outpatient clinic appointment." + "\n • It is recommended that you complete the assessment once for any outpatient healthcare appointment in the last 30 days." + " \n • Your answer will help to better understand and improve healthcare services." + " \n • The assessment consists of 8 questions." + " \n • Upon completion you will be able to print a copy of your responses." + " \n • Select Start Assessment to begin."
    @NUM_QUESTIONS = 8
    @REQUIRED_FIELD_INFO_TEXT = "* required field"
    @ASSESSMENT_POSITION = 3

    @USER_NAME = "zztest patient01"
    @USER_NAME_2 = "patient01, zztest"

    @NEXT_ASSESSMENT_TITLE = "Hospital Admission Care Assessment"

    @NOTIFICATION_FREQUENCY = "One Week"

    @QUESTIONS = {
        "Question 1 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* My outpatient appointment occurred in what type of facility?",
             "options" => "Veteran Administration|DoD (Military)|Civilian",
             "defaultOption" => "",
             "answer" => "Veteran Administration"
            },

        "Question 2 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "text",
             "question" => "* What was the date of this appointment?",
             "answer" => getDateNthDaysFromNow(-21, "%d/%m/%Y")
            },

        "Question 3 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "text",
             "question" => "* What was the name of the provider at this appointment?",
             "answer" => "VA Urgent Care"
            },

        "Question 4 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* If this appointment was for urgent care (care you needed right away), how long did you have to wait for this appointment?",
             "options" => "Not Applicable, appointment was not urgent|Was seen on the day I requested|1 day|2 to 3 days|4 to 7 days|More than 7 days",
             "defaultOption" => "",
             "answer" => "2 to 3 days"
            },

        "Question 5 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* If this appointment was for routine or non-urgent care, how long did you have to wait for this appointment?",
             "options" => "Not Applicable, appointment was for urgent care (care needed right away)|Up to 7 days|8 to 14 days|15 to 30 days|More than 30 days",
             "defaultOption" => "",
             "answer" => "Up to 7 days"
            },

        "Question 6 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* Did the provider explain things in a way that was easy to understand?",
             "options" => "No|Yes, somewhat|Yes, definitely",
             "defaultOption" => "",
             "answer" => "No",
            },

        "Question 7 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* Did the provider listen carefully to you?",
             "options" => "No|Yes, somewhat|Yes, definitely",
             "defaultOption" => "",
             "answer" => "Yes, somewhat"
            },

        "Question 8 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* During this episode of care, did your provider know important information about your previous medical history?",
             "options" => "No|Yes, somewhat|Yes, definitely",
             "defaultOption" => "",
             "answer" => "Yes, definitely"
            },
    }

    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1090|TC JRNL-1067: " + @ASSESSMENT_TITLE.to_s do
    it_behaves_like  "Verify Assessment functionalities"
  end

  context "#AC JRNL-1075|TC JRNL-1064: Outpatient Care - Successful Submit View & Print Options" do
    it_behaves_like  "Assessment - Successful Subimt View & Print Options"
  end

  context "#AC JRNL-1073|TC JRNL-1061: Notification" do
    it_behaves_like  "Hide Notification for Out/In patient"
  end

end