#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized



describe "[Story #JRNL-1201: Hospital Admission Care Assessment]
          [Story #JRNL-1079: Successful Submit View and Print Options]
          [Story #JRNL-1082: Notification]
          [Story #JRNL-1039: Hide Notification for Outpatient and Inpatient Assessments]", :acceptance => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("assessmentResults", "assessmentsdb")
    removeCollection("reminders", "remindersdb")
    removeCollection("notifications", "notificationsdb")
    resetQuartzNotificationDb()

    initializeAllObjects

    @ASSESSMENT_TITLE = "Hospital Admission Care Assessment"
    @INSTRUCTIONAL_TEXT = "• This assessment captures your comments about recent care that you received while an inpatient in a hospital." + "\n • It is recommended that you complete the assessment once for any hospital admission that occurred in the last 60 days." + " \n • Your answer will help to better understand and improve healthcare services." + "\n • The assessment consists of 7 questions." + " \n • Upon completion you will be able to print a copy of your responses." + " \n • Select Start Assessment to begin."
    @NUM_QUESTIONS = 7
    @REQUIRED_FIELD_INFO_TEXT = "* required field"
    @ASSESSMENT_POSITION = 2
    @USER_NAME = "zztest patient01"
    @USER_NAME_2 = "patient01, zztest"

    @NOTIFICATION_FREQUENCY = "One Month"

    @NEXT_ASSESSMENT_TITLE = "Outpatient Care Assessment"

    @QUESTIONS = {
                      "Question 1 of " + @NUM_QUESTIONS.to_s =>
                      {"questionType" => "radio",
                        "question" => "* My hospital care occurred in what type of facility?",
                        "options" => "Veteran Administration|DoD (Military)|Civilian",
                        "defaultOption" => "",
                        "answer" => "Civilian"
                      },

                      "Question 2 of " + @NUM_QUESTIONS.to_s =>
                      {"questionType" => "text",
                       "question" => "* Name of Facility:",
                       "answer" => "Chantilly VA Hospital:"
                      },

                      "Question 3 of " + @NUM_QUESTIONS.to_s =>
                      {"questionType" => "text",
                       "question" => "* Date of Hospital Discharge:",
                       "answer" => getDateNthDaysFromNow(-6, "%d/%m/%Y")
                      },

                     "Question 4 of " + @NUM_QUESTIONS.to_s =>
                     {"questionType" => "radio",
                      "question" => "* During this hospital stay, staff took my preferences and those of my family or caregiver into account in deciding what my health care needs would be when I was discharged.",
                      "options" => "Strongly disagree|Disagree|Agree|Strongly Agree",
                      "defaultOption" => "",
                      "answer" => "Strongly Agree"
                     },

                     "Question 5 of " + @NUM_QUESTIONS.to_s =>
                     {"questionType" => "radio",
                      "question" => "* When I was discharged from the hospital, I had a good understanding of the things I was responsible for in managing my health.",
                      "options" => "Strongly disagree|Disagree|Agree|Strongly Agree",
                      "defaultOption" => "",
                      "answer" => "Disagree "
                     },

                     "Question 6 of " + @NUM_QUESTIONS.to_s =>
                     {"questionType" => "radio",
                      "question" => "* When I was discharged from the hospital, I clearly understood the purpose for taking each of my medications.",
                      "options" => "Strongly disagree|Disagree|Agree|Strongly Agree|I was not given any medication when I left the hospital",
                      "defaultOption" => "",
                      "answer" => "I was not given any medication when I left the hospital"
                     },

                     "Question 7 of " + @NUM_QUESTIONS.to_s =>
                     {"questionType" => "radio",
                      "question" => "* During this episode of care, did your provider know important information about your previous medical history?",
                      "options" => "No|Yes, somewhat|Yes, definitely",
                      "defaultOption" => "",
                      "answer" => "Yes, somewhat"
                     }
                  }

    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1091|TC JRNL-1069: " + @ASSESSMENT_TITLE.to_s do
    it_behaves_like  "Verify Assessment functionalities"
  end

  context "#AC JRNL-1076|TC JRNL-1065: Hospital Admission Care Assessment - Successful Submit View & Print Options" do
    it_behaves_like  "Assessment - Successful Subimt View & Print Options"
  end

  context "#AC MVAH-|TC JRNL-1033: Hide Notification for Outpatient and Inpatient Assessments" do
    it_behaves_like  "Hide Notification for Out/In patient"
  end

end