#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized



describe "[Story #JRNL-1202: Health Status Self-Assessment]
          [Story #JRNL-1077: Successful Submit View & Print Options]
          [Story #JRNL-1080: Notification]
          [Story #JRNL-1036: Assessment detail page default display]
          [Story #JRNL-1037: Add Assessment Titles]", :acceptance => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("assessmentResults", "assessmentsdb")
    removeCollection("reminders", "remindersdb")
    removeCollection("notifications", "notificationsdb")
    resetQuartzNotificationDb()

    initializeAllObjects

    @USER_NAME = "zztest patient05"
    @USER_NAME_2 = "patient05, zztest"

    @ASSESSMENT_TITLE = "Health Status Self-Assessment"
    @INSTRUCTIONAL_TEXT = "• This assessment captures your current self-reported health status on key areas."  + " \n • The assessment consists of 8 questions." + " \n • Upon completion you will be able to print a copy of your responses." + "\n • It is recommended that you complete the assessment no more often than monthly." + " \n • Select Start Assessment to begin."
    @NUM_QUESTIONS = 8
    @REQUIRED_FIELD_INFO_TEXT = "* required field"
    @ASSESSMENT_POSITION = 1

    @NOTIFICATION_FREQUENCY = "Three Months"

    @NEXT_ASSESSMENT_TITLE = "Hospital Admission Care Assessment"

    @QUESTIONS = {
        "Question 1 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, would you say your health is:",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "",
             "answer" => "Very Good"
            },

        "Question 2 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, would you say your quality of life is:",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "",
             "answer" => "Good"
            },

        "Question 3 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, how would you rate your physical health?",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "",
             "answer" => "Fair"
            },

        "Question 4 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, how would you rate your mental health, including your mood and your ability to think?",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "Completely|Mostly|Moderately|A little|Not at all",
             "answer" => "Poor"
            },

        "Question 5 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* To what extent are you able to carry out your everyday physical activities such as walking, climbing stairs, carrying groceries, or moving a chair?",
             "options" => "Completely|Mostly|Moderately|A little|Not at all",
             "defaultOption" => "",
             "answer" => "Completely"
            },

        "Question 6 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* My health care practitioner encourages me to ask questions.",
             "options" => "Strongly disagree|Moderately disagree|Slightly disagree|Neutral|Slightly agree|Moderately agree|Strongly agree",
             "defaultOption" => "",
             "answer" => "Moderately agree"
            },

        "Question 7 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* I feel a lot of trust in my health care practitioner.",
             "options" =>  "Strongly disagree|Moderately disagree|Slightly disagree|Neutral|Slightly agree|Moderately agree|Strongly agree",
             "defaultOption" => "",
             "answer" => "Strongly agree"
            },

        "Question 8 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* How hard is it for you (and your family) to pay for medical care? Would you say it is:",
             "options" =>  "Very hard|Hard|Somewhat hard|Not very hard|Don't know|No answer",
             "defaultOption" => "",
             "answer" => "Very hard"
            }
    }

    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end


  context "#AC JRNL-1089|TC JRNL-1066 - #AC HASS-194|TC HASS-195: " + @ASSESSMENT_TITLE.to_s do
    it_behaves_like  "Verify Assessment functionalities"
  end

  context "#AC JRNL-1074|TC JRNL-1063: Health Status Assessment - Successful Submit View & Print Options" do
    it_behaves_like  "Assessment - Successful Subimt View & Print Options"
  end

  context "#AC JRNL-1071|TC JRNL-1060: Notification" do
    it_behaves_like  "Notification"
  end

end