#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story# JRNL-1038: Health Advocate User]", :acceptance => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("assessmentResults", "assessmentsdb")
    removeCollection("reminders", "remindersdb")
    removeCollection("notifications", "notificationsdb")

    ###The line of code below is connecting to mySQL and will not work unless configured
    ###resetQuartzNotificationDb()

    initializeAllObjects

    @USER_NAME = "zztest patient05"
    @USER_NAME_2 = "patient05, zztest"

    @ASSESSMENT_TITLE = "Health Status Self-Assessment"
    @INSTRUCTIONAL_TEXT = "• This assessment captures your current self-reported health status on key areas."  + " \n • The assessment consists of 8 questions." + " \n • Upon completion you will be able to print a copy of your responses." + "\n • It is recommended that you complete the assessment no more often than monthly." + " \n • Select Start Assessment to begin."
    @NUM_QUESTIONS = 8
    @REQUIRED_FIELD_INFO_TEXT = "* required field"
    @ASSESSMENT_POSITION = 1

    @NOTIFICATION_FREQUENCY = "Three Months"

    @NEXT_ASSESSMENT_TITLE = "Hospital Admission Care Assessment"

    @QUESTIONS = {
        "Question 1 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, would you say your health is:",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "",
             "answer" => "Very Good"
            },

        "Question 2 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, would you say your quality of life is:",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "",
             "answer" => "Good"
            },

        "Question 3 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, how would you rate your physical health?",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "",
             "answer" => "Fair"
            },

        "Question 4 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* In general, how would you rate your mental health, including your mood and your ability to think?",
             "options" => "Excellent|Very Good|Good|Fair|Poor",
             "defaultOption" => "Completely|Mostly|Moderately|A little|Not at all",
             "answer" => "Poor"
            },

        "Question 5 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* To what extent are you able to carry out your everyday physical activities such as walking, climbing stairs, carrying groceries, or moving a chair?",
             "options" => "Completely|Mostly|Moderately|A little|Not at all",
             "defaultOption" => "",
             "answer" => "Completely"
            },

        "Question 6 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* My health care practitioner encourages me to ask questions.",
             "options" => "Strongly disagree|Moderately disagree|Slightly disagree|Neutral|Slightly agree|Moderately agree|Strongly agree",
             "defaultOption" => "",
             "answer" => "Moderately agree"
            },

        "Question 7 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* I feel a lot of trust in my health care practitioner.",
             "options" =>  "Strongly disagree|Moderately disagree|Slightly disagree|Neutral|Slightly agree|Moderately agree|Strongly agree",
             "defaultOption" => "",
             "answer" => "Strongly agree"
            },

        "Question 8 of " + @NUM_QUESTIONS.to_s =>
            {"questionType" => "radio",
             "question" => "* How hard is it for you (and your family) to pay for medical care? Would you say it is:",
             "options" =>  "Very hard|Hard|Somewhat hard|Not very hard|Don't know|No answer",
             "defaultOption" => "",
             "answer" => "Very hard"
            }
    }

    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

  end

  after(:all) do
    quitDriver()
  end

  context  "AC#HASS-68|HASS-69|TC#:HASS-271: Verify that user can open the app and enter assessment data on behalf of the Veteran and  can see for whom they are submitting the assessment. " do
    it "When a user opens the assessment feature, the assessment name (Hospital Admission Care Assessment) is shown in the assessment list in alphabetical order.", :broken => true do
      #Checking the DS Logon screen loaded
      !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
      @loginpage.loginAsVeteran("zztest.advocate01")

      !45.times{ break if (@main.getFooterText() == "Logged in as advocate01, zztest - Health Advocate for patient01, zztest"); sleep 1 }
      expect(@main.getFooterText()).to eq("Logged in as advocate01, zztest - Health Advocate for patient01, zztest")

      #Click the Left Side Toggle button
      @main.clickNavMenu()
      !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
      #Click Assessment button
      @navMenu.clickAssessmentBtn()
      !45.times{ break if (getSecondaryHeader() == "Assessment List"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Assessment List")
      !45.times{ break if (getPrimaryHeader == "Assessment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Assessment")
      !45.times{ break if (@hassList.getNthAssessmentFeatureName(@ASSESSMENT_POSITION) == @ASSESSMENT_TITLE); sleep 1 }
      expect(@hassList.getNthAssessmentFeatureName(@ASSESSMENT_POSITION)).to eq(@ASSESSMENT_TITLE)
    end


  end

  context "AC HAS-71|TC HASS-271: Verify a health advocate user can save a draft assessment using the same processes used by veterans
           AC#HASS-70|TC#:HASS-271: Verify a health advocate user can submit a completed assessment using the same processed used by veterans" do
    it "When a user opens the assessment, the assessment content is shown in the detail view", :broken => true do
      #Click the assessment to display the Information screen
      hassID = @hassList.findIndexWithGivenName(@ASSESSMENT_TITLE)
      @hassList.clickThisAssessment(hassID)
      #Verify the name is displayed
      !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == @ASSESSMENT_TITLE); sleep 1 }
      expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq(@ASSESSMENT_TITLE)
      expect(@hassInfo.getInstructionalText()).to eq(@INSTRUCTIONAL_TEXT)
    end

    it "Question Format/Save Draft/Submit/Next/Back button", :broken => true do
      @hassInfo.clickStartAssessmentButton()
      !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of " + @NUM_QUESTIONS.to_s)); sleep 1 }

      for i in 1..@NUM_QUESTIONS
        question = @QUESTIONS["Question " + i.to_s + " of " + @NUM_QUESTIONS.to_s ]

        puts "Assessment title (Hospital Admission Care Assessment)"
        expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq(@ASSESSMENT_TITLE)
        puts "Required field key - right justified: * required field"
        expect(getRequiredFieldInfoText()).to eq(@REQUIRED_FIELD_INFO_TEXT)
        puts "Question " + i.to_s + " of <total number of questions>"
        expect(@hassQuest.getQuestionNumText).to eq("Question " + i.to_s + " of " + @NUM_QUESTIONS.to_s)

        puts "Question and Answer choice text (described in subsequent criteria)"
        if question['questionType'] == 'radio'
          !45.times{ break if (@hassQuest.getQuestionLabel('radio', i) == question['question']); sleep 1 }
          expect(@hassQuest.getQuestionLabel('radio', i)).to eq(question['question'])
          options = question['options'].split('|')

          actualOptions = getElements(:css,  "input[name='Q" + i.to_s + "-option']")
          for j in 0..(options.length - 1)
            expect(actualOptions[j].attribute('value').strip).to eq(options[j].strip)
          end

          if (question['defaultOption'] == "")
            expect(@hassQuest.isAnyRadioButtonChecked(i)).to eq(false)
          end

          @hassQuest.selectOneRadioButton("Q" + i.to_s + "-option", question['answer'])

        elsif question['questionType'] == 'text'
          !45.times{ break if (@hassQuest.getQuestionLabel('text', i) == question['question']); sleep 1 }
          expect(@hassQuest.getQuestionLabel('text', i)).to eq(question['question'])

          text_50 = "0123456789001234567890012345678900123456789001234567890"
          setInput("input[name='Q" + i.to_s + "']", text_50)
          expect(getTextFromInput(:css, "input[name='Q" + i.to_s + "']").length).to eq(50)

          setInput("input[name='Q" + i.to_s + "']", question['answer'])
        end

        puts "Save Draft Button"
        !45.times{ break if (@hassQuest.isTheSaveDraftButtonDisabled == false); sleep 1 }
        @hassQuest.clickTheSaveButton()
        puts "Click OK button from Save Draft pop up"
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        @modal.clickOKFromSaveDraftConfirmation()

        expect(isThisElementDisabled(:css, Assessment_Questionnaire::SAVE_DRAFT_BUTTON )).to eq(true)

        puts "inProgress field in db set to true"
        isInProgress = retrieveLatestRecordFieldInDocument("assessmentResults", "assessmentsdb", "EDIPI", "D123401", "inProgress")
        expect(isInProgress).to eq(true)
        hassID = @hassList.findIndexWithGivenName(@ASSESSMENT_TITLE)

        if (i + 1 > @NUM_QUESTIONS)  #submit
          !45.times{ break if (getFocusedElementText() == "Submit"); sleep 1 }
          expect(getFocusedElementText()).to eq("Submit")
        elsif
        !45.times{ break if (getFocusedElementText() == "Next"); sleep 1 }
          expect(getFocusedElementText()).to eq("Next")
        end

        @hassQuest.clickTheNextButton()
        nextQuestionNum = i + 1

        if (i + 1 > @NUM_QUESTIONS)  #submit
          !45.times{ break if (@modal.getConfirmationHeading() == "Submission Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Submission Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You are submitting the " + @ASSESSMENT_TITLE + " for zztest patient01.\nOnce you submit an assessment you will no longer be able to edit your answers.\nSelect CONTINUE to proceed with the submission, or RETURN to return to the assessment in progress.")

          @modal.clickContinueButton
          !45.times{ break if (@print.isSetUpNotificationButtonVisible() == true); sleep 1 }

          isInProgress = retrieveLatestRecordFieldInDocument("assessmentResults", "assessmentsdb", "EDIPI", "D123401", "inProgress")
          expect(isInProgress).to eq(false)
        elsif
          !45.times{ break if (@hassQuest.getQuestionNumText()== "Question " +  nextQuestionNum.to_s + " of " + @NUM_QUESTIONS.to_s); sleep 1 }
          expect(@hassQuest.getQuestionNumText()).to eq("Question " +  nextQuestionNum.to_s + " of " + @NUM_QUESTIONS.to_s)
        end
      end
    end
  end

  context  "AC HASS_70|TC HASS-271: Assessment Submissions create by the Health Advocate are identical to those created by the veteran" do
    it "When the user Submits an assessment, the system displays a summary view of the assessment in the Detail view.", :broken => true do
      !45.times{ break if (getPrimaryHeader() == "Assessment Details"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Assessment Details")
    end

    it "Instructional Text", :broken => true do
      expect(@print.getAssessmentSubmitConfirmationMessage()).to include('You have successfully submitted the ' + @ASSESSMENT_TITLE + ' for '+ @USER_NAME + '.')
      expect(@print.getAssessmentSubmitConfirmationMessage()).to include('A copy of the questions and your responses is provided below. This page may be printed using your browser print function.')
    end

    it "Assessment Name, Version, Patient Name, Date and time submitted ", :broken => true do
      expect(@print.getPrintAssessmentTitle).to eq(@ASSESSMENT_TITLE + ", Version 1.0")
      expect(@print.getSubmitterName(@ASSESSMENT_TITLE )).to eq(@USER_NAME_2)

      dateTaken = retrieveLatestRecordFieldInDocument("assessmentResults", "assessmentsdb", "EDIPI", "D123401", "dateTaken")
      time = Time.parse(dateTaken.to_s)
      expect(@print.getSubmittedDateTimeFromGUI(@ASSESSMENT_TITLE)).to eq((time.in_time_zone("Eastern Time (US & Canada)")).strftime("%m/%d/%Y %H:%M:%S").to_s)
    end

    it "Each question and answer provided by the user during assessment completion", :broken => true do
      for i in 1..@NUM_QUESTIONS
        question = @QUESTIONS["Question " + i.to_s + " of " + @NUM_QUESTIONS.to_s ]
        questionText = question['question'].split('*')
        expect(questionText[1].strip).to eq(@print.getDisplayedQuestion(i).strip)
        expect(question['answer'].strip).to eq(@print.getDisplayedAnswer(i).strip)
      end
    end

  end
end
