require_relative '../../globalized'
include Globalized

describe "[Story# JRNL-491 As a user I want to be able to select Vital Signs so I can have access to all the vital signs to enter or view.]" do


  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects

    VITALS_BTN = "Vitals"

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

  end

  after (:all) do
    quitDriver()
  end

  it 'AC #JRNL-545| TC #JRNL-707: Vital Signs will be a menu option on the left navigation App Menu', :broken => true do
    expect(@nav_menu.isThisNavButtonVisible(VITALS_BTN)).to be true
  end

  it 'AC #JRNL-546|TC #JRNL-707: When the user selects Vitals, options to select individual vital signs will be presented, including Blood Pressure, Temperature, Respiration, Weight, and Height', :broken => true do
    @nav_menu.clickVitals()

    !45.times{ break if (@vitals.getSecondaryHeader() == 'Vitals'); sleep 1 }
    expect(@vitals.getSecondaryHeader()).to eq("Vitals")

    expect(@vitals.hasListBtn('Blood Pressure')).to eq(true)
    expect(@vitals.hasListBtn('Respiration')).to eq(true)
    expect(@vitals.hasListBtn('Temperature')).to eq(true)
    expect(@vitals.hasListBtn('Height')).to eq(true)
    expect(@vitals.hasListBtn('Height2')).to eq(false)
    expect(@vitals.hasListBtn('Weight')).to eq(true)
    expect(@vitals.hasListBtn('Weight1')).to eq(false)

  end

  it 'AC #JRNL-546|TC #JRNL-707: The Detail screen will show a generic icon and the following text: "Select an item from the Vitals list to view details or add a new Vitals entry."', :broken => true do
    @nav_menu.clickVitals()

    !45.times{ break if (@main.getTitle() == 'Vitals'); sleep 1 }
    expect(@vitals.getTitle()).to eq('Vitals')

    expect(@vitals.getVitalIntroText()).to eq('Select an item from the Vitals list to view details or add a new Vitals entry.')
    expect(@vitals.getVitalsBackgroundImageFileName()).to include('img-vitals-placeholder.png')

  end

end