require_relative '../../globalized'
include Globalized



describe "Story# JRNL-1796: [Update_About_Screen_to_Reference_2.0_JRNL_1796_spec.rb]"  do



  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects


    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickUserMenu()
    !45.times { break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    expect(@menu.verifyAboutButtonPresent).to eq("About")
    @menu.clickAboutBtn


  end

  after(:all) do
    quitDriver()
  end

  context 'AC #JRNL-1691 |TC #JRNL-1666: Update About Screen to Reference 2.0' do

    it "About Screen for My VA Health 2.0", :broken => true do

      expect(@modal.getConfirmationHeading()).to eq("About")

      #Grabbing the Entire About content
      aboutcontent = @about.getAboutText()

      puts "About content is: " +aboutcontent

      #Verifying Entire content is covered
      expect(aboutcontent).to include("My VA Health - v2.0.0")
      expect(aboutcontent).to include("The My VA Health app allows you to enter, view, and track personal health information, which can be shared with your healthcare team.")
      expect(aboutcontent).to include("You can use the current version of the app to:")
      expect(aboutcontent).to include("Enter your medical history information including your diagnoses, hospitalizations, surgeries, pregnancies and family history")
      expect(aboutcontent).to include("Create and manage appointment, medication and preventive service reminders")
      expect(aboutcontent).to include("View notifications received from your VA care team")
      expect(aboutcontent).to include("Reflect on what matters to you in your life and how your health can help you reach your life goals")
      expect(aboutcontent).to include("Create and manage healthcare-related and personal contacts and related communications")
      expect(aboutcontent).to include("Complete health assessments")
      expect(aboutcontent).to include("Share elements of your health information with your care team")
      expect(aboutcontent).to include("Notes: The medical data in this app comes from the Veterans Administration Corporate Data Warehouse which is updated nightly. A DS Logon account (level 2) is needed for access.")

      #Verifying Eula link is Present
      expect(aboutcontent).to include("End User License Agreement (EULA)")

      #Clicking on Eula link and verifying that it opens in a new window
      @about.clickShowEULA()
      switchWindowToWindowHandleLast()

      #Verifying Eula Heading
      !45.times { break if (@eula.getEulaHeading == "End User License Agreement"); sleep 1 }
      expect(@eula.getEulaHeading).to eq("End User License Agreement")

      closeBrowser()
      switchWindowToWindowHandleFirst()

      @about.clickOKfromAboutScreen()

    end


  end

end