require_relative '../../globalized'
include Globalized


describe "[Story#JRNL-58|JRNL-497: Temperature_JRNL_58_spec.rb]", :broken => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAllRecordsFromTable("VITAL_OBSERVATION")
    deleteAllRecordsFromTable("VITAL_ENTRY")
    initializeAllObjects
    VITALS_BTN = "Vitals"
    TEMPERATURE = "ul.secondary-list li:nth-of-type(3) button span.ng-binding"

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible(VITALS_BTN)).to be true
    @vitals.clickVitals()

    !45.times{ break if (@vitals.getTitle() == "Vitals"); sleep 1 }
    expect(@vitals.getTitle()).to eq("Vitals")

  end

  after (:all) do
    quitDriver()
  end

  it "AC #JRNL-385|TC #JRNL-609: Temperature will be a topic under Vitals from the left Navigation Menu" do

    expect(@vitals.isThisButtonVisible(TEMPERATURE)).to be true
  end

  it "AC#JRNL-386|TC #JRNL-609|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Error message presentation and Required field testing on User will be able to ADD/EDIT/DELETE entries; Display 'Temperature' with (\u00B0F); Boundary Test for Temperature; Verify the max allowed characters for Note" do

    @vitals.clickThisButton(TEMPERATURE)
    @vitals.clickAddBtn()

    #Verifying Screen Headers
    expect(@vitals.getSecondaryHeader()).to eq("Vitals")
    expect(@vitals.getPrimaryHeader()).to eq ("Enter Temperature")

    expect(@vitals.getNthLabelTemp()).to eq("Temperature (\u00B0F):")

    @vitals.clickCancelBtn()

    #Display a message in the detailed pane when no records exist

    !45.times{break if (@vitals.getMessageInDetail() == "No results found."); sleep 1}
    expect(@vitals.getMessageInDetail()).to eq("No results found.")

    tempCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    puts today

    morningTime = "07:00 AM"
    afterNoonTime = "03:00 PM"
    eveningTime = "10:00 PM"
    dinnerTime = "11:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")

    #Type: Oral
    addAndVerifyATempEntry(yesterday, morningTime, "95", "Oral", "Low Temp")

    #Type: Tympanic
    addAndVerifyATempEntry(yesterday, afterNoonTime, "96", "Tympanic", "Perfect Temp")

    #Type: Rectal
    addAndVerifyATempEntry(yesterday, eveningTime, "100.5", "Rectal", "Light Fever")

    #Type: Auxillary
    addAndVerifyATempEntry(yesterday, dinnerTime, "104", "Auxillary", "Burning Up")

    #Validate max 250 characters for Note
    @vitals.clickAddBtn()

    !45.times{break if (@vitals.getPrimaryHeader() == "Enter Temperature"); sleep 1}
    expect(@vitals.getPrimaryHeader()).to eq("Enter Temperature")

    expect(@vitals.verifyTotalCharacterInNote()).to be true

    #Beginning of JRNL-497 validation
    #Boundary Test Max
    boundaryTestMax("Temperature", "Temperature (\u00B0F) is outside the expected range. Please enter a value between 95.0 and 106.0.")

    #Boundary Test Min
    boundaryTestMin("Temperature", "Temperature (\u00B0F) is outside the expected range. Please enter a value between 95.0 and 106.0.")

    #Required fields testing on Date and Time
    requiredFieldTest("Date", "Date field is required.")
    requiredFieldTest("Time", "Time field is required.")

    #Required fields testing on Temperature
    #Without providing any data to the Temperature field, we'll be getting the following error message
    @vitals.clickSaveNewBtn()
    sleep 10
    checkingInlineError("Temperature (\u00B0F) field is required.")

    #Click Cancel to exit
    @vitals.clickCancelBtn()
    #End of JRNL-497 validation

    #Edit an existing BP and verify the units
    @vitals.clickNthVital(3)

    !45.times{break if (@vitals.getPrimaryHeader() == "Edit Temperature"); sleep 1}
    expect(@vitals.getPrimaryHeader()).to eq("Edit Temperature")


    #Change Temperature to 106
    @vitals.editATemp(106)

    sleep 2

    #Verify that the 3rd entry has the new Temperature reading (106)
    expect(@vitals.getNthTempInList(3)).to eq("106")


  end

  it "AC #JRNL-387|TC #JRNL-609 Entries will be sorted in reverse chronological order" do

    expect(@vitals.getNthTypeInTempList(4)).to eq("Oral")
    expect(@vitals.getNthTypeInTempList(3)).to eq("Tympanic")
    expect(@vitals.getNthTypeInTempList(2)).to eq("Rectal")
    expect(@vitals.getNthTypeInTempList(1)).to eq("Auxillary")

  end

  it "AC #JRNL-386|TC #JRNL-609: User should be able to DELETE entries" do
    deleteNthTemp("Oral")
    deleteNthTemp("Tympanic")
    deleteNthTemp("Rectal")
    deleteNthTemp("Auxillary")
  end

  it "AC #JRNL-387|TC #JRNL-609: Display User Entered Data" do
    #Default Display to last 30 days displaying start and end date
    #Allow User to change date range(date picker will be in another story)


    #Verify that by default, the date range is set to last 30 days
    expect(@vitals.verifyDefaultDateRangeIs30DaysBack()).to be true

    #Set the date range to 2 years back so all the entered data will show up
    toDate = @vitals.getDateNthDaysAgo(0, "%m/%d/%Y")  #set it to Today
    fromDate = @vitals.getDateNthDaysAgo(730, "%m/%d/%Y") #set it to two year ago

    @vitals.setDateRange(fromDate, toDate)

    #Populate the list of the meals again
    tempCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"
    dinnerTime = "08:00 PM"

    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    tenDaysAgo = getDateNthDaysAgo(10, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
    sixtyDaysAgo = getDateNthDaysAgo(60, "%m/%d/%Y")

    addAndVerifyATempEntry(sixtyDaysAgo, dinnerTime, "105", "Auxillary", "I am burning up")
    addAndVerifyATempEntry(thirtyDaysAgo, noonTime, "95", "Oral", "I feel cold")
    addAndVerifyATempEntry(tenDaysAgo, morningTime, "96", "Tympanic", "I feel good")
    addAndVerifyATempEntry(twoDaysAgo, eveningTime, "103", "Rectal", "I have a fever")

    # @vitals.clickFilterBtn()

    setDateRangeAndValidate(3, 0, "Rectal") #to show the twoDaysAgo entry
    setDateRangeAndValidate(11, 3, "Tympanic") #to show the tenDaysAgo entry
    setDateRangeAndValidate(35, 29, "Oral") #to show the thirtyDaysAgo entry
    setDateRangeAndValidate(65, 59, "Auxillary") #to show the sixtyDaysAgo entry

    refreshBrowser()

  end



  #Local Functions

  def addAndVerifyATempEntry(dateStr, timeStr, temperature, type, note)
    tempCount = @vitals.getTotalCount()
    puts tempCount

    @vitals.addTemp(dateStr, timeStr, temperature, type, note)

    !45.times{ break if (@vitals.getTotalCount() == ( tempCount + 1) ); sleep 1 }
    expect(@vitals.getTotalCount()).to eq(tempCount + 1)

    rowIndex = @vitals.findIndexWithAGivenType(type)
    expect(@vitals.getNthTypeInTempList(rowIndex)).to eq(type)
    expect(@vitals.getNthTempInList(rowIndex)).to eq(temperature)
    expect(@vitals.getNthDateInTempList(rowIndex)).to eq(dateStr)
    expect(@vitals.getNthTimeInTempList(rowIndex)).to eq(timeStr)
  end

  def boundaryTestMax(testArea, errMsg)

    case testArea
      when "Temperature" then
        @vitals.setTemp(107)

    end

    @vitals.clickSaveNewBtn()
    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    case testArea
      when "Temperature" then
        @driver.find_element(:css, "input[name='Temperature']").clear

    end

  end

  def boundaryTestMin(testArea, errMsg)

    case testArea
      when "Temperature" then
        @vitals.setTemp(9)

    end

    @vitals.clickSaveNewBtn()
    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    case testArea
      when "Temperature" then
        @driver.find_element(:css, "input[name='Temperature']").clear

    end

  end

  def checkingInlineError(errMsg)

    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("vitalsForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("vitalsForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("vitalsForm", errMsg)).to be true

  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @vitals.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("vitalsForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("vitalsForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("vitalsForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

  def deleteNthTemp(type)
    tempCount = @vitals.getTotalCount()
    listIndex = @vitals.findIndexWithAGivenType(type)
    @vitals.clickNthVital(listIndex)
    !45.times{ break if (@vitals.getPrimaryHeader() == "Edit Temperature"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Edit Temperature")


    @vitals.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()
    !45.times{ break if (@vitals.getPrimaryHeader() == "Edit Temperature"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Edit Temperature")

    sleep 1

    @vitals.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !45.times{ break if ( @vitals.getTotalCount() == (tempCount - 1)); sleep 1 }
    expect(@vitals.getTotalCount()).to eq(tempCount - 1)

    expect(@vitals.isThisTempDisplayed?(type)).to be false

  end

  def setDateRangeAndValidate(numOfDaysAgoFromDate, numOfDaysAgoToDate, type)
    tempCount = @vitals.getTotalCount()

    toDate = @vitals.getDateNthDaysAgo(numOfDaysAgoToDate, "%m/%d/%Y")  #set it to Today
    fromDate = @vitals.getDateNthDaysAgo(numOfDaysAgoFromDate, "%m/%d/%Y")

    #@vitals.clickFilterBtn
    @vitals.setDateRange(fromDate, toDate)

    expect(@vitals.isThisTempDisplayed?(type)).to be true

    expect(@vitals.isTempDateWithinFilteredDateRange?()).to be true

    !45.times{ break if (@vitals.getTotalCount() == 1); sleep 1 }

  end


end