require_relative '../../globalized'
include Globalized


describe "Story#JRNL-2514: [Reminders_View_Filter_Reminder_NR_56_spec.rb]", :broken => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    #removeDocument("notificationPreferences", "notificationsdb", "EDIPI", "PATID52")
    #removeCollection("reminders", "remindersdb")
    resetCollection("reminders", "remindersdb", "reminders")
    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @login_page.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @login_page.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "AC #NR-186,188,189|TC#NR-263: Reminders list display; List filtering; Filter Action" do

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "Reminders"); sleep 1 }

    #Verify the List View header
    expect(@reminders.getSecondaryHeader()).to eq("Reminders")
    #Verify the Detail View header
    expect(@reminders.getPrimaryHeader()).to eq("Reminder Details")

    #Verify that when there are records in the list, the default message displayed as follow

    !45.times{ break if (@reminders.getMessageInPrimaryPane() == "Select an item from the list to view details, or select the button to add a new entry."); sleep 1 }
    expect(@reminders.getMessageInPrimaryPane()).to eq("Select an item from the list to view details, or select the button to add a new entry.")

    #Verify that the Filter button is available
    expect(@reminders.isTheFilterButtonVisible()).to eq(true)

    #Unread is a defaulted option
    expect(@reminders.isStatusSelected("On")).to eq(false)
    expect(@reminders.isStatusSelected("Off")).to eq(false)
    expect(@reminders.isStatusSelected("All")).to eq(true)

    remindersCountAll = @reminders.getRemindersCount()
    @reminders.selectStatus("All")
    !45.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
    @reminders.clickFilter

    !45.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

    #Filter by "On"
    @reminders.selectStatus("On")
    !45.times{ break if (@reminders.isStatusSelected("On") == true); sleep 1 }
    @reminders.clickFilter

    !45.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
    remindersCountOn = @reminders.getRemindersCount()
    #puts "remindersCountOn=" + remindersCountOn.to_s

    for i in 1..remindersCountOn
      expect(@reminders.getNthReminderStatus(i)).to eq("On")
    end

    #Filter by "Off"
    @reminders.selectStatus("Off")
    !45.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
    @reminders.clickFilter
    sleep 2
    !45.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
    remindersCountOff = @reminders.getRemindersCount()
    #puts "remindersCountOff=" + remindersCountOff.to_s

    for i in 1..remindersCountOff
      expect(@reminders.getNthReminderStatus(i)).to eq("Off")
    end

    #Reset it to "All"
    @reminders.selectStatus("All")
    !45.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
    @reminders.clickFilter
    !45.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

    #Click the hide filter button
    @reminders.showOrHideFilter()
    sleep 1
    #Verify the status filter options are hidden
    expect(@reminders.isTheFilterButtonVisible()).to eq(false)

    #Flip the hide filter button again
    @reminders.showOrHideFilter()
    sleep 1
    expect(@reminders.isTheFilterButtonVisible()).to eq(true)


  end

  it "AC #NR-187|TC#NR-263: Reminders list sorting order by name, frequency and status" do
    expect(@reminders.isRemindersListSortedByNameFrequencyStatus()).to eq(true)

  end


end