require_relative '../../globalized'
include Globalized


describe "[Story #NR-357: Reminder notification messages]" do


  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("notifications", "notificationsdb", "notifications")
    resetCollection("notificationPreferences", "notificationsdb", "notificationPreferences")
    resetCollection("preferences", "notificationsdb", "preferences")

    updateDisplayDate

    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @login_page.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @login_page.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    #resetCollection("notifications", "notificationsdb", "notifications")
    #resetCollection("notificationPreferences", "notificationsdb", "notificationPreferences")
    #resetCollection("preferences", "notificationsdb", "preferences")

    quitDriver()
  end

  it "AC #NR-363: Reminder Notification On - Display", :broken => true do
    @landing.clickNotificationCount
    !45.times{ break if (@notification.getTitle() == "Notifications"); sleep 1 }
    expect(@notification.getTitle()).to eq("Notifications")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickNotifications
    !45.times{ break if (@notification.getTitle() == "Notifications"); sleep 1 }

    expect(@notification.getTitle()).to eq("Notifications")

    expect(@notification.getNthNotificationText(5)).to eq("Take 'Tylenol' now.")
    expect(@notification.getNthSource(5)).to eq("My VA Health - Reminders")
    expect(@notification.isNthUnreadFlagVisible(5)).to eq(true)
    expect(isDateFormatValid?(@notification.getNthNotificationDateAndTime(5), "%m/%d/%Y %I:%M %p")).to eq(true)
    expect(@notification.getNthTimeZone(5)).to eq("(America/New_York)")

  end


  def updateDisplayDate

    oneDayAgo = (Time.now - 1.days).utc

    updateDocument("notifications", "notificationsdb", "53d2d4670364b8655ff2a51e", "effectiveDisplayDate", oneDayAgo)

    twoDaysAgo = (Time.now - 2.days).utc
    updateDocument("notifications", "notificationsdb", "53d2d4290364b8655ff2a51d", "effectiveDisplayDate", twoDaysAgo)

    tenDaysAgo = (Time.now - 10.days).utc
    updateDocument("notifications", "notificationsdb", "53d2d3cb0364b8655ff2a51b", "effectiveDisplayDate", tenDaysAgo)

    twentyDaysAgo = (Time.now - 20.days).utc
    updateDocument("notifications", "notificationsdb", "53d2d3f80364b8655ff2a51c", "effectiveDisplayDate", twentyDaysAgo)

    twentySevenDaysAgo = (Time.now - 27.days).utc
    updateDocument("notifications", "notificationsdb", "53fcbbbde4b0654c73d7cbca", "effectiveDisplayDate", twentySevenDaysAgo)

  end

end

 