require_relative '../../globalized'
include Globalized


describe "[Story #JRNL-1562: Glucose - Notification]", :broken => true do

  before(:all) do

    @ENTRY_FORM = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Glucose Level (mg/dl):",
        "Between 0 and 400",
        "* Tested:",
        "Select",
        "Fasting",
        "Before Meal",
        "After Meal",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Notification:",
        "Status:",
        "On",
        "Off",
        "Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        # "Day selected is Monday",
        # "Monday",
        "Notify Me:",
        "Select",
        "Daily",
        "Weekly",
        "Monthly",
        "Notification Delivery:",
        "In-App",
        "Email",
        "email910@gmail.com",
        "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
        "You may update your Preferred Email address in the Notification feature by selecting the icon.",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("chemlabs", "medicalhistorydb")
    removeCollection("reminders", "remindersdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickNotifications()
    sleep 1

    @glucoseNotification.clickTheGearIcon()
    #time zone
    expect(@landing.isTimeZoneVisible()).to eq("* Time Zone:")
    selectTimeZone("(+01:00) CET (Central European Time)")

     #email address verification
    expect(@landing.isEmailAddressVisible()).to eq("Email Address:")
    @landing.setEmailAddress("email910@gmail.com")
    expect(@landing.preferredEmailInstructionalText()).to eq("Your Preferred email for notifications applies to all VA Health apps.")
    expect(@glucoseNotification.timeZoneOption(3)).to eq("(+01:00) CET (Central European Time)")
    @modal.clickSaveButton()

    sleep 1

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickPersonalTrackers()
    !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
    expect(getSecondaryHeader()).to eq("Personal Trackers")

    @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
    !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
    expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

    expect(getCount()).to eq(0)
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1480|TC-3625: Notifications field for Glucose Tracker" do
    it "Content" do
      @common.clickAddButton()

      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::ADD_HEADER); sleep 1 }
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::ADD_HEADER)
      sleep 2.0

      @glucose.getScreenContent().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@ENTRY_FORM[i])
      end
    end

    it "Required" do
      expect(@glucose.isFieldRequired(:css, Glucose_Notification::START_DATE)).to eq(false)
      expect(@glucose.isFieldRequired(:css, Glucose_Notification::FREQUENCY)).to eq(false)
      expect(@glucose.isFieldRequired(:css, Glucose_Notification::NOTIFICATION_DELIVERY)).to eq(false)

      @glucoseNotification.clickOnRadioButton()
      expect(@glucose.isFieldRequired(:css, Glucose_Notification::START_DATE)).to eq(true)
      expect(@glucose.isFieldRequired(:css, Glucose_Notification::FREQUENCY)).to eq(true)
    end

    it "Error Messages" do
      expectedValidationSummaryHeader = "The following errors were found:"
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")

      @glucose.clickSaveButton()

      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Start Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Notify Me field is required.")).to eq(true)

      @glucose.setInput(Glucose_Notification::START_DATE, "11/01")
      click(:css, Glucose_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)

      @glucose.clickSaveButton()

      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Start Date field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "A Notification Delivery method is needed to save this record. Please select a method and save again.")).to eq(true)
    end

  end

  describe "AC JRNL-1479|TC-3625: In App Notification for Glucose Tracker" do
    it "Save" do
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")

      @date_picker.click(:css, Glucose::DATE_BUTTON)
      !45.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
      @date_picker.setDateFromGUI(11, 11, 2014)
      expect(@glucose.getTextFromInput(:css, Glucose::DATE)).to eq("11/11/2014")

      @time_picker.click(:css, Glucose::TIME_BUTTON)
      !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
      @time_picker.setTimeFromGUI(2, 35, "PM")
      !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
      expect(@glucose.getTextFromInput(:css, Glucose::TIME)).to eq("02:35 PM")

      @glucose.setInput(Glucose::GLUCOSE_LEVEL, 50)
      @glucose.setSelectBoxValue(Glucose::TESTED_CONDITION, "Fasting")

      @glucose.setInput(Glucose_Notification::START_DATE, today)
      @glucose.setSelectBoxValue(Glucose_Notification::FREQUENCY, "Weekly")
      click(:css, Glucose_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)

      @glucose.clickSaveButton()
      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
      expect(@glucose.getFocusedElementText()).to eq(Glucose::HEADER)

      expect(getCount()).to eq(1)
    end

    it "Verify Saved Data" do
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      clickNthRow(1)
      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

      expect(@glucose.getTextFromInput(:css, Glucose_Notification::START_DATE)).to eq(today)
      expect(@glucose.getSelectBoxText(Glucose_Notification::FREQUENCY)).to eq("Weekly")
      expect(getElement(:css, Glucose_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Glucose_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)
    end
  end

  describe "AC JRNL-1478|TC-3625: Email Notifications for Glucose Tracker" do

    it "Update Notification Delivery To Email" do
      @main.clickNavMenu()
      !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@navMenu.getNavMenuHeading()).to eq("App Options")

      @navMenu.clickPersonalTrackers()
      !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }
      expect(getSecondaryHeader()).to eq("Personal Trackers")

      @navMenu.click(:css, Nav_menu::NAV["Glucose"]["navButton"])
      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::HEADER)

      clickNthRow(1)
      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      click(:css, Glucose_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)

      @glucose.clickSaveButton()
      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::HEADER); sleep 1 }
      expect(@glucose.getFocusedElementText()).to eq(Glucose::HEADER)

      expect(getCount()).to eq(1)
    end

    it "Verify Saved Data" do
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      clickNthRow(1)
      !45.times{ break if (@glucose.getPrimaryHeader() == Glucose::EDIT_HEADER); sleep 1 }
      expect(@glucose.getPrimaryHeader()).to eq(Glucose::EDIT_HEADER)

      expect(@glucose.getTextFromInput(:css, Glucose_Notification::START_DATE)).to eq(today)
      expect(@glucose.getSelectBoxText(Glucose_Notification::FREQUENCY)).to eq("Weekly")
      expect(getElement(:css, Glucose_Notification::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Glucose_Notification::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)
    end
  end

end
