require_relative '../../globalized'
include Globalized


describe "Story#JRNL-42|JRNL-497|JRNL-751: [Pain_JRNL_42_spec.rb]" do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deletePainTable("D123401")
    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end


  it "AC #JRNL-345|TC#JRNL-371|AC#JRNL-359|TC#JRNL-468|AC#JRNL-788,791|TC#JRNL-812: User can Add/Edit/Delete entries;Today's system date and time should be populated in the new item; Display default message", :broken => true do
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    @nav_menu.clickPain()

    !45.times{ break if (@pain.getPrimaryHeader == "Pain Detail"); sleep 1 }
    expect(@pain.getPrimaryHeader).to eq("Pain Detail")

    #display a message in the detailed pane when no items are seleted
    !45.times{ break if (@pain.getMessageInEventDetail() == "Select the Add Entry button to add a new entry.\nSelect the button to add a new entry."); sleep 1 }
    expect(@pain.getMessageInEventDetail()).to eq("Select the Add Entry button to add a new entry.\nSelect the button to add a new entry.")

    #Add
    $oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")

    addPain(4, "Moderate.  Not too bad", $oneDayAgo, (Time.now+60).strftime("%I:%M %p"))
    !45.times{ break if (@pain.getNthScaleRange(1)== "4 out of 10"); sleep 1 }
    expect(@pain.getNthScaleRange(1)).to eq("4 out of 10")

    addPain(5, "Moderate pain", $oneDayAgo, (Time.now+120).strftime("%I:%M %p"))
    !45.times{ break if (@pain.getNthScaleRange(1)== "5 out of 10"); sleep 1 }
    expect(@pain.getNthScaleRange(1)).to eq("5 out of 10")

    addPain(9, "Really bad", $oneDayAgo, (Time.now+180).strftime("%I:%M %p"))
    !45.times{ break if (@pain.getNthScaleRange(1)== "9 out of 10"); sleep 1 }
    expect(@pain.getNthScaleRange(1)).to eq("9 out of 10")

    addPain(1, "Mild pain", $oneDayAgo, (Time.now+240).strftime("%I:%M %p"))
    !45.times{ break if (@pain.getNthScaleRange(1)== "1 out of 10"); sleep 1 }
    expect(@pain.getNthScaleRange(1)).to eq("1 out of 10")

    #Capturing the Date of the created comm log
    createdDateTime = @pain.getNthDate(1)
    #puts "Created Date is "  + createdDateTime

    @pain.clickNthPain(1)

    !45.times{ break if (@pain.isSaveExistingEventButtonVisible()); sleep 1 }
    expect(@pain.isSaveExistingEventButtonVisible()).to be true

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @pain.getDateInForm()
    #puts "Date in the form " + dateInForm
    timeInForm = @pain.getTimeInForm()
    #puts "Time in the form " + timeInForm
    dateTimeInForm = dateInForm + " " + timeInForm

    #validating that the created date and time equal the date and time in form
    expect(dateTimeInForm).to eq(createdDateTime)
    #puts(expect(dateTimeInForm).to eq(createdDateTime))

    #Edit
    @pain.clickNthPain(4)

    !45.times{ break if (@pain.isSaveExistingEventButtonVisible()); sleep 1 }
    expect(@pain.isSaveExistingEventButtonVisible()).to be true
    expect(@pain.getPainRangeValue()).to eq("4")
    expect(@pain.getNarrativeText()).to eq("Moderate.  Not too bad")
    
    expect(@pain.getDateLabel()).to eq("* Date:")
    expect(@pain.getPainLabel()).to eq("Pain:")
    expect(@pain.getPainDescription()).to eq("(0=No pain, 1=Mild pain, 4=Moderate pain, 10=Agonizing pain)")
    expect(@pain.getNarrativeLabel()).to eq("Note:")
    
    @pain.movePainRangeToLeft(2)
    @pain.setNarrativeText("feel better after taking Tylenol")
    @pain.clickSaveBtn()

    !45.times{ break if (@pain.getNthScaleRange(4) == "2 out of 10"); sleep 1 }
    expect(@pain.getNthScaleRange(4)).to eq("2 out of 10")
    expect(@pain.getMessageInEventDetail()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry.")
    expect(@pain.isDateFormatValid?(@pain.getNthDate(4),"%m/%d/%Y")).to be true

    @pain.clickNthPain(4)
    !45.times{ break if (@pain.isSaveExistingEventButtonVisible()); sleep 1 }

    painListCount = @pain.getPainCount()
    #puts "Pain Count is " + painListCount.to_s

    expect(@pain.isDeleteButtonVisible()).to be true
    @pain.getPainRangeValue() == "2"
    expect(@pain.getNarrativeText()).to eq("feel better after taking Tylenol")
    @pain.setNarrativeText("feel better after taking Tylenol - edited")

    @pain.clickNthPain(2)

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if (@pain.getPrimaryHeader() == "Pain Detail"); sleep 1 }
    expect(@pain.getPrimaryHeader()).to eq("Pain Detail")
    sleep 1

    @pain.clickNthPain(3)
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickContinueButton()
    !45.times{ break if (@pain.getPrimaryHeader() == "Pain Detail"); sleep 1 }
    expect(@pain.getPrimaryHeader()).to eq("Pain Detail")

    #Delete
    @pain.clickNthPain(2)
    !45.times{ break if (@pain.isDeleteButtonVisible()); sleep 1 }
    expect(@pain.isDeleteButtonVisible()).to be true

    @pain.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()

    !45.times{ break if (@pain.isDeleteButtonVisible()); sleep 1 }
    expect(@pain.isDeleteButtonVisible()).to be true
    sleep 1

    @pain.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !45.times{ break if (@pain.getPainCount() == (painListCount - 1)); sleep 1 }
    expect(@pain.getPainCount()).to eq(painListCount - 1)

  end

  it "AC #JRNL-347 | TC #JRNL-371: Default display to last 30 days", :broken => true do
    @pain.refreshBrowser()
    expect(@pain.is30DaysRange()).to be true
    expect(@pain.isDatesWithinFilteredDateRange?()).to be true

  end

  it "AC #JRNL-348 |TC #JRNL-371|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Required fields testing on Date/Time; Narrative will be limited to 250 characters with a countdown display", :broken => true do
    @pain.clickAddBtn()

    #Required fields test
    requiredFieldTest("Date", "Date field is required.")
    requiredFieldTest("Time", "Time field is required.")

    painListCount = @pain.getPainCount()
    narrativeText = "No pain today"
    expect(narrativeText.length).to eq(13)

    @pain.setNarrativeText(narrativeText)
    expect(@pain.getNarrativeText().length).to eq(13)
    expect(@pain.getNarrativeCounterText()).to eq("237 characters left")

    narrativeText = "No pain today - edited"
    expect(narrativeText.length()).to eq(22)
    @pain.setNarrativeText(narrativeText)
    expect(@pain.getNarrativeText().length).to eq(22)
    expect(@pain.getNarrativeCounterText()).to eq("228 characters left")

    narrativeText = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"
    expect(narrativeText.length).to eq(249)
    @pain.setNarrativeText(narrativeText)
    expect(@pain.getNarrativeText().length).to eq(249)
    expect(@pain.getNarrativeCounterText()).to eq("1 characters left")

    narrativeText = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    expect(narrativeText.length).to eq(250)
    @pain.setNarrativeText(narrativeText)
    expect(@pain.getNarrativeText().length).to eq(250)
    expect(@pain.getNarrativeCounterText()).to eq("0 characters left")

    narrativeText = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    expect(narrativeText.length).to eq(280)
    @pain.setNarrativeText(narrativeText)
    expect(@pain.getNarrativeText().length).to eq(250)
    expect(@pain.getNarrativeCounterText()).to eq("0 characters left")

    @pain.clickSaveNewBtn()

    !45.times{ break if (@pain.getPainCount() == (painListCount + 1)); sleep 1 }
    expect(@pain.getPainCount()).to eq(painListCount + 1)

    #delete all pain entries
    deleteNthPain(4)
    deleteNthPain(2)
    deleteNthPain(1)
    deleteNthPain(1)

  end

  it "AC #JRNL-346 | TC #JRNL-371: Multiple pain entries can be displayed in reverse chronological order", :broken => true do

    addPain(4, "Moderate.  Not too bad", $oneDayAgo, (Time.now).strftime("%I:%M %p"))
    addPain(5, "Moderate pain", $oneDayAgo, (Time.now+60).strftime("%I:%M %p"))
    addPain(9, "Really bad", $oneDayAgo, (Time.now+120).strftime("%I:%M %p"))
    addPain(1, "Mild pain", $oneDayAgo, (Time.now+180).strftime("%I:%M %p"))
    addPain(2, "Not too bad", $oneDayAgo, (Time.now+240).strftime("%I:%M %p"))
    addPain(10, "Worst pain", $oneDayAgo, (Time.now+300).strftime("%I:%M %p"))

    twoDaysAgo = getDateNthDaysAgo(2, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "Worst pain", twoDaysAgo) #10 out of 10

    tenDaysAgo = getDateNthDaysAgo(10, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "Not too bad", tenDaysAgo) #2 out of 10

    fourteenDaysAgo = getDateNthDaysAgo(14, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "Moderate.  Not too bad", fourteenDaysAgo) #4 out of 10

    thiryDaysAgo = getDateNthDaysAgo(30, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "Really bad", thiryDaysAgo) # 9 out of 10

    thirtytwoDaysAgo = getDateNthDaysAgo(32, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "Mild pain", thirtytwoDaysAgo) #1 out of 10

    fiftyfiveDaysAgo = getDateNthDaysAgo(55, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "moderate pain", fiftyfiveDaysAgo) # 5 out of 10
    
    @pain.refreshBrowser()

    !45.times{ break if (@pain.getPrimaryHeader == "Pain Detail"); sleep 1 }
    expect(@pain.getPrimaryHeader).to eq("Pain Detail")
    
    expect(@pain.getPainCount()).to eq(4)
    
    expect(@pain.getNthScaleRange(1)).to eq("10 out of 10")
    expect(@pain.getNthScaleRange(2)).to eq("2 out of 10")
    expect(@pain.getNthScaleRange(3)).to eq("4 out of 10")
    expect(@pain.getNthScaleRange(4)).to eq("9 out of 10")
    
    oneDayAgo = getDateNthDaysAgo(1, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "Mild pain", oneDayAgo) #1 out of 10
    
    @pain.refreshBrowser()
    expect(@pain.getPainCount()).to eq(5)
    
    expect(@pain.getNthScaleRange(1)).to eq("1 out of 10")
    expect(@pain.getNthScaleRange(2)).to eq("10 out of 10")
    expect(@pain.getNthScaleRange(3)).to eq("2 out of 10")
    expect(@pain.getNthScaleRange(4)).to eq("4 out of 10")
    expect(@pain.getNthScaleRange(5)).to eq("9 out of 10")
    
    twentyDaysAgo = getDateNthDaysAgo(20, "%Y-%m-%d")
    updateEntryTimePainTable("D123401", "moderate pain", twentyDaysAgo) # 5 out of 10
    
    @pain.refreshBrowser()
    
    expect(@pain.getNthScaleRange(1)).to eq("1 out of 10")
    expect(@pain.getNthScaleRange(2)).to eq("10 out of 10")
    expect(@pain.getNthScaleRange(3)).to eq("2 out of 10")
    expect(@pain.getNthScaleRange(4)).to eq("4 out of 10")
    expect(@pain.getNthScaleRange(5)).to eq("5 out of 10")
    expect(@pain.getNthScaleRange(6)).to eq("9 out of 10")

  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @pain.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("painForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("painForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("painForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

  def deleteNthPain(number)
    painListCount = @pain.getPainCount()
    @pain.clickNthPain(number)
    !45.times{ break if (@pain.isDeleteButtonVisible()); sleep 1 }
    expect(@pain.isDeleteButtonVisible()).to be true

    @pain.clickDeleteBtn()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !45.times{ break if (@pain.getPainCount() == (painListCount - 1)); sleep 1 }
    expect(@pain.getPainCount()).to eq(painListCount - 1)
  end

  def addPain(sliderRange, narrativeText, date, time)
    paintListCount = @pain.getPainCount()
    @pain.clickAddBtn()
    !45.times{ break if (@pain.getPrimaryHeader() == "Pain Detail"); sleep 1 }
    expect(@pain.getPrimaryHeader()).to eq("Pain Detail")

    @pain.setDate(date)
    @pain.setTime(time)
    @pain.movePainRangeToRight(sliderRange)
    @pain.setNarrativeText(narrativeText)
    @pain.clickSaveNewBtn()

    !45.times{ break if (@pain.getPainCount() == (paintListCount + 1)); sleep 1 }
    expect(@pain.getPainCount()).to eq(paintListCount + 1)

    # FAILS WHEN MULTIPLE ADDS OCCUR IN A GIVEN MINUTE
    # BEHAVIOR IS TESTED BY OTHER SECTIONS
    # expect(@pain.getNthScaleRange(1)).to eq(sliderRange.to_s + " out of 10")
    # expect(@pain.isDateFormatValid?(@pain.getNthDate(1),"%m/%d/%Y")).to be true
  end
end
