require_relative '../../globalized'
include Globalized


describe "[Story #NR-45 NR-47 NR-48 NR-90: Notifications]" do


  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("notifications", "notificationsdb", "notifications")
    resetCollection("notificationPreferences", "notificationsdb", "notificationPreferences")
    resetCollection("preferences", "notificationsdb", "preferences")

    updateDisplayDate
    #patient66 update optIn option to opted  Out
    updateDocument("notificationPreferences", "notificationsdb", "53cf0fa7c2e6c39d27997795", "optInSelected", false)

   initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @login_page.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @login_page.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    resetCollection("notifications", "notificationsdb", "notifications")
    resetCollection("notificationPreferences", "notificationsdb", "notificationPreferences")
    resetCollection("preferences", "notificationsdb", "preferences")

    quitDriver()
  end

 describe "Story #NR-45: Notification List" do
    before(:all) do
    end
    
    it "AC #NR-132: Access opt in feature", :broken => true do
      #Access from Landing page
      @landing.clickNotificationCount
      !45.times{ break if (@notification.getTitle() == "Notifications"); sleep 1 }
       expect(@notification.getTitle()).to eq("Notifications")
  
      #Access from the left navigation menu
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  
      @nav_menu.clickNotifications
      !45.times{ break if (@notification.getTitle() == "Notifications"); sleep 1 }
  
      #notificationCount = @notification.getNotificationCount
  
    end
  
    it "AC #NR-133: Notification list title", :broken => true do
      expect(@notification.getTitle()).to eq("Notifications")
    end
  
    it "AC #NR-134: Select item message for tablet and laptop users", :broken => true do
      expect(@notification.getMessageInPrimaryPane).to eq("Select an item from the list to view details.")
    end

    it "AC #NR-136: Order list in reverse chronological order", :broken => true do
      expect(@notification.isSortedReverseChronologicalOrder).to eq(true)
    end
  
    it "AC #NR-137: List view presentation", :broken => true do
      #Date and Time
      expect(isDateFormatValid?(@notification.getNthNotificationDateAndTime(1), "%m/%d/%Y %I:%M %p")).to eq(true)
      expect(isDateFormatValid?(@notification.getNthNotificationDateAndTime(2), "%m/%d/%Y %I:%M %p")).to eq(true)
      expect(isDateFormatValid?(@notification.getNthNotificationDateAndTime(3), "%m/%d/%Y %I:%M %p")).to eq(true)
      expect(isDateFormatValid?(@notification.getNthNotificationDateAndTime(4), "%m/%d/%Y %I:%M %p")).to eq(true)
  
      #source
      expect(@notification.getNthSource(1)).to eq("My VA Health - Assessments")
      expect(@notification.getNthSource(2)).to eq("VA - Notifications")
      expect(@notification.getNthSource(3)).to eq("VA - Notifications")
      expect(@notification.getNthSource(4)).to eq("VA - Notifications")
  
      #notification Text
      # notificationText = @notification.getNthNotificationText(3)
      # expect(notificationText.end_with?("...more")).to eq(true)

      #Unread status indicator icon
      expect(@notification.isNthUnreadFlagVisible(1)).to eq(true)
      expect(@notification.isNthUnreadFlagVisible(2)).to eq(true)
      expect(@notification.isNthUnreadFlagVisible(3)).to eq(true)
      expect(@notification.isNthUnreadFlagVisible(4)).to eq(true)
  
      @notification.clickNthNotification(2)
      !45.times{ break if (@notification.isNthUnreadFlagVisible(2) == false); sleep 1 }
      expect(@notification.isNthUnreadFlagVisible(2)).to eq(false)
  
      @notification.clickNthNotification(4)
      !45.times{ break if (@notification.isNthUnreadFlagVisible(4) == false); sleep 1 }
      expect(@notification.isNthUnreadFlagVisible(4)).to eq(false)
  
    end
  
    it "AC #NR-138: List view -opted out users", :broken => true do
      #patient66 update optIn option to opted  Out
      updateDocument("notificationPreferences", "notificationsdb", "53cf0fa7c2e6c39d27997795", "optInSelected", false)
      @main.clickUserMenu
      !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
      @menu.clickLogoutBtn()
  
      !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
  
      gotoHome(BASE_URL)
  
      !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
      expect(@landing.getTitle()).to eq("My VA Health")
      expect(@landing.getFooterText()).to eq("Not logged in")
  
      @login_page.passingByTheLandingPage()
  
      !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
      @login_page.loginAsVeteran("zztest.patient66")
  
      !45.times{ break if (@main.getFooterText() == "Logged in as patient66, zztest"); sleep 1 }
      expect(@main.getFooterText()).to eq("Logged in as patient66, zztest")
  
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  
      @nav_menu.clickNotifications
      !45.times{ break if (@notification.getTitle() == "Notifications"); sleep 1 }
  
      # expect(@notification.getOptedOutMessageInLeftPane).to eq("You are not opted-in for notifications.\nTo receive notifications, select the opt-in button.")
    end
  
    it "AC #NR-141: Opt in/out button location", :broken => true do
      #for opted out patient66
      expect(@notification.isOptInOutButtonPresent).to be true

      #for opted In patient01
      @main.clickUserMenu
      !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
      @menu.clickLogoutBtn()
  
      !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
  
      gotoHome(BASE_URL)
  
      !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
      expect(@landing.getTitle()).to eq("My VA Health")
      expect(@landing.getFooterText()).to eq("Not logged in")
  
      @login_page.passingByTheLandingPage()
  
      !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
      @login_page.loginAsVeteran("zztest.patient01")
  
      !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
      expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  
      @nav_menu.clickNotifications
      !45.times{ break if (@notification.getTitle() == "Notifications"); sleep 1 }
  
      #for opted out patient66
      expect(@notification.isOptInOutButtonPresent).to be true
  
    end
  end

  describe "[Story #NR-90: Notifications Filter]", :broken => true do
    before(:all) do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

      @nav_menu.clickNotifications
      !45.times{ break if (@notification.getTitle() == "Notifications"); sleep 1 }
    end


    it "AC #NR-142: Status filter" do

      #Unread is a defaulted option
      expect(@notification.isStatusSelected("Unread")).to eq(true)
      expect(@notification.isStatusSelected("Read")).to eq(false)
      expect(@notification.isStatusSelected("All")).to eq(false)

      notificationCount = @notification.getNotificationCount
      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount > notificationCount); sleep 1 }

      notificationCount = @notification.getNotificationCount

      @notification.selectStatus("Read")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount < notificationCount); sleep 1 }
      notificationCount1 = @notification.getNotificationCount

      puts "[Validing isNthUnreadFlagVisible ] notificationCount : " + notificationCount1.to_s

      for i in 1..notificationCount1
        expect(@notification.isNthUnreadFlagVisible(i)).to eq(false)
      end

      puts "[End of Validating isNthUnReadFlagVisible]"


      notificationCount = @notification.getNotificationCount
      @notification.selectStatus("All")
      @notification.clickFilter
      !45.times{ break if (@notification.getNotificationCount > notificationCount); sleep 1 }

      notificationCount = @notification.getNotificationCount
      @notification.selectStatus("Unread")
      @notification.clickFilter
      !45.times{ break if (@notification.getNotificationCount < notificationCount); sleep 1 }

      notificationCount2 = @notification.getNotificationCount
      for i in 1..notificationCount2
        expect(@notification.isNthUnreadFlagVisible(i)).to eq(true)
      end

      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount > notificationCount2); sleep 1 }

      notificationCount3 = @notification.getNotificationCount
      expect(notificationCount3).to eq(notificationCount1 + notificationCount2)

    end

    it "AC #NR-143: Date filter" do
      #Start Date and End Dates default to show the last 30 days
      today = getDateNthDaysAgo(0,"%m/%d/%Y")

      thirtyDaysAgo =  getDateNthDaysAgo(30,"%m/%d/%Y")
      expect(@date_filter.getStartDate).to eq(thirtyDaysAgo)
      expect(@date_filter.getEndDate).to eq(today)

      #Date fields don't allow a future dates

      oneYearAgo = getDateNthYeasFromNow(-1, "%m/%d/%Y")
      expectedMessage1 = "Start Date must be between " + oneYearAgo + " and " + today +"."
      expectedMessage2 = "End Date must be between " + oneYearAgo + " and " + today +"."

      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      dayAfterTomorrow = getDateNthDaysFromNow(2, "%m/%d/%Y")
      validateError(tomorrow, dayAfterTomorrow, [expectedMessage1, expectedMessage2])


      #Start Date and End Date are required fields
      expectedMessage1 = "Start Date field is required."
      expectedMessage2 = "End Date field is required."
      validateError("", "", [expectedMessage1, expectedMessage2])

      #Only valid date formats are allowed
      expect(@date_filter.getStartDatePlaceHolder).to eq("MM/DD/YYYY")
      expect(@date_filter.getEndDatePlaceHolder).to eq("MM/DD/YYYY")

      POSSIBLE_ERRORS = ["Start Date field is required.", "End Date field is required.", "Start Date must be formatted MM/DD/YYYY.", "End Date must be formatted MM/DD/YYYY.", "Start Date cannot be a future date.", "End Date cannot be a future date.", "Start Date is an invalid date.", "End Date is an invalid date.", "Start Date must occur before End Date."]

      validateError("01/31/1813", "05/21/1931", [POSSIBLE_ERRORS[2]] )
      validateError("02/29/2013", "05/21/0024", [POSSIBLE_ERRORS[3], POSSIBLE_ERRORS[6]] )
      validateError("ab/bb/cccc", "gg/hh/iiii", [POSSIBLE_ERRORS[0], POSSIBLE_ERRORS[1]])
      validateError("01/24", "06/72", [POSSIBLE_ERRORS[2], POSSIBLE_ERRORS[3]])
      validateError("0/24/2014", "05/21/2014", [POSSIBLE_ERRORS[2]])
      validateError("02/24/2014", "05/21/201", [POSSIBLE_ERRORS[3]])

      #Constrain start date minimum entry to today-1 year.
      expectedMessage1 = "Start Date must be between " + oneYearAgo + " and " + today +"."
      threeHundredSixtySixDaysAgo = getDateNthDaysFromNow(-366, "%m/%d/%Y")
      validateError(threeHundredSixtySixDaysAgo, today, [expectedMessage1])

      #start date must be before end date, otherwise display standard error message
      yesterday = getDateNthDaysFromNow(-1, "%m/%d/%Y")
      validateError(today, yesterday, [POSSIBLE_ERRORS[8]])

    end

    it "AC #NR-144: No results found message" do
      threeHundredFiftyTwoAgo = getDateNthDaysFromNow(-352, "%m/%d/%Y")
      threeHundredFiftyDaysAgo = getDateNthDaysFromNow(-350, "%m/%d/%Y")
      @notification.setDateRange(threeHundredFiftyTwoAgo, threeHundredFiftyDaysAgo)
      @notification.clickFilter
      puts threeHundredFiftyTwoAgo
      puts threeHundredFiftyDaysAgo
      !45.times{ break if (@notification.getNoResultsFoundMessage == "No results found."); sleep 1 }
      expect(@notification.getNoResultsFoundMessage).to eq("No results found.")

      #filtering 30 days range
      notificationCount = @notification.getNotificationCount
      today = getDateNthDaysAgo(0,"%m/%d/%Y")
      thirtyDaysAgo = getDateNthDaysAgo(30,"%m/%d/%Y")
      @notification.setDateRange(thirtyDaysAgo, today)
      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount > notificationCount); sleep 1 }

      expect(@notification.isDatesWithinFilteredDateRange?()).to eq(true)
      notificationCount = @notification.getNotificationCount
      expect(notificationCount).to eq(4)

      #filtering 20 days range
      today = getDateNthDaysAgo(0,"%m/%d/%Y")
      twentyDaysAgo = getDateNthDaysAgo(20,"%m/%d/%Y")
      @notification.setDateRange(twentyDaysAgo, today)
      @notification.selectStatus("All")
      @notification.clickFilter
      sleep 1
      !45.times{ break if (@notification.getNotificationCount == notificationCount); sleep 1 }

      expect(@notification.isDatesWithinFilteredDateRange?()).to eq(true)
      notificationCount = @notification.getNotificationCount
      expect(notificationCount).to eq(4)

      #filtering 10 days ago
      today = getDateNthDaysAgo(0,"%m/%d/%Y")
      tenDaysAgo = getDateNthDaysAgo(10,"%m/%d/%Y")
      @notification.setDateRange(tenDaysAgo, today)
      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount < notificationCount); sleep 1 }

      expect(@notification.isDatesWithinFilteredDateRange?()).to eq(true)
      notificationCount = @notification.getNotificationCount
      expect(notificationCount).to eq(3)

      #filtering 2 days ago
      today = getDateNthDaysAgo(0,"%m/%d/%Y")
      twoDaysAgo = getDateNthDaysAgo(2,"%m/%d/%Y")
      @notification.setDateRange(twoDaysAgo, today)
      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount < notificationCount); sleep 1 }

      expect(@notification.isDatesWithinFilteredDateRange?()).to eq(true)
      notificationCount = @notification.getNotificationCount
      expect(notificationCount).to eq(2)

      #filtering 1 day ago
      today = getDateNthDaysAgo(0,"%m/%d/%Y")
      oneDayAgo = getDateNthDaysAgo(1,"%m/%d/%Y")
      @notification.setDateRange(oneDayAgo, today)
      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount < notificationCount); sleep 1 }

      expect(@notification.isDatesWithinFilteredDateRange?()).to eq(true)
      notificationCount = @notification.getNotificationCount
      expect(notificationCount).to eq(1)

    end


  end

  describe "[Story #NR-47: Notification Details]", :broken => true do
    before(:all) do
      notificationCount = @notification.getNotificationCount

      today = getDateNthDaysAgo(0, "%m/%d/%Y")
      thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
      @notification.setDateRange(thirtyDaysAgo, today)

      #Display all notifications
      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount > notificationCount); sleep 1 }

    end

    it "AC #NR-145: Expanded view - AC #NR-146: Detail label" do
      @notification.clickNthNotification(1)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details" ); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      expect(@notification.getSourceInDetail).to eq("My VA Health - Assessments")
      expect(@notification.getNthNotificationDateAndTime(1)).to eq(@notification.getDateAndTimeInDetail)
      expect(@notification.getTextInDetail).to eq("You will receive your assessment reminder in 4 weeks")
      expect(@notification.getTextInDetail.length).to be <= 250

      @notification.clickNthNotification(2)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details" ); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      expect(@notification.getSourceInDetail).to eq("VA - Notifications")
      expect(@notification.getNthNotificationDateAndTime(2)).to eq(@notification.getDateAndTimeInDetail)
      expect(@notification.getTextInDetail).to eq("In a previous mailing, you were notified of your enrollment in the Department of Veterans Affairs (VA) health care system. You are currently enrolled in priority group.")
      expect(@notification.getTextInDetail.length).to be <= 250

    end

    it "AC #NR-47: Cancel view" do
      @notification.clickCancelButton()

      !45.times{ break if (@notification.getMessageInPrimaryPane == "Select an item from the list to view details." ); sleep 1 }
      expect(@notification.getMessageInPrimaryPane).to eq("Select an item from the list to view details.")
    end

    it "AC #NR-148:  Read status" do
      #Display all notifications
      notificationCount = @notification.getNotificationCount

      @notification.selectStatus("Unread")
      @notification.clickFilter
      !45.times{ break if (@notification.getNotificationCount <  notificationCount); sleep 1 }

      expect(@notification.isNthUnreadFlagVisible(1)).to eq(true)

      @notification.clickNthNotification(1)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details" ); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")
      sleep 1
      expect(@notification.isNthUnreadFlagVisible(1)).to eq(false)
      notificationCount = @notification.getNotificationCount

      refreshBrowser
      expect(@notification.getNotificationCount).to eq(notificationCount -1)

    end

  end

  describe "Story #NR-48: Delete Notification" do
    before(:all) do
    end

    it "AC #NR-149: Delete function", :broken => true do

      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d4670364b8655ff2a51e", "deletedFlag")).to eq(false)
      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d4290364b8655ff2a51d", "deletedFlag")).to eq(false)
      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d3cb0364b8655ff2a51b", "deletedFlag")).to eq(false)
      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d3f80364b8655ff2a51c", "deletedFlag")).to eq(false)

      notificationCount = @notification.getNotificationCount

      today = getDateNthDaysAgo(0, "%m/%d/%Y")
      thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
      @notification.setDateRange(thirtyDaysAgo, today)

      #Display all notifications
      @notification.selectStatus("All")
      @notification.clickFilter

      !45.times{ break if (@notification.getNotificationCount > notificationCount); sleep 1 }

      notificationCount = @notification.getNotificationCount

      @notification.clickNthNotification(1)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details"); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      @notification.clickDeleteButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickNoButton

      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details"); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      notificationCountAfterClickingNo = @notification.getNotificationCount
      expect(notificationCount).to eq(notificationCountAfterClickingNo)

      @notification.clickNthNotification(2)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details"); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      !45.times{ break if (@notification.isDeleteButtonVisible()); sleep 1 }
      expect(@notification.isDeleteButtonVisible()).to be true
      @notification.clickDeleteButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickYesButton

      !45.times{ break if (@notification.getNotificationCount == (notificationCount - 1)); sleep 1 }
      expect(@notification.getNotificationCount).to eq(notificationCount - 1)

      notificationCount = @notification.getNotificationCount

      @notification.clickNthNotification(3)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details"); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      !45.times{ break if (@notification.isDeleteButtonVisible()); sleep 1 }
      expect(@notification.isDeleteButtonVisible()).to be true
      @notification.clickDeleteButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickYesButton

      !45.times{ break if (@notification.getNotificationCount == (notificationCount - 1)); sleep 1 }
      expect(@notification.getNotificationCount).to eq(notificationCount - 1)

      notificationCount = @notification.getNotificationCount

      @notification.clickNthNotification(2)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details"); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      !45.times{ break if (@notification.isDeleteButtonVisible()); sleep 1 }
      expect(@notification.isDeleteButtonVisible()).to be true
      @notification.clickDeleteButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickYesButton

      !45.times{ break if (@notification.getNotificationCount == (notificationCount - 1)); sleep 1 }
      expect(@notification.getNotificationCount).to eq(notificationCount - 1)

      notificationCount = @notification.getNotificationCount

      @notification.clickNthNotification(1)
      !45.times{ break if (@notification.getPrimaryHeader == "Notification Details"); sleep 1 }
      expect(@notification.getPrimaryHeader).to eq("Notification Details")

      !45.times{ break if (@notification.isDeleteButtonVisible()); sleep 1 }
      expect(@notification.isDeleteButtonVisible()).to be true
      @notification.clickDeleteButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickYesButton

      !45.times{ break if (@notification.getNoResultsFoundMessage== "No results found."); sleep 1 }
      expect(@notification.getNoResultsFoundMessage).to eq("No results found.")

    end

    it "AC #NR-151: Deleted notifications in database" do
      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d4670364b8655ff2a51e", "deletedFlag")).to eq(true)
      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d4290364b8655ff2a51d", "deletedFlag")).to eq(true)
      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d3cb0364b8655ff2a51b", "deletedFlag")).to eq(true)
      expect(verifyNotificationDeleted("notifications", "notificationsdb", "53d2d3f80364b8655ff2a51c", "deletedFlag")).to eq(true)
    end

  end

  def updateDisplayDate

    oneDayAgo = (Time.now - 1.days)

    updateDocument("notifications", "notificationsdb", "53d2d4670364b8655ff2a51e", "effectiveDisplayDate", oneDayAgo)

    twoDaysAgo = (Time.now - 2.days)
    updateDocument("notifications", "notificationsdb", "53d2d4290364b8655ff2a51d", "effectiveDisplayDate", twoDaysAgo)

    tenDaysAgo = (Time.now - 10.days)
    updateDocument("notifications", "notificationsdb", "53d2d3cb0364b8655ff2a51b", "effectiveDisplayDate", tenDaysAgo)

    twentyDaysAgo = (Time.now - 20.days)
    updateDocument("notifications", "notificationsdb", "53d2d3f80364b8655ff2a51c", "effectiveDisplayDate", twentyDaysAgo)

  end


  def validateError(startDate, endDate, errors)
    puts"[validateError] (start date=" + startDate + ", end date=" + endDate + ")"
    @date_filter.setDateRangeAndFilter(startDate, endDate)
    expectedValidationSummaryHeader = errors.length > 0 ? "The following errors were found:" : ""
    sleep 1

    !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)

    if(expectedValidationSummaryHeader != "")
      for i in 0..(errors.length - 1)
        if errors[i] != nil
          puts "Error is " + errors[i].to_s
          expect(@error.isErrorMessageDisplayed("filterForm", errors[i])).to eq(true)
        else
          expect(@error.isErrorMessageDisplayed("filterForm", errors[i])).to eq(false)
        end
      end
    else
      puts "No errors displayed"
      expect(@error.isErrorSummaryElementPresent("filterForm")).to eq(false)
    end
  end
end

 