require_relative '../../globalized'
include Globalized


describe "[Story#JRNL-22|JRNL-649|JRNL-751: Mood_JRNL_22_spec.rb]" do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteMoodTable("D123401")
    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "AC#JRNL-339|TC#JRNL-370|AC#JRNL-788TC#JRNL-812: Mood will appear as an option on the app menu; Default message is displayed", :broken => true do
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMoodButtonVisible).to be true
    @nav_menu.clickMood()

    !45.times{ break if (@mood.getTitle() == "Mood"); sleep 1 }
    expect(@mood.getTitle()).to eq("Mood")

    #display a message in the detailed pane when no items are seleted
    !45.times{ break if (@mood.getMessageInEventDetail() == "Select the Add Entry button to add a new entry.\nSelect the button to add a new entry."); sleep 1 }
    expect(@mood.getMessageInEventDetail()).to eq("Select the Add Entry button to add a new entry.\nSelect the button to add a new entry.")

  end

  it "AC#JRNL-340|TC#JRNL-370|AC#JRNL-359|TC#JRNL-468|AC#JRNL-791|TC#JRNL-812: Today's system date and time should be populated in the new item |AC #JRNL-511| TC #JRNL-540: Allow date time change for date entry", :broken => true do
    #Add
    @mood.clickAddBtn()
    !45.times{ break if (@mood.getPrimaryHeader() == "Mood Detail"); sleep 1 }
    expect(@mood.getPrimaryHeader()).to eq("Mood Detail")

    @mood.moveMoodRangeToLeft(1)
    @mood.setNarrativeText("Not happy!")
    @mood.clickSaveNewBtn()

    !45.times{ break if (@mood.getMoodCount() > 0); sleep 1 }
    expect(@mood.getMoodCount()).to eq(1)

    expect(@mood.getNthScaleRange(1)).to eq("4 out of 10")
    expect(@mood.isDateFormatValid?(@mood.getNthDate(1),"%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @mood.getNthDate(1)
    #puts "Created Date is "  + createdDateTime


    @mood.clickNthMood(1)

    !45.times{ break if (@mood.isSaveExistingEventButtonVisible()); sleep 1 }
    expect(@mood.isSaveExistingEventButtonVisible()).to be true

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @mood.getDateInForm()
    #puts "Date in the form " + dateInForm

    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))

    expect(@mood.getMoodRangeValue()).to eq("4")
    expect(@mood.getNarrative()).to eq("Not happy!")

    #Edit
    @mood.moveMoodRangeToLeft(3)
    @mood.setNarrativeText("Happy mood today")
    @mood.clickSaveBtn()

    !45.times{ break if (@mood.getNthScaleRange(1) == "1 out of 10"); sleep 1 }
    expect(@mood.getNthScaleRange(1)).to eq("1 out of 10")

    expect(@mood.getMessageInEventDetail()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry.")

    #Delete
    @mood.clickNthMood(1)
    !45.times{ break if (@mood.isDeleteButtonVisible()); sleep 1 }
    expect(@mood.isDeleteButtonVisible()).to be true
    @mood.clickDeleteBtn()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()
    sleep 1
    !45.times{ break if (@mood.isDeleteButtonVisible()); sleep 1 }
    expect(@mood.isDeleteButtonVisible()).to be true

    @mood.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !45.times{ break if (@mood.getMoodCount() == 0); sleep 1 }

    #Notification message validation when user leaving current screen without saving the content
    twentyDaysAgo = getDateNthDaysAgo(20, "%m/%d/%Y")
    addMood(twentyDaysAgo, 1, "feel great today")
    #validating changing date and time for date entry
    expect(@mood.getNthDate(1)).to eq (twentyDaysAgo)

    !45.times{ break if (@mood.getMoodCount() > 0); sleep 1 }
    expect(@mood.getMoodCount()).to eq(1)

    @mood.clickNthMood(1)

    !45.times{ break if (@mood.isSaveExistingEventButtonVisible()); sleep 1 }
    expect(@mood.isSaveExistingEventButtonVisible()).to be true
    @mood.setNarrativeText("feel great - edited")
    @mood.clickAddBtn()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if (@mood.getPrimaryHeader() == "Mood Detail"); sleep 1 }
    expect(@mood.getPrimaryHeader()).to eq("Mood Detail")

    expect(@mood.getNarrative()).to eq("feel great - edited")

    @mood.clickAddBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickContinueButton()

    !45.times{ break if (@mood.getPrimaryHeader() == "Mood Detail"); sleep 1 }
    expect(@mood.getPrimaryHeader()).to eq("Mood Detail")

    @mood.clickNthMood(1)
    !45.times{ break if (@mood.isSaveExistingEventButtonVisible()); sleep 1 }
    expect(@mood.isSaveExistingEventButtonVisible()).to be true

    @mood.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !45.times{ break if (@mood.getMoodCount() == 0); sleep 1 }

  end

  it "AC #JRNL-237| TC #JRNL-370:  Narrative will be limited to 250 characters with a countdown display", :broken => true do
    @mood.clickAddBtn()
    @mood.moveMoodRangeToRight(2)
    @mood.setNarrativeText("Having a headache and not feeling well")
    charsLeft = 250 - @mood.getNarrativeTextLength()
    expect(@mood.getNarrativeCounterText()).to eq(charsLeft.to_s + " characters left")

    @mood.setNarrativeText("Having a headache and not feeling well edited")
    charsLeft = 250 - @mood.getNarrativeTextLength()
    expect(@mood.getNarrativeCounterText()).to eq(charsLeft.to_s + " characters left")

    narrativeText = "123456789012345678901234567890"
    expect(narrativeText.length()).to eq(30)

    @mood.setNarrativeText(narrativeText)
    expect(@mood.getNarrativeTextLength()).to eq(30)
    expect(@mood.getNarrativeCounterText()).to eq("220 characters left")

    narrativeText = "12345678901234567890123456789012345678"
    expect(narrativeText.length()).to eq(38)

    @mood.setNarrativeText(narrativeText)
    expect(@mood.getNarrativeTextLength()).to eq(38)
    expect(@mood.getNarrativeCounterText()).to eq("212 characters left")

    narrativeText = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789 "
    expect(narrativeText.length).to eq(280)

    @mood.setNarrativeText(narrativeText)
    expect(@mood.getNarrativeTextLength()).to eq(250)
    expect(@mood.getNarrativeCounterText()).to eq("0 characters left")

    @mood.clickCancelBtn()
  end

  it "AC #JRNL-341| TC #JRNL-370 |AC #JRNL-511| TC #JRNL-540: Multiple entries in reverse chronological order; Allow date time change for date entry", :broken => true do
    moodCount = @mood.getMoodCount()
    nineteenDaysAgo = getDateNthDaysAgo(19, "%m/%d/%Y")
    addMood(nineteenDaysAgo, 1, "feel great today")
    #validating changing date and time for date entry
    expect(@mood.getNthDate(1)).to eq (nineteenDaysAgo)

    !45.times{ break if (@mood.getMoodCount() > moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount + 1)

    moodCount = @mood.getMoodCount()
    sixteenDaysAgo = getDateNthDaysAgo(16, "%m/%d/%Y")
    addMood(sixteenDaysAgo, 2, "Happy day")

    !45.times{ break if (@mood.getMoodCount() > moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount + 1)

    moodCount = @mood.getMoodCount()
    twelveDaysAgo = getDateNthDaysAgo(12, "%m/%d/%Y")
    addMood(twelveDaysAgo, 7, "Bad mood")

    !45.times{ break if (@mood.getMoodCount() > moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount + 1)

    moodCount = @mood.getMoodCount()
    tenDaysAgo = getDateNthDaysAgo(10, "%m/%d/%Y")
    addMood(tenDaysAgo, 2, "Good mood")

    !45.times{ break if (@mood.getMoodCount() > moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount + 1)

    moodCount = @mood.getMoodCount()
    fiveDaysAgo = getDateNthDaysAgo(5, "%m/%d/%Y")
    addMood(fiveDaysAgo, 4, "Not bad")

    !45.times{ break if (@mood.getMoodCount() > moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount + 1)

    #Add sorting order validation
    fourtyDaysAgo = getDateNthDaysAgo(40, "%Y-%m-%d")
    updateLogTimeMoodTable("D123401", "Not bad", "4", fourtyDaysAgo)

    twentySevenDaysAgo = getDateNthDaysAgo(27, "%Y-%m-%d")
    updateLogTimeMoodTable("D123401", "Good mood", "2", twentySevenDaysAgo)

    twelveDaysAgo = getDateNthDaysAgo(12, "%Y-%m-%d")
    updateLogTimeMoodTable("D123401", "Bad mood", "7", twelveDaysAgo)

    sevenDaysAgo = getDateNthDaysAgo(7, "%Y-%m-%d")
    updateLogTimeMoodTable("D123401", "Happy day", "2", sevenDaysAgo)

    twoDaysAgo = getDateNthDaysAgo(2, "%Y-%m-%d")
    updateLogTimeMoodTable("D123401", "feel great today", "1", twoDaysAgo)

    refreshBrowser()

    expect(@mood.getMoodCount()).to eq(4)

    expect(@mood.getNthScaleRange(1)).to eq("1 out of 10")
    expect(@mood.getNthScaleRange(2)).to eq("2 out of 10")
    expect(@mood.getNthScaleRange(3)).to eq("7 out of 10")
    expect(@mood.getNthScaleRange(4)).to eq("2 out of 10")

    eightTeen = getDateNthDaysAgo(18, "%Y-%m-%d")
    updateLogTimeMoodTable("D123401", "Not bad", "4", eightTeen)

    refreshBrowser()

    expect(@mood.getMoodCount()).to eq(5)

    expect(@mood.getNthScaleRange(1)).to eq("1 out of 10")
    expect(@mood.getNthScaleRange(2)).to eq("2 out of 10")
    expect(@mood.getNthScaleRange(3)).to eq("7 out of 10")
    expect(@mood.getNthScaleRange(4)).to eq("4 out of 10")
    expect(@mood.getNthScaleRange(5)).to eq("2 out of 10")

  end

  it "AC #JRNL-342 | TC #JRNL-370: Default display to last 30 days", :broken => true do
    refreshBrowser()
    expect(@mood.is30DaysRange()).to be true
    expect(@mood.isDatesWithinFilteredDateRange?()).to be true

    #delete all mood entries
    moodCount = @mood.getMoodCount()
    deleteNthMood(3)
    !45.times{ break if (@mood.getMoodCount() < moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount -1)

    moodCount = @mood.getMoodCount()
    deleteNthMood(4)
    !45.times{ break if (@mood.getMoodCount() < moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount -1)

    moodCount = @mood.getMoodCount()
    deleteNthMood(3)
    !45.times{ break if (@mood.getMoodCount() < moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount -1)

    moodCount = @mood.getMoodCount()
    deleteNthMood(2)
    !45.times{ break if (@mood.getMoodCount() < moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount -1)

    moodCount = @mood.getMoodCount()
    deleteNthMood(1)
    !45.times{ break if (@mood.getMoodCount() < moodCount); sleep 1 }
    expect(@mood.getMoodCount()).to eq(moodCount -1)

  end

  it "AC #JRNL-719,720,723|TC #JRNL-744: Error message presentation; Required field validation; Validation information in error messages", :broken => true do

    @mood.clickAddBtn()
    #Required fields testing on Date
    requiredFieldTest("Date", "Date field is required.")

  end

  def addMood(dateStr, moodRange, narrativeText)
    #Add
    @mood.clickAddBtn()
    !45.times{ break if (@mood.getPrimaryHeader() == "Mood Detail"); sleep 1 }
    expect(@mood.getPrimaryHeader()).to eq("Mood Detail")

    setDate(dateStr, "input[name='date']")
    stepToMove = moodRange -5

    if(stepToMove < 0)
      @mood.moveMoodRangeToLeft(stepToMove * -1)
    else
      @mood.moveMoodRangeToRight(stepToMove)
    end

    @mood.setNarrativeText(narrativeText)
    @mood.clickSaveNewBtn()
  end

  def deleteNthMood(number)
    @mood.clickNthMood(number)
    !45.times{ break if (@mood.isDeleteButtonVisible()); sleep 1 }
    expect(@mood.isDeleteButtonVisible()).to be true
    @mood.clickDeleteBtn()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    #puts "[deleteNthMood ] " + number.to_s + " Nth mood deleted"
  end


  def checkingInlineError(errMsg)

    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("moodForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("moodForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("moodForm", errMsg)).to be true

  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @mood.clickSaveNewBtn()
    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

end
