
require_relative '../../globalized'
include Globalized

describe "[Story#JRNL-57|JRNL-497: Height_JRNL_57_spec.rb]", :broken => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAllRecordsFromTable("VITAL_OBSERVATION")
    deleteAllRecordsFromTable("VITAL_ENTRY")
    initializeAllObjects
    VITALS_BTN = "Vitals"
    HEIGHT_BTN = "ul.secondary-list li:nth-of-type(4) button span.ng-binding"

    !45.times { break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times { break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times { break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times { break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible(VITALS_BTN)).to be true
    @vitals.clickVitals()

    !45.times { break if (@vitals.getTitle() == "Vitals"); sleep 1 }
    expect(@vitals.getTitle()).to eq("Vitals")

  end

  after (:all) do
    quitDriver()
  end

  it "AC #JRNL-394|TC #JRNL-601: Height will be a topic under Vitals from the left Navigation Menu" do

    expect(@vitals.isThisButtonVisible(HEIGHT_BTN)).to be true
  end

  it "AC#JRNL-395|TC#JRNL-601|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586: Error message presentation and Required fields validation; User will be able to ADD/EDIT/DELETE entries; Display 'Height' with '(in)' Boundary Test for Height; Verify the max allowed characters for Note" do

    @vitals.clickThisButton(HEIGHT_BTN)
    @vitals.clickAddBtn()

    #Verifying Screen Headers
    expect(@vitals.getSecondaryHeader()).to eq("Vitals")
    expect(@vitals.getPrimaryHeader()).to eq ("Enter Height")

    expect(@vitals.getNthLabelHeight()).to eq("Height (in):")

    @vitals.clickCancelBtn()

    #Display a message in the detailed pane when no records exist

    !45.times { break if (@vitals.getMessageInDetail() == "No results found."); sleep 1 }
    expect(@vitals.getMessageInDetail()).to eq("No results found.")

    respirationCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    puts today

    morningTime = "07:00 AM"
    afterNoonTime = "03:00 PM"
    eveningTime = "10:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")

    #Morning
    addAndVerifyAHeight(yesterday, morningTime, "60", "Average")

    #Afternoon
    addAndVerifyAHeight(yesterday, afterNoonTime, "72", "Tall")

    #Evening
    addAndVerifyAHeight(yesterday, eveningTime, "84", "Giant")


    #Validate max 250 characters for Note
    @vitals.clickAddBtn()

    !45.times { break if (@vitals.getPrimaryHeader() == "Enter Height"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Enter Height")

    expect(@vitals.verifyTotalCharacterInNote()).to be true

    #Boundary Test Max
    boundaryTestMax("Height", "Height (in) is outside the expected range. Please enter a value between 0 and 96.")

    #Required fields testing on Date and Time
    requiredFieldTest("Date", "Date field is required.")
    requiredFieldTest("Time", "Time field is required.")

    #Required fields testing on Height
    #Without providing any values to the this field, we'll be getting the following error message
    @vitals.clickSaveNewBtn()
    sleep 1
    checkingInlineError("Height (in) field is required.")

    #Click Cancel to exit
    @vitals.clickCancelBtn()
    #End of JRNL-497 validation

    #Edit an existing Height
    @vitals.clickNthVital(3)

    !45.times { break if (@vitals.getPrimaryHeader() == "Edit Height"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Edit Height")

    #Change Height to 90
    @vitals.editAHeight(90)

    sleep 2

    #Verify that the 3rd entry has the new Height reading (90)
    expect(@vitals.getNthRespHeightWeightInList(3)).to eq("90")

  end

  it "AC #JRNL-396|TC #JRNL-601 Entries will be sorted in reverse chronological order" do

    expect(@vitals.getNthTimeInRespHeightWeightList(3)).to eq("07:00 AM")
    expect(@vitals.getNthTimeInRespHeightWeightList(2)).to eq("03:00 PM")
    expect(@vitals.getNthTimeInRespHeightWeightList(1)).to eq("10:00 PM")

  end

  it "AC #JRNL-395|TC #JRNL-601: User should be able to DELETE entries" do
    deleteNthHeight("07:00 AM")
    deleteNthHeight("03:00 PM")
    deleteNthHeight("10:00 PM")
  end

  it "AC #JRNL-396|TC #JRNL-601: Display User Entered Data" do
    #Default Display to last 30 days displaying start and end date
    #Allow User to change date range(date picker will be in another story)


    #Verify that by default, the date range is set to last 30 days
    expect(@vitals.verifyDefaultDateRangeIs30DaysBack()).to be true

    #Set the date range to 2 years back so all the entered data will show up
    toDate = @vitals.getDateNthDaysAgo(0, "%m/%d/%Y")  #set it to Today
    fromDate = @vitals.getDateNthDaysAgo(730, "%m/%d/%Y") #set it to two year ago

    @vitals.setDateRange(fromDate, toDate)

    #Populate the list of the meals again
    heightCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    tenDaysAgo = getDateNthDaysAgo(10, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    addAndVerifyAHeight(thirtyDaysAgo, morningTime, "84", "Feeling Tall")
    addAndVerifyAHeight(tenDaysAgo, noonTime, "72", "Feeling Average")
    addAndVerifyAHeight(twoDaysAgo, eveningTime, "60", "Feeling Short")

    # @vitals.clickFilterBtn()

    setDateRangeAndValidate(3, 0, "06:00 PM") #to show the twoDaysAgo entry
    setDateRangeAndValidate(11, 3, "12:00 PM") #to show the tenDaysAgo entry
    setDateRangeAndValidate(35, 29, "08:00 AM") #to show the thirtyDaysAgo entry

    refreshBrowser()

  end


  #Local Functions

  def addAndVerifyAHeight(dateStr, timeStr, height, note)
    heightCount = @vitals.getTotalCount()
    puts heightCount

    @vitals.addHeight(dateStr, timeStr, height, note)

    !45.times { break if (@vitals.getTotalCount() == (heightCount + 1)); sleep 1 }
    expect(@vitals.getTotalCount()).to eq(heightCount + 1)

    rowIndex = @vitals.findIndexWithAGivenTime(timeStr)

    expect(@vitals.getNthTimeInRespHeightWeightList(rowIndex)).to eq(timeStr)
    expect(@vitals.getNthRespHeightWeightInList(rowIndex)).to eq(height)

  end

  def checkingInlineError(errMsg)

    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("vitalsForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("vitalsForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("vitalsForm", errMsg)).to be true

  end

  def boundaryTestMax(testArea, errMsg)

    case testArea
      when "Height" then
        @vitals.setHeight(97)


    end

    @vitals.clickSaveNewBtn()
    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    case testArea
      when "Height" then
        @driver.find_element(:css, "input[name='Height']").clear
    end

  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @vitals.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("vitalsForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("vitalsForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("vitalsForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

  def deleteNthHeight(time)
    heightCount = @vitals.getTotalCount()
    listIndex = @vitals.findIndexWithAGivenTime(time)
    @vitals.clickNthVital(listIndex)
    !45.times{ break if (@vitals.getPrimaryHeader() == "Edit Height"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Edit Height")

    @vitals.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()

    !45.times{ break if (@vitals.getPrimaryHeader() == "Edit Height"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Edit Height")
    sleep 1

    @vitals.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !45.times{ break if ( @vitals.getTotalCount() == (heightCount - 1)); sleep 1 }
    expect(@vitals.getTotalCount()).to eq(heightCount - 1)

    expect(@vitals.isThisRecordDisplayed?(time)).to be false

  end

  def setDateRangeAndValidate(numOfDaysAgoFromDate, numOfDaysAgoToDate, time)
    respHeightWeightCount = @vitals.getTotalCount()

    toDate = @vitals.getDateNthDaysAgo(numOfDaysAgoToDate, "%m/%d/%Y")  #set it to Today
    fromDate = @vitals.getDateNthDaysAgo(numOfDaysAgoFromDate, "%m/%d/%Y")

    #@vitals.clickFilterBtn
    @vitals.setDateRange(fromDate, toDate)

    expect(@vitals.isThisRecordDisplayed?(time)).to be true

    expect(@vitals.isDateWithinFilteredDateRange?()).to be true

    !45.times{ break if (@vitals.getTotalCount() == 1); sleep 1 }

  end

end