require_relative '../../globalized'
include Globalized



describe "[Story#JRNL-61: Graph My Vital Signs: View Tracked Items Over Time -- Story#JRNL-805: Detail Page table view guidance - update vital]" , :broken => true, :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAllRecordsFromTable("VITAL_OBSERVATION")
    deleteAllRecordsFromTable("VITAL_ENTRY")
    initializeAllObjects
	@bpentries = Array.new
	@respentries = Array.new
	@tempentries = Array.new
	@heightentries = Array.new
	@weightentries = Array.new

    VITALS_BTN = "Vitals"

    !45.times { break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times { break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times { break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times { break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu
	sleep 1 # in order to get the snap menu event to finish, and start listening for a nav menu click event
    !45.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible(VITALS_BTN)).to be true
    @nav_menu.clickVitals

    !45.times { break if (@vitals.getVitalIntroText == "Select an item from the Vitals list to view details or add a new Vitals entry."); sleep 1 }
    expect(@vitals.getVitalIntroText).to eq("Select an item from the Vitals list to view details or add a new Vitals entry.")

  end

  after (:all) do
    quitDriver()
  end

  it "AC #JRNL-547|TC #JRNL-584: The graph will display the date range that is currently being displayed" do

    # Populate entries for all vitals, 30 days ago, 15 days ago, and yesterday
    @vitals.click_bp_btn
    !45.times { break if (@vitals.getPrimaryHeader() == "Blood Pressure Summary"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq('Blood Pressure Summary') # Check if in BP section
    add_five_bps

    @vitals.click_resp_btn
    !45.times { break if (@vitals.getPrimaryHeader() == "Respiration Summary"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq('Respiration Summary') # Check if in RESP section
    add_five_resps

    @vitals.click_temp_btn
    !45.times { break if (@vitals.getPrimaryHeader() == "Temperature Summary"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq('Temperature Summary') # Check if in TEMP section
    add_five_temps

    @vitals.click_height_btn
    !45.times { break if (@vitals.getPrimaryHeader() == "Height Summary"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq('Height Summary') # Check if in HEIGHT section
    add_five_heights

    @vitals.click_weight_btn
    !45.times { break if (@vitals.getPrimaryHeader() == "Weight Summary"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq('Weight Summary') # Check if in WEIGHT section
    add_five_weights
    sleep 1

    verify_graph_and_filter_dates

    rubydata = @graph.get_json_entries("BP", @filter.getStartDate, @filter.getEndDate)

    rubydata["vitalEntry"].length.times do |idx|
      if rubydata["vitalEntry"][idx]["section"] == "BP"
        @bpentries.push(rubydata["vitalEntry"][idx])

      elsif rubydata["vitalEntry"][idx]["section"] == "respiration"
        @respentries.push(rubydata["vitalEntry"][idx])

      elsif rubydata["vitalEntry"][idx]["section"] == "temperature"
        @tempentries.push(rubydata["vitalEntry"][idx])

      elsif rubydata["vitalEntry"][idx]["section"] == "height"
        @heightentries.push(rubydata["vitalEntry"][idx])

      elsif rubydata["vitalEntry"][idx]["section"] == "weight"
        @weightentries.push(rubydata["vitalEntry"][idx])
      end
    end

    @arrayofentries = [@bpentries, @respentries, @tempentries, @heightentries, @weightentries]

    @arrayofentries.length.times do |idx|
      @arrayofentries[idx] = @graph.filter_graph_points(@arrayofentries[idx])
    end


    @arrayofentries.each do |entries|
      expect(entries.length).to eq(3)
    end

  end

  it "AC #JRNL-548|TC #JRNL-584: Display Graph in detail pane" do
    @vitals.click_bp_btn
    @graph.click_graph_and_table_btn
	sleep 1
    begin
      element = @driver.find_element(:id, 'vitalsChart') # see if chart is contained within primary view
      expect(element.displayed?).to be(true)
    rescue Exception=>e
      return false
    end


    # Appropriate y-axis values for BP
    @vitals.click_bp_btn
	@graph.click_graph_and_table_btn
    systolic = @bpentries[0]['vitalObservations'][0]['valueUnits'].to_s
    diastolic = @bpentries[0]['vitalObservations'][1]['valueUnits'].to_s
    pulse = @bpentries[0]['vitalObservations'][2]['valueUnits'].to_s
	puts systolic
	puts diastolic
	puts pulse
	expect(systolic).to eq('mm[Hg]')
	expect(diastolic).to eq('mm[Hg]')
	expect(pulse).to eq('bpm')

    # Appropriate y-axis values for RESP
    @vitals.click_resp_btn
    @graph.click_graph_and_table_btn
	respiration_label = @respentries[0]['vitalObservations'][0]['valueUnits'].to_s
	puts respiration_label
	expect(respiration_label).to eq('/minutes')

    # Appropriate y-axis values for TEMP
    @vitals.click_temp_btn
    @graph.click_graph_and_table_btn
	temperature_label = @tempentries[0]['vitalObservations'][0]['valueUnits'].to_s
	puts temperature_label
	expect(temperature_label).to eq('F')

    # Appropriate y-axis values for HEIGHT
	@vitals.click_height_btn
	@graph.click_graph_and_table_btn
	height_label = @heightentries[0]['vitalObservations'][0]['valueUnits'].to_s
	puts height_label
	expect(height_label).to eq('Inches')

    # Appropriate y-axis values for WEIGHT
	@vitals.click_weight_btn
	@graph.click_graph_and_table_btn
	weight_label = @weightentries[0]['vitalObservations'][0]['valueUnits'].to_s
	puts weight_label
	expect(weight_label).to eq('Pounds')


    # Check to make sure "A text description of the information on this page is available in the Table tab."
    above_graph_text = 'A text description of the information on this page is available in the table view.'
    @vitals.click_bp_btn
    @graph.click_graph_and_table_btn
    expect(@graph.get_heading_text).to eq(above_graph_text)
    @vitals.click_resp_btn
    @graph.click_graph_and_table_btn
    expect(@graph.get_heading_text).to eq(above_graph_text)
    @vitals.click_temp_btn
    @graph.click_graph_and_table_btn
    expect(@graph.get_heading_text).to eq(above_graph_text)
    @vitals.click_height_btn
    @graph.click_graph_and_table_btn
    expect(@graph.get_heading_text).to eq(above_graph_text)
    @vitals.click_weight_btn
    @graph.click_graph_and_table_btn
    expect(@graph.get_heading_text).to eq(above_graph_text)

  end

  it "AC #JRNL-549|TC #JRNL-584: Table View can be selected - AC#JRNL-830:  Text description guidance text update" do

	@vitals.click_bp_btn
	verify_filter_dates_unchanged

	@vitals.click_resp_btn
	verify_filter_dates_unchanged

	@vitals.click_temp_btn
	verify_filter_dates_unchanged

	@vitals.click_height_btn
	verify_filter_dates_unchanged

	@vitals.click_weight_btn
	verify_filter_dates_unchanged

  end

  #Local Functions

  def add_five_bps
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    @vitals.addBP(thirtyDaysAgo, morningTime, "90", "80", "110", "Standing", "I fear no evil, for I am the baddest Mamma-Jamma alive")
    @vitals.addBP(thirtyDaysAgo, eveningTime, "110", "90", "120", "Sitting", "I want to eat ice cream and watch Friends")
    @vitals.addBP(fifteenDaysAgo, noonTime, "120", "90", "130", "Sitting", "I should not have eaten that Chinese food")
    @vitals.addBP(yesterday, eveningTime, "100", "80", "120", "Standing", "I should really stop eating Chinese")
    @vitals.addBP(yesterday, morningTime, "110", "100", "120", "Sitting", "I am happy")
  end

  def add_five_resps
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    @vitals.addRespiration(thirtyDaysAgo, morningTime, "30", "I feel Grrrrreat!")
    @vitals.addRespiration(fifteenDaysAgo, morningTime, "38", "Today was fun")
    @vitals.addRespiration(fifteenDaysAgo, noonTime, "40", "I'm thuper, thankth for athking.")
    @vitals.addRespiration(yesterday, morningTime, "38", "Today was a good day")
    @vitals.addRespiration(yesterday, eveningTime, "45", "My back hurts")
  end

  def add_five_temps
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    @vitals.addTemp(thirtyDaysAgo, eveningTime, "97", "Oral", "I blame the AC")
    @vitals.addTemp(thirtyDaysAgo, morningTime, "98", "Oral", "Everything is going well")
    @vitals.addTemp(fifteenDaysAgo, noonTime, "98", "Tympanic", "I feel OK")
    @vitals.addTemp(yesterday, morningTime, "99", "Rectal", "At least I'm alive, I guess")
    @vitals.addTemp(yesterday, eveningTime, "98", "Oral", "This thermometer tastes funny")
  end

  def add_five_heights
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    @vitals.addHeight(thirtyDaysAgo, morningTime, "67", "I don't feel like I'm getting shorter")
    @vitals.addHeight(fifteenDaysAgo, noonTime, "66", "That's weird...")
    @vitals.addHeight(yesterday, eveningTime, "65", "I should always take my measurements in the morning..")
    @vitals.addHeight(yesterday, morningTime, "67", "I can't complain.")
    @vitals.addHeight(yesterday, noonTime, "66", "I'm already an inch shorter?")
  end

  def add_five_weights
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    @vitals.addWeight(thirtyDaysAgo, morningTime, "215", "That's not so bad")
    @vitals.addWeight(thirtyDaysAgo, noonTime, "217", "uh oh")
    @vitals.addWeight(thirtyDaysAgo, eveningTime, "220", "I should really cut back on the Chinese Food")
    @vitals.addWeight(fifteenDaysAgo, noonTime, "210", "Sometimes I hate owning a resturaunt")
    @vitals.addWeight(yesterday, eveningTime, "190", "Oh wow, maybe I have lost too much weight. Is this healthy?")
  end

  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)
    return dateNthDaysAgo
  end

  def verify_graph_and_filter_dates
    @vitals.click_bp_btn

    # View Date range currently displayed and get current date values from Filter
    sd = @filter.getStartDate
    ed = @filter.getEndDate
    sdArray = sd.split('/')
    edArray = ed.split('/')
    sd_dmy = sdArray[1].to_s + '/' + sdArray[0].to_s + '/' + sdArray[2].to_s
    ed_dmy = edArray[1].to_s + '/' + edArray[0].to_s + '/' + edArray[2].to_s
    startingDate = @graph.convert_date_to_graph_format(sd_dmy)
    endingDate = @graph.convert_date_to_graph_format(ed_dmy)

    # Click Graph Button and get date values after Graph click from Filter
    @graph.click_graph_and_table_btn
	sleep 1
     expect(@vitals.getPrimaryHeader()).to include('Graph')  # making sure user is looking at graph
    nsd = @filter.getStartDate
    ned = @filter.getEndDate
    nsdArray = nsd.split('/')
    nedArray = ned.split('/')
    nsd_dmy = nsdArray[1].to_s + '/' + nsdArray[0].to_s + '/' + nsdArray[2].to_s
    ned_dmy = nedArray[1].to_s + '/' + nedArray[0].to_s + '/' + nedArray[2].to_s
    newStartDate = @graph.convert_date_to_graph_format(nsd_dmy)
    newEndDate = @graph.convert_date_to_graph_format(ned_dmy)

    # Check and make sure dates from Filter are the same after Graph Button Click
    expect(startingDate).to eq(newStartDate)
    expect(endingDate).to eq(newEndDate)

    # Check to see if dates reflected in Filter are displayed in the Graph
    graphStartDate = @graph.get_graph_start_date
    graphEndDate = @graph.get_graph_end_date

    gsd_array = graphStartDate.split(" ") # graph start date month and day
    ged_array = graphEndDate.split(" ") # graph end date month and day
    fsd_array = startingDate.split(" ") # filter start date month and day
    fed_array = endingDate.split(" ") # filter end date month and day

    if startingDate != graphStartDate || endingDate != graphEndDate
      if gsd_array[0] == fsd_array[0] && ged_array[0] == fed_array[0] # months are equal but days are not
        expect(gsd_array[1].to_i).to be_within(2).of(fsd_array[1].to_i) # days are off by 1
      end
    else
      expect(startingDate).to eq(graphStartDate)
      expect(endingDate).to eq(graphEndDate)
    end

  end

  def verify_filter_dates_unchanged
	  above_graph_text = 'A text description of the information on this page is available in the table view.'

	  @graph.click_graph_and_table_btn
    #AC-JRNL-830
	  expect(@graph.get_heading_text).to eq(above_graph_text)
	  startingDate = @filter.getStartDate
	  endingDate = @filter.getEndDate

	  @graph.click_graph_and_table_btn
	  expect(@vitals.getPrimaryHeader()).to include('Summary')
	  newStartDate = @filter.getStartDate
	  newEndDate = @filter.getEndDate
	  # Check and make sure dates from Filter are the same after Table Button Click
	  expect(startingDate).to eq(newStartDate)
	  expect(endingDate).to eq(newEndDate)
  end

end