require_relative '../../globalized'
include Globalized

describe "[Story#JRNL-480: Graph My Pain Entries]", :broken => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAllRecordsFromTable("VITAL_OBSERVATION")
    deleteAllRecordsFromTable("VITAL_ENTRY")
    initializeAllObjects
    @pain_entries = Array.new
    @pain_entries_filtered = Array.new

    PAIN_BTN = "Pain"

    !45.times { break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times { break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times { break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times { break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu
    sleep 1 # in order to get the snap menu event to finish, and start listening for a nav menu click event
    !45.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible(PAIN_BTN)).to be true
    @nav_menu.clickPain

    !45.times { break if (@pain.getTitle() == "Pain"); sleep 1 }
    expect(@pain.getTitle()).to eq("Pain")

  end

  after (:all) do
    quitDriver()
  end

  it "AC #JRNL-550|TC #JRNL-755: User can select date range for pain graph view" do

    # Populate entries for pain, 30 days ago, 15 days ago, and yesterday
    add_six_pains
    sleep 1

    add_one_extra_pain # adds an entry for pain 45 days ago, to ensure graph changes when filter changes
    verify_filter_manual_entry # ensures filter dates can be changed manually
    verify_graph_and_filter_dates # ensures that the dates in the filter do not change after clicking graph button, and makes sure the dates in the graph match up with dates in filter

    # refresh page to reset filter to 30 days ago
    @driver.navigate.refresh
    sleep 2

    # ensure dates default to the last 30 days
    verify_graph_and_filter_dates # since this test relies on the entries made 30 days ago to yesterday, if it passes, then the dates reflect the last thirty days

  end

  it "AC #JRNL-553|TC #JRNL-755: User will be able to see table view" do

    # ensure list view ("table view" in Acceptance Criteria) can be navigated to
    @driver.manage.window.resize_to(320, 480)
    sleep 1

    arrow_btn = @driver.find_element(:css, '.primary-header > button')

    if arrow_btn.displayed?
      arrow_btn.click
      sleep 1
      expect(@driver.find_element(:css, 'ul.secondary-list').displayed?).to eq(true)
    else # in case where list view is already displayed
      expect(@driver.find_element(:css, 'ul.secondary-list').displayed?).to eq(true)
    end

    # since it can be navigated to, we will increase browser size and continue with next test
    @driver.manage.window.resize_to(1040, 600)
    @driver.navigate.refresh
    sleep 3

    # selecting table view will display the same date range that was last selected
    verify_graph_and_filter_dates
  end

  it "AC #JRNL-554|TC #JRNL-755: User can select graph and see graph view" do

    # selecting graph produces/displays the graphed data in the main screen
    # appropriate x values
    verify_graph_and_filter_dates # since this test grabs the dates currently displayed in graph, we know the x values display dates, and that they're the dates currently selected in the filter

    # appropriate y values
    rubydata = @graph.get_json_entries("pain", @filter.getStartDate, @filter.getEndDate)

    rubydata["vitalEntry"].length.times do |idx|
      @pain_entries.push(rubydata["vitalEntry"][idx])
    end

    y_value = @pain_entries[0]['vitalObservations'][0]['type'].to_s
    expect(y_value).to eq('pain')

    # For days with multiple data points for a given parameter, only the last will be graphed
    @pain_entries_filtered = @graph.filter_graph_points(@pain_entries)
    expect(@pain_entries_filtered.length).to eq(4) # 4 entries including the one made 45 days ago for test JRNL-550

    # Legend will describe data and label
    legend_str = @graph.get_legend_text
    expect(legend_str).to eq('Pain')

    # Include text with each graph that states: "A text description of the information..."
    above_graph_text = 'A text description of the information on this page is available in the list view.'
    expect(@graph.get_heading_text).to eq(above_graph_text)

    # Display Level label: Pain Level (0=No pain, 10=Agonizing)
    y_level_label = 'Pain (0=None - 10=Agonizing)'
    expect(y_level_label).to eq(getTextForElement(:css, '.highcharts-yaxis-title > tspan'))
  end

  #Local Functions

  def add_six_pains
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    @pain.add_pain_entry(thirtyDaysAgo, morningTime, 2, 'My kankle feels swollen')
    @pain.add_pain_entry(thirtyDaysAgo, noonTime, 0, 'I am feeling great!')
    @pain.add_pain_entry(thirtyDaysAgo, eveningTime, 1, 'Kankle slightly sore but OK')
    @pain.add_pain_entry(fifteenDaysAgo, eveningTime, 5, 'My chest is hurting')
    @pain.add_pain_entry(fifteenDaysAgo, noonTime, 3, 'I think I drank too much coffee or something')
    @pain.add_pain_entry(yesterday, morningTime, 8, 'My chest has not stopped pounding since this morning')
    @pain.add_pain_entry(yesterday, eveningTime, 10, 'I am having a heart attack again')
  end

  def add_one_extra_pain
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    eveningTime = "08:00 PM"
    fourtyFiveDaysAgo = getDateNthDaysAgo(45, "%m/%d/%Y")

    @pain.add_pain_entry(fourtyFiveDaysAgo, eveningTime, 5, 'I think I was having some pain on this day')

  end

  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)
    return dateNthDaysAgo
  end

  def verify_filter_manual_entry
    #change start date and end date manually to be from 45 days ago to 15 days ago
    @filter.setDateRange(getDateNthDaysAgo(45, "%m/%d/%Y"), getDateNthDaysAgo(15, "%m/%d/%Y"))
    @filter.clickFilterBtn
    start_date = @filter.getStartDate
    end_date = @filter.getEndDate

    expect(start_date).to eq(getDateNthDaysAgo(45, "%m/%d/%Y"))
    expect(end_date).to eq(getDateNthDaysAgo(15, "%m/%d/%Y"))
  end

  def verify_graph_and_filter_dates

    # View Date range currently displayed and get current date values from Filter
    sd = @filter.getStartDate
    ed = @filter.getEndDate
    sdArray = sd.split('/')
    edArray = ed.split('/')
    sd_dmy = sdArray[1].to_s + '/' + sdArray[0].to_s + '/' + sdArray[2].to_s
    ed_dmy = edArray[1].to_s + '/' + edArray[0].to_s + '/' + edArray[2].to_s
    startingDate = @graph.convert_date_to_graph_format(sd_dmy)
    endingDate = @graph.convert_date_to_graph_format(ed_dmy)
    # puts startingDate
    # puts endingDate

    # Click Graph Button and get date values after Graph click from Filter
    @graph.click_graph_btn
    sleep 2
    expect(@pain.getPrimaryHeader()).to eq ("Pain Graph")# making sure user is looking at graph
    nsd = @filter.getStartDate
    ned = @filter.getEndDate
    nsdArray = nsd.split('/')
    nedArray = ned.split('/')
    nsd_dmy = nsdArray[1].to_s + '/' + nsdArray[0].to_s + '/' + nsdArray[2].to_s
    ned_dmy = nedArray[1].to_s + '/' + nedArray[0].to_s + '/' + nedArray[2].to_s
    newStartDate = @graph.convert_date_to_graph_format(nsd_dmy)
    newEndDate = @graph.convert_date_to_graph_format(ned_dmy)
    # puts newStartDate
    # puts newEndDate

    # Check and make sure dates from Filter are the same after Graph Button Click
    expect(startingDate).to eq(newStartDate)
    expect(endingDate).to eq(newEndDate)

    # Check to see if dates reflected in Filter are displayed in the Graph
    graphStartDate = @graph.get_graph_start_date
    graphEndDate = @graph.get_graph_end_date

    gsd_array = graphStartDate.split(" ") # graph start date month and day
    ged_array = graphEndDate.split(" ") # graph end date month and day
    fsd_array = startingDate.split(" ") # filter start date month and day
    fed_array = endingDate.split(" ") # filter end date month and day

    # puts gsd_array.to_s
    # puts ged_array.to_s
    # puts fsd_array.to_s
    # puts fed_array.to_s

    if startingDate != graphStartDate || endingDate != graphEndDate
      if gsd_array[0] == fsd_array[0] && ged_array[0] == fed_array[0] # months are equal but days are not
        expect(gsd_array[1].to_i).to be_within(2).of(fsd_array[1].to_i) # days are off by 1
      end
    else
      expect(startingDate).to eq(graphStartDate)
      expect(endingDate).to eq(graphEndDate)
    end

  end

  def verify_filter_dates_unchanged
    above_graph_text = 'A text description of the information on this page is available in the Table tab.'

    @graph.click_graph_and_table_btn
    expect(@graph.get_heading_text).to eq(above_graph_text)
    startingDate = @filter.getStartDate
    endingDate = @filter.getEndDate

    @graph.click_graph_and_table_btn
    expect(getCurrentURL).to include(BASE_URL + '/#/vitals/table?')
    newStartDate = @filter.getStartDate
    newEndDate = @filter.getEndDate
    # Check and make sure dates from Filter are the same after Table Button Click
    expect(startingDate).to eq(newStartDate)
    expect(endingDate).to eq(newEndDate)
  end

end