require_relative '../../globalized'
include Globalized


describe "[ Story#JRNL-63|JRNL-497: DailyEvents_Image_Attachment_JRNL_63_spec.rb] ", :broken => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteDailyEventTable("D123401")

    initializeAllObjects
    @photo = File.new("resources")

    ADD_ATTACHMENT_BTN = "button[name='addEventAttachment']"
    MODAL_CANCEL = "div.modal-content div.modal-footer button:first-child"
    MODAL_SAVE = "div.modal-content div.modal-footer button:last-child"
    FIRST_IMAGE = ".attachments tr:nth-of-type(1) a"
    SECOND_IMAGE = ".attachments tr:nth-of-type(2) a"
    THIRD_IMAGE = ".attachments tr:nth-of-type(3) a"
    FOURTH_IMAGE = ".attachments tr:nth-of-type(4) a"
    DELETE_FIRST_IMAGE = ".attachments tr:nth-of-type(1) button"
    DELETE_SECOND_IMAGE = ".attachments tr:nth-of-type(2) button"
    DELETE_THIRD_IMAGE = ".attachments tr:nth-of-type(3) button"
    DELETE_FOURTH_IMAGE = ".attachments tr:nth-of-type(4) button"

    !45.times { break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times { break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times { break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times { break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isDailyEventsButtonVisible()).to be true
    @nav_menu.clickDailyEvents()

    !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    expect(@events.getTitle()).to eq("Daily Events")

  end

  after(:all) do
    quitDriver()
  end

  it "AC#JRNL-859,861|AC#542,543,544|TC#JRNL-976|TC#JRNL-586|AC #JRNL-862|TC #JRNL-989:  PDF View button: Daily Events Attachment Fields|Attachment Upload|Error Messages" do
    #Detail View Add Mode
    @events.clickAddEvent()

    #Verifying Label, Instructional Text and presence of Add Button
    puts getTextForElement(:css, "div h5")
    expect(@events.getAttachmentLabel()).to eq("Attachments:")
    expect(@events.isThisButtonVisible(ADD_ATTACHMENT_BTN)).to be true

    #Detail View Edit Mode
    twentyfiveDaysAgo = getDateNthDaysAgo(25, "%m/%d/%Y")
    morningTime = "08:00 AM"

    @events.addNewEvent( twentyfiveDaysAgo, morningTime, "Took Tylenol in the morning. Took a walk for 30 min","Writing note is optional")

    @events.clickNthEvent(1)

    #Verifying Label, Instructional Text and presence of Add Button
    puts getTextForElement(:css, "div h5")
    expect(@events.getAttachmentLabel()).to eq("Attachments:")
    expect(@events.isThisButtonVisible(ADD_ATTACHMENT_BTN)).to be true


    #Adding an attachments and making sure user is returned to Detail View, Attached filename is visible and Delete buttons are visible next to the respective file names
    @events.addImageAttachment("spidey.jpg")

    expect(@events.getPrimaryHeader()).to eq("Event Detail")
    expect(@events.isThisButtonVisible(FIRST_IMAGE)).to be true
    expect(@events.isThisButtonVisible(DELETE_FIRST_IMAGE)).to be true

    @events.addImageAttachment("imgo.jpeg")

    expect(@events.getPrimaryHeader()).to eq("Event Detail")
    expect(@events.isThisButtonVisible(SECOND_IMAGE)).to be true
    expect(@events.isThisButtonVisible(DELETE_SECOND_IMAGE)).to be true

    @events.addImageAttachment("testSat.jpg")

    expect(@events.getPrimaryHeader()).to eq("Event Detail")
    expect(@events.isThisButtonVisible(THIRD_IMAGE)).to be true
    expect(@events.isThisButtonVisible(DELETE_THIRD_IMAGE)).to be true

    @events.addImageAttachment("johnS.jpg")

    expect(@events.getPrimaryHeader()).to eq("Event Detail")
    expect(@events.isThisButtonVisible(FOURTH_IMAGE)).to be true
    expect(@events.isThisButtonVisible(DELETE_FOURTH_IMAGE)).to be true

    #Making sure that the Add button has disappeared
    expect(@events.isThisButtonVisible("button[name='addEventAttachment']")).to be false

    #PDF Validation
    #AC #JRNL-862|TC #JRNL-989:  PDF View button
    expect(@events.isPDFButtonDisplayed?).to eq(true)
    @events.clickPDFBtn
    switchWindowToWindowHandleLast()

    !45.times{ break if (getPageTitle() == "pdf"); sleep 1 }
    expect(@events.getPageTitle).to eq("pdf")

    expect(@events.verifyEmbeddedPDF()).to eq(true)

    closeBrowser()
    switchWindowToWindowHandleFirst()

    #Deleting Images in different order
    @events.deleteAttachment(DELETE_THIRD_IMAGE)
    @events.deleteAttachment(DELETE_FIRST_IMAGE)
    @events.deleteAttachment(DELETE_FOURTH_IMAGE)
    @events.deleteAttachment(DELETE_SECOND_IMAGE)

    #Making sure file size > 10 MB is not allowed and verifying the Error Message
    @events.addImageAttachment("bumblebee-poster-11mb.jpg")
    checkingInlineError("Your file could not be added. Attachments must be image files (jpeg, jpg, png) that are no bigger than 10 MB. Only one file may be added at time. Please check the file and try again.")

  end

  it "AC#JRNL-860|AC#JRNL-542,543,544|TC#JRNL-976|TC#JRNL-586: Display Device Browse Function|Error Messages" do

    @events.clickAddEvent()

    #Clicking Add Attachment without saving
    @events.clickAddAttachmentButton()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("In order to add an attachment, this Daily Event record must first be saved.")

    expect(@events.isThisButtonVisible(MODAL_CANCEL)).to be true
    expect(@events.isThisButtonVisible(MODAL_SAVE)).to be true

    #Verifying Cancel Button takes the user back to Detail View
    @modal.clickCancelButtonAttachmentModal()

    !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    expect(@events.getTitle()).to eq("Daily Events")

    #Clicking Add Attachment and then clicking the Save button to verify the error message

    @events.clickAddAttachmentButton()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("In order to add an attachment, this Daily Event record must first be saved.")

    @modal.clickSaveButtonAttachmentModal()

    checkingInlineError("Title field is required.")

    #Filling the Required field and clicking the Add Button
    @events.setEventText("I want to add a few pictures.")

    @events.clickAddAttachmentButton()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("In order to add an attachment, this Daily Event record must first be saved.")

    @modal.clickSaveButtonAttachmentModal()

  end

  # Local Function
  def checkingInlineError(errMsg)

    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("eventForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("eventForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("eventForm", errMsg)).to be true

  end

end