require_relative '../../globalized'
include Globalized

describe "[ Story#JRNL-41|JRNL-497|JRNL-469|JRNL-751|JRNL-746: DailyEvents_JRNL_41_spec.rb] " do


  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteDailyEventTable("D123401")

    initializeAllObjects

  end


  after(:all) do
    quitDriver()
  end


  it "AC#JRNL-171|TC#JRNL-222|AC#JRNL-511|TC#JRNL-540|AC#JRNL-791,788|TC#812: User will be able to enter an event up to 50 characters; Allow date time change for date entry", :broken => true do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 } 
     @eula.clickAccept()   
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    expect(@nav_menu.isDailyEventsButtonVisible()).to be true
    @nav_menu.clickDailyEvents()
    !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    expect(@events.getTitle()).to eq("Daily Events")

    expect(@events.getMessageInEventDetail()).to eq("Select the Add Entry button to add a new entry.\nSelect the button to add a new entry.")
    twentyfiveDaysAgo = getDateNthDaysAgo(25, "%m/%d/%Y")
    morningTime = "08:00 AM"
    creationtime = twentyfiveDaysAgo + " 08:00 AM"
    #puts "Created Date and time is :" + creationtime

    @events.addNewEvent( twentyfiveDaysAgo, morningTime, "Took Tylenol in the morning. Took a walk for 30 min","Writing note is optional")

    #validating changing date and time for date entry
    timeStamp1 = @events.getNthEventTimeStamp(1)
    #puts "Display Date and time is :" + timeStamp1
    expect(creationtime).to eq(timeStamp1)
    #puts(expect(creationtime).to eq(timeStamp1))

    eventLog = @events.getNthEventText(1)
    expect(@events.getTextLength(eventLog)).to eq(50)
    
    expect(@events.getMessageInEventDetail()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry.")

  end



  it "AC #JRNL-256 | TC #JRNL-222: Screen titles.@communications  Include titles for main screen ('Events') and detailed screen ('Event Detail')", :broken => true do
    expect(@events.getSecondaryHeader()).to eq("Events")
    expect(@events.getPrimaryHeader()).to eq("Event Detail")
    
  end

  it "AC #JRNL-172 | TC #JRNL-222: For each event entered, the system date and time stamp will be included", :broken => true do
    twentyDaysAgo = getDateNthDaysAgo(20, "%m/%d/%Y")
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    midAMTime = "10:00 AM"
    noonTime = "12:00 PM"
    creationtime2 = twentyDaysAgo + " 10:00 AM"
    #puts "Created Date and time is :" + creationtime2

    @events.addNewEvent(twentyDaysAgo, midAMTime, "Blood Pressure 69 - 126", "Writing note is optional")
    @events.addNewEvent(fifteenDaysAgo, noonTime, "Fever 103.2", "Writing note is optional")

    timeStamp1 = @events.getNthEventTimeStamp(1)
    timeStamp2 = @events.getNthEventTimeStamp(2)
    timeStamp3 = @events.getNthEventTimeStamp(3)

    #validating changing date and time for date entry
    #puts "Display Date and time is :" + timeStamp2
    expect(creationtime2).to eq(timeStamp2)
    #puts(expect(creationtime2).to eq(timeStamp2))

    #04/24/2014 11:06
    formatStr = "%m/%d/%Y %H:%M"
    expect(isDateFormatValid?(timeStamp1,formatStr)).to be true
    expect(isDateFormatValid?(timeStamp2,formatStr)).to be true
    expect(isDateFormatValid?(timeStamp3,formatStr)).to be true

  end

  it "AC #JRNL-175 | TC #JRNL-222: Events will be displayed", :broken => true do
    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    afternoonTime = "03:00 PM"
    @events.addNewEvent(twoDaysAgo, afternoonTime, "Ran 2 miles","Writing note is optional")
    @events.printEventTimeStampAndTitle()
    
    expect(@events.getNthEventText(1)).to eq("Ran 2 miles")
    expect(@events.getNthEventText(2)).to eq("Fever 103.2")
    expect(@events.getNthEventText(3)).to eq("Blood Pressure 69 - 126")
    expect(@events.getNthEventText(4)).to eq("Took Tylenol in the morning. Took a walk for 30 mi")
    
    @events.clickNthEvent(4)
    !45.times{ break if (@events.isCancelButtonVisible() == true); sleep 1 }
    expect(@events.isCancelButtonVisible()).to be true
    
    @events.clickCancelButton()
    !45.times{ break if (@events.getMessageInEventDetail() == "Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry."); sleep 1 }
    expect(@events.getMessageInEventDetail()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry.")
  end


  it "AC #JRNL-862|TC #JRNL-989:  PDF View button", :broken => true do
    @events.clickNthEvent(1)
    !45.times{ break if (@events.isSaveExistingEventButtonVisible == true); sleep 1 }

    expect(@events.isPDFButtonDisplayed?).to eq(true)
    @events.clickPDFBtn
    switchWindowToWindowHandleLast()

    !45.times{ break if (getPageTitle() == "pdf"); sleep 1 }
    expect(@events.getPageTitle).to eq("pdf")

    expect(@events.verifyEmbeddedPDF()).to eq(true)

    closeBrowser()
    switchWindowToWindowHandleFirst()

    @events.clickCancelButton
    !45.times{ break if (@events.getMessageInEventDetail() == "Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry."); sleep 1 }
    expect(@events.getMessageInEventDetail()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.\nSelect an item from the list to view details, or select the button to add a new entry.")

  end

  it "AC # JRNL-173 | TC #JRNL-222: The user will be able to Edit existing events, AC#JRNL517 | TC#JRNL537:Add Narrative field to Daily Events and Communications Log", :broken => true do
    origTimeStamp = @events.getNthEventTimeStamp(2)
    eventLog = @events.getNthEventText(2)

    puts "Editing third entry"

    @events.editNthEvents(3, "Blood Pressure 89 - 136")
    !45.times{ break if(@events.getNthEventText(3) == "Blood Pressure 89 - 136"); sleep 1 }
    expect(@events.getNthEventText(3)).to eq("Blood Pressure 89 - 136")

    puts "Clicking 2nd entry"
    @events.clickNthEvent(2)
    !45.times{ break if (@events.isSaveExistingEventButtonVisible == true); sleep 1 }
    @events.setEventText("TEXT Edited")

    # to verify that EventNote will be 250 characters with character countdown
    expect(@events.verifyTotalCharacterInNarrative()).to be true
    # to verify that note is optional
    @events.setEventNote("")
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickAssessmentBtn()

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    expect(@events.getTitle()).to eq("Daily Events")

    puts "About to click Commuincation Log"
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickCommunicationLog()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    @modal.clickContinueButton()
    
    !45.times{ break if (@communications.getTitle() == "Communications Log"); sleep 1 }
    expect(@communications.getTitle()).to eq("Communications Log")

    puts "About to click Daily Event"
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickDailyEvents()
    !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    expect(@events.getTitle()).to eq("Daily Events")
  
    @events.clickNthEvent(2)
    !45.times{ break if (@events.isSaveExistingEventButtonVisible == true); sleep 1 }
    @events.setEventText("TEXT Edited 2")

    @events.clickNthEvent(1)
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()

    !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent).to eq(true)
  
    thirdEventTitle = @events.getNthEventText(3)
    #puts "Third Event Title is " + thirdEventTitle
      
    @events.clickNthEvent(3)
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
     expect(@modal.getConfirmationHeading()).to eq("Confirmation")
     expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
     sleep 2

    @modal.clickContinueButton()
    !45.times{ break if (@events.getEventTitle() == thirdEventTitle); sleep 1 }
    expect(@events.getEventTitle()).to eq(thirdEventTitle)
    
  end

  it "AC #JRNL-235 | TC #JRNL-222: Date Range for display of data", :broken => true do
    twoDaysAgo = getDateNthDaysAgo(2, "%Y-%m-%d")
    updateDailyEvent("D123401", "Took Tylenol in the morning. Took a walk for 30 mi", twoDaysAgo)
    
    fifteenDaysAgo = getDateNthDaysAgo(15, "%Y-%m-%d")
    updateDailyEvent("D123401", "Fever 103.2", fifteenDaysAgo)
    
    thirtyDaysAgo = getDateNthDaysAgo(30, "%Y-%m-%d")
    updateDailyEvent("D123401", "Ran 2 miles", thirtyDaysAgo)
    
    thirtyfiveDaysAgo = getDateNthDaysAgo(35, "%Y-%m-%d")
    updateDailyEvent("D123401", "Blood Pressure 89 - 136", thirtyfiveDaysAgo)
    
    refreshBrowser()
    
    expect(@events.getDailyEventsCount()).to eq(3)
    expect(@events.getNthEventText(1)).to eq("Took Tylenol in the morning. Took a walk for 30 mi")
    expect(@events.getNthEventText(2)).to eq("Fever 103.2")
    expect(@events.getNthEventText(3)).to eq("Ran 2 miles")
    
    expect(@events.isEventsDisplayed?("Blood Pressure 89 - 136")).to be false
    
    fourtyDaysAgo = getDateNthDaysAgo(40, "%Y-%m-%d")
    updateDailyEvent("D123401", "Ran 2 miles", fourtyDaysAgo)
    
    refreshBrowser()
    
    expect(@events.getDailyEventsCount()).to eq(2)
    expect(@events.getNthEventText(1)).to eq("Took Tylenol in the morning. Took a walk for 30 mi")
    expect(@events.getNthEventText(2)).to eq("Fever 103.2")
    
    expect(@events.isEventsDisplayed?("Blood Pressure 89 - 136")).to be false
    expect(@events.isEventsDisplayed?("Ran 2 miles")).to be false
   
    
    twentyDaysAgo = getDateNthDaysAgo(20, "%Y-%m-%d")
    updateDailyEvent("D123401", "Blood Pressure 89 - 136", twentyDaysAgo)
    
    twentyEightDaysAgo = getDateNthDaysAgo(28, "%Y-%m-%d")
    updateDailyEvent("D123401", "Ran 2 miles", twentyEightDaysAgo)
    
    refreshBrowser()
    
    expect(@events.getDailyEventsCount()).to eq(4)
    
  end

  it "AC #JRNL-174 |TC #JRNL-222: The user will be able to remove(delete) events : AC #JRNL-359 | TC #JRNL-468: Today's system date and time should be populated in the new item", :broken => true do
    #Capturing the Date and Timestamp of the created event
    createdDateTime = @events.getNthEventTimeStamp(4)
    #puts createdDateTime

    @events.clickNthEvent(4)
    !45.times{ break if (@events.isDeleteButtonVisible() == true); sleep 1 }
    expect(@events.isDeleteButtonVisible()).to be true

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @events.getDateInForm()
    #puts dateInForm
    timeInForm = @events.getTimeInForm()
    #puts timeInForm

    dateTimeInForm = dateInForm + " " + timeInForm

    #validating that the created date and time equal the date and time in form
    expect(dateTimeInForm).to eq(createdDateTime)
    #puts(expect(dateTimeInForm).to eq(createdDateTime))
    
    @events.clickDeleteButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()

    !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    expect(@events.getTitle()).to eq("Daily Events")
    
    dailyEventCount = @events.getDailyEventsCount()
    
    @events.clickNthEvent(3)
    !45.times{ break if (@events.isDeleteButtonVisible() == true); sleep 1 }
    expect(@events.isDeleteButtonVisible()).to be true
    
    eventTitle = @events.getNthEventText(3)
    #puts "Event Title is : " + eventTitle
     
    @events.clickDeleteButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()  
    
    !45.times{ break if (@events.getDailyEventsCount() == (dailyEventCount - 1) ); sleep 1 }
     
    rowIndex = @events.findIndexWithGivenEventTitle(eventTitle)  
    expect(rowIndex).to eq(-1) # -1 means the event title is not availble 
    
  end

  it "AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Required fields validation; Error message Presentation; Validation information shown in Error Messages", :broken => true do
    @events.clickAddEvent()

    !45.times{ break if (@events.getPrimaryHeader() == "Event Detail"); sleep 1 }
    expect(@events.getPrimaryHeader).to eq("Event Detail")

    #Required fields testing on Date and Time
    requiredFieldTest("Date", "Date field is required.")
    requiredFieldTest("Time", "Time field is required.")

    #Required fields testing on Title
    #Without providing any values to the the fields, we'll be getting the following error messages
    @events.clickSaveNewEventButton()

    checkingInlineError("Title field is required.")

    @events.clickCancelButton()
  end


  # Local Functions start
  def checkingInlineError(errMsg)

    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("eventForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("eventForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("eventForm", errMsg)).to be true

  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @events.clickSaveNewEventButton()
    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")

    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")

    end

    sleep 2
  end


end