require_relative '../../globalized'
include Globalized

describe "[Story#JRNL-12|JRNL-497|JRNL-469|JRNL-751: Communication_Log_JRNL_12_spec.rb]", :broken => true do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteCommunicationsTable("D123401")
    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isCommunicationLogButtonVisible).to be true
    @nav_menu.clickCommunicationLog()

    !45.times{ break if (getMainHeader() == "Communications Log"); sleep 1 }
    expect(getMainHeader()).to eq("Communications Log")

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-257|TC #JRNL-293: Screen Titles" do
    expect(@communications.getSecondaryHeader()).to eq("Communications")
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")
  end

  it "AC#JRNL-176|TC#JRNL-293|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744|AC#JRNL-788,791|TC#JRNL-812: User can add a communications log entry - AC #JRNL-192: Required fields will be denoted as required and reinforced - AC #JRNL-240: Display a message in the detailed pane when no items are selected - AC #JRNL-359 | TC #JRNL-468: Today's system date and time should be populated in the new item - AC#JRNL517|TC#JRNL-537 Add Narrative field to Daily Events and Communications Log |AC #JRNL-511| TC #JRNL-540 :Allow date time change for date entry" do
    @communications.clickAddCommunicationBtn()

    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    @communications.clickCancelBtn()

    #display a message in the detailed pane when no items are seleted
    !45.times{ break if (@communications.getMessageInEventDetail() == "Select the button to add a new entry."); sleep 1 }
    expect(@communications.getMessageInEventDetail()).to eq("Select the button to add a new entry.")

    commLogCount = 0

    # verify that Note will be 250 characters with character countdown.
    @communications.clickAddCommunicationBtn()

    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    expect(@communications.verifyTotalCharacterInNarrative()).to be true
    @communications.clickCancelBtn()

    #type: phone
    twentyfiveDaysAgo = getDateNthDaysAgo(25, "%m/%d/%Y")
    @communications.addCommunicationLog(twentyfiveDaysAgo, "Phone", "Received my annual check-up results from Dr. Kim", "Dr.Kim", "Writing a note is optional")
    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)

    rowIndex = @communications.findIndexWithGivenLogSubject("Received my annual check-up results from Dr. Kim")
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("Phone")

    #validating changing date and time for date entry
    expect(@communications.getNthDateInCommList(rowIndex)).to eq (twentyfiveDaysAgo)

    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Received my annual check-up results from Dr. Kim")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("Dr.Kim")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @communications.getNthDateInCommList(rowIndex)
    #puts "Created Date is " + createdDateTime

    @communications.clickNthCommunicationLog(rowIndex)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @communications.getDateInForm()
    #puts "Date in the form " + dateInForm

    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))


    #type Email
    commLogCount = @communications.getCommunicationsLogCount()
    twentyDaysAgo = getDateNthDaysAgo(20, "%m/%d/%Y")
    @communications.addCommunicationLog(twentyDaysAgo, "Email", "Sent an email to ask about the lab test results", "Dr.Sue", "")

    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)

    rowIndex = @communications.findIndexWithGivenLogSubject("Sent an email to ask about the lab test results")
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("Email")
    #validating changing date and time for date entry
    expect(@communications.getNthDateInCommList(rowIndex)).to eq (twentyDaysAgo)

    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Sent an email to ask about the lab test results")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("Dr.Sue")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @communications.getNthDateInCommList(rowIndex)
    #puts "Created Date is " + createdDateTime

    @communications.clickNthCommunicationLog(rowIndex)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @communications.getDateInForm()
    #puts "Date in the form " + dateInForm

    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))

    #type Postal
    commLogCount = @communications.getCommunicationsLogCount()
    fifteenDaysAgo = getDateNthDaysAgo(15, "%m/%d/%Y")
    @communications.addCommunicationLog(fifteenDaysAgo, "Postal", "Received XRay films via mail", "","")
    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)

    rowIndex = @communications.findIndexWithGivenLogSubject("Received XRay films via mail")
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("Postal")
    #validating changing date and time for date entry
    expect(@communications.getNthDateInCommList(rowIndex)).to eq (fifteenDaysAgo)

    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Received XRay films via mail")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @communications.getNthDateInCommList(rowIndex)
    #puts "Created Date is " + createdDateTime

    @communications.clickNthCommunicationLog(rowIndex)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @communications.getDateInForm()
    #puts "Date in the form " + dateInForm


    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))

    #type In person
    commLogCount = @communications.getCommunicationsLogCount()
    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    @communications.addCommunicationLog(twoDaysAgo, "In Person", "Talked to Dr Sharon", "Dr. Sharon","Writing a note is optional")
    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)

    rowIndex = @communications.findIndexWithGivenLogSubject("Talked to Dr Sharon")
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("In Person")
    #validating changing date and time for date entry
    expect(@communications.getNthDateInCommList(rowIndex)).to eq (twoDaysAgo)

    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Talked to Dr Sharon")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("Dr. Sharon")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @communications.getNthDateInCommList(rowIndex)
    #puts "Created Date is " + createdDateTime

    @communications.clickNthCommunicationLog(rowIndex)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @communications.getDateInForm()
    #puts "Date in the form " + dateInForm


    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))

    #type Text
    commLogCount = @communications.getCommunicationsLogCount()
    oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")
    @communications.addCommunicationLog(oneDayAgo, "Text", "Texted Dr Sharon", "Dr. Sharon", "")
    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)

    rowIndex = @communications.findIndexWithGivenLogSubject("Texted Dr Sharon")
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("Text")
    #validating changing date and time for date entry
    expect(@communications.getNthDateInCommList(rowIndex)).to eq (oneDayAgo)

    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Texted Dr Sharon")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("Dr. Sharon")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @communications.getNthDateInCommList(rowIndex)
    #puts "Created Date is " + createdDateTime

    @communications.clickNthCommunicationLog(rowIndex)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @communications.getDateInForm()
    #puts "Date in the form " + dateInForm

    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))

    #validate max 50 characters for Subject and Who
    commLogCount = @communications.getCommunicationsLogCount()
    oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")
    @communications.addCommunicationLog(oneDayAgo, "Fax", "Requested a refill prescription and should be mailed in 5-6 days", "12345678901234567890123456789012345678901234567890AAAAAAAAAA","")

    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)

    rowIndex = @communications.findIndexWithGivenLogSubject("Requested a refill prescription and should be mail")
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("Fax")
    #validating changing date and time for date entry
    expect(@communications.getNthDateInCommList(rowIndex)).to eq (oneDayAgo)

    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Requested a refill prescription and should be mail")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("12345678901234567890123456789012345678901234567890")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @communications.getNthDateInCommList(rowIndex)
    #puts "Created Date is " + createdDateTime

    @communications.clickNthCommunicationLog(rowIndex)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @communications.getDateInForm()
    #puts "Date in the form " + dateInForm

    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))

    #validate required fields
    oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")
    @communications.addCommunicationLog(oneDayAgo, "", "", "", "")

    !45.times{ break if (@errorSummary.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@errorSummary.isErrorMessageDisplayed("entryForm", "Subject field is required.")).to eq(true)

    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    @communications.clickCancelBtn()
    #Display a message in the detailed pane when no items are selected
    !45.times{ break if (@communications.getMessageInEventDetail() == "Select an item from the list to view details, or select the button to add a new entry."); sleep 1 }
    expect(@communications.getMessageInEventDetail()).to eq("Select an item from the list to view details, or select the button to add a new entry.")
    expect(@communications.getMessageInEventDetailAriaLabel()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.")

    oneDayAgo = getDateNthDaysAgo(1, "%m/%d/%Y")
    @communications.addCommunicationLog(oneDayAgo, "Other", "", "", "")

    !45.times{ break if (@errorSummary.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@errorSummary.isErrorMessageDisplayed("entryForm", "Subject field is required.")).to eq(true)

    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Required fields testing on Date
    requiredFieldTest("Date", "Date field is required.")


    commLogCount = @communications.getCommunicationsLogCount()

    @communications.selectType("Other")
    @communications.setSubject("Need to ask my lab results")
    @communications.setWho("")
    @communications.clickSaveNewBtn()

    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)

    #Type Other
    rowIndex = @communications.findIndexWithGivenLogSubject("Need to ask my lab results")
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("Other")
    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Need to ask my lab results")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

    #Capturing the Date of the created comm log
    createdDateTime = @communications.getNthDateInCommList(rowIndex)
    #puts "Created Date is " + createdDateTime

    @communications.clickNthCommunicationLog(rowIndex)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    #Capturing the Date and Time after the event is selected for modification
    dateInForm = @communications.getDateInForm()
    #puts "Date in the form " + dateInForm

    #validating that the created date and time equal the date and time in form
    expect(dateInForm).to eq(createdDateTime)
    #puts(expect(dateInForm).to eq(createdDateTime))

  end


  it "AC JRNL-177|TC #JRNL-293: User can edit existing communication entries" do
    @communications.clickNthCommunicationLog(5)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    @communications.EditCommunicationLog("In Person", "Received Xray films and talked a nurse in the office", "")

    !45.times{ break if (@communications.getMessageInEventDetail() == "Select an item from the list to view details, or select the button to add a new entry."); sleep 1 }
    expect(@communications.getMessageInEventDetail()).to eq("Select an item from the list to view details, or select the button to add a new entry.")
    expect(@communications.getMessageInEventDetailAriaLabel()).to eq("Select an item from the list to view details, or select the Add Entry button to add a new entry.")


    sleep 2
    rowIndex = @communications.findIndexWithGivenLogSubject("Received Xray films and talked a nurse in the offi")
    
    expect(@communications.getNthTypeInCommList(rowIndex)).to eq("In Person")
    expect(@communications.getNthSubjectInCommList(rowIndex)).to eq("Received Xray films and talked a nurse in the offi")
    expect(@communications.getNthWhoInCommList(rowIndex)).to eq("")
    expect(isDateFormatValid?(@communications.getNthDateInCommList(rowIndex), "%m/%d/%Y")).to be true

  end

  it "AC JRNL-179|TC #JRNL-293: Entries will be sorted in reverse chronological order "  do
    oneDaysAgo = @communications.getDateNthDaysAgo(1, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", "Received my annual check-up results from Dr. Kim", oneDaysAgo)

    twoDaysAgo = @communications.getDateNthDaysAgo(2, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", "Received Xray films and talked a nurse in the offi", twoDaysAgo)

    threeDaysAgo = @communications.getDateNthDaysAgo(3, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", "Texted Dr Sharon", threeDaysAgo)

    fifteenDaysAgo = @communications.getDateNthDaysAgo(15, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", "Sent an email to ask about the lab test results", fifteenDaysAgo)

    twentyDaysAgo = @communications.getDateNthDaysAgo(20, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", "Talked to Dr Sharon", twentyDaysAgo)

    twentySevenDaysAgo = @communications.getDateNthDaysAgo(27, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", "Requested a refill prescription and should be mail", twentySevenDaysAgo)

    twentyNineDaysAgo = @communications.getDateNthDaysAgo(29, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", "Need to ask my lab results", twentyNineDaysAgo)

    refreshBrowser()

    expect(@communications.getNthSubjectInCommList(1)).to eq("Received my annual check-up results from Dr. Kim")
    expect(@communications.getNthSubjectInCommList(2)).to eq("Received Xray films and talked a nurse in the offi")
    expect(@communications.getNthSubjectInCommList(3)).to eq("Texted Dr Sharon")
    expect(@communications.getNthSubjectInCommList(4)).to eq("Sent an email to ask about the lab test results")
    expect(@communications.getNthSubjectInCommList(5)).to eq("Talked to Dr Sharon")
    expect(@communications.getNthSubjectInCommList(6)).to eq("Requested a refill prescription and should be mail")
    expect(@communications.getNthSubjectInCommList(7)).to eq("Need to ask my lab results")

  end

  it "AC #JRNL-194|TC #JRNL-293: User can save or cancel entry actions" do
    @communications.clickAddCommunicationBtn()

    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    @communications.selectType("Email")
    @communications.clickNthCommunicationLog(3)

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    fourthSubject = @communications.getNthSubjectInCommList(4)
    puts "Fourth Subject is " + fourthSubject
    @communications.clickNthCommunicationLog(4)

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    sleep 2
    @modal.clickContinueButton()
    !45.times{ break if (@communications.getSelectedLogSubject() == fourthSubject); sleep 1 }
    expect(@communications.getSelectedLogSubject()).to eq(fourthSubject)
    @communications.setSubject("Sent an email to Dr. Zeita's office")

    puts "before clicking the menu"
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

  puts "after clicking"

    @nav_menu.clickMyStory()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")


    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickContinueButton()
    !45.times{ break if (getMainHeader() == "My Story"); sleep 1 }
    expect(getMainHeader()).to eq("My Story")

  end

  it "AC #JRNL-236|TC #JRNL-293: Display of data" do
    #Default display to last 30 days displaying start and end date
    #Allow user to change date range(date picker will be in another story
    @main.clickNavMenu()
    @nav_menu.clickCommunicationLog()
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    setDateRangeAndValidate(39, "Need to ask my lab results")
    setDateRangeAndValidate(100, "Sent an email to ask about the lab test results")
    setDateRangeAndValidate(800, "Texted Dr Sharon")
    
    commLogCount = @communications.getCommunicationsLogCount()
    @communications.setDateRange("01/23/2012", "03/01/2014")
    !45.times{ break if (@communications.getCommunicationsLogCount() > (commLogCount + 1)); sleep 1 }

    expect(@communications.isDatesWithinFilteredDateRange?()).to be true
     
    refreshBrowser()
 
  end

  it "AC JRNL-193|TC #JRNL-293: The user will be able to remove(delete) entries" do
    deleteNthCommLog(2)
    deleteNthCommLog(1)
    deleteNthCommLog(2)
    deleteNthCommLog(1)
  end

  def setDateRangeAndValidate(numOfDaysAgo, subjectStr)
    commLogCount = @communications.getCommunicationsLogCount()
    
    daysAgo = @communications.getDateNthDaysAgo(numOfDaysAgo, "%Y-%m-%d")
    updateLogTimeCommunicationsTable("D123401", subjectStr, daysAgo)

    refreshBrowser()
    !45.times{ break if (getMainHeader() == "Communications Log"); sleep 1 }
    expect(getMainHeader()).to eq("Communications Log")
    
    !45.times{ break if (@communications.getCommunicationsLogCount() == (commLogCount - 1)); sleep 1 }
    
    expect(@communications.isCommLogDisplayed?(subjectStr)).to be false
        
    expect(@communications.isDatesWithinFilteredDateRange?()).to be true

    today = @communications.getDateNthDaysAgo(0, "%m/%d/%Y")
    fromDate = @communications.getDateNthDaysAgo(numOfDaysAgo, "%m/%d/%Y")

    commLogCount = @communications.getCommunicationsLogCount()
    @communications.setDateRange(fromDate, today)
   # sleep 2
    !45.times{ break if (@communications.getCommunicationsLogCount() > (commLogCount + 1)); sleep 1 }

    expect(@communications.isCommLogDisplayed?(subjectStr)).to be true
    expect(@communications.isDatesWithinFilteredDateRange?()).to be true
  end

  def deleteNthCommLog(number)
    @communications.clickNthCommunicationLog(number)
    !45.times{ break if (@communications.getPrimaryHeader() == "Communication Detail"); sleep 1 }
    expect(@communications.getPrimaryHeader()).to eq("Communication Detail")

    selectedSubject = @communications.getSelectedLogSubject()
    puts "Selected Subject :" + selectedSubject

    @communications.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()

    sleep 2
    !45.times{ break if ( @communications.getSelectedLogSubject() == selectedSubject); sleep 1 }
    expect(@communications.getSelectedLogSubject()).to eq(selectedSubject)

    commLogCount = @communications.getCommunicationsLogCount()

    @communications.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
  # sleep 2
    @modal.clickYesButton()

    !45.times{ break if ( @communications.getCommunicationsLogCount() == (commLogCount - 1)); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount - 1)

    expect(@communications.isCommLogDisplayed?(selectedSubject)).to be false

  end




  # Local functions starts
  def checkingInlineError(errMsg)

    #Verify that the error message section header is displayed
    !45.times{ break if (@errorSummary.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@errorSummary.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@errorSummary.isErrorMessageDisplayed("entryForm", errMsg)).to be true

  end

  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @communications.clickSaveNewBtn()
    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

end