require_relative '../../globalized'
include Globalized

describe "Story#MVAH-8: [CPS_PS_Notification_MVAH_8_spec.rb] | JRNL-1303: [Update Preventive Services header]" do



  startTime = Time.new
  puts "Start Time: " + startTime.inspect

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")
    removeCollection("preferences", "healthtrackerdb")

   initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
  end

  after(:all) do
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")
    quitDriver()
  end

  describe "Story#JRNL-1556: Pneumococcal PCV13 Vaccination | AC#JRNL-1236: Notification Delivery for PCV13
           Story#JRNL-1557: Pneumococcal PPSV23 Vaccination | AC#JRNL-1232: Notification Delivery for PPSV23" do


    for ps in [ "Cervical Cancer Screening", "Blood Pressure Screening", "PCV13 - Pneumococcal Vaccination", "PPSV23 - Pneumococcal Vaccination" ] do

      context "Testing PS [#{ps}]" do

        # Need to reassign ps to a different variable in order to access the value at runtime
        preventive_service_being_tested = ps


        before(:all) do
          #removeCollection("preventiveservices", "healthtrackerdb")
          removeCollection("reminders", "remindersdb")
          sleep 3
        end

        after(:all) do
          @nav_menu.navigate("Home")
          sleep 3
          #Navigate to the Notification Setting screen to remove the email address
          @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
          !15.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
          expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")
          @modal.clickSaveButton()
          !15.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
          expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
        end

        it "AC #JRNL-3193|TC#JRNL-2009|: Verify that the Notification fields-Status, Notify Me, Next Due Date are displayed according to acceptance criteria", :broken => true do
          @main.clickNavMenu()
          !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
          expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

          @nav_menu.clickReminders()
          !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
          expect(@reminders.getTitle()).to eq("My Reminders")
          expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
          expect(@reminders.getPrimaryHeader()).to eq("My Reminders")

          @reminders.clickSubGroup("preventive-services")
          !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
          expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
          !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
          expect(@screening.getTableViewHeader()).to eq("Status")

          #Click on PS
          @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(preventive_service_being_tested))

          #Add double wait since the header is loaded at differently time as the form
          !45.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
          expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
          !45.times{ break if (isElementVisible(:css, "input[name='notificationOption'][type='radio']") == true); sleep 1 }
          expect(isElementVisible(:css, "input[name='notificationOption'][type='radio']")).to eq(true)

          # Pneumeococcal has Next Due date with a past date so need to clear it
          if ["PCV13 - Pneumococcal Vaccination", "PPSV23 - Pneumococcal Vaccination"].index(preventive_service_being_tested) != nil
            setDate("", "date-control[label='Next Due Date'] input")
          end

          #Verify that the Notification radio button is set on Off because Next Due Date is null
          expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)

          #Verify that Notify Me all four checkboxes are disabled
          verifyThisCheckboxIsDisabled("On the date", true)
          verifyThisCheckboxIsDisabled("1 day before", true)
          verifyThisCheckboxIsDisabled("2 weeks before", true)
          verifyThisCheckboxIsDisabled("4 weeks before", true)
          #Verify that the Notification Delivery Method is disabled too
          expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='In-App']")).to eq(true)
          expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)

          #Click on Save, there should be no validation against any of the fields
          @screening.clickSaveButton()
          !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
          expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
          !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
          expect(@screening.getTableViewHeader()).to eq("Status")

          #Click on PS
          @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(preventive_service_being_tested))
          #Add double wait since the header is loaded at differently time as the form
          !45.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
          expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
          !45.times{ break if (isElementVisible(:css, "input[name='notificationOption'][type='radio']") == true); sleep 1 }
          expect(isElementVisible(:css, "input[name='notificationOption'][type='radio']")).to eq(true)

          #Select On from Notification Preference
          @screening.selectNotificationStatus("On")
          expect(@screening.isNotificationStatusSelected("On")).to eq(true)

          #Verify text "* requred field" shows up
          #Verify Next Due Date, Notify Me and Notification Delivery now have a "*" next to it
          expect(@common.verifyRequiredFieldTextIsDisplayed()).to eq("* required field")

          #Verify the require fields now have a * next to Next Due Date, Notify Me and Notification Delivery
          # Next Due Date
          expect(@screening.isRequiredFieldIndicatorPresent("label[for='nextDueDate'] span[ng-if='isRequired']")).to eq(true)
          #Notify Me
          expect(@screening.isRequiredFieldIndicatorPresent(".margin-top-md legend span.ng-isolate-scope span")).to eq(true)
          #Notification Delivery
          expect(@screening.isRequiredFieldIndicatorPresent(".notification-delivery [ng-if='isRequired']")).to eq(true)

          #Notify Me requirements validation has been moved to MVAH-1291

          #Select On from Notification Preference without providing values to the required fields, then click Save
          @screening.clickSaveButton()

          #Verify error messages are displayed at the top of the screen
          checkingInlineError("Next Due Date is required when Notifications are on.", 0)
        end

        it "AC #JRNL-3193|TC#JRNL-2009|: Verify that when user does not have an email in the system the Notification fields - Notification Method are displayed according to acceptance criteria", :broken => true do
          #Verify the Notification Method
          #In app is checked as default
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
          #Email is disabled since this user does not have email provided
          expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
          #Verify that the text is displayed when email is not available and this box is disabled
          expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")
          #Verify the instructional text is displayed
          expect(@screening.getInstructionalTextWhenEmailIsNotAvailable()).to eq("You may update your Preferred Email address in the Notification feature by selecting the notification settings icon")
        end

        it "AC #JRNL-3193|TC#JRNL-2009|: Verify that when user has an email in the system the Notification fields - Notification Method are displayed according to acceptance criteria", :broken => true do
          @screening.clickCancelButton()
          !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
          expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
          !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
          expect(@screening.getTableViewHeader()).to eq("Status")

          #Set the email to the user
          @common.navigateToNotificationSettingAndSetOrRemoveEmail("lian.gould@agilex.com")
          #Come back to Preventive Service table view
          @screening.returnToPSAndEditAPS(preventive_service_being_tested)
          expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
          expect(isElementVisible(:css, "input[name='notificationOption'][type='radio']")).to eq(true)

          #Click the Status = On radio button
          @screening.selectNotificationStatus("On")
          expect(@screening.isNotificationStatusSelected("On")).to eq(true)

          #In app is checked as default
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
          #Email is enabled since this user has an email provided
          expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(false)
          #Verify that the email address is displayed in the edit box
          expect(@screening.getEmailFromNotification()).to eq("lian.gould@agilex.com")

          # un-check the In-App option
          @screening.clickNotificationDeliveryCheckBox("In-App")
          # check the Email option
          @screening.clickNotificationDeliveryCheckBox("Email")

          #Provide values to Next Due Date (tomorrow)
          setDate(getDateNthDaysFromNow(1, "%m/%d/%Y"), "date-control[label='Next Due Date'] input")

          #Check On the date checkbox from Notify Me
          @screening.clickNotificationDeliveryCheckBox("On the date")

          #Click Save
          @screening.clickSaveButton()
          !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
          expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
          !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
          expect(@screening.getTableViewHeader()).to eq("Status")

          #Navigate to the Notification Setting screen to remove the email address
          @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
          !15.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
          expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")

          @modal.clickSaveButton()
          !15.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
          expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

          #Return to Preventive Service screen
          @screening.returnToPSAndEditAPS(preventive_service_being_tested)
          expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
          expect(isElementVisible(:css, "input[name='notificationOption'][type='radio']")).to eq(true)

          #Verify that now the Notification Status is set to Off and email checkbox is unchecked
          expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)

          # Turn the Status to On
          @screening.selectNotificationStatus("On")
          expect(@screening.isNotificationStatusSelected("On")).to eq(true)

          # check In-App checkbox
          @screening.clickNotificationDeliveryCheckBox("In-App")

          @screening.clickSaveButton()
          !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
          expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
          !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
          expect(@screening.getTableViewHeader()).to eq("Status")
          sleep 1

          #Navigate to Notification Settings and provide an email address
          @common.navigateToNotificationSettingAndSetOrRemoveEmail("lian.gould@agilex.com")

          #Return to Preventive Service screen
          @screening.returnToPSAndEditAPS(preventive_service_being_tested)
          expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
          expect(isElementVisible(:css, "input[name='notificationOption'][type='radio']")).to eq(true)
          #Verify that email return to the edit box, but email checkbox is NOT checked automatically. User has to elect to check it
          expect(@screening.getEmailFromNotification()).to eq("lian.gould@agilex.com")
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
          @screening.clickCancelButton()
        end

      end # context

    end # for

  end # describe


  #######################
  ### Local Functions ###
  #######################
  def checkingInlineError(errMsg, seqNum)
    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

  def verifyThisCheckboxIsDisabled(value, trueOrFalse)
    expect(isThisElementDisabled(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

end