require_relative '../../globalized'
include Globalized


#Obsolete
describe "Story#MVAH-1291|JRNL-1788: [CPS_Notify_Me_Rework_MVAH_1291_Reminder_Notifications_Update_JRNL_1788_spec.rb] | JRNL-1303: [Update Preventive Services header]" do

  startTime = Time.new
  puts "Start Time: " + startTime.inspect



  before(:all) do
    initializeConfigurations(BASE_URL)
    #clean up preventiveservices collection
    removeCollection("preventiveservices", "healthtrackerdb")
    #clean up notificationPreferences and import
    removeCollection("notificationPreferences", "notificationsdb")
    #clean up preferences and import
    removeCollection("preferences", "notificationsdb")
    #clean up reminders
    removeCollection("reminders", "remindersdb")
    initializeAllObjects
    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

  end

  after(:all) do
    quitDriver()
  end

  describe "Story#JRNL-1556: Pneumococcal PCV13 Vaccination | AC#JRNL-1236: Notification Delivery for PCV13
           Story#JRNL-1557: Pneumococcal PPSV23 Vaccination | AC#JRNL-1232: Notification Delivery for PPSV23" do
    for ps in [ "Cervical Cancer Screening", "PCV13 - Pneumococcal Vaccination", "PPSV23 - Pneumococcal Vaccination" ] do

      context "Testing PS [#{ps}]" do

        # Need to reassign ps to a different variable in order to access the value at runtime
        preventive_service_being_tested = ps

        it "AC #JRNL-2840,1599|TC#JRNL-2898|: Verify that the Notify Me label has changed and the select list is changed to checkboxes with the four new values", :broken => true do
          #puts "      Testing ... #{preventive_service_being_tested}"

          @main.clickNavMenu()
          !10.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
          expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

          @nav_menu.clickReminders()
          !10.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }

          @reminders.clickSubGroup("preventive-services")
          !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
          !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

          #Open the PS
          indexID = @screening.findIndexWithGivenPSName(preventive_service_being_tested)
          @reminders.clickNthReminder(indexID)
          #Add double wait since the header is loaded at differently time as the form
          !10.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
          !10.times{ break if (isElementVisible(:css, "input[name*='notificationOption'][type='radio']") == true); sleep 1 }

          #Select On from Notification Preference
          @screening.selectNotificationStatus("On")
          #Verify the Notify Label
          expect(@screening.getNotifyMeLabel()).to eq("* Notify Me About This Due Date:")
          #Verify that four checkboxes are present
          verifyThisCheckboxPresentAndVisible("On the date", true)
          verifyThisCheckboxPresentAndVisible("1 day before", true)
          verifyThisCheckboxPresentAndVisible("2 weeks before", true)
          verifyThisCheckboxPresentAndVisible("4 weeks before", true)

          #VErify that four checkboxes are disabled when Next Due Date = null
          verifyThisCheckboxIsDisabled("On the date", true)
          verifyThisCheckboxIsDisabled("1 day before", true)
          verifyThisCheckboxIsDisabled("2 weeks before", true)
          verifyThisCheckboxIsDisabled("4 weeks before", true)

        end

        it "AC #JRNL-1585|TC#JRNL-1504: Reminder Notification updates", :broken => true do

          today = getDateNthDaysAgo(0, "%m/%d/%Y")
          yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
          tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

          #Verifying 'Status' label is present right above 'On', 'Off' radio buttons
          expect(getTextForElement(:css, Screening::STATUS_LABEL)).to eq("Status:")

          #Verifying when all when past or present date is entered the correct instructional text is displayed

          #Present Date
          setDate(today, Screening::NEXT_DUE_DATE)
          expect(getTextForElement(:css, Screening::INSTRUCTIONAL_TEXT)).to eq("Notifications are available for future due dates only.")

          #Past Date
          setDate(yesterday, Screening::NEXT_DUE_DATE)
          expect(getTextForElement(:css, Screening::INSTRUCTIONAL_TEXT)).to eq("Notifications are available for future due dates only.")

          #When a Future Date is entered, correct instructional text displays
          setDate(tomorrow, Screening::NEXT_DUE_DATE)
          expect(getTextForElement(:css, Screening::INSTRUCTIONAL_TEXT)).to eq("Send yourself a notice about this preventive service due date.")

        end


        it "AC #JRNL-2843,1665,1666|TC#JRNL-2898|: Verify that when status is on, notify me checkboxes are enable/disabled based on Next Due Date; Also verify error handling upon save", :broken => true do
          today = getDateNthDaysFromNow(0, "%m/%d/%Y")
          tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
          the3rdDay = getDateNthDaysFromNow(2, "%m/%d/%Y")
          the15thDay = getDateNthDaysFromNow(14, "%m/%d/%Y")
          the16thDay = getDateNthDaysFromNow(15, "%m/%d/%Y")
          the29thDay = getDateNthDaysFromNow(28, "%m/%d/%Y")
          the30theDay = getDateNthDaysFromNow(29, "%m/%d/%Y")

          #When NDD = today, all checkboxes are disabled
          setDate(today, "date-control[label='Next Due Date'] input")
          verifyThisCheckboxIsDisabled("On the date", true)
          verifyThisCheckboxIsDisabled("1 day before", true)
          verifyThisCheckboxIsDisabled("2 weeks before", true)
          verifyThisCheckboxIsDisabled("4 weeks before", true)

          #Click Save, verify an error message is displayed asking user to turn the Notification to Off
          @screening.clickSaveButton()
          #Verify error messages are displayed at the top of the screen
          checkingInlineError("Notifications cannot be provided for the Next Due Date you entered. Turn the Notification off to save the reminder.", 0)
          #Set Status to Off then Save
          @screening.selectNotificationStatus("Off")
          @screening.clickSaveButton()
          !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
          !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

          #Click to open the PS again
          indexID = @screening.findIndexWithGivenPSName(preventive_service_being_tested)
          @reminders.clickNthReminder(indexID)
          #Add double wait since the header is loaded at differently time as the form
          !10.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
          !10.times{ break if (isElementVisible(:css, "input[name*='notificationOption'][type='radio']") == true); sleep 1 }
          #Select On from Notification Preference
          @screening.selectNotificationStatus("On")
          #When NDD = tomorrow, 3 checkboxes are disabled, one is enabled
          setDate(tomorrow, "date-control[label='Next Due Date'] input")
          verifyThisCheckboxIsDisabled("On the date", false)
          verifyThisCheckboxIsDisabled("1 day before", true)
          verifyThisCheckboxIsDisabled("2 weeks before", true)
          verifyThisCheckboxIsDisabled("4 weeks before", true)

          #When NDD = the3rdDay, 2w, 4w disabled; On the date, 1 day before enabled
          setDate(the3rdDay, "date-control[label='Next Due Date'] input")
          verifyThisCheckboxIsDisabled("On the date", false)
          verifyThisCheckboxIsDisabled("1 day before", false)
          verifyThisCheckboxIsDisabled("2 weeks before", true)
          verifyThisCheckboxIsDisabled("4 weeks before", true)
          #When NDD = the15thDay, 2w, 4w disabled; On the date, 1 day before enabled
          setDate(the15thDay, "date-control[label='Next Due Date'] input")
          verifyThisCheckboxIsDisabled("On the date", false)
          verifyThisCheckboxIsDisabled("1 day before", false)
          verifyThisCheckboxIsDisabled("2 weeks before", true)
          verifyThisCheckboxIsDisabled("4 weeks before", true)

          #When NDD = the16thDay, 4w disabled; On the date, 1 day before, 2w enabled
          setDate(the16thDay, "date-control[label='Next Due Date'] input")
          verifyThisCheckboxIsDisabled("On the date", false)
          verifyThisCheckboxIsDisabled("1 day before", false)
          verifyThisCheckboxIsDisabled("2 weeks before", false)
          verifyThisCheckboxIsDisabled("4 weeks before", true)
          #When NDD = the29thDay, 2w, 4w disabled; On the date, 1 day before enabled
          setDate(the29thDay, "date-control[label='Next Due Date'] input")
          verifyThisCheckboxIsDisabled("On the date", false)
          verifyThisCheckboxIsDisabled("1 day before", false)
          verifyThisCheckboxIsDisabled("2 weeks before", false)
          verifyThisCheckboxIsDisabled("4 weeks before", true)

          #When NDD = the30theDay, all enabled
          setDate(the30theDay, "date-control[label='Next Due Date'] input")
          verifyThisCheckboxIsDisabled("On the date", false)
          verifyThisCheckboxIsDisabled("1 day before", false)
          verifyThisCheckboxIsDisabled("2 weeks before", false)
          verifyThisCheckboxIsDisabled("4 weeks before", false)

          #Check all four checkboxes
          @screening.clickNotificationDeliveryCheckBox("On the date")
          @screening.clickNotificationDeliveryCheckBox("1 day before")
          @screening.clickNotificationDeliveryCheckBox("2 weeks before")
          @screening.clickNotificationDeliveryCheckBox("4 weeks before")
          #Click status = Off
          @screening.selectNotificationStatus("Off")
          #Verify that all four checkboxes are still checked
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(true)
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(true)
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(true)
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(true)


          #Set NDD = today, then select status = On
          setDate(today, "date-control[label='Next Due Date'] input")
          @screening.selectNotificationStatus("On")
          #Verify that all four checkboxes now are no longer checked
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(false)
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(false)
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(false)
          expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(false)
          #And they are all disabled too
          verifyThisCheckboxIsDisabled("On the date", true)
          verifyThisCheckboxIsDisabled("1 day before", true)
          verifyThisCheckboxIsDisabled("2 weeks before", true)
          verifyThisCheckboxIsDisabled("4 weeks before", true)

          @screening.clickCancelButton()
        end

      end # context

    end # for

  end # describe

  #Begin local functions

  def checkingInlineError(errMsg, seqNum)

    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !10.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to be true

  end

  def verifyThisCheckboxPresentAndVisible(value, trueOrFalse)
    expect(isElementPresentAndVisible(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

  def verifyThisCheckboxIsDisabled(value, trueOrFalse)
    expect(isThisElementDisabled(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

  #End of local functions

end
