require_relative '../../globalized'
include Globalized

describe "Story#JRNL-2461: [CPS_Error_Handling_Upon_Email_Removal_JRNL_2461_spec.rb]" do



  startTime = Time.new
  puts "Start Time: " + startTime.inspect

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient14", "patient14, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient14, zztest")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #MVAH-|TC#JRNL-2833|: Login and Add an Email address from Notification Settings page and then create a reminder with In-App and Email delivery methods", :broken => true do
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Service Reminders")

    !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@screening.getTableViewHeader()).to eq("Status")

    #Set an email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("lian.gould@agilex.com")

    #Return to PS and click on Cervical Cancer Screening
    @screening.returnToPSAndEditAPS("Cervical Cancer Screening")

    #Select On from Notification Preference
    @screening.selectNotificationStatus("On")

    #Check the Email option
    @screening.clickNotificationDeliveryCheckBox("Email")

    #Provide values to Next Due Date
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    setDate(tomorrow, "date-control[label='Next Due Date'] input")
    #Check one checkbox under Notify Me
    @screening.clickNotificationDeliveryCheckBox("On the date")
    #Click Save
    @screening.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Service Reminders")

    !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@screening.getTableViewHeader()).to eq("Status")
  end

  it "AC #MVAH-|TC#JRNL-2833|: Navigate back to Notification Settings and remove the email then save. Verify that a modal dialog pops up and all its Title, Body Contents and Button names meet the requirment", :broken => true do
    #Remove the email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
    !45.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(1)")).to eq("An email address is required for VA Health email notifications. If you do not provide an email address any future email notifications will be cancelled.")
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(2)")).to eq("If you wish to continue saving, click SAVE, otherwise, select CANCEL to update your Notification Settings.")
    #Verify that Save and Cancel buttons are present
    expect(@modal.isSaveButtonPresent()).to eq(true)
    expect(@modal.isCancelButtonPresent()).to eq(true)
    #Verify the button texts
    expect(@modal.getConfirmButtonText()).to eq("Save")
    expect(@modal.getCancelButtonText()).to eq("Cancel")

    #Click Cancel
    @modal.clickCancelButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    #Verify that the email address persist
    expect(@notification.getEmailAddressFromNotificationSettingScreen()).to eq("lian.gould@agilex.com")

    #Attempt to remove again
    @landing.setEmailAddress("")
    @modal.clickSaveButton()
    !45.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")
    #Click Save
    @modal.clickSaveButton()
    !30.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
  end

  it "AC #MVAH-|TC#JRNL-2833|: Verify that after removing the email, the email notification delivery method is removed from the notification reminders", :broken => true do
    #Return to PS and click on Cervical Cancer Screening
    @screening.returnToPSAndEditAPS("Cervical Cancer Screening")

    #Verify that the Email notification delivery method is unchecked
    expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
    #Verify the Email checkbox is disabled
    expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
    #Verify that the text is displayed when email is not available and this box is disabled
    expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")

    @screening.clickCancelButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Service Reminders")
  end

end