require_relative '../../globalized'
include Globalized

describe "Story# MVAH-10: [CPS_Cholesterol_Screening_JRNL_1621_spec.rb] | JRNL-1303: [Update Preventive Services header]" do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 5

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  it "AC(JRNL-3219|), TC(JRNL-3256): Cholesterol screening in Preventive Service Table" do
    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  it "AC(JRNL-3220|JRNL-3222|JRNL-3223), TC(JRNL-3256): Cholesterol Screening - Detail View.; Cholesterol screening - save; Cholesterol screening - cancel; ", :broken => true do
    indexID = @screening.findIndexWithGivenPSName("Cholesterol Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    #Verifying the Header, Text and Button information for the "Next Due Date Modal"
    @screening.clickInformationButton()
    !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
    expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
    expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

    @modal.clickNoButton()
    !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    time = Time.new()
    today = time.strftime("%m/%d/%Y")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    setDate(tomorrow, "input[name='lastCompleted']")
    @screening.setCholesterol("A*(-0180")
    expect(getTextFromInput(:css, "input[name='result']")).to eq("0180")

    #Verify that, drop down input default to Select and all expected values are available
    expect(getSelectedOptionValue(:css, "select[name='fastingState']")).to eq("")
    expect(areAllTheseValuesAvailableInDropDown("select[name='fastingState']", "Select,Yes,No,I don't know")).to eq(true)
    @screening.selectOption("Yes")
    setDate(today, "input[name='nextDueDate']")

    #verify that Notes will be 250 characters with character countdown
    expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)
    @screening.setNote("Cholesterol Screening is done.")
    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()
    if time.year.to_s != tomorrow[-4..-1]
      checkingInlineError("Last Completed must be formatted MM/DD/YYYY.")
    else
      #Verify that, last Completed date cannot be future date
      checkingInlineError("Last Completed must be between 01/01/1900 and " + today + ".")
    end

    setDate(today, "input[name='lastCompleted']")
    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end