require_relative '../../globalized'
include Globalized

describe "Story# MVAH-11: [CPS_Cervical_Cancer_Screening_MVAH_11_spec.rb] | JRNL-1303: [Update Preventive Services header]", :broken => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 5

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3157|TC#JRNL-3257: Cervical Cancer Screening Display in Table" do
    @screening.clickPreventiveServices()
    waitForPageToFinishLoading()
  end

  it "AC #JRNL-3158, #JRNL-3159, #JRNL-3160|TC#JRNL-3257: Cervical Cancer Screening Detail | Required Field Validations | Save Cervical Cancer Screening Entry | Cancel Cervical Cancer Screening Entry." do
    indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    waitForPageToFinishLoading()

    #Verifying the Header, Text and Button information for the "Next Due Date Modal"
    @screening.clickInformationButton()
    !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
    expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
    expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

    @modal.clickNoButton()
    !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    #Verify that, last Pap Smear and Last HPV date cannot be future date
    time = Time.new()
    today = time.strftime("%m/%d/%Y")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    setDate(tomorrow, "input[name='Pap Smear-lastCompleted']")
    @screening.selectPapResult("Normal")
    @screening.setPapLocation("Jefferson Hospital")
    setDate(tomorrow, "input[name='HPV Test-lastCompleted']")
    @screening.selectHPVResult("Normal")
    @screening.setHPVLocation("Jefferson Hospital")
    setDate(today, "input[name='nextDueDate']")
    @screening.verifyTotalCharacterInNarrative()

    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()
    if time.year.to_s != tomorrow[-4..-1]
      checkingInlineError("Last Pap Smear must be formatted MM/DD/YYYY.")
      checkingInlineError("Last HPV Test must be formatted MM/DD/YYYY.")
    else
      checkingInlineError("Last Pap Smear must be between 01/01/1900 and " + today + ".")
      checkingInlineError("Last HPV Test must be between 01/01/1900 and " + today + ".")
    end

    setDate(today, "input[name='Pap Smear-lastCompleted']")
    setDate(today, "input[name='HPV Test-lastCompleted']")

    @screening.clickSaveButton()
    waitForPageToFinishLoading()
  end

  it "Verify that 'HPV Test Options' are not visible for female user < 30 years of age" do
    @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.female90", "female90, zztest")

    sleep 5

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading()

    @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Cervical Cancer Screening"))
    waitForPageToFinishLoading()

    expect(is_element_present(:css, "input[name='HPV Test-lastCompleted']")).to eq(false)
    expect(is_element_present(:css, "select[name='HPV Test-result']")).to eq(false)
    expect(is_element_present(:css, "input[name='HPV Test-location']")).to eq(false)
  end

  it "Verify that 'Cervical Cancer Screening' is hidden for Male Users" do
    @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient01", "patient01, zztest")

    sleep 5

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading()

    expect(@screening.findIndexWithGivenPSName("Cervical Cancer Screening")).to eq(-1)
  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end