require_relative '../../globalized'
include Globalized

describe "Story# JRNL-1624 | JRNL-2477: [CPS_BP_Screening_JRNL-1624_2477_spec.rb] | JRNL-1303: [Update Preventive Services header]", :broken => true do

  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 7

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3214|TC#JRNL-3274: BP Screening Display in Table" do
    @screening.clickPreventiveServices()
    waitForPageToFinishLoading()


  end

  it "AC #JRNL-3215, #JRNL-3216, #JRNL-3217|TC#JRNL-3274: BP Screening Detail. | Required Field Validations | Save BP Screening Entry | Cancel BP Screening Entry." do
    indexID = @screening.findIndexWithGivenPSName("Blood Pressure Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    waitForPageToFinishLoading()

    #Verifying the Header, Text and Button information for the "Next Due Date Modal"
    @screening.clickInformationButton()
    !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
    expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
    expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

    @modal.clickNoButton()
    !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    time = Time.new()
    today = time.strftime("%m/%d/%Y")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    setDate(tomorrow, "input[name='lastCompleted']")
    @screening.setSystolic("60")
    @screening.setDiastolic("40")
    setDate(today, "input[name='nextDueDate']")
    @screening.verifyTotalCharacterInNarrative()
    @screening.selectNotificationStatus("Off")

    #Clicking Save button to verify required validations for invalid entries
    @screening.clickSaveButton()
    # If tomorrow is the start of a new year, will get a format error because the last digit of the year will be chopped off
    if time.year.to_s != tomorrow[-4..-1]
      checkingInlineError("Last Taken must be formatted MM/DD/YYYY.")
    else
      checkingInlineError("Last Taken must be between 01/01/1900 and " + today + ".")
    end
    checkingInlineError("Systolic (mmHg) is outside the expected range. Please enter a value between 80 and 200.")
    checkingInlineError("Diastolic (mmHg) is outside the expected range. Please enter a value between 50 and 150.")

    @screening.setSystolic("210")
    @screening.setDiastolic("160")

    @screening.clickSaveButton()
    checkingInlineError("Systolic (mmHg) is outside the expected range. Please enter a value between 80 and 200.")
    checkingInlineError("Diastolic (mmHg) is outside the expected range. Please enter a value between 50 and 150.")

    #Checking Systolic must be greater than Diastolic Validation
    setDate(today, "input[name='lastCompleted']")
    @screening.setSystolic("80")
    @screening.setDiastolic("80")

    @screening.clickSaveButton()
    checkingInlineError("The Systolic (mmHg) value must be greater than the Diastolic (mmHg) value. Please check the values and re-enter.")

    @screening.setSystolic("120")
    @screening.setDiastolic("80")
    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()
    waitForPageToFinishLoading()
  end

  it "AC #JRNL-2885|TC#MVAH-1671: Blood Pressure Screening Preventative Service Guidance Text" do
    @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Blood Pressure Screening"))
    waitForPageToFinishLoading()

    @screening.setSystolic("")
    @screening.setDiastolic("")

    expect(getPlaceHolderByCSS(:css, "input[name='Systolic']")).to eq("Between 80 and 200")
    expect(getPlaceHolderByCSS(:css, "input[name='Diastolic']")).to eq("Between 50 and 150")

    @screening.clickCancelButton()
    waitForPageToFinishLoading()
  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end