require_relative '../../globalized'
include Globalized

describe "[Story#JRNL-15|JRNL-34|JRNL-497: BP_Pulse_Edit_Del_JRNL_15_807_70_BP_Data_Entry_Validation_JRNL_34_spec.rb]", :broken => true do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAllRecordsFromTable("VITAL_OBSERVATION")
    deleteAllRecordsFromTable("VITAL_ENTRY")
    initializeAllObjects


    VITALS_BTN = "Vitals"
    BP = "ul.secondary-list li:nth-of-type(1) button span.ng-binding"

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible(VITALS_BTN)).to be true
    @vitals.clickVitals()

    !45.times{ break if (@vitals.getTitle() == "Vitals"); sleep 1 }
    expect(@vitals.getTitle()).to eq("Vitals")

  end

  after (:all) do
    quitDriver()
  end


  it "AC #NAVYM-2397|TC #JRNL-490: Blood Pressure will be a topic under Vitals from the left Navigation Menu" do

    expect(@vitals.isThisButtonVisible(BP)).to be true
  end


  it "AC#NAVYM-2398|AC#JRNL-384|TC#JRNL-490|AC#JRNL-542,543,544,719,720,723|TC#JRNL-586,744: Error message presentation and Required field testing on User will be able to ADD/EDIT/DELETE entries; Display 'Systolic' and 'Diastolic' with '(mmHg)' and 'Pulse' with (bpm); Boundary Test for Systolic/Diastolic/Pulse; Verify the max allowed characters for Note" do

    @vitals.clickThisButton(BP)
    @vitals.clickAddBtn()

    !45.times{ break if (@vitals.getPrimaryHeader == "Enter Blood Pressure"); sleep 1 }

    #Verifying Screen Headers
    expect(@vitals.getSecondaryHeader()).to eq("Vitals")
    expect(@vitals.getPrimaryHeader()).to eq ("Enter Blood Pressure")

    expect(@vitals.getNthLabelSystolic()).to eq("Systolic (mmHg):")
    expect(@vitals.getNthLabelDiastolic()).to eq("Diastolic (mmHg):")
    expect(@vitals.getNthLabelPulse()).to eq("Pulse (bpm):")

    @vitals.clickCancelBtn()

    #Display a message in the detailed pane when no records exist

    !45.times{break if (@vitals.getMessageInDetail() == "No results found."); sleep 1}
    expect(@vitals.getMessageInDetail()).to eq("No results found.")

    bpCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    puts today

    morningTime = "07:00 AM"
    afterNoonTime = "03:00 PM"
    eveningTime = "10:00 PM"

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")

    #Position: Sitting
    addAndVerifyABPEntry(yesterday, morningTime, "120", "80", "78", "Sitting", "Feeling Good" )

    #Position: Standing
    addAndVerifyABPEntry(yesterday, afterNoonTime, "140", "90", "65", "Standing", "Feeling Hypertensive")

    #Position: Lying
    addAndVerifyABPEntry(yesterday, eveningTime, "130", "80", "85", "Lying", "Feeling Hypotensive")

    #Validate max 250 characters for Note
    @vitals.clickAddBtn()

    !45.times{break if (@vitals.getPrimaryHeader() == "Enter Blood Pressure"); sleep 1}
    expect(@vitals.getPrimaryHeader()).to eq("Enter Blood Pressure")

    expect(@vitals.verifyTotalCharacterInNote()).to be true

    #Beginning of JRNL-497 validation
    #Boundary Test Max
    boundaryTestMax("Systolic blood pressure", "Systolic (mmHg) is outside the expected range. Please enter a value between 60 and 220.")
    boundaryTestMax("Diastolic blood pressure", "Diastolic (mmHg) is outside the expected range. Please enter a value between 40 and 160.")
    boundaryTestMax("Pulse", "Pulse (bpm) is outside the expected range. Please enter a value between 40 and 250.")

    #Boundary Test Min
    boundaryTestMin("Systolic blood pressure", "Systolic (mmHg) is outside the expected range. Please enter a value between 60 and 220.")
    boundaryTestMin("Diastolic blood pressure", "Diastolic (mmHg) is outside the expected range. Please enter a value between 40 and 160.")
    boundaryTestMin("Pulse", "Pulse (bpm) is outside the expected range. Please enter a value between 40 and 250.")

    #Required fields testing on Date and Time
    requiredFieldTest("Date", "Date field is required.")
    requiredFieldTest("Time", "Time field is required.")

    #Required fields testing on Systolic, Diastolic and Pulse
    #Without providing any values to the these three fields, we'll be getting the following error messages
    @vitals.clickSaveNewBtn()
    sleep 10
    checkingInlineError("Systolic (mmHg) field is required.")
    checkingInlineError("Diastolic (mmHg) field is required.")
    checkingInlineError("Pulse (bpm) field is required.")

    #Click Cancel to exit
    @vitals.clickCancelBtn()
    #End of JRNL-497 validation

    #Edit an existing BP and verify the units
    @vitals.clickNthVital(3)

    !45.times{break if (@vitals.getPrimaryHeader() == "Edit Blood Pressure"); sleep 1}
    expect(@vitals.getPrimaryHeader()).to eq("Edit Blood Pressure")

    #Change Diastolic to 110
    @vitals.editABP(110)

    sleep 2

    #Verify that the 3rd entry has the new Diastolic reading (110)
    expect(@vitals.getNthDiastolicInBPList(3)).to eq("110")

  end

  it "AC #NAVYM-2399|TC #JRNL-490 Entries will be sorted in reverse chronological order" do

    expect(@vitals.getNthPositionInBPList(3)).to eq("Sitting")
    expect(@vitals.getNthPositionInBPList(2)).to eq("Standing")
    expect(@vitals.getNthPositionInBPList(1)).to eq("Lying")

  end

  it "AC #JRNL-866|TC #JRNL-947:  View PDF - BP" do
    expect(@vitals.isPDFButtonDisplayed?).to eq(true)
    @vitals.clickPDFBtn
    switchWindowToWindowHandleLast()

    !45.times{ break if ( @vitals.getPageTitle() == "pdf"); sleep 1 }
    expect(@vitals.getPageTitle).to eq("pdf")

    expect(@vitals.verifyEmbeddedPDF('D123401')).to eq(true)

    closeBrowser()
    switchWindowToWindowHandleFirst()

  end

  it "AC #NAVY-2398|TC #JRNL-490: User should be able to DELETE entries" do
      deleteNthBP("Sitting")
      deleteNthBP("Standing")
      deleteNthBP("Lying")
  end

  it "AC #NAVY-2399|TC #JRNL-490: Display User Entered Data" do
    #Default Display to last 30 days displaying start and end date
    #Allow User to change date range(date picker will be in another story)

    # @vitals.clickFilterBtn()

    #Verify that by default, the date range is set to last 30 days
    expect(@vitals.verifyDefaultDateRangeIs30DaysBack()).to be true

    #Set the date range to 2 years back so all the entered data will show up
    toDate = @vitals.getDateNthDaysAgo(0, "%m/%d/%Y")  #set it to Today
    fromDate = @vitals.getDateNthDaysAgo(730, "%m/%d/%Y") #set it to two year ago

    @vitals.setDateRange(fromDate, toDate)

    #Populate the list of the meals again
    bpCount = 0
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    morningTime = "08:00 AM"
    noonTime = "12:00 PM"
    eveningTime = "06:00 PM"

    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")
    tenDaysAgo = getDateNthDaysAgo(10, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    addAndVerifyABPEntry(thirtyDaysAgo, noonTime, "81", "80", "90", "Sitting", "I feel dizzy")
    addAndVerifyABPEntry(tenDaysAgo, morningTime, "91", "90", "90", "Standing", "Feeling a little better")
    addAndVerifyABPEntry(twoDaysAgo, eveningTime, "111", "110", "110", "Lying", "My heart is racing")

    # @vitals.clickFilterBtn()

    setDateRangeAndValidate(3, 0, "Lying") #to show the twoDaysAgo entry
    setDateRangeAndValidate(11, 3, "Standing") #to show the tenDaysAgo entry
    setDateRangeAndValidate(35, 29, "Sitting") #to show the thirtyDaysAgo entry

  end

  it "AC #JRNL-828:  Blood pressure error prevention " do

    twentyDaysAgo = getDateNthDaysAgo(20, "%m/%d/%Y")
    noonTime = "12:00 PM"

    @vitals.addBP(twentyDaysAgo, noonTime, "90", "100", "65", "Standing", "Feeling Hypertensive")

    checkingInlineError("The Systolic (mmHg) value must be greater than the Diastolic (mmHg) value. Please check the values and re-enter.")
    @vitals.clickCancelBtn

    !45.times{ break if (@vitals.getTitle() == "Vitals"); sleep 1 }
    expect(@vitals.getTitle()).to eq("Vitals")

    @vitals.addBP(twentyDaysAgo, noonTime, "90", "90", "65", "Standing", "Feeling Hypertensive")
    checkingInlineError("The Systolic (mmHg) value must be greater than the Diastolic (mmHg) value. Please check the values and re-enter.")

  end


  #Local Functions

  def boundaryTestMax(testArea, errMsg)

    case testArea
      when "Systolic blood pressure" then
        @vitals.setSystolic(230)
        @vitals.setDiastolic(50)
        @vitals.setPulse(50)
      when "Diastolic blood pressure" then
        @vitals.setSystolic(210)
        @vitals.setDiastolic(170)
        @vitals.setPulse(50)
      when "Pulse" then
        @vitals.setSystolic(60)
        @vitals.setDiastolic(70)
        @vitals.setPulse(260)

    end

    @vitals.clickSaveNewBtn()
    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    case testArea
      when "Systolic blood pressure" then
        @driver.find_element(:css, "input[name='Systolic']").clear
      when "Diastolic blood pressure" then
        @driver.find_element(:css, "input[name='Diastolic']").clear
      when "Pulse" then
        @driver.find_element(:css, "input[name='Pulse']").clear
    end

  end

  def checkingInlineError(errMsg)

    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("vitalsForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("vitalsForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("vitalsForm", errMsg)).to be true

  end

  def boundaryTestMin(testArea, errMsg)
    tempStr = " field is required."
    validationStr = testArea + tempStr
    case testArea
      when "Systolic blood pressure" then
        @vitals.setSystolic(7)
      when "Diastolic blood pressure" then
        @vitals.setSystolic(60)
        @vitals.setDiastolic(7)
      when "Pulse" then
        @vitals.setSystolic(60)
        @vitals.setDiastolic(70)
        @vitals.setPulse(8)

    end

    @vitals.clickSaveNewBtn()

    checkingInlineError(errMsg)

    #Clear the previously tested area to prepare for the next test
    case testArea
      when "Systolic blood pressure" then
        @driver.find_element(:css, "input[name='Systolic']").clear
      when "Diastolic blood pressure" then
        @driver.find_element(:css, "input[name='Diastolic']").clear
      when "Pulse" then
        @driver.find_element(:css, "input[name='Pulse']").clear
        @driver.find_element(:css, "input[name='Diastolic']").clear
        @driver.find_element(:css, "input[name='Systolic']").clear
    end

  end


  def addAndVerifyABPEntry(dateStr, timeStr, systolic, diastolic, pulse, position, note)
    bpcount = @vitals.getTotalCount()
    puts bpcount

    puts "DateStr " + dateStr

    @vitals.addBP(dateStr, timeStr, systolic, diastolic, pulse, position, note)

    !45.times{ break if (@vitals.getTotalCount() == ( bpcount + 1) ); sleep 1 }
    expect(@vitals.getTotalCount()).to eq(bpcount + 1)

    rowIndex = @vitals.findIndexWithAGivenPosition(position)
    expect(@vitals.getNthPositionInBPList(rowIndex)).to eq(position)
    expect(@vitals.getNthSystolicInBPList(rowIndex)).to eq(systolic)
    expect(@vitals.getNthDiastolicInBPList(rowIndex)).to eq(diastolic)
    expect(@vitals.getNthPulseInBPList(rowIndex)).to eq(pulse)
  end

  def setDateRangeAndValidate(numOfDaysAgoFromDate, numOfDaysAgoToDate, position)
    bpCount = @vitals.getTotalCount()

    toDate = @vitals.getDateNthDaysAgo(numOfDaysAgoToDate, "%m/%d/%Y")  #set it to Today
    fromDate = @vitals.getDateNthDaysAgo(numOfDaysAgoFromDate, "%m/%d/%Y")

    #@vitals.clickFilterBtn
    @vitals.setDateRange(fromDate, toDate)

    expect(@vitals.isThisBPDisplayed?(position)).to be true

    expect(@vitals.isBPDateWithinFilteredDateRange?()).to be true

    !45.times{ break if (@vitals.getTotalCount() == 1); sleep 1 }

  end

  def deleteNthBP(position)
    bpCount = @vitals.getTotalCount()
    listIndex = @vitals.findIndexWithAGivenPosition(position)
    @vitals.clickNthVital(listIndex)
    !45.times{ break if (@vitals.getPrimaryHeader() == "Edit Blood Pressure"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Edit Blood Pressure")

    # selectedPosition = @vitals.getNthPositionInBPList(listIndex)
    # puts "Selected Position :" + selectedPosition

    @vitals.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()

    !45.times{ break if (@vitals.getPrimaryHeader() == "Edit Blood Pressure"); sleep 1 }
    expect(@vitals.getPrimaryHeader()).to eq("Edit Blood Pressure")
    sleep 1

    @vitals.clickDeleteBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()

    !45.times{ break if ( @vitals.getTotalCount() == (bpCount - 1)); sleep 1 }
    expect(@vitals.getTotalCount()).to eq(bpCount - 1)

    expect(@vitals.isThisBPDisplayed?(position)).to be false

  end


  def requiredFieldTest(testArea, errMsg)

    case testArea
      when "Date" then
        clearDateOrTime("input[name='date']")
      when "Time" then
        clearDateOrTime("input[name='time']")

    end

    @vitals.clickSaveNewBtn()
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("vitalsForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("vitalsForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("vitalsForm", errMsg)).to be true

    #Clear the previously tested area to prepare for the next test
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    now = time.strftime("%I:%M %p")
    case testArea
      when "Date" then
        setDate(today, "input[name='date']")
      when "Time" then
        setTime(now, "input[name='time']")
    end

    sleep 2
  end

  end