require_relative '../../globalized'
include Globalized

describe "Story# HASS-189 [Assessment_Titles_HASS_189_spec.rb]" do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-194|TC#:HASS-195: Verify that users user sees the title Assessment List in the Main page and the title Assessment in the Detail page." do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Verify that the title on Secondary screen is Assessment List
    !45.times{ break if (@hassList.getAssessmentTitleFromSeconaryScreen() == "Assessment List"); sleep 1 }
    expect(@hassList.getAssessmentTitleFromSeconaryScreen()).to eq("Assessment List")
    
    #Verify that the title on Primary screen is Assessment
    !45.times{ break if (@hassInfo.getAssessmentTitleFromPrimaryScreen() == "Assessment"); sleep 1 }
    expect(@hassInfo.getAssessmentTitleFromPrimaryScreen()).to eq("Assessment")
    
  end

 
end
